/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.ServiceInfo;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceJoinRequest$Poll;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceJoining;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceUpdateResponse;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.Continuation;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class ClusterService$ServiceJoinRequest
extends RequestMessage
implements Continuation {
    private Map __m_MemberConfigMap;
    private String __m_ServiceEndPointName;
    private int __m_ServiceId;
    private String __m_ServiceVersion;

    public ClusterService$ServiceJoinRequest() {
        this(null, null, true);
    }

    public ClusterService$ServiceJoinRequest(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setBufferUsageCounter(1);
            this.setMessageType(42);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new ClusterService$ServiceJoinRequest$Poll("Poll", this, true), "Poll");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public String getDescription() {
        return String.valueOf("ServiceId=") + this.getServiceId() + "\nServiceVersion=" + this.getServiceVersion() + "\nServiceEndPoint=" + this.getServiceEndPointName() + "\nMemberConfigMap=" + this.getMemberConfigMap();
    }

    public Map getMemberConfigMap() {
        return this.__m_MemberConfigMap;
    }

    public String getServiceEndPointName() {
        return this.__m_ServiceEndPointName;
    }

    public int getServiceId() {
        return this.__m_ServiceId;
    }

    public String getServiceVersion() {
        return this.__m_ServiceVersion;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$ServiceJoinRequest".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ClusterService$ServiceJoinRequest();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceived() {
        super.onReceived();
        ClusterService service = (ClusterService)this.getService();
        int nService = this.getServiceId();
        ServiceInfo info = service.getServiceInfo(nService);
        if (info == null) {
            ClusterService$ServiceUpdateResponse msg = (ClusterService$ServiceUpdateResponse)service.instantiateMessage("ServiceUpdateResponse");
            msg.respondTo(this);
            service.send(msg);
        } else {
            boolean fNew;
            long ldtJoined = service.getTimestamp();
            ServiceMemberSet setMember = info.getMemberSet();
            Iterator iter = setMember.iterator();
            while (iter.hasNext()) {
                long ldtOld = setMember.getServiceJoinTime(((Member)iter.next()).getId());
                if (!(ldtJoined <= ldtOld)) continue;
                ldtJoined = ldtOld + (long)1;
            }
            Member member = this.getFromMember();
            int nMember = member.getId();
            ServiceMemberSet serviceMemberSet = setMember;
            synchronized (serviceMemberSet) {
                fNew = setMember.add(member);
                if (fNew) {
                    setMember.setServiceVersion(nMember, this.getServiceVersion());
                    setMember.setServiceJoinTime(nMember, ldtJoined);
                    setMember.setServiceJoining(nMember);
                    setMember.setServiceEndPointName(nMember, this.getServiceEndPointName());
                }
                if (member != service.getThisMember()) {
                    setMember.updateMemberConfigMap(nMember, this.getMemberConfigMap(), fNew);
                }
            }
            service.onServiceJoining(info, member, fNew);
            service.validateNewService(info, member, this);
        }
    }

    public void proceed(Object oResult) {
        ClusterService service = (ClusterService)this.getService();
        int nService = this.getServiceId();
        Member member = this.getFromMember();
        int nMember = member.getId();
        ServiceInfo info = service.getServiceInfo(nService);
        Component._assert(info != null);
        MemberSet setOthers = service.getOthersMemberSet();
        setOthers.remove(member);
        ClusterService$ServiceJoining msg = (ClusterService$ServiceJoining)service.instantiateMessage("ServiceJoining");
        msg.setMemberId(nMember);
        msg.setServiceId(nService);
        msg.setServiceName(info.getServiceName());
        msg.setServiceType(info.getServiceType());
        msg.setServiceJoinTime(info.getServiceJoinTime(nMember));
        msg.setServiceVersion(this.getServiceVersion());
        msg.setServiceEndPointName(this.getServiceEndPointName());
        msg.setMemberConfigMap(this.getMemberConfigMap());
        msg.setToMemberSet(setOthers);
        msg.setJoinRequest(this);
        service.registerServiceJoining(msg);
        service.send(msg);
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        try {
            this.setServiceId(input.readUnsignedShort());
            this.setServiceVersion(input.readUTF());
            this.setServiceEndPointName(input.readUTF());
            this.setMemberConfigMap((Map)this.readObject(input));
        }
        catch (IOException e) {
            this.getService().onConfigIOException(e, this.getFromMember());
        }
    }

    public void setMemberConfigMap(Map map) {
        this.__m_MemberConfigMap = map;
    }

    public void setServiceEndPointName(String sEndPoint) {
        this.__m_ServiceEndPointName = sEndPoint;
    }

    public void setServiceId(int nId) {
        this.__m_ServiceId = nId;
    }

    public void setServiceVersion(String sVersion) {
        this.__m_ServiceVersion = sVersion;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        output.writeShort(this.getServiceId());
        output.writeUTF(this.getServiceVersion());
        output.writeUTF(this.getServiceEndPointName());
        this.writeObject(output, this.getMemberConfigMap());
    }
}

