/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.ServiceInfo;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceJoinRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceJoining$Poll;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceUpdateResponse;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.Continuation;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class ClusterService$ServiceJoining
extends RequestMessage
implements Continuation {
    private transient ClusterService$ServiceJoinRequest __m_JoinRequest;
    private Map __m_MemberConfigMap;
    private int __m_MemberId;
    private String __m_ServiceEndPointName;
    private int __m_ServiceId;
    private long __m_ServiceJoinTime;
    private String __m_ServiceName;
    private String __m_ServiceType;
    private String __m_ServiceVersion;

    public ClusterService$ServiceJoining() {
        this(null, null, true);
    }

    public ClusterService$ServiceJoining(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setBufferUsageCounter(1);
            this.setMessageType(43);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new ClusterService$ServiceJoining$Poll("Poll", this, true), "Poll");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public String getDescription() {
        return String.valueOf("MemberId=") + this.getMemberId() + "\nServiceId=" + this.getServiceId() + "\nServiceName=" + this.getServiceName() + "\nServiceVersion=" + this.getServiceVersion() + "\nServiceEndPoint=" + this.getServiceEndPointName() + "\nServiceJoinTime=" + this.getServiceJoinTime() + "\nMemberConfigMap=" + this.getMemberConfigMap();
    }

    public ClusterService$ServiceJoinRequest getJoinRequest() {
        return this.__m_JoinRequest;
    }

    public Map getMemberConfigMap() {
        return this.__m_MemberConfigMap;
    }

    public int getMemberId() {
        return this.__m_MemberId;
    }

    public String getServiceEndPointName() {
        return this.__m_ServiceEndPointName;
    }

    public int getServiceId() {
        return this.__m_ServiceId;
    }

    public long getServiceJoinTime() {
        return this.__m_ServiceJoinTime;
    }

    public String getServiceName() {
        return this.__m_ServiceName;
    }

    public String getServiceType() {
        return this.__m_ServiceType;
    }

    public String getServiceVersion() {
        return this.__m_ServiceVersion;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$ServiceJoining".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ClusterService$ServiceJoining();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceived() {
        ServiceInfo info;
        super.onReceived();
        ClusterService service = (ClusterService)this.getService();
        int nMember = this.getMemberId();
        Member member = service.getClusterMemberSet().getMember(nMember);
        Component._assert(member != null, String.valueOf("Member ") + nMember + " is unknown to this member");
        if (member == service.getThisMember()) {
            info = service.getServiceInfo(this.getServiceId());
            Component._assert(info != null);
        } else {
            info = service.ensureServiceInfo(this.getServiceId(), this.getServiceName(), this.getServiceType());
        }
        ServiceMemberSet setMember = info.getMemberSet();
        long ldtJoined = this.getServiceJoinTime();
        boolean fNew = true;
        if (setMember.contains(member)) {
            long ldtJoinedOld = setMember.getServiceJoinTime(nMember);
            if (ldtJoined != ldtJoinedOld) {
                Iterator iter = setMember.iterator();
                while (iter.hasNext()) {
                    Member memberOther = (Member)iter.next();
                    if (!(!(memberOther != member) ? false : setMember.getServiceJoinTime(memberOther.getId()) >= ldtJoined)) continue;
                    throw new IllegalStateException(String.valueOf("Service ") + this.getServiceName() + " joining request for member " + member.getId() + " (joinTime=" + ServiceMemberSet.formatJoinTime(ldtJoined) + ") out of order:\n" + setMember);
                }
                setMember.setServiceJoinTime(member.getId(), ldtJoined);
            }
            fNew = false;
        }
        ServiceMemberSet serviceMemberSet = setMember;
        synchronized (serviceMemberSet) {
            if (fNew) {
                setMember.add(member);
                setMember.setServiceVersion(nMember, this.getServiceVersion());
                setMember.setServiceJoinTime(nMember, ldtJoined);
                setMember.setServiceJoining(nMember);
                setMember.setServiceEndPointName(nMember, this.getServiceEndPointName());
            }
            if (member != service.getThisMember()) {
                setMember.updateMemberConfigMap(nMember, this.getMemberConfigMap(), fNew);
            }
        }
        service.onServiceJoining(info, member, fNew);
        service.validateNewService(info, member, this);
    }

    public void proceed(Object oResult) {
        ClusterService service = (ClusterService)this.getService();
        ClusterService$ServiceUpdateResponse msgResponse = (ClusterService$ServiceUpdateResponse)service.instantiateMessage("ServiceUpdateResponse");
        msgResponse.respondTo(this);
        service.send(msgResponse);
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        try {
            this.setMemberId(input.readUnsignedShort());
            this.setServiceId(input.readUnsignedShort());
            this.setServiceName(input.readUTF());
            this.setServiceType(input.readUTF());
            this.setServiceVersion(input.readUTF());
            this.setServiceEndPointName(input.readUTF());
            this.setServiceJoinTime(input.readLong());
            this.setMemberConfigMap((Map)this.readObject(input));
        }
        catch (IOException e) {
            this.getService().onConfigIOException(e, this.getFromMember());
        }
    }

    public void setJoinRequest(ClusterService$ServiceJoinRequest pJoinRequest) {
        this.__m_JoinRequest = pJoinRequest;
    }

    public void setMemberConfigMap(Map map) {
        this.__m_MemberConfigMap = map;
    }

    public void setMemberId(int pMemberId) {
        this.__m_MemberId = pMemberId;
    }

    public void setServiceEndPointName(String sName) {
        this.__m_ServiceEndPointName = sName;
    }

    public void setServiceId(int nId) {
        this.__m_ServiceId = nId;
    }

    public void setServiceJoinTime(long lMillis) {
        this.__m_ServiceJoinTime = lMillis;
    }

    public void setServiceName(String sName) {
        this.__m_ServiceName = sName;
    }

    public void setServiceType(String pServiceType) {
        this.__m_ServiceType = pServiceType;
    }

    public void setServiceVersion(String sVersion) {
        this.__m_ServiceVersion = sVersion;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        output.writeShort(this.getMemberId());
        output.writeShort(this.getServiceId());
        output.writeUTF(this.getServiceName());
        output.writeUTF(this.getServiceType());
        output.writeUTF(this.getServiceVersion());
        output.writeUTF(this.getServiceEndPointName());
        output.writeLong(this.getServiceJoinTime());
        this.writeObject(output, this.getMemberConfigMap());
    }
}

