/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.util.DistributionStrategy;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Response;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$DistributionRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$TransferControl;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.Base;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PartitionedService$AutonomousDistribution
extends DistributionStrategy {
    public PartitionedService$AutonomousDistribution() {
        this(null, null, true);
    }

    public PartitionedService$AutonomousDistribution(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    protected int calculateFairShare(int cMembers, boolean fPrimary) {
        int cPartitionsTotal = (fPrimary ? 1 : this.getBackupCount()) * this.getPartitionCount();
        return cPartitionsTotal / (cMembers == 0 ? 1 : cMembers) + 1;
    }

    protected int calculateFairShare(boolean fPrimary) {
        int cMembers = 0;
        PartitionedService service = this.getService();
        ServiceMemberSet setService = service.getServiceMemberSet();
        Iterator iter = setService.iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            if (!(!service.isOwnershipEnabled(member) ? false : setService.isServiceLeaving(member.getId()) ^ true)) continue;
            ++cMembers;
        }
        return this.calculateFairShare(cMembers, fPrimary);
    }

    protected boolean checkBackupDistribution(MemberSet setOwners, MemberSet setOthers) {
        int nMember;
        Member member;
        Iterator iter;
        PartitionedService service = this.getService();
        Member memberThis = this.getThisMember();
        int nMemberThis = memberThis.getId();
        int cMembers = setOthers.size() + 1;
        int[][] aaiOwner = this.getPartitionAssignments();
        int cPartitionsTotal = aaiOwner.length;
        int cBackups = this.getBackupCount();
        boolean fVulnerabilityAvoidable = service.isVulnerabilityAvoidable(setOwners);
        int cFairShare = this.calculateFairShare(cMembers, false);
        int[] acPartitions = service.calculateOwnership(setOwners, false);
        List listOthers = service.sortMembers(setOthers, acPartitions, null);
        int nMachineThis = memberThis.getMachineId();
        int iBackup = 1;
        while (iBackup <= cBackups) {
            PartitionSet setEndangered = service.collectEndangeredPartitions(iBackup);
            int cEndangered = setEndangered.cardinality();
            if (!(cEndangered == 0)) {
                int cStrongMembers = 0;
                int cEndangeredMembers = service.calculateEndangeredMembers();
                Component._assert(cEndangeredMembers > 0);
                int iPass = 1;
                while (iPass <= 4) {
                    int cBusyPartitions = 0;
                    iter = listOthers.iterator();
                    block8: while (!iter.hasNext() ? false : cEndangered > 0) {
                        member = (Member)iter.next();
                        nMember = member.getId();
                        boolean fStrong = member.getMachineId() != nMachineThis;
                        int cUnderload = cFairShare - acPartitions[nMember];
                        int cTransfer = 0;
                        switch (iPass) {
                            case 1: {
                                if (fStrong) {
                                    ++cStrongMembers;
                                } else if (fVulnerabilityAvoidable) {
                                    Component._assert(cStrongMembers > 0);
                                    break block8;
                                }
                                if (cUnderload <= 0) continue block8;
                                cTransfer = Math.min(cUnderload / cEndangeredMembers + 1, cEndangered);
                                break;
                            }
                            case 2: {
                                if (!(!fVulnerabilityAvoidable ? false : fStrong)) break block8;
                                cTransfer = cEndangered / cStrongMembers + 1;
                                break;
                            }
                            case 3: {
                                if (cMembers > 2) {
                                    cTransfer = cEndangered / (cMembers - 1) + 1;
                                    break;
                                }
                            }
                            case 4: {
                                cTransfer = cEndangered;
                                break;
                            }
                            default: {
                                throw new IllegalStateException();
                            }
                        }
                        PartitionSet setTransfer = this.collectTransfer(setEndangered, nMember, cTransfer);
                        cTransfer = setTransfer.cardinality();
                        if (!(cTransfer > 0)) continue;
                        Component._trace(String.valueOf(iPass) + "> Transferring " + cTransfer + " out of " + cEndangered + " partitions to a " + (fStrong ? "machine-safe" : "node-safe") + " backup " + iBackup + " at member " + nMember + " (under " + cUnderload + ")", 4);
                        int cSent = service.transferBackup(member, setTransfer, iBackup, cTransfer);
                        if (cSent > 0) {
                            return false;
                        }
                        cEndangered -= cSent;
                        cBusyPartitions += cTransfer - cSent;
                    }
                    if (!(cEndangered > 0) ? false : cBusyPartitions > 0) {
                        Component._trace(String.valueOf("Deferring backup transfer for ") + cEndangered + " in-use partitions", 4);
                        return false;
                    }
                    if (service.isTransferInProgress()) {
                        return false;
                    }
                    ++iPass;
                }
            }
            ++iBackup;
        }
        int nMaxOverload = Math.max(0, acPartitions[nMemberThis] - cFairShare);
        int cVulnerable = service.calculateVulnerable();
        int cTransferLimit = 128;
        int cPass = fVulnerabilityAvoidable ? 3 : 2;
        int iPass = 1;
        while (iPass <= cPass) {
            int iBackup2 = 1;
            while (iBackup2 <= cBackups) {
                PartitionSet setPartition;
                PartitionSet partitionSet = setPartition = iPass == 2 ? service.collectOwnedPartitions(true) : service.collectVulnerablePartitions();
                if (setPartition.isEmpty()) break;
                iter = listOthers.iterator();
                while (iter.hasNext()) {
                    member = (Member)iter.next();
                    nMember = member.getId();
                    int cOverload = acPartitions[nMember] - cFairShare;
                    if (iPass < 3) {
                        if (cOverload >= 0) {
                            nMaxOverload = Math.max(nMaxOverload, cOverload);
                            continue;
                        }
                        if (Base.getRandom().nextDouble() >= (double)(-cOverload) / (double)cMembers) continue;
                    }
                    int iPartition = setPartition.next(0);
                    while (iPartition >= 0) {
                        int nBackupOwner = aaiOwner[iPartition][iBackup2];
                        int cBackupOverload = acPartitions[nBackupOwner] - cFairShare;
                        boolean fTransferVulnerable = service.isTransferVulnerable(iPartition, iBackup2, member);
                        boolean fPartitionVulnerable = service.isPartitionVulnerable(iPartition);
                        if ((service.isBackupOwner(iPartition, nMember) ? true : (!(fPartitionVulnerable ^ true) ? false : fTransferVulnerable)) ? true : (!(fPartitionVulnerable ^ fTransferVulnerable ^ true) ? false : (cBackupOverload <= 0 ? true : cOverload >= 0))) {
                            setPartition.remove(iPartition);
                        } else {
                            int n = nBackupOwner;
                            acPartitions[n] = acPartitions[n] - 1;
                            int n2 = nMember;
                            int n3 = acPartitions[n2] + 1;
                            acPartitions[n2] = n3;
                            cOverload = n3 - cFairShare;
                        }
                        iPartition = setPartition.next(iPartition + 1);
                    }
                    if (!(!(setPartition.isEmpty() ^ true) ? false : service.transferBackup(member, setPartition, iBackup2, cTransferLimit) > 0)) continue;
                    return false;
                }
                ++iBackup2;
            }
            ++iPass;
        }
        return !(cVulnerable == 0 ? true : fVulnerabilityAvoidable ^ true) ? false : nMaxOverload == 0;
    }

    public void checkDistribution(MemberSet setOwners, Set setLeaving) {
        super.checkDistribution(setOwners, setLeaving);
        if (setLeaving.isEmpty() ^ true) {
            this.endangerLeavingBackups(setLeaving);
        }
        PartitionedService service = this.getService();
        MemberSet setOthers = service.getOwnershipOtherMemberSet(setOwners);
        Member memberThis = this.getThisMember();
        Member memberOverload = null;
        int nMemberThis = memberThis.getId();
        int cOverload = 0;
        int cMembers = 1 + setOthers.size() - setLeaving.size();
        int cPartitionsTotal = this.getPartitionCount();
        int[] acPartitions = service.calculateOwnership(setOwners, true);
        int cFairShare = this.calculateFairShare(cMembers, true);
        int cUnderloadThis = cFairShare - acPartitions[nMemberThis];
        boolean fRegular = setLeaving.isEmpty();
        if (cUnderloadThis > 0) {
            Set setMembers;
            if (fRegular) {
                setMembers = setOthers;
            } else {
                setMembers = setLeaving;
                cFairShare = 0;
            }
            Iterator iter = Base.randomize(setMembers).iterator();
            while (iter.hasNext()) {
                Member member = (Member)iter.next();
                cOverload = acPartitions[member.getId()] - cFairShare;
                if (!(cOverload > 0)) continue;
                memberOverload = member;
                break;
            }
        }
        if (service.isDistributionAllowed()) {
            if (memberOverload != null) {
                int cRequest = Math.min(cUnderloadThis, cOverload);
                this.sendDistributionRequest(memberOverload, cRequest);
            } else if (fRegular) {
                int nError = cMembers * cFairShare - cPartitionsTotal;
                if (cUnderloadThis <= nError) {
                    int cOverloadThis = -cUnderloadThis;
                    if (cOverloadThis <= 0) {
                        boolean fBalanced;
                        boolean bl = fBalanced = !(this.getBackupCount() == 0 ? true : this.checkBackupDistribution(setOwners, setOthers)) ? false : this.refineDistribution(cMembers, acPartitions, setOthers, 1);
                        if (fBalanced) {
                            service.setDistributionNextMillis(Base.getSafeTimeMillis() + (long)(4 * service.getDistributionRepeatMillis()));
                        }
                    }
                } else {
                    Component._trace(String.valueOf("Failed to find an overloaded member to request: ") + cUnderloadThis + " partitions", 2);
                }
            }
        }
    }

    protected PartitionSet collectTransfer(PartitionSet setEndangered, int nMember, int cTransfer) {
        PartitionedService service = this.getService();
        PartitionSet setTransfer = new PartitionSet(setEndangered.getPartitionCount());
        int iPartition = setEndangered.next(0);
        while (!(iPartition >= 0) ? false : cTransfer > 0) {
            if (service.isBackupOwner(iPartition, nMember) ^ true) {
                setTransfer.add(iPartition);
                setEndangered.remove(iPartition);
                --cTransfer;
            }
            iPartition = setEndangered.next(iPartition + 1);
        }
        return setTransfer;
    }

    protected void endangerLeavingBackups(Set setLeaving) {
        BitSet bsLeaving = new BitSet();
        Iterator iter = setLeaving.iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            bsLeaving.set(member.getId());
        }
        PartitionedService service = this.getService();
        int nMemberThis = service.getThisMember().getId();
        ServiceMemberSet setMembers = service.getServiceMemberSet();
        PartitionedService$TransferControl ctrlTransfer = service.getTransferControl();
        int cBackups = service.getBackupCount();
        int[][] aaiOwners = service.getPartitionAssignments();
        PartitionSet parts = service.collectOwnedPartitions(true);
        int iPart = parts.next(0);
        while (iPart >= 0) {
            int[] aiOwners = aaiOwners[iPart];
            int iStore = 1;
            while (iStore <= cBackups) {
                Member memberBackup;
                int nOwnerBackup = aiOwners[iStore];
                if (bsLeaving.get(nOwnerBackup) && (memberBackup = ((MemberSet)setMembers).getMember(nOwnerBackup)) != null) {
                    aiOwners[iStore] = 0;
                    service.getPartitionControl(iPart).preventTransfer();
                    ctrlTransfer.sendBackupRelease(iPart, iStore, nMemberThis, 0, memberBackup);
                }
                ++iStore;
            }
            iPart = parts.next(iPart + 1);
        }
    }

    protected PartitionedService$TransferControl getTransferControl() {
        return this.getService().getTransferControl();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$AutonomousDistribution".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new PartitionedService$AutonomousDistribution();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public void onDistributionCompleted(Member member, boolean fSuccess) {
        PartitionedService service = this.getService();
        this.setDistributionInProgress(false);
        int nRetryMillis = service.getDistributionRepeatMillis() / service.getDistributionAggressiveness();
        if (fSuccess ^ true) {
            MemberSet setOwners = service.getOwnershipMemberSet();
            int cFairShare = this.calculateFairShare(true);
            int[] acPartitions = service.calculateOwnership(setOwners, true);
            int cUnderloaded = 0;
            int cOverloaded = 0;
            Iterator iter = setOwners.iterator();
            while (iter.hasNext()) {
                int cPartitions = acPartitions[((Member)iter.next()).getId()];
                if (cPartitions >= cFairShare) {
                    ++cOverloaded;
                    continue;
                }
                ++cUnderloaded;
            }
            if (cOverloaded != 0) {
                int iThrottle = Math.min((cUnderloaded / cOverloaded + 1) * 10, service.getDistributionAggressiveness());
                Component._trace(String.valueOf("DistributionRequest was rejected because the receiver was busy.") + "  Next retry in: " + (nRetryMillis *= iThrottle) + "ms", 6);
            }
            this.getTransferControl().onReceiveRollback(member);
        }
        service.setDistributionNextMillis(Base.getSafeTimeMillis() + (long)nRetryMillis);
        Component._assert(service.isTransferInProgress() ^ true);
    }

    public void onDistributionRequest(RequestMessage msgRequest) {
        PartitionedService service = this.getService();
        PartitionedService$DistributionRequest msgDistRequest = (PartitionedService$DistributionRequest)msgRequest;
        if (service.checkDeferredDistribution() ^ true) {
            int cOverload;
            int cPartitionsThis = service.calculateThisOwnership(true);
            if (service.getServiceState() == Service.SERVICE_STOPPING) {
                cOverload = cPartitionsThis;
            } else {
                int cFairShare = this.calculateFairShare(true);
                cOverload = cPartitionsThis - cFairShare + 1;
            }
            if (cOverload > 0) {
                int cPartitions = Math.min(msgDistRequest.getPartitionCount(), cOverload);
                msgDistRequest.setPartitionCount(cPartitions);
                if (this.transferPrimary(msgDistRequest) > 0) {
                    return;
                }
            }
        }
        Grid$Response msgResponse = (Grid$Response)service.instantiateMessage("Response");
        msgResponse.respondTo(msgDistRequest);
        service.post(msgResponse);
    }

    public void onMembershipChanged(int iReason) {
        this.getService().setDistributionNextMillis(0L);
    }

    protected boolean refineDistribution(int cMembers, int[] acPartitions, MemberSet setOthers, int nDevMax) {
        PartitionedService service = this.getService();
        if (cMembers != setOthers.size() + 1) {
            return false;
        }
        int nMemberThis = this.getThisMember().getId();
        int cFairSharePrimary = this.calculateFairShare(cMembers, true);
        int cUnderloadThis = cFairSharePrimary - acPartitions[nMemberThis];
        if (cUnderloadThis > nDevMax) {
            Iterator iter = Base.randomize(setOthers).iterator();
            while (iter.hasNext()) {
                Member member = (Member)iter.next();
                int cOverloadThat = acPartitions[member.getId()] - cFairSharePrimary;
                if (!(cOverloadThat >= 0)) continue;
                int cRequest = Math.min(cUnderloadThis, cOverloadThat + 1);
                this.sendDistributionRequest(member, cRequest);
                return false;
            }
        }
        int[] acPartitionBackup = service.calculateOwnership(setOthers, false);
        int[] acPartitionTotal = new int[cMembers];
        int i = 0;
        while (i < cMembers) {
            acPartitionTotal[i] = acPartitions[i] + acPartitionBackup[i];
            ++i;
        }
        List listOthers = service.sortMembers(setOthers, acPartitionBackup, acPartitionTotal);
        int cFairShareBackup = this.calculateFairShare(cMembers, false);
        int[][] aaiOwner = this.getPartitionAssignments();
        PartitionSet setPartition = service.collectOwnedPartitions(true);
        int cBackups = this.getBackupCount();
        PartitionedService$TransferControl control = this.getTransferControl();
        int cTransferLimit = 1;
        int iBackup = 1;
        while (iBackup <= cBackups) {
            Iterator iter = listOthers.iterator();
            while (iter.hasNext()) {
                Member member = (Member)iter.next();
                int nMember = member.getId();
                int cUnderload = cFairShareBackup - acPartitionBackup[nMember];
                if (!(cUnderload > nDevMax)) break;
                if (Base.getRandom().nextDouble() >= (double)cUnderload / (double)cMembers) continue;
                int iPartition = setPartition.next(0);
                while (iPartition >= 0) {
                    int nBackupOwner = aaiOwner[iPartition][iBackup];
                    int cOverloadThat = acPartitionBackup[nBackupOwner] - cFairShareBackup;
                    if ((service.isBackupOwner(iPartition, nMember) ? true : (!(service.isPartitionVulnerable(iPartition) ^ true) ? false : service.isTransferVulnerable(iPartition, iBackup, member))) ? true : cOverloadThat < 0) {
                        setPartition.remove(iPartition);
                    } else {
                        int n = nBackupOwner;
                        acPartitionBackup[n] = acPartitionBackup[n] - 1;
                        int n2 = nMember;
                        int n3 = acPartitionBackup[n2] + 1;
                        acPartitionBackup[n2] = n3;
                        cUnderload = cFairShareBackup - n3;
                    }
                    iPartition = setPartition.next(iPartition + 1);
                }
                if (!(!(setPartition.isEmpty() ^ true) ? false : service.transferBackup(member, setPartition, iBackup, cTransferLimit) > 0)) continue;
                return false;
            }
            ++iBackup;
        }
        return true;
    }

    public String reportDistributionState() {
        int cPartitions = this.getPartitionCount();
        int cBackups = this.getBackupCount();
        int cMembers = this.getService().getOwnershipMemberSet().size();
        int cFairShare = this.calculateFairShare(cMembers, true);
        int nError = cMembers * cFairShare - cPartitions;
        StringBuffer sb = new StringBuffer();
        sb.append("Distribution state{");
        sb.append("Fair share=").append(cFairShare).append(", deviation=").append(nError);
        if (cBackups >= 1) {
            cFairShare = this.calculateFairShare(cMembers, false);
            nError = cMembers * cFairShare - cPartitions * cBackups;
            sb.append(", backup fair share=").append(cFairShare).append(", backup deviation=").append(nError);
        }
        sb.append("}");
        return sb.toString();
    }

    protected void sendDistributionRequest(Member member, int cPartitions) {
        PartitionedService service = this.getService();
        PartitionSet parts = new PartitionSet(service.getPartitionCount());
        PartitionedService$DistributionRequest msg = (PartitionedService$DistributionRequest)service.instantiateMessage("DistributionRequest");
        parts.fill();
        msg.addToMember(member);
        msg.setSourceMember(member);
        msg.setPartitionCount(cPartitions);
        msg.setPartitions(parts);
        Component._trace(String.valueOf("Asking member ") + member.getId() + " for " + cPartitions + " primary partitions", 4);
        this.setDistributionInProgress(true);
        service.post(msg);
        service.setDistributionNextMillis(Long.MAX_VALUE);
    }

    protected int transferPrimary(PartitionedService$DistributionRequest msgRequest) {
        PartitionedService service = this.getService();
        Member memberThis = this.getThisMember();
        Member memberRequest = msgRequest.getFromMember();
        int nMemberRequest = memberRequest.getId();
        int cRequest = msgRequest.getPartitionCount();
        boolean fStrong = memberThis.getMachineId() != memberRequest.getMachineId();
        boolean cTransfer = false;
        int iPass = fStrong ? 1 : 3;
        do {
            PartitionSet partitions = iPass == 1 ? service.collectVulnerablePartitions() : service.collectOwnedPartitions(true);
            int cPartitions = partitions.cardinality();
            switch (iPass) {
                case 1: {
                    break;
                }
                case 2: {
                    int iPartition = partitions.next(0);
                    while (iPartition >= 0) {
                        if (service.isTransferVulnerable(iPartition, 0, memberRequest)) {
                            partitions.remove(iPartition);
                        }
                        iPartition = partitions.next(iPartition + 1);
                    }
                    break;
                }
                case 3: {
                    int iPartition = partitions.next(0);
                    while (iPartition >= 0) {
                        if (service.isBackupOwner(iPartition, nMemberRequest)) {
                            partitions.remove(iPartition);
                        }
                        iPartition = partitions.next(iPartition + 1);
                    }
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (!(partitions.isEmpty() ^ true)) continue;
            int cSent = service.transferPrimary(memberRequest, msgRequest, partitions, cRequest);
            if (!(cSent > 0)) break;
            Component._trace(String.valueOf(iPass) + "> Transferring " + (iPass == 1 ? "vulnerable " : "primary ") + partitions + " to member " + nMemberRequest + " requesting " + cRequest, 5);
            return cSent;
        } while (++iPass <= 4);
        return 0;
    }
}

