/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel.optimizers.dynamic;

import com.tangosol.coherence.mvel.ParserContext;
import com.tangosol.coherence.mvel.compiler.Accessor;
import com.tangosol.coherence.mvel.integration.VariableResolverFactory;
import com.tangosol.coherence.mvel.optimizers.AccessorOptimizer;
import com.tangosol.coherence.mvel.optimizers.OptimizerFactory;
import com.tangosol.coherence.mvel.optimizers.dynamic.DynamicAccessor;
import com.tangosol.coherence.mvel.optimizers.dynamic.DynamicOptimizer;

public class DynamicSetAccessor
implements DynamicAccessor {
    private char[] property;
    private boolean opt = false;
    private int runcount = 0;
    private long stamp;
    private ParserContext context;
    private final Accessor _safeAccessor;
    private Accessor _accessor;
    private String description;

    public DynamicSetAccessor(ParserContext context, char[] property, Accessor _accessor) {
        assert (_accessor != null);
        this._safeAccessor = this._accessor = _accessor;
        this.context = context;
        this.property = property;
        this.stamp = System.currentTimeMillis();
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        if (!this.opt && ++this.runcount > DynamicOptimizer.tenuringThreshold) {
            if (System.currentTimeMillis() - this.stamp < DynamicOptimizer.timeSpan) {
                this.opt = true;
                return this.optimize(ctx, elCtx, variableFactory, value);
            }
            this.runcount = 0;
            this.stamp = System.currentTimeMillis();
        }
        this._accessor.setValue(ctx, elCtx, variableFactory, value);
        return value;
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
        throw new RuntimeException("value cannot be read with this accessor");
    }

    private Object optimize(Object ctx, Object elCtx, VariableResolverFactory variableResolverFactory, Object value) {
        if (DynamicOptimizer.isOverloaded()) {
            DynamicOptimizer.enforceTenureLimit();
        }
        AccessorOptimizer ao = OptimizerFactory.getAccessorCompiler("ASM");
        this._accessor = ao.optimizeSetAccessor(this.context, this.property, ctx, elCtx, variableResolverFactory, false, value, value != null ? value.getClass() : Object.class);
        assert (this._accessor != null);
        return value;
    }

    public void deoptimize() {
        this._accessor = this._safeAccessor;
        this.opt = false;
        this.runcount = 0;
        this.stamp = System.currentTimeMillis();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Class getKnownEgressType() {
        return this._safeAccessor.getKnownEgressType();
    }
}

