/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.component;

import com.tangosol.coherence.transaction.Status;
import com.tangosol.coherence.transaction.internal.Message;
import com.tangosol.coherence.transaction.internal.Results;
import com.tangosol.coherence.transaction.internal.ServiceContext;
import com.tangosol.coherence.transaction.internal.Transaction;
import com.tangosol.coherence.transaction.internal.component.Component;
import com.tangosol.coherence.transaction.internal.storage.Session;
import java.util.HashMap;
import java.util.Map;

public class SessionReconciler
implements Component {
    @Override
    public Message invoke(Message msg) {
        String sService = msg.getOperation().getServiceName();
        Results results = msg.getResults();
        Transaction tx = (Transaction)msg.getContext();
        Session session = tx.getSession();
        boolean fHasMutations = session.hasMutations();
        results.applyToSession(tx);
        this.reconcileInvokeData(sService, results, session);
        if (!tx.isAutoCommit() && !fHasMutations && session.hasMutations()) {
            this.registerSession(tx, sService);
        }
        return msg;
    }

    private void reconcileInvokeData(String sTable, Results results, Session session) {
        Map mapInvokeData = results.getInvokeData();
        if (!mapInvokeData.isEmpty()) {
            Map<String, Map<?, ?>> mapSession = session.getClientData();
            Map<?, ?> mapCacheValue = mapSession.get(sTable);
            if (mapCacheValue == null) {
                mapCacheValue = new HashMap();
                mapSession.put(sTable, mapCacheValue);
            }
            mapCacheValue.putAll(mapInvokeData);
        }
    }

    private void registerSession(Transaction tx, String sService) {
        Status status = tx.getStatus();
        if (status != Status.COMMITTING) {
            ServiceContext.getContext(sService).getSessionManager().register(tx);
        }
    }
}

