/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.component;

import com.tangosol.coherence.transaction.internal.Message;
import com.tangosol.coherence.transaction.internal.ServiceContext;
import com.tangosol.coherence.transaction.internal.component.Component;
import com.tangosol.coherence.transaction.internal.operation.Operation;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.LockManager;
import com.tangosol.coherence.transaction.internal.storage.SyntheticKey;
import com.tangosol.coherence.transaction.internal.storage.TableInfoImpl;
import com.tangosol.coherence.transaction.internal.storage.VersionDependencyManager;
import com.tangosol.coherence.transaction.internal.storage.XidSyntheticKey;
import com.tangosol.util.InvocableMap;
import java.util.Set;

public class StorageRollback
implements Component {
    @Override
    public Message invoke(Message msg) {
        Operation op = msg.getOperation();
        String sService = op.getServiceName();
        Set entries = (Set)msg.getContext();
        LockManager lockManager = ServiceContext.getContext(sService).getLockManager();
        VersionDependencyManager dependencyManager = null;
        for (InvocableMap.Entry entry : entries) {
            XidSyntheticKey key = (XidSyntheticKey)entry.getKey();
            SyntheticKey syntheticKey = new SyntheticKey(key.getKey());
            if (dependencyManager == null) {
                dependencyManager = LocalMemberState.getMemberState(sService).ensureLocalPartitionState(syntheticKey.getPartition()).getDependencyManager();
            }
            TableInfoImpl tableInfo = new TableInfoImpl(op.getTableName(), sService);
            lockManager.unlock(tableInfo, syntheticKey);
            entry.remove(true);
        }
        if (dependencyManager != null) {
            dependencyManager.releaseVersionDependency(op.getXid());
        }
        return msg;
    }
}

