/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.util;

import com.tangosol.coherence.transaction.internal.util.PartitionedSetWrapper;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class PartitionedIteratorWrapper
implements Iterator {
    private PartitionedSetWrapper m_set;
    private Iterator m_iter;
    private Object m_last;
    private int m_partition;
    private int m_partitionCount;

    public PartitionedIteratorWrapper(PartitionedSetWrapper set) {
        this.m_set = set;
        this.m_iter = null;
        this.m_partition = 0;
        this.m_partitionCount = set.getOperation().getPartitionSet().getPartitionCount();
    }

    @Override
    public boolean hasNext() {
        return this.hasIterator() && this.m_iter.hasNext();
    }

    public Object next() {
        if (!this.hasIterator()) {
            throw new NoSuchElementException();
        }
        this.m_last = this.m_iter.next();
        return this.m_last;
    }

    @Override
    public void remove() {
        this.m_set.remove(this.m_last);
    }

    private boolean hasIterator() {
        while (!(this.m_iter != null && this.m_iter.hasNext() || this.m_partition >= this.m_partitionCount)) {
            Set set;
            if ((set = this.m_set.getPartitionedSet(this.m_partition++)) == null) continue;
            this.m_iter = set.iterator();
        }
        return this.m_iter != null;
    }
}

