/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.pof.PofConstants;
import com.tangosol.io.pof.PofHandler;
import com.tangosol.io.pof.PofHelper;
import com.tangosol.io.pof.RawQuad;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

public class ValidatingPofHandler
extends PofHelper
implements PofHandler,
PofConstants {
    private Complex m_complex;
    private Set m_setRefs = new HashSet();
    private int m_nIdPending = -1;

    @Override
    public void registerIdentity(int nId) {
        if (nId >= 0) {
            ValidatingPofHandler.checkReferenceRange(nId);
            if (this.m_nIdPending >= 0) {
                this.report("two identities (" + this.m_nIdPending + ", " + nId + ") are not permitted for one value");
            } else if (this.m_setRefs.contains(new Integer(nId))) {
                this.report("duplicate identity: " + nId);
            } else {
                this.m_nIdPending = nId;
            }
        }
    }

    @Override
    public void onNullReference(int iPos) {
        this.checkPosition(iPos);
    }

    @Override
    public void onIdentityReference(int iPos, int nId) {
        ValidatingPofHandler.checkReferenceRange(nId);
        if (!this.m_setRefs.contains(new Integer(nId))) {
            this.report("unknown identity reference: " + nId);
        }
        this.checkPosition(iPos);
    }

    @Override
    public void onInt16(int iPos, short n) {
        this.checkPosition(iPos);
    }

    @Override
    public void onInt32(int iPos, int n) {
        this.checkPosition(iPos);
    }

    @Override
    public void onInt64(int iPos, long n) {
        this.checkPosition(iPos);
    }

    @Override
    public void onInt128(int iPos, BigInteger n) {
        this.checkPosition(iPos);
        if (n == null) {
            this.report("BigInteger is null");
        } else if (n.bitLength() > 127) {
            this.report("Int128 value out of range: 0x" + n.toString(16));
        }
    }

    @Override
    public void onFloat32(int iPos, float fl) {
        this.checkPosition(iPos);
    }

    @Override
    public void onFloat64(int iPos, double dfl) {
        this.checkPosition(iPos);
    }

    @Override
    public void onFloat128(int iPos, RawQuad qfl) {
        this.checkPosition(iPos);
    }

    @Override
    public void onDecimal32(int iPos, BigDecimal dec) {
        this.checkPosition(iPos);
        ValidatingPofHandler.checkDecimalRange(dec, 4);
    }

    @Override
    public void onDecimal64(int iPos, BigDecimal dec) {
        this.checkPosition(iPos);
        ValidatingPofHandler.checkDecimalRange(dec, 8);
    }

    @Override
    public void onDecimal128(int iPos, BigDecimal dec) {
        this.checkPosition(iPos);
        ValidatingPofHandler.checkDecimalRange(dec, 16);
    }

    @Override
    public void onBoolean(int iPos, boolean f) {
        this.checkPosition(iPos);
    }

    @Override
    public void onOctet(int iPos, int b) {
        this.checkPosition(iPos);
        if (b < 0 || b > 255) {
            this.report("octet value=0x" + ValidatingPofHandler.toHexString(b, 8) + " (" + b + "); range is [0x00-0xFF]");
        }
    }

    @Override
    public void onOctetString(int iPos, Binary bin) {
        this.checkPosition(iPos);
        if (bin == null) {
            this.report("Binary is null");
        }
    }

    @Override
    public void onChar(int iPos, char ch) {
        this.checkPosition(iPos);
    }

    @Override
    public void onCharString(int iPos, String s) {
        this.checkPosition(iPos);
        if (s == null) {
            this.report("String is null");
        }
    }

    @Override
    public void onDate(int iPos, int nYear, int nMonth, int nDay) {
        this.checkPosition(iPos);
        ValidatingPofHandler.checkDate(nYear, nMonth, nDay);
    }

    @Override
    public void onYearMonthInterval(int iPos, int cYears, int cMonths) {
        this.checkPosition(iPos);
        ValidatingPofHandler.checkYearMonthInterval(cYears, cMonths);
    }

    @Override
    public void onTime(int iPos, int nHour, int nMinute, int nSecond, int nNano, boolean fUTC) {
        this.checkPosition(iPos);
        ValidatingPofHandler.checkTime(nHour, nMinute, nSecond, nNano);
    }

    @Override
    public void onTime(int iPos, int nHour, int nMinute, int nSecond, int nNano, int nHourOffset, int nMinuteOffset) {
        this.checkPosition(iPos);
        ValidatingPofHandler.checkTime(nHour, nMinute, nSecond, nNano);
        ValidatingPofHandler.checkTimeZone(nHourOffset, nMinuteOffset);
    }

    @Override
    public void onTimeInterval(int iPos, int cHours, int cMinutes, int cSeconds, int cNanos) {
        this.checkPosition(iPos);
        ValidatingPofHandler.checkTimeInterval(cHours, cMinutes, cSeconds, cNanos);
    }

    @Override
    public void onDateTime(int iPos, int nYear, int nMonth, int nDay, int nHour, int nMinute, int nSecond, int nNano, boolean fUTC) {
        this.checkPosition(iPos);
        ValidatingPofHandler.checkDate(nYear, nMonth, nDay);
        ValidatingPofHandler.checkTime(nHour, nMinute, nSecond, nNano);
    }

    @Override
    public void onDateTime(int iPos, int nYear, int nMonth, int nDay, int nHour, int nMinute, int nSecond, int nNano, int nHourOffset, int nMinuteOffset) {
        this.checkPosition(iPos);
        ValidatingPofHandler.checkDate(nYear, nMonth, nDay);
        ValidatingPofHandler.checkTime(nHour, nMinute, nSecond, nNano);
        ValidatingPofHandler.checkTimeZone(nHourOffset, nMinuteOffset);
    }

    @Override
    public void onDayTimeInterval(int iPos, int cDays, int cHours, int cMinutes, int cSeconds, int cNanos) {
        this.checkPosition(iPos);
        ValidatingPofHandler.checkDayTimeInterval(cDays, cHours, cMinutes, cSeconds, cNanos);
    }

    @Override
    public void beginCollection(int iPos, int cElements) {
        this.checkPosition(iPos);
        ValidatingPofHandler.checkElementCount(cElements);
        this.m_complex = new Complex(this.m_complex, cElements, true);
    }

    @Override
    public void beginUniformCollection(int iPos, int cElements, int nType) {
        this.checkPosition(iPos);
        ValidatingPofHandler.checkType(nType);
        ValidatingPofHandler.checkElementCount(cElements);
        this.m_complex = new Complex(this.m_complex, cElements, true, nType);
    }

    @Override
    public void beginArray(int iPos, int cElements) {
        this.checkPosition(iPos);
        ValidatingPofHandler.checkElementCount(cElements);
        this.m_complex = new Complex(this.m_complex, cElements, true);
    }

    @Override
    public void beginUniformArray(int iPos, int cElements, int nType) {
        this.checkPosition(iPos);
        ValidatingPofHandler.checkType(nType);
        ValidatingPofHandler.checkElementCount(cElements);
        this.m_complex = new Complex(this.m_complex, cElements, true, nType);
    }

    @Override
    public void beginSparseArray(int iPos, int cElements) {
        this.checkPosition(iPos);
        ValidatingPofHandler.checkElementCount(cElements);
        this.m_complex = new Complex(this.m_complex, cElements, false);
    }

    @Override
    public void beginUniformSparseArray(int iPos, int cElements, int nType) {
        this.checkPosition(iPos);
        ValidatingPofHandler.checkType(nType);
        ValidatingPofHandler.checkElementCount(cElements);
        this.m_complex = new Complex(this.m_complex, cElements, false, nType);
    }

    @Override
    public void beginMap(int iPos, int cElements) {
        this.checkPosition(iPos);
        ValidatingPofHandler.checkElementCount(cElements);
        this.m_complex = new ComplexMap(this.m_complex, cElements);
    }

    @Override
    public void beginUniformKeysMap(int iPos, int cElements, int nTypeKeys) {
        this.checkPosition(iPos);
        ValidatingPofHandler.checkType(nTypeKeys);
        ValidatingPofHandler.checkElementCount(cElements);
        this.m_complex = new ComplexMap(this.m_complex, cElements, nTypeKeys);
    }

    @Override
    public void beginUniformMap(int iPos, int cElements, int nTypeKeys, int nTypeValues) {
        this.checkPosition(iPos);
        ValidatingPofHandler.checkType(nTypeKeys);
        ValidatingPofHandler.checkType(nTypeValues);
        ValidatingPofHandler.checkElementCount(cElements);
        this.m_complex = new ComplexMap(this.m_complex, cElements, nTypeKeys, nTypeValues);
    }

    @Override
    public void beginUserType(int iPos, int nUserTypeId, int nVersionId) {
        this.checkPosition(iPos);
        if (nUserTypeId < 0) {
            this.report("illegal user type id: " + nUserTypeId);
        }
        if (nVersionId < 0) {
            this.report("illegal version id: " + nUserTypeId);
        }
        this.m_complex = new Complex(this.m_complex, Integer.MAX_VALUE, false);
    }

    @Override
    public void endComplexValue() {
        Complex complex = this.m_complex;
        if (complex == null) {
            this.report("no current compex value");
        } else {
            this.m_complex = complex.pop();
        }
    }

    protected Complex getComplex() {
        return this.m_complex;
    }

    protected void checkPosition(int iPos) {
        Complex complex = this.m_complex;
        if (complex == null) {
            if (iPos != -1) {
                this.report("position=" + iPos + " (expected position=-1)");
            }
        } else {
            complex.checkPosition(iPos);
        }
        if (this.m_nIdPending >= 0) {
            this.m_setRefs.add(new Integer(this.m_nIdPending));
        }
    }

    protected void report(String s) {
        throw new IllegalStateException(s);
    }

    public class ComplexMap
    extends Complex {
        private boolean m_fKey;
        private boolean m_fUniformValue;
        private int m_nValueTypeId;

        public ComplexMap(Complex complexCurrent, int cElements) {
            super(complexCurrent, cElements, true);
        }

        public ComplexMap(Complex complexCurrent, int cElements, int nUniformKeyTypeId) {
            super(complexCurrent, cElements, true, nUniformKeyTypeId);
        }

        public ComplexMap(Complex complexCurrent, int cElements, int nUniformKeyTypeId, int nUniformValTypeId) {
            this(complexCurrent, cElements, nUniformKeyTypeId);
            this.m_fUniformValue = true;
            this.m_nValueTypeId = nUniformValTypeId;
        }

        @Override
        public void checkPosition(int iPos) {
            super.checkPosition(iPos);
            this.m_fKey = !this.m_fKey;
        }

        @Override
        public int getNextPosition() {
            int iPos = this.getLastPosition();
            return this.m_fKey ? iPos : iPos + 1;
        }

        @Override
        public boolean isUniform() {
            return this.m_fKey ? super.isUniform() : this.m_fUniformValue;
        }

        @Override
        public int getUniformType() {
            return this.m_fKey ? super.getUniformType() : this.m_nValueTypeId;
        }
    }

    public class Complex
    extends Base {
        private int m_iPosPrev = -1;
        private int m_cElements;
        private boolean m_fContiguous;
        private boolean m_fUniform;
        private int m_nTypeId;
        private Complex m_complexOuter;

        public Complex(Complex complexCurrent, int cElements, boolean fContiguous) {
            this.m_complexOuter = complexCurrent;
            this.m_cElements = cElements;
            this.m_fContiguous = fContiguous;
        }

        public Complex(Complex complexCurrent, int cElements, boolean fContiguous, int nUniformTypeId) {
            this(complexCurrent, cElements, fContiguous);
            this.m_fUniform = true;
            this.m_nTypeId = nUniformTypeId;
        }

        public void checkPosition(int iPos) {
            if (iPos < 0) {
                ValidatingPofHandler.this.report("illegal negative position: " + iPos);
            } else if (iPos >= this.getElementCount()) {
                ValidatingPofHandler.this.report("position of range: " + iPos + " (range=0.." + this.getElementCount() + ")");
            } else if (this.isContiguous()) {
                if (iPos != this.getNextPosition()) {
                    ValidatingPofHandler.this.report("position is non-contiguous: " + iPos + " (expected=" + this.getNextPosition() + ")");
                }
            } else if (iPos <= this.getLastPosition()) {
                ValidatingPofHandler.this.report("position is non-increasing: " + iPos + " (previous=" + this.getLastPosition() + ")");
            }
            this.m_iPosPrev = iPos;
        }

        public int getLastPosition() {
            return this.m_iPosPrev;
        }

        public int getNextPosition() {
            if (!this.isContiguous()) {
                throw new UnsupportedOperationException("not contiguous");
            }
            return this.getLastPosition() + 1;
        }

        public int getElementCount() {
            return this.m_cElements;
        }

        public boolean isContiguous() {
            return this.m_fContiguous;
        }

        public boolean isUniform() {
            return this.m_fUniform;
        }

        public int getUniformType() {
            return this.m_nTypeId;
        }

        public Complex pop() {
            if (this.isContiguous() && this.getNextPosition() != this.getElementCount()) {
                ValidatingPofHandler.this.report("missing " + (this.getElementCount() - this.getNextPosition()) + " elements");
            }
            return this.m_complexOuter;
        }
    }
}

