/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.partition;

import com.tangosol.net.PartitionedService;
import com.tangosol.net.partition.DefaultKeyPartitioningStrategy;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.ClassHelper;

public class BroadKeyPartitioningStrategy
extends DefaultKeyPartitioningStrategy {
    private int m_nSpan;

    public BroadKeyPartitioningStrategy(int nSpan) {
        this.m_nSpan = Math.max(0, nSpan);
    }

    @Override
    public void init(PartitionedService service) {
        super.init(service);
        int nMaxSpan = (int)Math.sqrt(service.getPartitionCount());
        if (this.m_nSpan > nMaxSpan) {
            throw new IllegalStateException(ClassHelper.getSimpleName(this.getClass()) + ": the span should not exceed " + nMaxSpan);
        }
    }

    @Override
    public int getKeyPartition(Object oKey) {
        PartitionedService service = this.m_service;
        Object oBaseKey = service.getKeyAssociator().getAssociatedKey(oKey);
        if (oBaseKey == null) {
            oBaseKey = oKey;
        }
        int cParts = service.getPartitionCount();
        int nSpan = this.getSpan(oBaseKey);
        int nBase = BroadKeyPartitioningStrategy.toBinary(oBaseKey, service.getSerializer()).calculateNaturalPartition(cParts);
        int of = Math.abs(oKey.hashCode()) % (nSpan + 1);
        return (nBase + of) % cParts;
    }

    @Override
    public PartitionSet getAssociatedPartitions(Object oKey) {
        PartitionedService service = this.m_service;
        Object oBaseKey = service.getKeyAssociator().getAssociatedKey(oKey);
        if (oBaseKey == null) {
            oBaseKey = oKey;
        }
        int cParts = service.getPartitionCount();
        int nSpan = this.getSpan(oBaseKey);
        int nBase = BroadKeyPartitioningStrategy.toBinary(oBaseKey, service.getSerializer()).calculateNaturalPartition(cParts);
        PartitionSet parts = new PartitionSet(cParts);
        for (int of = 0; of <= nSpan; ++of) {
            parts.add((nBase + of) % cParts);
        }
        return parts;
    }

    protected int getSpan(Object oBaseKey) {
        return this.m_nSpan;
    }
}

