/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.partition;

import com.tangosol.net.Member;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.partition.PartitionSet;
import java.util.EventObject;

public class PartitionEvent
extends EventObject {
    public static final int PARTITION_LOST = 1;
    public static final int PARTITION_TRANSMIT_BEGIN = 2;
    public static final int PARTITION_TRANSMIT_COMMIT = 3;
    public static final int PARTITION_TRANSMIT_ROLLBACK = 4;
    public static final int PARTITION_RECEIVE_BEGIN = 5;
    public static final int PARTITION_RECEIVE_COMMIT = 6;
    public static final int PARTITION_ASSIGNED = 7;
    protected int m_nId;
    protected PartitionSet m_setPartitions;
    protected Member m_memberFrom;
    protected Member m_memberTo;

    public PartitionEvent(PartitionedService svc, int nId, PartitionSet setPartitions, Member memberFrom, Member memberTo) {
        super(svc);
        this.m_nId = nId;
        this.m_setPartitions = setPartitions;
        this.m_memberFrom = memberFrom;
        this.m_memberTo = memberTo;
    }

    public PartitionedService getService() {
        return (PartitionedService)this.getSource();
    }

    public int getId() {
        return this.m_nId;
    }

    public PartitionSet getPartitionSet() {
        return this.m_setPartitions;
    }

    public Member getFromMember() {
        return this.m_memberFrom;
    }

    public Member getToMember() {
        return this.m_memberTo;
    }

    protected String getDescription() {
        Member memberFrom = this.getFromMember();
        Member memberTo = this.getToMember();
        StringBuffer sb = new StringBuffer();
        PartitionSet partitions = this.getPartitionSet();
        if (partitions.cardinality() == 1) {
            sb.append("partition=").append(partitions.next(0));
        } else {
            sb.append(this.getPartitionSet());
        }
        int nEventId = this.getId();
        switch (nEventId) {
            case 1: {
                if (memberFrom != null) {
                    sb.append(" lost by ").append(memberFrom);
                }
                if (memberTo == null) break;
                sb.append(" ownership reassigned to ").append(memberTo);
                break;
            }
            case 7: {
                if (memberTo == null) break;
                sb.append(" ownership assigned to ").append(memberTo);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                sb.append(' ').append(PartitionEvent.getDescription(nEventId)).append(" from ");
                if (memberFrom == null) {
                    sb.append("backup");
                } else {
                    sb.append(memberFrom);
                }
                sb.append(" to ").append(memberTo);
                break;
            }
            default: {
                throw new IllegalStateException("unknown event: " + nEventId);
            }
        }
        return sb.toString();
    }

    public static String getDescription(int nId) {
        switch (nId) {
            case 1: {
                return "lost";
            }
            case 7: {
                return "assigned";
            }
            case 2: {
                return "transmission began";
            }
            case 3: {
                return "transmission committed";
            }
            case 4: {
                return "transmission rolled back";
            }
            case 5: {
                return "receive began";
            }
            case 6: {
                return "receive committed";
            }
        }
        return "<unknown>";
    }

    @Override
    public String toString() {
        String sEvt = this.getClass().getName();
        return sEvt.substring(sEvt.lastIndexOf(46) + 1) + "{Service=" + this.getService().getInfo().getServiceName() + ", " + this.getDescription() + '}';
    }
}

