/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.NullImplementation;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class DeltaSet
extends AbstractSet
implements Cloneable,
Serializable {
    private static final Set EMPTY_SET = NullImplementation.getSet();
    private static final Iterator EMPTY_ITERATOR = NullImplementation.getIterator();
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Set m_setOrig;
    private HashSet m_setAdded;
    private HashSet m_setRemoved;

    public DeltaSet(Set set) {
        this.m_setOrig = set;
        this.reset();
    }

    public Set getOriginal() {
        return this.m_setOrig;
    }

    public boolean isModified() {
        return this.m_setAdded != null || this.m_setRemoved != null;
    }

    public Set getAdded() {
        HashSet set = this.m_setAdded;
        return set == null ? EMPTY_SET : set;
    }

    public Set getRemoved() {
        HashSet set = this.m_setRemoved;
        return set == null ? EMPTY_SET : set;
    }

    protected Set ensureAdded() {
        HashSet set = this.m_setAdded;
        if (set == null) {
            this.m_setAdded = set = new HashSet();
        }
        return set;
    }

    protected Set ensureRemoved() {
        HashSet set = this.m_setRemoved;
        if (set == null) {
            this.m_setRemoved = set = new HashSet();
        }
        return set;
    }

    public void resolve() {
        Set setRemoved;
        Set setAdded = this.getAdded();
        if (!setAdded.isEmpty()) {
            this.m_setOrig.addAll(setAdded);
        }
        if (!(setRemoved = this.getRemoved()).isEmpty()) {
            this.m_setOrig.removeAll(setRemoved);
        }
        this.reset();
    }

    public void reset() {
        this.m_setAdded = null;
        this.m_setRemoved = null;
    }

    @Override
    public Iterator iterator() {
        return this.isEmpty() ? EMPTY_ITERATOR : new DeltaIterator();
    }

    @Override
    public int size() {
        int c = this.m_setOrig.size() + this.getAdded().size() - this.getRemoved().size();
        return c;
    }

    @Override
    public boolean contains(Object o) {
        return this.getAdded().contains(o) || !this.getRemoved().contains(o) && this.m_setOrig.contains(o);
    }

    @Override
    public boolean add(Object o) {
        if (this.getRemoved().contains(o)) {
            this.ensureRemoved().remove(o);
            return true;
        }
        if (this.getAdded().contains(o) || this.m_setOrig.contains(o)) {
            return false;
        }
        this.ensureAdded().add(o);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (this.getRemoved().contains(o)) {
            return false;
        }
        if (this.getAdded().contains(o)) {
            this.ensureAdded().remove(o);
            return true;
        }
        if (this.m_setOrig.contains(o)) {
            this.ensureRemoved().add(o);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.reset();
        this.ensureRemoved().addAll(this.m_setOrig);
    }

    @Override
    public Object[] toArray() {
        int c = this.size();
        if (c == 0) {
            return EMPTY_ARRAY;
        }
        Object[] ao = new Object[c];
        Set setAdded = this.getAdded();
        c = setAdded.size();
        if (c > 0) {
            setAdded.toArray(ao);
        }
        Set setRemoved = this.getRemoved();
        for (Object o : this.m_setOrig) {
            if (setRemoved.contains(o)) continue;
            ao[c++] = o;
        }
        return ao;
    }

    public Object clone() {
        HashSet setRemoved;
        DeltaSet dset;
        try {
            dset = (DeltaSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
        HashSet setAdded = dset.m_setAdded;
        if (setAdded != null) {
            dset.m_setAdded = (HashSet)setAdded.clone();
        }
        if ((setRemoved = dset.m_setRemoved) != null) {
            dset.m_setRemoved = (HashSet)setRemoved.clone();
        }
        return dset;
    }

    protected class DeltaIterator
    implements Iterator {
        private Object[] m_aObject;
        private int m_index = 0;
        private boolean m_fRemovable = false;

        protected DeltaIterator() {
            this.m_aObject = DeltaSet.this.toArray();
        }

        @Override
        public boolean hasNext() {
            return this.m_index < this.m_aObject.length;
        }

        public Object next() {
            if (this.m_index < this.m_aObject.length) {
                this.m_fRemovable = true;
                return this.m_aObject[this.m_index++];
            }
            this.m_fRemovable = false;
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (!this.m_fRemovable) {
                throw new IllegalStateException();
            }
            this.m_fRemovable = false;
            DeltaSet.this.remove(this.m_aObject[this.m_index - 1]);
        }
    }
}

