/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.AbstractLongArray;
import com.tangosol.util.LongArray;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;

public class SimpleLongArray
extends AbstractLongArray
implements Serializable {
    public static final long MAX = Integer.MAX_VALUE;
    public static final Object[] EMPTY = new Object[0];
    Object[] m_ao;
    int m_iFirst;
    int m_iLast;
    int m_cItems;

    public SimpleLongArray() {
        this.clear();
    }

    @Override
    public Object get(long lIndex) {
        if (lIndex < 0L || lIndex > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("illegal index: " + lIndex);
        }
        int i = (int)lIndex;
        if (i < this.m_iFirst || i > this.m_iLast) {
            return null;
        }
        return this.m_ao[i];
    }

    @Override
    public Object set(long lIndex, Object oValue) {
        if (oValue == null) {
            return this.remove(lIndex);
        }
        if (lIndex < 0L || lIndex > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("illegal index: " + lIndex);
        }
        int iFirst = this.m_iFirst;
        int iLast = this.m_iLast;
        int cItems = this.m_cItems;
        int i = (int)lIndex;
        Object[] ao = this.m_ao;
        int co = ao.length;
        if (i >= co) {
            int coNew = Math.max((i >>> 5) + 1 << 5, co + (co >>> 2));
            Object[] aoNew = new Object[coNew];
            if (cItems > 0) {
                System.arraycopy(ao, iFirst, aoNew, iFirst, iLast - iFirst + 1);
            }
            ao = aoNew;
            this.m_ao = aoNew;
        }
        Object oOrig = ao[i];
        ao[i] = oValue;
        if (oOrig == null) {
            if (cItems == 0) {
                this.m_iFirst = i;
                this.m_iLast = i;
                this.m_cItems = 1;
            } else {
                if (i < iFirst) {
                    this.m_iFirst = i;
                } else if (i > iLast) {
                    this.m_iLast = i;
                }
                this.m_cItems = cItems + 1;
            }
        }
        return oOrig;
    }

    @Override
    public long add(Object oValue) {
        int i = this.m_iLast + 1;
        this.set(i, oValue);
        return i;
    }

    @Override
    public boolean exists(long lIndex) {
        int i;
        if (lIndex >= 0L && lIndex < Integer.MAX_VALUE && (i = (int)lIndex) >= this.m_iFirst && i <= this.m_iLast) {
            return this.m_ao[i] != null;
        }
        return false;
    }

    @Override
    public Object remove(long lIndex) {
        if (lIndex < 0L || lIndex > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("illegal index: " + lIndex);
        }
        int iFirst = this.m_iFirst;
        int iLast = this.m_iLast;
        int i = (int)lIndex;
        if (i < iFirst || i > iLast) {
            return null;
        }
        Object[] ao = this.m_ao;
        Object oOrig = ao[i];
        if (oOrig == null) {
            return null;
        }
        int cItems = this.m_cItems;
        if (cItems == 1) {
            this.clear();
        } else {
            ao[i] = null;
            this.m_cItems = cItems - 1;
            if (i == iFirst) {
                while (ao[++iFirst] == null) {
                }
                this.m_iFirst = iFirst;
            } else if (i == iLast) {
                while (ao[--iLast] == null) {
                }
                this.m_iLast = iLast;
            }
        }
        return oOrig;
    }

    @Override
    public boolean contains(Object oValue) {
        return this.indexOf(oValue, 0L) != -1L;
    }

    @Override
    public void clear() {
        this.m_ao = EMPTY;
        this.m_iFirst = -1;
        this.m_iLast = -1;
        this.m_cItems = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.m_cItems == 0;
    }

    @Override
    public int getSize() {
        return this.m_cItems;
    }

    @Override
    public LongArray.Iterator iterator() {
        return new Iterator(Math.max(0, this.m_iFirst), true);
    }

    @Override
    public LongArray.Iterator iterator(long lIndex) {
        if (lIndex < 0L || lIndex > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("illegal index: " + lIndex);
        }
        return new Iterator((int)lIndex, true);
    }

    @Override
    public LongArray.Iterator reverseIterator() {
        return new Iterator(Math.max(0, this.m_iLast), false);
    }

    @Override
    public LongArray.Iterator reverseIterator(long lIndex) {
        if (lIndex < 0L || lIndex > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("illegal index: " + lIndex);
        }
        return new Iterator((int)lIndex, false);
    }

    @Override
    public long getFirstIndex() {
        return this.m_iFirst == -1 ? -1L : (long)this.m_iFirst;
    }

    @Override
    public long getLastIndex() {
        return this.m_iLast == -1 ? -1L : (long)this.m_iLast;
    }

    @Override
    public long indexOf(Object oValue, long lIndex) {
        if (oValue == null || this.m_iFirst == -1) {
            return -1L;
        }
        int iFirst = (int)Math.min(Math.max(0L, lIndex), Integer.MAX_VALUE);
        int iLast = this.m_iLast;
        Object[] ao = this.m_ao;
        for (int i = iFirst; i <= iLast; ++i) {
            Object oElement = ao[i];
            if (oElement == null || !oValue.equals(oElement)) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(Object oValue, long lIndex) {
        if (oValue == null || this.m_iFirst == -1) {
            return -1L;
        }
        int iFirst = this.m_iFirst;
        int iLast = (int)Math.min(lIndex, Integer.MAX_VALUE);
        Object[] ao = this.m_ao;
        for (int i = iLast; i >= iFirst; --i) {
            Object oElement = ao[i];
            if (oElement == null || !oValue.equals(oElement)) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public Object clone() {
        SimpleLongArray that = (SimpleLongArray)super.clone();
        Object[] ao = that.m_ao;
        if (ao != null && ao.length != 0) {
            that.m_ao = (Object[])ao.clone();
        }
        return that;
    }

    public class Iterator
    implements LongArray.Iterator {
        private boolean m_fForward;
        private int m_iNext;
        private int m_iPrev;

        public Iterator(int iNext, boolean fForward) {
            this.m_iNext = fForward ? Math.max(SimpleLongArray.this.m_iFirst, iNext) : Math.min(SimpleLongArray.this.m_iLast, iNext);
            this.m_iPrev = -1;
            this.m_fForward = fForward;
            if (!SimpleLongArray.this.exists(this.m_iNext)) {
                this.scanNext();
            }
        }

        @Override
        public boolean hasNext() {
            return this.m_iNext >= SimpleLongArray.this.m_iFirst && this.m_iNext <= SimpleLongArray.this.m_iLast && this.m_iNext >= 0;
        }

        @Override
        public Object next() {
            int i = this.m_iNext;
            if (i > SimpleLongArray.this.m_iLast || i < SimpleLongArray.this.m_iFirst) {
                throw new NoSuchElementException();
            }
            Object o = SimpleLongArray.this.get(i);
            if (o == null) {
                throw new ConcurrentModificationException();
            }
            this.m_iPrev = i;
            this.scanNext();
            return o;
        }

        @Override
        public long getIndex() {
            int i = this.m_iPrev;
            if (i < 0) {
                throw new IllegalStateException();
            }
            return i;
        }

        @Override
        public Object getValue() {
            return SimpleLongArray.this.get(this.getIndex());
        }

        @Override
        public Object setValue(Object oValue) {
            Object oOrig = SimpleLongArray.this.set(this.getIndex(), oValue);
            if (oValue == null) {
                this.m_iPrev = -1;
            }
            return oOrig;
        }

        @Override
        public void remove() {
            SimpleLongArray.this.remove(this.getIndex());
            this.m_iPrev = -1;
        }

        private void scanNext() {
            Object[] ao = SimpleLongArray.this.m_ao;
            int iDelta = this.m_fForward ? 1 : -1;
            int i = this.m_iNext;
            int iFirst = SimpleLongArray.this.m_iFirst;
            int iLast = SimpleLongArray.this.m_iLast;
            while ((i += iDelta) >= iFirst && i <= iLast && i >= 0 && ao[i] == null) {
            }
            this.m_iNext = i;
        }
    }
}

