/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.extractor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.BackingMapContext;
import com.tangosol.util.ConditionalIndex;
import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.AbstractExtractor;
import com.tangosol.util.extractor.IndexAwareExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;

public class ConditionalExtractor
extends AbstractExtractor
implements IndexAwareExtractor,
ExternalizableLite,
PortableObject {
    protected Filter m_filter;
    protected ValueExtractor m_extractor;
    protected boolean m_fForwardIndex;

    public ConditionalExtractor() {
    }

    public ConditionalExtractor(Filter filter, ValueExtractor extractor, boolean fForwardIndex) {
        ConditionalExtractor.azzert(filter != null && extractor != null, "Filter and extractor must not be null");
        this.m_filter = filter;
        this.m_extractor = extractor;
        this.m_fForwardIndex = fForwardIndex;
    }

    @Override
    public MapIndex createIndex(boolean fOrdered, Comparator comparator, Map mapIndex, BackingMapContext ctx) {
        ValueExtractor extractor = this.m_extractor;
        MapIndex index = (MapIndex)mapIndex.get(extractor);
        if (index != null) {
            if (index instanceof ConditionalIndex && ConditionalExtractor.equals(((ConditionalIndex)index).getFilter(), this.m_filter)) {
                return null;
            }
            throw new IllegalArgumentException("Repetitive addIndex call for " + this);
        }
        index = new ConditionalIndex(this.m_filter, extractor, fOrdered, comparator, this.m_fForwardIndex, ctx);
        mapIndex.put(extractor, index);
        return index;
    }

    @Override
    public MapIndex destroyIndex(Map mapIndex) {
        return (MapIndex)mapIndex.remove(this.m_extractor);
    }

    @Override
    public Object extract(Object oTarget) {
        throw new UnsupportedOperationException("ConditionalExtractor may not be used as an extractor.");
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_filter = (Filter)ConditionalExtractor.readObject(in);
        this.m_extractor = (ValueExtractor)ConditionalExtractor.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ConditionalExtractor.writeObject(out, this.m_filter);
        ConditionalExtractor.writeObject(out, this.m_extractor);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_filter = (Filter)in.readObject(0);
        this.m_extractor = (ValueExtractor)in.readObject(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_filter);
        out.writeObject(1, this.m_extractor);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ConditionalExtractor) {
            ConditionalExtractor that = (ConditionalExtractor)o;
            return ConditionalExtractor.equals(this.m_filter, that.m_filter) && ConditionalExtractor.equals(this.m_extractor, that.m_extractor) && this.m_fForwardIndex == that.m_fForwardIndex;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.m_filter.hashCode() ^ ((Object)this.m_extractor).hashCode();
    }

    @Override
    public String toString() {
        return "ConditionalExtractor(extractor=" + this.m_extractor + ", filter=" + this.m_filter + ")";
    }
}

