/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.extractor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.MapEvent;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.AbstractExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.NotActiveException;
import java.lang.reflect.Method;

public class ReflectionExtractor
extends AbstractExtractor
implements ValueExtractor,
ExternalizableLite,
PortableObject {
    protected String m_sMethod;
    protected Object[] m_aoParam;
    private transient Method m_methodPrev;

    public ReflectionExtractor() {
    }

    public ReflectionExtractor(String sMethod) {
        this(sMethod, null, 0);
    }

    public ReflectionExtractor(String sMethod, Object[] aoParam) {
        this(sMethod, aoParam, 0);
    }

    public ReflectionExtractor(String sMethod, Object[] aoParam, int nTarget) {
        ReflectionExtractor.azzert(sMethod != null);
        this.m_sMethod = sMethod;
        this.m_aoParam = aoParam;
        this.m_nTarget = nTarget;
    }

    @Override
    public Object extract(Object oTarget) {
        if (oTarget == null) {
            return null;
        }
        Class<?> clz = oTarget.getClass();
        try {
            Method method = this.m_methodPrev;
            if (method == null || method.getDeclaringClass() != clz) {
                this.m_methodPrev = method = ClassHelper.findMethod(clz, this.getMethodName(), this.getClassArray(), false);
            }
            return method.invoke(oTarget, this.m_aoParam);
        }
        catch (NullPointerException e) {
            throw new RuntimeException(this.suggestExtractFailureCause(clz));
        }
        catch (Exception e) {
            throw ReflectionExtractor.ensureRuntimeException(e, clz.getName() + this + '(' + oTarget + ')');
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ReflectionExtractor) {
            ReflectionExtractor that = (ReflectionExtractor)o;
            return this.m_sMethod.equals(that.m_sMethod) && ReflectionExtractor.equalsDeep(this.m_aoParam, that.m_aoParam);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.m_sMethod.hashCode();
    }

    @Override
    public String toString() {
        Object[] aoParam = this.m_aoParam;
        int cParams = aoParam == null ? 0 : aoParam.length;
        StringBuffer sb = new StringBuffer();
        if (this.m_nTarget == 1) {
            sb.append(".getKey()");
        }
        sb.append('.').append(this.m_sMethod).append('(');
        for (int i = 0; i < cParams; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(String.valueOf(aoParam[i]));
        }
        sb.append(')');
        return sb.toString();
    }

    public String getMethodName() {
        return this.m_sMethod;
    }

    public Object[] getParameters() {
        return this.m_aoParam;
    }

    private String suggestExtractFailureCause(Class clzTarget) {
        String sMsg = "Missing or inaccessible method: " + clzTarget.getName() + this;
        if (MapEvent.class.isAssignableFrom(clzTarget)) {
            sMsg = sMsg + " (the object is a com.tangosol.util.MapEvent, which may suggest that a raw com.tangosol.util.Filter is being used to filter map events rather than a com.tangosol.util.filter.MapEventFilter)";
        }
        return sMsg;
    }

    private Class[] getClassArray() {
        int cParams;
        Object[] aoParam = this.m_aoParam;
        if (aoParam != null && (cParams = aoParam.length) > 0) {
            Class[] aClass = new Class[cParams];
            for (int i = 0; i < cParams; ++i) {
                Object oParam = aoParam[i];
                if (oParam == null) continue;
                aClass[i] = oParam.getClass();
            }
            return aClass;
        }
        return ClassHelper.VOID_PARAMS;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_sMethod = ReflectionExtractor.readUTF(in);
        int cParams = ReflectionExtractor.readInt(in);
        Object[] aoParam = cParams == 0 ? null : new Object[cParams];
        for (int i = 0; i < cParams; ++i) {
            aoParam[i] = ReflectionExtractor.readObject(in);
        }
        this.m_aoParam = aoParam;
        this.m_nTarget = ReflectionExtractor.readInt(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        String sMethod = this.m_sMethod;
        if (sMethod == null) {
            throw new NotActiveException("ReflectionExtractor was constructed without a method name");
        }
        Object[] aoParam = this.m_aoParam;
        int cParams = aoParam == null ? 0 : aoParam.length;
        ReflectionExtractor.writeUTF(out, sMethod);
        ReflectionExtractor.writeInt(out, cParams);
        for (int i = 0; i < cParams; ++i) {
            ReflectionExtractor.writeObject(out, aoParam[i]);
        }
        ReflectionExtractor.writeInt(out, this.m_nTarget);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_sMethod = in.readString(0);
        int cParams = in.readInt(1);
        if (cParams > 0) {
            Object[] aoParam = new Object[cParams];
            for (int i = 0; i < cParams; ++i) {
                aoParam[i] = in.readObject(i + 2);
            }
            this.m_aoParam = aoParam;
        } else {
            this.m_aoParam = in.readObjectArray(2, null);
            this.m_nTarget = in.readInt(3);
        }
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        String sMethod = this.m_sMethod;
        if (sMethod == null) {
            throw new NotActiveException("ReflectionExtractor was constructed without a method name");
        }
        out.writeString(0, sMethod);
        out.writeObjectArray(2, this.m_aoParam);
        out.writeInt(3, this.m_nTarget);
    }
}

