/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.collections;

import com.oracle.common.collections.Collections;
import com.oracle.common.collections.SimpleMapEntry;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractKeyBasedMap<K, V>
implements Map<K, V> {
    private transient Set<K> m_setKeys;
    private transient Set<Map.Entry<K, V>> m_setEntries;
    private transient Collection<V> m_collValues;

    @Override
    public void clear() {
        Iterator<K> iter = this.iterateKeys();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    @Override
    public boolean containsKey(Object oKey) {
        Iterator<K> iter = this.iterateKeys();
        while (iter.hasNext()) {
            if (!Collections.equals(oKey, iter.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object oValue) {
        return this.values().contains(oValue);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.m_setEntries;
        if (set == null) {
            this.m_setEntries = set = this.instantiateEntrySet();
        }
        return set;
    }

    @Override
    public abstract V get(Object var1);

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<K> keySet() {
        Set<K> set = this.m_setKeys;
        if (set == null) {
            this.m_setKeys = set = this.instantiateKeySet();
        }
        return set;
    }

    @Override
    public V put(K oKey, V oValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object oKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int c = 0;
        Iterator<K> iter = this.iterateKeys();
        while (iter.hasNext()) {
            iter.next();
            ++c;
        }
        return c;
    }

    @Override
    public Collection<V> values() {
        Collection<V> coll = this.m_collValues;
        if (coll == null) {
            this.m_collValues = coll = this.instantiateValues();
        }
        return coll;
    }

    public Map getAll(Collection colKeys) {
        LinkedHashMap map = new LinkedHashMap();
        for (Object oKey : colKeys) {
            V oVal = this.get(oKey);
            if (oVal == null && !this.containsKey(oKey)) continue;
            map.put(oKey, oVal);
        }
        return map;
    }

    protected abstract Iterator<K> iterateKeys();

    protected boolean removeBlind(Object oKey) {
        if (this.containsKey(oKey)) {
            this.remove(oKey);
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Map) {
            Map that = (Map)o;
            if (this == that) {
                return true;
            }
            if (this.size() == that.size()) {
                for (Map.Entry<K, V> entry : this.entrySet()) {
                    Object oThatValue;
                    K oKey = entry.getKey();
                    V oThisValue = entry.getValue();
                    try {
                        oThatValue = that.get(oKey);
                    }
                    catch (ClassCastException e) {
                        return false;
                    }
                    catch (NullPointerException e) {
                        return false;
                    }
                    if (!(oThisValue == this || oThisValue == that ? oThatValue != this && oThatValue != that : !Collections.equals(oThisValue, oThatValue) || oThatValue == null && !that.containsKey(oKey))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int nHash = 0;
        for (Map.Entry<K, V> entry : this.entrySet()) {
            nHash += ((Object)entry).hashCode();
        }
        return nHash;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100 + (this.size() << 3));
        sb.append('{');
        boolean fFirst = true;
        for (Map.Entry<K, V> entry : this.entrySet()) {
            if (fFirst) {
                fFirst = false;
            } else {
                sb.append(", ");
            }
            K oKey = entry.getKey();
            V oValue = entry.getValue();
            sb.append(oKey == this ? "(this Map)" : String.valueOf(oKey)).append('=').append(oValue == this ? "(this Map)" : String.valueOf(oValue));
        }
        sb.append('}');
        return sb.toString();
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractKeyBasedMap that = (AbstractKeyBasedMap)super.clone();
        that.m_setKeys = null;
        that.m_setEntries = null;
        that.m_collValues = null;
        return that;
    }

    protected Set<K> instantiateKeySet() {
        return new KeySet();
    }

    protected Set<Map.Entry<K, V>> instantiateEntrySet() {
        return new EntrySet();
    }

    protected Collection<V> instantiateValues() {
        return new ValuesCollection();
    }

    protected class ValuesCollection
    extends AbstractCollection<V> {
        protected ValuesCollection() {
        }

        @Override
        public void clear() {
            AbstractKeyBasedMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                for (Object oValue : this) {
                    if (oValue != null) continue;
                    return true;
                }
            } else {
                for (Object oValue : this) {
                    if (!Collections.equals(o, oValue)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return AbstractKeyBasedMap.this.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            return this.isEmpty() ? Collections.emptyIterator() : this.instantiateIterator();
        }

        @Override
        public boolean remove(Object o) {
            if (o == null) {
                Iterator iter = this.iterator();
                while (iter.hasNext()) {
                    if (iter.next() != null) continue;
                    iter.remove();
                    return true;
                }
            } else {
                Iterator iter = this.iterator();
                while (iter.hasNext()) {
                    if (!Collections.equals(o, iter.next())) continue;
                    iter.remove();
                    return true;
                }
            }
            return false;
        }

        @Override
        public int size() {
            return AbstractKeyBasedMap.this.size();
        }

        @Override
        public Object[] toArray() {
            return this.toArray((T[])null);
        }

        @Override
        public <T> T[] toArray(T[] ao) {
            return Collections.toArray(this.iterator(), ao);
        }

        protected Iterator<V> instantiateIterator() {
            return new ValuesIterator();
        }

        protected class ValuesIterator
        implements Iterator<V> {
            protected Iterator<K> m_iterKeys;

            protected ValuesIterator() {
                this.m_iterKeys = AbstractKeyBasedMap.this.iterateKeys();
            }

            @Override
            public boolean hasNext() {
                return this.m_iterKeys.hasNext();
            }

            @Override
            public V next() {
                return AbstractKeyBasedMap.this.get(this.m_iterKeys.next());
            }

            @Override
            public void remove() {
                this.m_iterKeys.remove();
            }
        }
    }

    public class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        @Override
        public void clear() {
            AbstractKeyBasedMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                AbstractKeyBasedMap map;
                Map.Entry entry = (Map.Entry)o;
                Object oKey = entry.getKey();
                Object oValue = entry.getValue();
                return Collections.equals(oValue, (map = AbstractKeyBasedMap.this).get(oKey)) && (oValue != null || map.containsKey(oKey));
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return AbstractKeyBasedMap.this.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return this.isEmpty() ? Collections.emptyIterator() : this.instantiateIterator();
        }

        @Override
        public boolean remove(Object o) {
            if (this.contains(o)) {
                AbstractKeyBasedMap.this.remove(((Map.Entry)o).getKey());
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return AbstractKeyBasedMap.this.size();
        }

        @Override
        public Object[] toArray() {
            return this.toArray((T[])null);
        }

        @Override
        public <T> T[] toArray(T[] ao) {
            return Collections.toArray(this.iterator(), ao);
        }

        protected Map.Entry<K, V> instantiateEntry(K oKey, V oValue) {
            return new Entry(oKey, oValue);
        }

        protected Iterator<Map.Entry<K, V>> instantiateIterator() {
            return new EntrySetIterator();
        }

        protected class EntrySetIterator
        implements Iterator<Map.Entry<K, V>> {
            protected Iterator<K> m_iterKeys;

            protected EntrySetIterator() {
                this.m_iterKeys = AbstractKeyBasedMap.this.iterateKeys();
            }

            @Override
            public boolean hasNext() {
                return this.m_iterKeys.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                return EntrySet.this.instantiateEntry(this.m_iterKeys.next(), null);
            }

            @Override
            public void remove() {
                this.m_iterKeys.remove();
            }
        }

        protected class Entry
        extends SimpleMapEntry<K, V> {
            public Entry(K oKey, V oValue) {
                super(oKey, oValue);
            }

            @Override
            public V getValue() {
                Object oValue = super.getValue();
                if (oValue == null) {
                    oValue = AbstractKeyBasedMap.this.get(this.getKey());
                    super.setValue(oValue);
                }
                return oValue;
            }

            @Override
            public V setValue(V oValue) {
                Object oValueOrig = AbstractKeyBasedMap.this.put(this.getKey(), oValue);
                super.setValue(oValue);
                return oValueOrig;
            }

            @Override
            public int hashCode() {
                Object oKey = this.getKey();
                Object oValue = this.getValue();
                AbstractKeyBasedMap map = AbstractKeyBasedMap.this;
                return (oKey == null || oKey == map ? 0 : oKey.hashCode()) ^ (oValue == null || oValue == map ? 0 : oValue.hashCode());
            }
        }
    }

    protected class KeySet
    extends AbstractSet<K> {
        protected KeySet() {
        }

        @Override
        public void clear() {
            AbstractKeyBasedMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractKeyBasedMap.this.containsKey(o);
        }

        @Override
        public boolean isEmpty() {
            return AbstractKeyBasedMap.this.isEmpty();
        }

        @Override
        public Iterator<K> iterator() {
            return this.isEmpty() ? Collections.emptyIterator() : AbstractKeyBasedMap.this.iterateKeys();
        }

        @Override
        public boolean remove(Object o) {
            return AbstractKeyBasedMap.this.removeBlind(o);
        }

        @Override
        public int size() {
            return AbstractKeyBasedMap.this.size();
        }

        @Override
        public Object[] toArray() {
            return this.toArray((T[])null);
        }

        @Override
        public <T> T[] toArray(T[] ao) {
            return Collections.toArray(this.iterator(), ao);
        }
    }
}

