/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.collections;

import com.oracle.common.base.Converter;
import com.oracle.common.base.NaturalHasher;
import com.oracle.common.collections.ArrayIterator;
import com.oracle.common.collections.Collections;
import com.oracle.common.collections.SimpleMapEntry;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public abstract class ConverterCollections {
    public static Iterator getIterator(Iterator iter, Converter conv) {
        return new ConverterEnumerator(iter, conv);
    }

    public static ConverterCollection getCollection(Collection col, Converter convUp, Converter convDown) {
        return new ConverterCollection(col, convUp, convDown);
    }

    public static ConverterSet getSet(Set set, Converter convUp, Converter convDown) {
        return new ConverterSet(set, convUp, convDown);
    }

    public static ConverterSortedSet getSortedSet(SortedSet set, Converter convUp, Converter convDown) {
        return new ConverterSortedSet(set, convUp, convDown);
    }

    public static ConverterList getList(List list, Converter convUp, Converter convDown) {
        return new ConverterList(list, convUp, convDown);
    }

    public static ConverterListIterator getListIterator(ListIterator iter, Converter convUp, Converter convDown) {
        return new ConverterListIterator(iter, convUp, convDown);
    }

    public static ConverterMap getMap(Map map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
        return new ConverterMap(map, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static ConverterSortedMap getSortedMap(SortedMap map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
        return new ConverterSortedMap(map, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static ConverterEntrySet getEntrySet(Collection set, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
        return new ConverterEntrySet(set, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static ConverterEntry getEntry(Map.Entry entry, Converter convKeyUp, Converter convValUp, Converter convValDown) {
        return new ConverterEntry(entry, convKeyUp, convValUp, convValDown);
    }

    public static Object[] convertArray(Object[] ao, Converter conv) {
        int c = ao.length;
        for (int i = 0; i < c; ++i) {
            ao[i] = conv.convert(ao[i]);
        }
        return ao;
    }

    public static Object[] convertArray(Object[] aoSrc, Converter conv, Object[] aoDest) {
        int cSrc = aoSrc.length;
        int cDest = aoDest.length;
        if (cSrc > cDest) {
            cDest = cSrc;
            aoDest = (Object[])Array.newInstance(aoDest.getClass().getComponentType(), cDest);
        }
        if (cDest > cSrc) {
            aoDest[cSrc] = null;
        }
        for (int i = 0; i < cSrc; ++i) {
            aoDest[i] = conv.convert(aoSrc[i]);
        }
        return aoDest;
    }

    public static class ConverterEntry
    extends AbstractConverterEntry {
        protected Converter m_convKeyUp;
        protected Converter m_convValUp;
        protected Converter m_convValDown;

        public ConverterEntry(Map.Entry entry, Converter convKeyUp, Converter convValUp, Converter convValDown) {
            super(entry);
            this.m_convKeyUp = convKeyUp;
            this.m_convValUp = convValUp;
            this.m_convValDown = convValDown;
        }

        @Override
        protected Converter getConverterKeyUp() {
            return this.m_convKeyUp;
        }

        @Override
        protected Converter getConverterValueUp() {
            return this.m_convValUp;
        }

        @Override
        protected Converter getConverterValueDown() {
            return this.m_convValDown;
        }
    }

    protected static abstract class AbstractConverterEntry
    implements Map.Entry,
    Serializable {
        protected Map.Entry m_entry;
        protected transient Object m_oKeyUp;
        protected transient Object m_oValueUp;

        protected AbstractConverterEntry(Map.Entry entry) {
            this.m_entry = entry;
        }

        protected abstract Converter getConverterKeyUp();

        protected abstract Converter getConverterValueUp();

        protected abstract Converter getConverterValueDown();

        public Object getKey() {
            Object oKeyUp = this.m_oKeyUp;
            if (oKeyUp == null) {
                this.m_oKeyUp = oKeyUp = this.getConverterKeyUp().convert(this.getEntry().getKey());
            }
            return oKeyUp;
        }

        public Object getValue() {
            Object oValueUp = this.m_oValueUp;
            if (oValueUp == null) {
                this.m_oValueUp = oValueUp = this.getConverterValueUp().convert(this.getEntry().getValue());
            }
            return oValueUp;
        }

        public Object setValue(Object value) {
            this.m_oValueUp = null;
            return this.getConverterValueUp().convert(this.getEntry().setValue(this.getConverterValueDown().convert(value)));
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Map.Entry) {
                Map.Entry that = (Map.Entry)o;
                return NaturalHasher.INSTANCE.equals(this.getKey(), that.getKey()) && NaturalHasher.INSTANCE.equals(this.getValue(), that.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            Object oKey = this.getKey();
            Object oValue = this.getValue();
            return (oKey == null ? 0 : oKey.hashCode()) ^ (oValue == null ? 0 : oValue.hashCode());
        }

        public String toString() {
            return "ConverterEntry{Key=\"" + this.getKey() + "\", Value=\"" + this.getValue() + "\"}";
        }

        public Map.Entry getEntry() {
            return this.m_entry;
        }
    }

    public static class ConverterEntrySet
    implements Set,
    Serializable {
        protected Collection m_set;
        protected Converter m_convKeyUp;
        protected Converter m_convKeyDown;
        protected Converter m_convValUp;
        protected Converter m_convValDown;

        public ConverterEntrySet(Collection set, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            assert (set != null && convKeyUp != null && convKeyDown != null && convValUp != null && convValDown != null);
            this.m_set = set;
            this.m_convKeyUp = convKeyUp;
            this.m_convKeyDown = convKeyDown;
            this.m_convValUp = convValUp;
            this.m_convValDown = convValDown;
        }

        @Override
        public int size() {
            return this.getEntrySet().size();
        }

        @Override
        public boolean isEmpty() {
            return this.getEntrySet().isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.getEntrySet().contains(new com.oracle.common.collections.ConverterCollections$ConverterEntry((Map.Entry)o, this.getConverterKeyDown(), this.getConverterValueDown(), this.getConverterValueUp()));
        }

        @Override
        public Iterator iterator() {
            return this.wrapIterator(this.getEntrySet().iterator());
        }

        @Override
        public Object[] toArray() {
            Object[] ao = this.getEntrySet().toArray();
            int c = ao.length;
            Object[] aEntry = new Map.Entry[c];
            for (int i = 0; i < c; ++i) {
                aEntry[i] = this.wrapEntry((Map.Entry)ao[i]);
            }
            return aEntry;
        }

        @Override
        public Object[] toArray(Object[] ao) {
            Object[] aoDest;
            int cDest;
            Object[] aoSrc = this.getEntrySet().toArray();
            int cSrc = aoSrc.length;
            if (cSrc > (cDest = (aoDest = ao).length)) {
                cDest = cSrc;
                aoDest = (Object[])Array.newInstance(aoDest.getClass().getComponentType(), cDest);
            }
            if (cDest > cSrc) {
                aoDest[cSrc] = null;
            }
            for (int i = 0; i < cSrc; ++i) {
                aoDest[i] = this.wrapEntry((Map.Entry)aoSrc[i]);
            }
            return aoDest;
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            Map.Entry entry = (Map.Entry)o;
            return this.getEntrySet().remove(new SimpleMapEntry(this.getConverterKeyDown().convert(entry.getKey()), this.getConverterValueDown().convert(entry.getValue())));
        }

        @Override
        public boolean containsAll(Collection col) {
            return this.getEntrySet().containsAll(this.instantiateEntrySet(col, this.getConverterKeyDown(), this.getConverterKeyUp(), this.getConverterValueDown(), this.getConverterValueUp()));
        }

        @Override
        public boolean addAll(Collection col) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection col) {
            return this.getEntrySet().removeAll(this.instantiateEntrySet(col, this.getConverterKeyDown(), this.getConverterKeyUp(), this.getConverterValueDown(), this.getConverterValueUp()));
        }

        @Override
        public boolean retainAll(Collection col) {
            return this.getEntrySet().retainAll(this.instantiateEntrySet(col, this.getConverterKeyDown(), this.getConverterKeyUp(), this.getConverterValueDown(), this.getConverterValueUp()));
        }

        @Override
        public void clear() {
            this.getEntrySet().clear();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ConverterEntrySet) {
                ConverterEntrySet that = (ConverterEntrySet)o;
                return ((Object)this.getEntrySet()).equals(that.getEntrySet()) && this.getConverterKeyUp().equals(that.getConverterKeyUp()) && this.getConverterKeyDown().equals(that.getConverterKeyDown()) && this.getConverterValueUp().equals(that.getConverterValueUp()) && this.getConverterValueDown().equals(that.getConverterValueDown());
            }
            if (o instanceof Set) {
                Set set = (Set)o;
                return set.size() == this.size() && this.containsAll((Collection)set);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int nHash = 0;
            for (Object o : this.getEntrySet()) {
                nHash += NaturalHasher.INSTANCE.hashCode(o);
            }
            return nHash;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ConverterEntrySet{");
            boolean fFirst = true;
            for (Object o : this) {
                if (fFirst) {
                    fFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(o);
            }
            sb.append('}');
            return sb.toString();
        }

        protected Set instantiateEntrySet(Collection col, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            return ConverterCollections.getEntrySet(col, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        protected Map.Entry wrapEntry(Map.Entry entry) {
            return new ConverterEntry(entry);
        }

        protected Iterator wrapIterator(Iterator iter) {
            return new ConverterIterator(iter);
        }

        public Collection getEntrySet() {
            return this.m_set;
        }

        public Converter getConverterKeyUp() {
            return this.m_convKeyUp;
        }

        public Converter getConverterKeyDown() {
            return this.m_convKeyDown;
        }

        public Converter getConverterValueUp() {
            return this.m_convValUp;
        }

        public Converter getConverterValueDown() {
            return this.m_convValDown;
        }

        protected class ConverterIterator
        implements Iterator {
            protected Iterator m_iter;

            public ConverterIterator(Iterator iter) {
                this.m_iter = iter;
            }

            @Override
            public boolean hasNext() {
                return this.getIterator().hasNext();
            }

            public Object next() {
                return ConverterEntrySet.this.wrapEntry((Map.Entry)this.getIterator().next());
            }

            @Override
            public void remove() {
                this.getIterator().remove();
            }

            public Iterator getIterator() {
                return this.m_iter;
            }
        }

        protected class ConverterEntry
        extends AbstractConverterEntry {
            public ConverterEntry(Map.Entry entry) {
                super(entry);
            }

            @Override
            protected Converter getConverterKeyUp() {
                return ConverterEntrySet.this.getConverterKeyUp();
            }

            @Override
            protected Converter getConverterValueUp() {
                return ConverterEntrySet.this.getConverterValueUp();
            }

            @Override
            protected Converter getConverterValueDown() {
                return ConverterEntrySet.this.getConverterValueDown();
            }
        }
    }

    public static class ConverterSortedMap
    extends ConverterMap
    implements SortedMap,
    Serializable {
        public ConverterSortedMap(SortedMap map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            super(map, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        public Comparator comparator() {
            return this.getSortedMap().comparator();
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            return this.instantiateSortedMap(this.getSortedMap().subMap(fromKey, toKey), this.getConverterKeyUp(), this.getConverterKeyDown(), this.getConverterValueUp(), this.getConverterKeyDown());
        }

        public SortedMap headMap(Object toKey) {
            return this.instantiateSortedMap(this.getSortedMap().headMap(toKey), this.getConverterKeyUp(), this.getConverterKeyDown(), this.getConverterValueUp(), this.getConverterValueDown());
        }

        public SortedMap tailMap(Object fromKey) {
            return this.instantiateSortedMap(this.getSortedMap().tailMap(fromKey), this.getConverterKeyUp(), this.getConverterKeyDown(), this.getConverterValueUp(), this.getConverterValueDown());
        }

        public Object firstKey() {
            return this.getConverterKeyUp().convert(this.getSortedMap().firstKey());
        }

        public Object lastKey() {
            return this.getConverterKeyUp().convert(this.getSortedMap().lastKey());
        }

        protected SortedMap instantiateSortedMap(SortedMap map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            return ConverterCollections.getSortedMap(map, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        public SortedMap getSortedMap() {
            return (SortedMap)this.getMap();
        }
    }

    public static class ConverterMap
    implements Map,
    Serializable {
        protected Map m_map;
        protected Converter m_convKeyUp;
        protected Converter m_convKeyDown;
        protected Converter m_convValUp;
        protected Converter m_convValDown;
        protected transient Set m_set;

        public ConverterMap(Map map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            assert (map != null && convKeyUp != null && convKeyDown != null && convValUp != null && convValDown != null);
            this.m_map = map;
            this.m_convKeyUp = convKeyUp;
            this.m_convKeyDown = convKeyDown;
            this.m_convValUp = convValUp;
            this.m_convValDown = convValDown;
        }

        @Override
        public int size() {
            return this.getMap().size();
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.getMap().containsKey(this.getConverterKeyDown().convert(key));
        }

        @Override
        public boolean containsValue(Object value) {
            return this.getMap().containsValue(this.getConverterValueDown().convert(value));
        }

        public Object get(Object key) {
            return this.getConverterValueUp().convert(this.getMap().get(this.getConverterKeyDown().convert(key)));
        }

        public Object put(Object key, Object value) {
            return this.getConverterValueUp().convert(this.getMap().put(this.getConverterKeyDown().convert(key), this.getConverterValueDown().convert(value)));
        }

        public Object remove(Object key) {
            return this.getConverterValueUp().convert(this.getMap().remove(this.getConverterKeyDown().convert(key)));
        }

        public void putAll(Map map) {
            this.getMap().putAll(this.instantiateMap(map, this.getConverterKeyDown(), this.getConverterKeyUp(), this.getConverterValueDown(), this.getConverterValueUp()));
        }

        @Override
        public void clear() {
            this.getMap().clear();
        }

        public Set keySet() {
            return this.instantiateSet(this.getMap().keySet(), this.getConverterKeyUp(), this.getConverterKeyDown());
        }

        public Collection values() {
            return this.instantiateCollection(this.getMap().values(), this.getConverterValueUp(), this.getConverterValueDown());
        }

        public Set entrySet() {
            if (this.m_set == null) {
                Set set = this.getMap().entrySet();
                this.m_set = this.instantiateEntrySet(set, this.getConverterKeyUp(), this.getConverterKeyDown(), this.getConverterValueUp(), this.getConverterValueDown());
            }
            return this.m_set;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ConverterMap{");
            boolean fFirst = true;
            for (Object o : this.entrySet()) {
                if (fFirst) {
                    fFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(o);
            }
            sb.append("}");
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Map) {
                return ((Object)this.entrySet()).equals(((Map)o).entrySet());
            }
            return false;
        }

        @Override
        public int hashCode() {
            int nHash = 0;
            for (Object o : this.entrySet()) {
                nHash += NaturalHasher.INSTANCE.hashCode(o);
            }
            return nHash;
        }

        protected Collection instantiateCollection(Collection col, Converter convUp, Converter convDown) {
            return ConverterCollections.getCollection(col, convUp, convDown);
        }

        protected Set instantiateSet(Set set, Converter convUp, Converter convDown) {
            return ConverterCollections.getSet(set, convUp, convDown);
        }

        protected Map instantiateMap(Map map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            return ConverterCollections.getMap(map, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        protected Set instantiateEntrySet(Set set, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            return ConverterCollections.getEntrySet(set, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        public Map getMap() {
            return this.m_map;
        }

        public Converter getConverterKeyUp() {
            return this.m_convKeyUp;
        }

        public Converter getConverterKeyDown() {
            return this.m_convKeyDown;
        }

        public Converter getConverterValueUp() {
            return this.m_convValUp;
        }

        public Converter getConverterValueDown() {
            return this.m_convValDown;
        }
    }

    public static class ConverterListIterator
    implements ListIterator {
        protected ListIterator m_iter;
        protected Converter m_convUp;
        protected Converter m_convDown;

        public ConverterListIterator(ListIterator iter, Converter convUp, Converter convDown) {
            assert (iter != null && convUp != null && convDown != null);
            this.m_iter = iter;
            this.m_convUp = convUp;
            this.m_convDown = convDown;
        }

        @Override
        public boolean hasNext() {
            return this.getListIterator().hasNext();
        }

        @Override
        public Object next() {
            return this.getConverterUp().convert(this.getListIterator().next());
        }

        @Override
        public boolean hasPrevious() {
            return this.getListIterator().hasPrevious();
        }

        public Object previous() {
            return this.getConverterUp().convert(this.getListIterator().previous());
        }

        @Override
        public int nextIndex() {
            return this.getListIterator().nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.getListIterator().previousIndex();
        }

        @Override
        public void remove() {
            this.getListIterator().remove();
        }

        public void set(Object o) {
            this.getListIterator().set(this.getConverterDown().convert(o));
        }

        public void add(Object o) {
            this.getListIterator().add(this.getConverterDown().convert(o));
        }

        public ListIterator getListIterator() {
            return this.m_iter;
        }

        public Converter getConverterUp() {
            return this.m_convUp;
        }

        public Converter getConverterDown() {
            return this.m_convDown;
        }
    }

    public static class ConverterList
    extends ConverterCollection
    implements List,
    Serializable {
        public ConverterList(List list, Converter convUp, Converter convDown) {
            super(list, convUp, convDown);
        }

        public Object get(int index) {
            return this.getConverterUp().convert(this.getList().get(index));
        }

        public Object set(int index, Object element) {
            return this.getConverterUp().convert(this.getList().set(index, this.getConverterDown().convert(element)));
        }

        public void add(int index, Object element) {
            this.getList().add(index, this.getConverterDown().convert(element));
        }

        public boolean addAll(int index, Collection col) {
            return this.getList().addAll(index, this.instantiateCollection(col, this.getConverterDown(), this.getConverterUp()));
        }

        public Object remove(int index) {
            return this.getConverterUp().convert(this.getList().remove(index));
        }

        @Override
        public int indexOf(Object o) {
            return this.getList().indexOf(this.getConverterDown().convert(o));
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.getList().lastIndexOf(this.getConverterDown().convert(o));
        }

        public ListIterator listIterator() {
            return this.instantiateListIterator(this.getList().listIterator(), this.getConverterUp(), this.getConverterDown());
        }

        public ListIterator listIterator(int index) {
            return this.instantiateListIterator(this.getList().listIterator(index), this.getConverterUp(), this.getConverterDown());
        }

        public List subList(int fromIndex, int toIndex) {
            return this.instantiateList(this.getList().subList(fromIndex, toIndex), this.getConverterUp(), this.getConverterDown());
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ConverterCollection) {
                ConverterCollection that = (ConverterCollection)o;
                return ((Object)this.getCollection()).equals(that.getCollection()) && this.getConverterUp().equals(that.getConverterUp()) && this.getConverterDown().equals(that.getConverterDown());
            }
            if (o instanceof List) {
                ListIterator iterThis = this.listIterator();
                ListIterator iterThat = ((List)o).listIterator();
                while (iterThis.hasNext() && iterThat.hasNext()) {
                    if (NaturalHasher.INSTANCE.equals(iterThis.next(), iterThat.next())) continue;
                    return false;
                }
                return !iterThis.hasNext() && !iterThat.hasNext();
            }
            return false;
        }

        @Override
        public int hashCode() {
            int nHash = 1;
            ListIterator iter = this.listIterator();
            while (iter.hasNext()) {
                nHash = 31 * nHash + NaturalHasher.INSTANCE.hashCode(iter.next());
            }
            return nHash;
        }

        protected List instantiateList(List list, Converter convUp, Converter convDown) {
            return ConverterCollections.getList(list, convUp, convDown);
        }

        protected ListIterator instantiateListIterator(ListIterator iter, Converter convUp, Converter convDown) {
            return ConverterCollections.getListIterator(iter, convUp, convDown);
        }

        public List getList() {
            return (List)this.getCollection();
        }
    }

    public static class ConverterSortedSet
    extends ConverterSet
    implements SortedSet,
    Serializable {
        public ConverterSortedSet(SortedSet set, Converter convUp, Converter convDown) {
            super(set, convUp, convDown);
        }

        public Comparator comparator() {
            return this.getSortedSet().comparator();
        }

        public SortedSet subSet(Object fromElement, Object toElement) {
            SortedSet subset = this.getSortedSet().subSet(this.getConverterDown().convert(fromElement), this.getConverterDown().convert(toElement));
            return this.instantiateSortedSet(subset, this.getConverterUp(), this.getConverterDown());
        }

        public SortedSet headSet(Object toElement) {
            SortedSet subset = this.getSortedSet().headSet(this.getConverterDown().convert(toElement));
            return this.instantiateSortedSet(subset, this.getConverterUp(), this.getConverterDown());
        }

        public SortedSet tailSet(Object fromElement) {
            SortedSet subset = this.getSortedSet().tailSet(this.getConverterDown().convert(fromElement));
            return this.instantiateSortedSet(subset, this.getConverterUp(), this.getConverterDown());
        }

        public Object first() {
            return this.getConverterUp().convert(this.getSortedSet().first());
        }

        public Object last() {
            return this.getConverterUp().convert(this.getSortedSet().last());
        }

        protected SortedSet instantiateSortedSet(SortedSet set, Converter convUp, Converter convDown) {
            return ConverterCollections.getSortedSet(set, convUp, convDown);
        }

        public SortedSet getSortedSet() {
            return (SortedSet)this.getCollection();
        }
    }

    public static class ConverterSet
    extends ConverterCollection
    implements Set,
    Serializable {
        public ConverterSet(Set set, Converter convUp, Converter convDown) {
            super(set, convUp, convDown);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ConverterCollection) {
                ConverterCollection that = (ConverterCollection)o;
                return ((Object)this.getCollection()).equals(that.getCollection()) && this.getConverterUp().equals(that.getConverterUp()) && this.getConverterDown().equals(that.getConverterDown());
            }
            if (o instanceof Set) {
                Set set = (Set)o;
                return set.size() == this.size() && this.containsAll((Collection)set);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int nHash = 0;
            for (Object o : this.getCollection()) {
                nHash += NaturalHasher.INSTANCE.hashCode(o);
            }
            return nHash;
        }
    }

    public static class ConverterCollection
    implements Collection,
    Serializable {
        protected Collection m_col;
        protected Converter m_convUp;
        protected Converter m_convDown;

        public ConverterCollection(Collection col, Converter convUp, Converter convDown) {
            assert (col != null && convUp != null && convDown != null);
            this.m_col = col;
            this.m_convUp = convUp;
            this.m_convDown = convDown;
        }

        @Override
        public int size() {
            return this.getCollection().size();
        }

        @Override
        public boolean isEmpty() {
            return this.getCollection().isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.getCollection().contains(this.getConverterDown().convert(o));
        }

        @Override
        public Iterator iterator() {
            return this.instantiateIterator(this.getCollection().iterator(), this.getConverterUp());
        }

        @Override
        public Object[] toArray() {
            return ConverterCollections.convertArray(this.getCollection().toArray(), this.getConverterUp());
        }

        public Object[] toArray(Object[] aoDest) {
            return ConverterCollections.convertArray(this.getCollection().toArray(), this.getConverterUp(), aoDest);
        }

        public boolean add(Object o) {
            return this.getCollection().add(this.getConverterDown().convert(o));
        }

        @Override
        public boolean remove(Object o) {
            return this.getCollection().remove(this.getConverterDown().convert(o));
        }

        public boolean containsAll(Collection col) {
            return this.getCollection().containsAll(this.instantiateCollection(col, this.getConverterDown(), this.getConverterUp()));
        }

        public boolean addAll(Collection col) {
            return this.getCollection().addAll(this.instantiateCollection(col, this.getConverterDown(), this.getConverterUp()));
        }

        public boolean removeAll(Collection col) {
            return this.getCollection().removeAll(this.instantiateCollection(col, this.getConverterDown(), this.getConverterUp()));
        }

        public boolean retainAll(Collection col) {
            return this.getCollection().retainAll(this.instantiateCollection(col, this.getConverterDown(), this.getConverterUp()));
        }

        @Override
        public void clear() {
            this.getCollection().clear();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ConverterCollection) {
                ConverterCollection that = (ConverterCollection)o;
                return ((Object)this.getCollection()).equals(that.getCollection()) && this.getConverterUp().equals(that.getConverterUp()) && this.getConverterDown().equals(that.getConverterDown());
            }
            return false;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ConverterCollection{");
            boolean fFirst = true;
            for (Object o : this) {
                if (fFirst) {
                    fFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(o);
            }
            sb.append('}');
            return sb.toString();
        }

        public void invalidate() {
            this.m_col = null;
            this.m_convUp = null;
            this.m_convDown = null;
        }

        protected Collection instantiateCollection(Collection col, Converter convUp, Converter convDown) {
            return ConverterCollections.getCollection(col, convUp, convDown);
        }

        protected Iterator instantiateIterator(Iterator iter, Converter conv) {
            return ConverterCollections.getIterator(iter, conv);
        }

        public Collection getCollection() {
            return this.m_col;
        }

        public Converter getConverterUp() {
            return this.m_convUp;
        }

        public Converter getConverterDown() {
            return this.m_convDown;
        }
    }

    public static class ConverterEnumerator
    implements Enumeration,
    Iterator {
        protected Iterator m_iter;
        protected Converter m_conv;

        public ConverterEnumerator(Enumeration enmr, Converter conv) {
            this(new Collections.EnumerationIterator(enmr), conv);
        }

        public ConverterEnumerator(Iterator iter, Converter conv) {
            this.m_iter = iter;
            this.m_conv = conv;
        }

        public ConverterEnumerator(Object[] aoItem, Converter conv) {
            this(new ArrayIterator<Object>(aoItem), conv);
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }

        public Object nextElement() {
            return this.next();
        }

        @Override
        public boolean hasNext() {
            return this.m_iter.hasNext();
        }

        public Object next() {
            return this.m_conv.convert(this.m_iter.next());
        }

        @Override
        public void remove() {
            this.m_iter.remove();
        }
    }
}

