/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DaemonThreadFactory
implements ThreadFactory {
    protected final String m_sNamePrefix;
    protected final AtomicInteger m_cNameSuffix = new AtomicInteger();
    public static final DaemonThreadFactory INSTANCE = new DaemonThreadFactory("DaemonThread-");

    public DaemonThreadFactory() {
        this(null);
    }

    public DaemonThreadFactory(String sPrefix) {
        this.m_sNamePrefix = sPrefix;
    }

    @Override
    public Thread newThread(Runnable r) {
        String sPrefix = this.m_sNamePrefix;
        Thread thread = sPrefix == null ? new Thread(r) : new Thread(r, sPrefix + this.m_cNameSuffix.incrementAndGet());
        thread.setDaemon(true);
        return thread;
    }
}

