/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.application.console;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Application;
import com.tangosol.coherence.component.application.Console;
import com.tangosol.coherence.component.application.console.Coherence$CacheItem;
import com.tangosol.coherence.component.application.console.Coherence$Logger;
import com.tangosol.coherence.component.application.console.Coherence$Worker;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.net.jmxHelper.HttpAdapter;
import com.tangosol.coherence.component.net.jmxHelper.ServerConnector;
import com.tangosol.coherence.component.net.management.Gateway;
import com.tangosol.coherence.component.net.packet.messagePacket.Broadcast;
import com.tangosol.coherence.component.net.socket.UdpSocket;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Logger;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$SeniorMemberHeartbeat;
import com.tangosol.coherence.component.util.transactionCache.Local;
import com.tangosol.coherence.dslquery.QueryPlus;
import com.tangosol.dev.component.ComponentClassLoader;
import com.tangosol.dev.component.NullStorage;
import com.tangosol.io.ReadBuffer;
import com.tangosol.license.LicensedObject;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.DefaultCacheServer;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.InvocationService;
import com.tangosol.net.Member;
import com.tangosol.net.NamedCache;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.cache.ContinuousQueryCache;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.run.jca.SimpleValidator;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.SimpleParser;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ListMap;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MapTriggerListener;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.Resources;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.TransactionMap;
import com.tangosol.util.UID;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.Versionable;
import com.tangosol.util.WrapperException;
import com.tangosol.util.comparator.ChainedComparator;
import com.tangosol.util.comparator.InverseComparator;
import com.tangosol.util.comparator.SafeComparator;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.ConditionalExtractor;
import com.tangosol.util.extractor.KeyExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import com.tangosol.util.filter.FilterTrigger;
import com.tangosol.util.filter.LimitFilter;
import com.tangosol.util.processor.ConditionalProcessor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class Coherence
extends Console {
    public static final String COPYRIGHT = "Copyright (c) 2000, 2011, Oracle and/or its affiliates. All rights reserved.";
    public static final String DEFAULT_EDITION = "GE";
    public static final String DEFAULT_MODE = "development";
    public static final String[] EDITION_NAMES;
    public static final String FILE_CFG_CERTIFICATE = "tangosol.cer";
    public static final String FILE_CFG_COHERENCE = "/tangosol-coherence.xml";
    public static final String FILE_CFG_COHERENCE_OVERRIDE = "/tangosol-coherence-override.xml";
    public static final String[] MODE_NAMES;
    public static final String TITLE = "Oracle Coherence";
    public static final String VERSION;
    private transient List __m_CommandHistory;
    private int __m_Edition;
    private transient Map __m_Filters;
    private transient Object[] __m_LogParameters;
    private transient Coherence$Logger __m_Logger;
    private transient NamedCache __m_Map;
    private int __m_Mode;
    private transient String __m_Product;
    private transient CacheService __m_Service;
    private transient boolean __m_Stop;
    private static ListMap __mapChildren;
    private static transient String __s_BuildNumber;
    private static transient SafeCluster __s_Cluster;
    private static volatile boolean __s_ConfigurationLoaded;
    private static transient boolean __s_LicenseLoaded;
    private static Map __s_ServiceConfigMap;
    private static transient ThreadLocal __s_TloCluster;
    private static /* synthetic */ Class __sf0;
    private static /* synthetic */ Class __sf1;

    static {
        try {
            EDITION_NAMES = new String[]{"DC", "RTC", "", "SE", "EE", DEFAULT_EDITION};
            MODE_NAMES = new String[]{"eval", "dev", "prod"};
            VERSION = null;
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        Coherence._initStatic();
    }

    public Coherence() {
        this(null, null, true);
    }

    public Coherence(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        if (Application.__singleton != null) {
            throw new IllegalStateException("A singleton for \\\"Coherence\\\" has already been set");
        }
        Application.__singleton = this;
        this.__initPrivate();
        try {
            this.setCommandHistory(new LinkedList());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        try {
            Coherence.setServiceConfigMap(new SafeHashMap());
            __s_TloCluster = new ThreadLocal();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("CacheItem", Coherence$CacheItem.get_CLASS());
        Class clazz2 = __mapChildren.put("Logger", Coherence$Logger.get_CLASS());
        Class clazz3 = __mapChildren.put("Worker", Coherence$Worker.get_CLASS());
    }

    private static /* synthetic */ Class __sm0() {
        Class<?> clazz = __sf0;
        if (clazz == null) {
            try {
                clazz = __sf0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static /* synthetic */ Class __sm1() {
        Class<?> clazz = __sf1;
        if (clazz == null) {
            try {
                clazz = __sf1 = Class.forName("com.tangosol.license.LicensedObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static void _initStatic$Default() {
        Coherence.__initStatic();
    }

    protected static void _initStatic() {
        Coherence._initStatic$Default();
        String MANIFEST = "META-INF/MANIFEST.MF";
        InputStream in = null;
        String sVersion = null;
        String sDescr = null;
        Attributes attrs = null;
        try {
            try {
                CodeSource codeSource;
                ProtectionDomain pDomain = Coherence.get_CLASS().getProtectionDomain();
                if (pDomain != null && (codeSource = pDomain.getCodeSource()) != null) {
                    URL urlSrc = codeSource.getLocation();
                    URL urlMf = new URL(String.valueOf("jar:") + urlSrc + '!' + '/' + MANIFEST);
                    try {
                        URLConnection urlCon = urlMf.openConnection();
                        urlCon.setUseCaches(false);
                        in = urlCon.getInputStream();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (in == null) {
                        urlMf = new URL(String.valueOf(urlSrc) + (String.valueOf('/') + MANIFEST));
                        try {
                            in = urlMf.openStream();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (in != null) {
                        attrs = new Manifest(in).getMainAttributes();
                    }
                }
                if (attrs == null) {
                    ClassLoader loader = Coherence.get_CLASS().getClassLoader();
                    Enumeration<URL> enumMF = loader == null ? ClassLoader.getSystemResources(MANIFEST) : loader.getResources(MANIFEST);
                    while (enumMF.hasMoreElements()) {
                        in = enumMF.nextElement().openStream();
                        attrs = new Manifest(in).getMainAttributes();
                        String sTitle = attrs.getValue("Implementation-Title");
                        String sVendor = attrs.getValue("Implementation-Vendor");
                        if (!"Coherence".equalsIgnoreCase(sTitle) ? false : "Oracle".equalsIgnoreCase(sVendor)) break;
                        attrs = null;
                        in.close();
                    }
                }
                if (attrs != null) {
                    Coherence.setBuildNumber(attrs.getValue("Implementation-Build"));
                    sDescr = attrs.getValue("Implementation-Description");
                    sVersion = attrs.getValue("Implementation-Version");
                }
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception e) {}
        if (sVersion == null) {
            System.err.println(String.valueOf(TITLE) + ": The Manifest is corrupted or inaccessible;" + " some functionality may be disabled");
            sVersion = "n/a";
            Coherence.setBuildNumber("n/a");
        }
        VERSION = (sDescr == null ? true : sDescr.length() == 0) ? sVersion : String.valueOf(sVersion) + " " + sDescr;
    }

    protected Set applyFilter(String sFilter, boolean fKeysOnly, Comparator comparator, int nPage) {
        try {
            LimitFilter filterLimit;
            Filter filter = (Filter)this.getFilters().get(sFilter);
            Set setEntry = null;
            if (filter instanceof LimitFilter) {
                filterLimit = (LimitFilter)filter;
                if (nPage >= 0) {
                    filterLimit.setPage(nPage);
                }
                filterLimit.setComparator(comparator);
            }
            setEntry = fKeysOnly ? this.getMap().keySet(filter) : (comparator != null ? this.getMap().entrySet(filter, comparator) : this.getMap().entrySet(filter));
            if (!(filter instanceof LimitFilter) ? false : nPage < 0) {
                filterLimit = (LimitFilter)filter;
                if (setEntry.size() < filterLimit.getPageSize()) {
                    filterLimit.setPage(0);
                } else {
                    filterLimit.nextPage();
                }
            }
            return setEntry;
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected static String calculateAttribute(String sAttr) {
        String MODE = "{mode}";
        if (sAttr.indexOf(MODE) >= 0) {
            XmlElement xmlLicense = (XmlElement)Coherence.getServiceConfigMap().get("$License");
            sAttr = Base.replace(sAttr, MODE, xmlLicense.getSafeElement("license-mode").getString(DEFAULT_MODE));
        }
        while (!sAttr.startsWith("{") ? false : sAttr.endsWith("}")) {
            String sDefault;
            String sPropName;
            int ofDefault = sAttr.indexOf(32);
            int cchLength = sAttr.length();
            if (ofDefault < 0) {
                sDefault = sPropName = sAttr.substring(1, cchLength - 1);
            } else {
                sPropName = sAttr.substring(1, ofDefault);
                sDefault = sAttr.substring(ofDefault + 1, cchLength - 1);
            }
            sAttr = System.getProperty(sPropName, sDefault);
        }
        return sAttr;
    }

    protected Object[] collectLogParameters() {
        Object[] aoParam = this.getLogParameters();
        try {
            SafeCluster cluster = Coherence.getCluster();
            com.tangosol.coherence.component.net.Member member = (cluster == null ? true : cluster.isRunning() ^ true) ? null : (com.tangosol.coherence.component.net.Member)cluster.getLocalMember();
            int nMemberNew = member == null ? 0 : member.getId();
            int nMemberOld = aoParam == null ? -1 : (Integer)aoParam[0];
            if (nMemberNew != nMemberOld) {
                aoParam = member == null ? new Object[]{Base.makeInteger(0), null, null, this.getProduct()} : new Object[]{Base.makeInteger(nMemberNew), member.getRoleName(), member.getLocationInfo(), this.getProduct()};
                this.setLogParameters(aoParam);
            }
        }
        catch (Throwable throwable) {}
        return aoParam;
    }

    protected Object convertArgument(String sParam) {
        block42: {
            String sValue;
            int ofStart = sParam.indexOf(123);
            if (ofStart == 0) {
                if (sParam.equals("{cluster}")) {
                    return Coherence.getSafeCluster();
                }
                if (sParam.equals("{Date}")) {
                    return new Date(Base.getSafeTimeMillis());
                }
                if (sParam.equals("{date}")) {
                    return new Date(Coherence.getSafeCluster().getTimeMillis());
                }
                if (sParam.equals("{map}")) {
                    return this.getMap();
                }
                if (sParam.equals("{Member}")) {
                    return Coherence.getSafeCluster().getLocalMember();
                }
                if (sParam.equals("{random}")) {
                    return new Integer(Base.getRandom().nextInt());
                }
                if (sParam.equals("{result}")) {
                    return ((ThreadLocal)this.get_Sink()).get();
                }
                if (sParam.equals("{service}")) {
                    return this.getService();
                }
                if (sParam.equals("{time}")) {
                    return new Long(Coherence.getSafeCluster().getTimeMillis());
                }
                if (sParam.endsWith("}")) {
                    sValue = sParam.substring(1, sParam.length() - 1);
                    if (sValue.charAt(0) == '#') {
                        int ofIter = sValue.indexOf(32);
                        String sIter = sValue.substring(1, ofIter);
                        int cIters = Integer.parseInt(sIter);
                        if (ofIter > 0) {
                            Object[] aoValue = new Object[cIters];
                            sValue = sValue.substring(ofIter + 1);
                            int i = 0;
                            while (i < cIters) {
                                String s = sValue.indexOf(35) >= 0 ? Base.replace(sValue, "#", String.valueOf(i)) : sValue;
                                aoValue[i] = this.convertArgument(s);
                                ++i;
                            }
                            return new ImmutableArrayList(aoValue);
                        }
                    } else {
                        if (sValue.indexOf(44) >= 0) {
                            Object[] aoValue = sValue.length() == 0 ? ClassHelper.VOID : this.convertArguments(Base.parseDelimitedString(sValue, ','));
                            return new ImmutableArrayList(aoValue);
                        }
                        if (sValue.startsWith("filter:")) {
                            String sFilter = sValue.substring(sValue.indexOf(58) + 1);
                            return (Filter)this.getFilters().get(sFilter);
                        }
                    }
                } else {
                    throw new RuntimeException(String.valueOf("Unbalanced {} in parameter: ") + sParam + "; quotes may need to be used");
                }
            }
            if (ofStart >= 0) {
                int ofEnd;
                String[][] aasReplace = null;
                try {
                    SafeCluster cluster = Coherence.getSafeCluster();
                    long dtTime = cluster.getTimeMillis();
                    Member member = cluster.getLocalMember();
                    aasReplace = new String[][]{{"{Date}", String.valueOf(new Date(Base.getSafeTimeMillis()))}, {"{date}", String.valueOf(new Date(dtTime))}, {"{random}", String.valueOf(Base.getRandom().nextInt())}, {"{result}", String.valueOf(((ThreadLocal)this.get_Sink()).get())}, {"{time}", String.valueOf(dtTime)}, {"{Member}", String.valueOf(member)}, {"{member}", member == null ? "0" : String.valueOf(member.getId())}};
                }
                catch (Exception e) {
                    // empty catch block
                }
                int iR = 0;
                int cR = aasReplace == null ? 0 : aasReplace.length;
                while (iR < cR) {
                    void asReplace = aasReplace[iR];
                    sParam = Base.replace(sParam, (String)asReplace[0], (String)asReplace[1]);
                    ++iR;
                }
                int ofBegin = sParam.indexOf("{random:");
                if (ofBegin >= 0 && (ofEnd = sParam.indexOf(125, ofBegin)) > ofBegin) {
                    String sMax = sParam.substring(ofBegin + "{random:".length(), ofEnd);
                    int iMax = sMax.length() == 0 ? Integer.MAX_VALUE : Integer.parseInt(sMax);
                    int iRand = iMax > 0 ? Base.getRandom().nextInt(iMax) : (iMax < 0 ? (int)((double)(-iMax) * Base.getRandom().nextDouble() * Base.getRandom().nextDouble()) : (int)Math.abs((double)Integer.MAX_VALUE * Base.getRandom().nextGaussian()));
                    sParam = Base.replace(sParam, sParam.substring(ofBegin, ofEnd + 1), String.valueOf(iRand));
                }
            }
            if (sParam.startsWith("[")) {
                if (sParam.equals("[null]")) {
                    return null;
                }
                if (sParam.equals("[true]")) {
                    return Boolean.TRUE;
                }
                if (sParam.equals("[false]")) {
                    return Boolean.FALSE;
                }
                if (sParam.endsWith("]")) {
                    sValue = sParam.substring(1, sParam.length() - 1);
                    return sValue.length() == 0 ? ClassHelper.VOID : this.convertArguments(Base.parseDelimitedString(sValue, ','));
                }
            } else {
                if (sParam.endsWith("l")) {
                    try {
                        return Long.valueOf(sParam.substring(0, sParam.length() - 1));
                    }
                    catch (NumberFormatException e) {
                        break block42;
                    }
                }
                if (sParam.endsWith("f")) {
                    try {
                        return Float.valueOf(sParam.substring(0, sParam.length() - 1));
                    }
                    catch (NumberFormatException e) {
                        break block42;
                    }
                }
                if (sParam.endsWith("d")) {
                    try {
                        return Double.valueOf(sParam.substring(0, sParam.length() - 1));
                    }
                    catch (NumberFormatException e) {
                        break block42;
                    }
                }
                if (!(sParam.length() == 2) ? false : sParam.charAt(0) == '\\') {
                    return new Character(sParam.charAt(1));
                }
                if (sParam.startsWith(" ")) {
                    return sParam.trim();
                }
                try {
                    return Integer.valueOf(sParam);
                }
                catch (NumberFormatException numberFormatException) {}
                {
                }
            }
        }
        return sParam;
    }

    public Object[] convertArguments(String[] asParam) {
        int cParams = asParam == null ? 0 : asParam.length;
        Object[] aoParam = new Object[cParams];
        int i = 0;
        while (i < cParams) {
            Object oParam;
            String sParam = asParam[i];
            aoParam[i] = oParam = this.convertArgument(sParam);
            if (oParam != sParam) {
                asParam[i] = String.valueOf(oParam);
            }
            ++i;
        }
        return aoParam;
    }

    protected Object createReader() {
        Object reader;
        try {
            reader = Class.forName("jline.ConsoleReader").newInstance();
        }
        catch (Exception e) {
            return new InputStreamReader(System.in);
        }
        try {
            File fileHistory = new File(".coh-history");
            Class<?> clzHistory = Class.forName("jline.History");
            Object history = ClassHelper.newInstance(clzHistory, new Object[]{fileHistory});
            ClassHelper.invoke(reader, "setHistory", new Object[]{history});
        }
        catch (Exception e) {
            System.out.println(String.valueOf("failed to setup history: ") + e);
        }
        return reader;
    }

    public void debugOutput(String message, int severity) {
        Coherence$Logger logger = this.ensureRunningLogger();
        try {
            if (logger.isEnabled(severity)) {
                logger.log(severity, message, this.collectLogParameters());
            }
        }
        catch (Throwable error) {
            System.err.println("<Error>: Failed to write a log message");
        }
    }

    public void debugOutput(Throwable e) {
        Coherence$Logger logger = this.ensureRunningLogger();
        try {
            if (logger.isEnabled(Logger.LEVEL_ERROR)) {
                logger.log(Logger.LEVEL_ERROR, e, this.collectLogParameters());
            }
        }
        catch (Throwable error) {
            System.err.println("<Error>: Failed to write a log message");
        }
    }

    public static Message displayMessage(ReadBuffer buf, InetSocketAddress addr, ClusterService$SeniorMemberHeartbeat msgPrevHeartbeat) throws IOException {
        Broadcast packet = (Broadcast)Packet.instantiate(buf.getBufferInput(), 0);
        Message msg = new ClusterService().instantiateMessage(packet.getMessageType());
        msg.setDeserializationRequired(true);
        msg.setMessageType(packet.getMessageType());
        msg.setMessagePartCount(1);
        msg.setPacket(0, packet);
        ReadBuffer.BufferInput inBody = packet.getWriteBuffer().getReadBuffer().getBufferInput();
        msg.readInternal(inBody);
        msg.read(inBody);
        ClusterService$SeniorMemberHeartbeat msgCurHeartbeat = msg instanceof ClusterService$SeniorMemberHeartbeat ? (ClusterService$SeniorMemberHeartbeat)msg : null;
        if (!(!(!(msgCurHeartbeat != null) ? false : msgPrevHeartbeat != null) ? false : packet.getFromId() == msgPrevHeartbeat.getPacket(0).getFromId()) ? false : msgCurHeartbeat.getMemberSet().toString().equals(msgPrevHeartbeat.getMemberSet().toString())) {
            long lLastRecvTimestamp = msgCurHeartbeat.getLastReceivedMillis();
            String sLastRecvTimestamp = lLastRecvTimestamp == 0L ? "none" : new Date(lLastRecvTimestamp).toString();
            Base.out(String.valueOf("Message \"SeniorMemberHeartbeat\" (no change) LastRecvTimestamp=") + sLastRecvTimestamp);
        } else {
            Base.out(msg);
        }
        return msgCurHeartbeat;
    }

    protected void doAggregate(Object[] aoParam, boolean fSilent) {
        InvocableMap.EntryAggregator aggregator;
        NamedCache map = this.getMap();
        int cParams = aoParam.length;
        if (cParams < 2) {
            Component._trace("Aggregator name must be specified");
            return;
        }
        Object oTarget = aoParam[0];
        String sAggregator = (String)aoParam[1];
        Object extractor = null;
        if (cParams > 2) {
            String sMethod = (String)aoParam[2];
            extractor = (sMethod == null ? true : sMethod.equals("none")) ? NullImplementation.getValueExtractor() : (Object)sMethod;
        }
        try {
            Object[] objectArray;
            Class<?> clzAggregator = Class.forName(String.valueOf("com.tangosol.util.aggregator.") + sAggregator);
            if (extractor == null) {
                objectArray = ClassHelper.VOID;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = extractor;
            }
            aggregator = (InvocableMap.EntryAggregator)ClassHelper.newInstance(clzAggregator, objectArray);
        }
        catch (Throwable e) {
            Coherence.printException(String.valueOf("Invalid aggregator format: ") + sAggregator + " " + Coherence.toString(extractor) + "\n", e);
            return;
        }
        Object oResult = (oTarget instanceof Filter ? true : oTarget == null) ? map.aggregate((Filter)oTarget, aggregator) : (oTarget instanceof Collection ? map.aggregate((Collection)oTarget, aggregator) : (oTarget.equals("*") ? map.aggregate(map.keySet(), aggregator) : map.aggregate(Collections.singleton(oTarget), aggregator)));
        ((ThreadLocal)this.get_Sink()).set(oResult);
        if (fSilent ^ true) {
            Component._trace(String.valueOf(oResult));
        }
    }

    protected void doBackup(String[] asParam, boolean fSilent) {
        if (asParam.length == 0) {
            Component._trace("File name is expected");
            return;
        }
        NamedCache map = this.getMap();
        try {
            File file = new File(asParam[0]);
            FileOutputStream streamFile = new FileOutputStream(file);
            DataOutputStream streamData = new DataOutputStream(new BufferedOutputStream(streamFile, 32 * 1024));
            ExternalizableHelper.writeMap(streamData, map);
            streamData.close();
            streamFile.close();
            if (fSilent ^ true) {
                Component._trace(String.valueOf(map.size()) + " entries written to " + file.getAbsolutePath() + " (" + file.length() + " bytes)");
            }
        }
        catch (IOException e) {
            Component._trace(String.valueOf("Failed to backup: ") + e);
        }
    }

    protected void doBatch(String[] asParam, boolean fSilent) throws InterruptedException {
        if (asParam.length == 0) {
            Component._trace("File name is expected");
            return;
        }
        String sFile = asParam[0];
        InputStreamReader readerRaw = null;
        try {
            try {
                String sCmd;
                readerRaw = new FileReader(sFile);
                BufferedReader reader = new BufferedReader(readerRaw);
                while (!((sCmd = reader.readLine()) == null)) {
                    if (!(sCmd.length() > 0)) continue;
                    if (fSilent ^ true) {
                        Component._trace(String.valueOf(">>> ") + sCmd);
                    }
                    if (!(sCmd.startsWith("//") ^ true)) continue;
                    this.processCommand(sCmd);
                }
            }
            catch (IOException e) {
                Component._trace(String.valueOf("Failed to read the batch file: ") + e);
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                readerRaw.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            readerRaw.close();
        }
        catch (Exception e) {}
    }

    protected void doBulkPut(String[] asParam, boolean fSilent) {
        if (this.isMapValid() ^ true) {
            return;
        }
        int cIters = 1000;
        int cbData = 1000;
        int iFirst = 0;
        try {
            cIters = Integer.parseInt(asParam[0]);
            cbData = Integer.parseInt(asParam[1]);
            iFirst = Integer.parseInt(asParam[2]);
        }
        catch (Exception e) {
            Component._trace(String.valueOf("Assuming iterations=") + cIters + ", size=" + cbData + ", first=" + iFirst);
        }
        int cBatch = 0;
        if (asParam.length > 3) {
            String sBatch = asParam[3];
            if ("all".equals(sBatch)) {
                cBatch = cIters;
            } else {
                try {
                    cBatch = Integer.parseInt(sBatch);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        if (cIters < 0) {
            cIters = -cIters;
            iFirst -= cIters - 1;
        }
        if (fSilent ^ true) {
            Component._trace(String.valueOf(new Date()) + ": adding " + cIters + " items (starting with #" + iFirst + ") each " + cbData + " bytes ...");
        }
        int nOrigin = 0;
        try {
            nOrigin = this.getService().getCluster().getLocalMember().getId();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        NamedCache mapAll = this.getMap();
        HashMap<Object, byte[]> mapBatch = cBatch > 0 ? new HashMap<Object, byte[]>() : null;
        Random random = new Random();
        long lBegin = Base.getSafeTimeMillis();
        int i = iFirst;
        int iLast = iFirst + cIters;
        int cB = 0;
        while (i < iLast) {
            Object oVal;
            Object oKey;
            if (cbData > 0) {
                byte[] ab = new byte[cbData];
                ab[0] = (byte)random.nextInt();
                oKey = new Integer(i);
                oVal = ab;
            } else {
                Coherence$CacheItem item = new Coherence$CacheItem();
                item.setIndex(i);
                item.setOrigin(nOrigin);
                oKey = cbData < 0 ? (Object)item : new Integer(i);
                oVal = item;
            }
            if (cBatch > 0) {
                mapBatch.put(oKey, (byte[])oVal);
                if (++cB == cBatch) {
                    mapAll.putAll(mapBatch);
                    mapBatch.clear();
                    cB = 0;
                }
            } else {
                mapAll.put(oKey, oVal);
            }
            ++i;
        }
        if (!(cBatch > 0) ? false : mapBatch.isEmpty() ^ true) {
            mapAll.putAll(mapBatch);
        }
        long lElapsed = Base.getSafeTimeMillis() - lBegin;
        if (fSilent ^ true) {
            if (cbData == 0) {
                cbData = 480;
            }
            double dThrouK = (double)cIters * (double)(cbData += 4) / (double)lElapsed;
            double dThrouI = (double)cIters * (double)1000 / (double)lElapsed;
            Component._trace(String.valueOf(new Date()) + ": done putting (" + lElapsed + "ms, " + (int)dThrouK + "KB/sec, " + (int)dThrouI + " items/sec)");
        }
    }

    protected void doBulkRemove(String[] asParam, boolean fSilent) {
        if (this.isMapValid() ^ true) {
            return;
        }
        int cIters = 1000;
        int iFirst = 1;
        try {
            cIters = Integer.parseInt(asParam[0]);
            iFirst = Integer.parseInt(asParam[1]);
        }
        catch (Exception e) {
            Component._trace(String.valueOf("Assuming iterations=") + cIters + ", first=" + iFirst);
        }
        int cBatch = 0;
        if (asParam.length > 3) {
            String sBatch = asParam[3];
            if ("all".equals(sBatch)) {
                cBatch = cIters;
            } else {
                try {
                    cBatch = Integer.parseInt(sBatch);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        if (cIters < 0) {
            cIters = -cIters;
            iFirst -= cIters - 1;
        }
        if (fSilent ^ true) {
            Component._trace(String.valueOf(new Date()) + ": removing " + cIters + " items (starting with #" + iFirst + ")");
        }
        boolean fResult = false;
        Set setAll = this.getMap().keySet();
        HashSet<Integer> setBatch = cBatch > 0 ? new HashSet<Integer>() : null;
        long lBegin = Base.getSafeTimeMillis();
        int i = iFirst;
        int iLast = iFirst + cIters;
        int cB = 0;
        while (i < iLast) {
            Integer oKey = new Integer(i);
            if (cBatch > 0) {
                setBatch.add(oKey);
                if (cB++ == cBatch) {
                    fResult |= setAll.removeAll(setBatch);
                    setBatch.clear();
                    cB = 0;
                }
            } else {
                fResult |= setAll.remove(oKey);
            }
            ++i;
        }
        if (!(cBatch > 1) ? false : setBatch.isEmpty() ^ true) {
            fResult |= setAll.removeAll(setBatch);
        }
        long lElapsed = Base.getSafeTimeMillis() - lBegin;
        if (fSilent ^ true) {
            Component._trace(String.valueOf(new Date()) + ": done removing; " + "result=" + fResult + " (" + lElapsed + "ms)");
        }
    }

    protected void doCache(String[] asParam, boolean fSilent) {
        boolean fCQC;
        DefaultConfigurableCacheFactory factory = (DefaultConfigurableCacheFactory)CacheFactory.getConfigurableCacheFactory();
        String sName = asParam[0];
        boolean fUnique = !(asParam.length > 1) ? false : asParam[1].equals("unique");
        boolean fBinary = !(asParam.length > 1) ? false : asParam[1].equals("binary");
        boolean bl = fCQC = !(asParam.length > 1) ? false : this.getFilters().containsKey(asParam[1]);
        ClassLoader loader = fUnique ? this.getUniqueClassLoader() : (fBinary ? NullImplementation.getClassLoader() : this.getClass().getClassLoader());
        NamedCache cache = CacheFactory.getCache(sName, loader);
        String sPrompt = cache.getCacheName();
        if (fCQC) {
            cache = new ContinuousQueryCache(cache, (Filter)this.getFilters().get(asParam[1]));
            sPrompt = String.valueOf("CQC-") + sPrompt;
        }
        this.getLogger().setPrompt(sPrompt);
        this.setService(cache.getCacheService());
        this.setMap(cache);
        if (fSilent ^ true) {
            DefaultConfigurableCacheFactory.CacheInfo info = factory.findSchemeMapping(sName);
            Component._trace(String.valueOf(factory.resolveScheme(info)));
        }
    }

    protected void doCacheFactory(String[] asParam, boolean fSilent) {
        int cParams = asParam.length;
        if (cParams > 0) {
            DefaultConfigurableCacheFactory factory = new DefaultConfigurableCacheFactory(asParam[0]);
            CacheFactory.setConfigurableCacheFactory(factory);
            if (!(cParams > 1) ? false : asParam[1].equals("start")) {
                DefaultCacheServer.start(factory);
            }
        }
        if (fSilent ^ true) {
            Component._trace(CacheFactory.getConfigurableCacheFactory().getConfig().getSafeElement("caching-scheme-mapping").toString());
        }
    }

    protected void doConnector(String[] asParam, boolean fSilent) throws InterruptedException {
        int cParams = asParam.length;
        if (cParams == 0) {
            Component._trace("Command: connector (listener | publisher) [(unicast | multicast | p2p <ip:port> | member <id> | *) [on | off | drop <drop ratio> | pause <pause ratio> | delay <delay>]]");
            return;
        }
        com.tangosol.coherence.component.net.Member member = null;
        HashSet<InetSocketAddress> setAddr = null;
        int CHANNEL_UNI = 1;
        int CHANNEL_MULTI = 2;
        int nChannels = CHANNEL_MULTI | CHANNEL_UNI;
        if (cParams >= 2) {
            char chParam = asParam[1].charAt(0);
            switch (chParam) {
                case 'u': {
                    nChannels = CHANNEL_UNI;
                    break;
                }
                case 'm': {
                    if (asParam[1].startsWith("mu")) {
                        nChannels = CHANNEL_MULTI;
                        break;
                    }
                    try {
                        int nMember = Integer.parseInt(asParam[2]);
                        Cluster cluster = (Cluster)Coherence.getSafeCluster().getCluster();
                        member = ((MemberSet)cluster.getMemberSet()).getMember(nMember);
                        setAddr = new HashSet();
                        setAddr.add(member.getSocketAddress());
                        break;
                    }
                    catch (Exception e) {
                        Component._trace(e);
                        return;
                    }
                }
                case 'p': {
                    setAddr = new HashSet<InetSocketAddress>();
                    int i = 2;
                    while (i < cParams) {
                        String sParam = asParam[i];
                        if (sParam.endsWith(",")) {
                            sParam = sParam.substring(0, sParam.length() - 1);
                        } else {
                            i = cParams;
                        }
                        try {
                            int iColon = sParam.indexOf(58);
                            if (iColon == -1) {
                                Component._trace("address must include port");
                                return;
                            }
                            InetAddress ipAddr = iColon == 0 ? InetAddress.getLocalHost() : InetAddress.getByName(sParam.substring(0, iColon));
                            int nPort = Integer.parseInt(sParam.substring(iColon + 1));
                            setAddr.add(new InetSocketAddress(ipAddr, nPort));
                        }
                        catch (Exception e) {
                            Component._trace(e);
                            return;
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        int cAddr = setAddr == null ? 0 : setAddr.size();
        float flRate = -1.0f;
        boolean fPause = false;
        boolean fDelay = false;
        if (cParams >= cAddr + 3) {
            String sRate = asParam[cAddr + 2];
            float f = sRate.equals("off") ? 1.0f : (sRate.equals("on") ? 0.0f : (sRate.equals("drop") ? (cParams >= cAddr + 4 ? Float.parseFloat(asParam[cAddr + 3]) : -1.0f) : (flRate = sRate.equals("delay") ? 0.0f : -1.0f)));
            fPause = !(!sRate.equals("pause") ? false : flRate > 0.0f) ? false : flRate < 1.0f;
            fDelay = sRate.equals("delay");
            if (flRate < 0.0f ? true : flRate > 1.0f) {
                Component._trace("Ratio should be within [0.0, 1.0] interval");
                return;
            }
        }
        if (!fDelay ? false : member != null) {
            Cluster cluster = (Cluster)Coherence.getSafeCluster().getCluster();
            long nDelay = Base.parseTime(asParam[cAddr + 3]);
            int nResendDelay = cluster.getDependencies().getPublisherResendDelayMillis();
            int nDropCount = (int)Math.ceil((float)nDelay / (float)nResendDelay);
            Component._trace(String.valueOf("Each packet sent to member ") + member + " will be dropped " + nDropCount + " times.");
            member.setTxDebugDropCount(nDropCount);
            return;
        }
        long lPause = (long)((float)10000 * flRate);
        int iDropRate = fPause ? 100000 : (int)(flRate * (float)100000);
        while (true) {
            int nChannel = CHANNEL_UNI;
            while (nChannel <= CHANNEL_MULTI) {
                if ((nChannels & nChannel) != 0) {
                    boolean fTx;
                    String sDirection;
                    String sTarget = String.valueOf(this.getMap() == null ? "&" : "&getCacheService.getService.") + "getCluster";
                    if (asParam[0].startsWith("l")) {
                        sDirection = "Rx";
                        fTx = false;
                        sTarget = String.valueOf(sTarget) + (nChannel == CHANNEL_UNI ? ".getPointListener" : ".getMultiListener");
                        sTarget = String.valueOf(sTarget) + ".getUdpSocket";
                    } else {
                        sDirection = "Tx";
                        fTx = true;
                        sTarget = String.valueOf(sTarget) + (String.valueOf(".getPublisher") + (nChannel == CHANNEL_UNI ? ".getUdpSocketUnicast" : ".getUdpSocketMulticast"));
                    }
                    if (flRate == -1.0f) {
                        this.processCommand(sTarget);
                    } else {
                        UdpSocket socket = (UdpSocket)this.processCommand(String.valueOf('@') + sTarget);
                        if (socket != null) {
                            if (fTx) {
                                socket.setTxDebugDropAddresses(setAddr);
                            } else {
                                socket.setRxDebugDropAddresses(setAddr);
                            }
                        }
                        this.processCommand(String.valueOf('@') + sTarget + ".set" + sDirection + "DebugDropRate " + iDropRate);
                    }
                }
                nChannel <<= 1;
            }
            if (!fPause) break;
            ((ThreadLocal)this.get_Sink()).set(null);
            Thread.sleep(lPause);
            lPause = (long)10000 - lPause;
            iDropRate = Math.abs(iDropRate - 100000);
        }
    }

    protected void doFilter(Object[] aoParam, boolean fSilent) {
        Map mapFilter = this.getFilters();
        int cParams = aoParam.length;
        String sFilterName = (String)aoParam[0];
        String sFilterType = (String)aoParam[1];
        Object[] aoFilterParam = new Object[cParams - 2];
        try {
            int i = 2;
            while (i < cParams) {
                Object oParam = aoParam[i];
                Filter filter = (Filter)mapFilter.get(oParam);
                if (filter != null) {
                    oParam = filter;
                } else if (String.valueOf(oParam).startsWith("!")) {
                    oParam = (oParam = this.convertArgument(((String)oParam).substring(1))) == null ? new KeyExtractor(null) : new KeyExtractor((String)oParam);
                } else if (!sFilterType.equals("Partitioned") ? false : oParam instanceof Integer) {
                    DistributedCacheService service = (DistributedCacheService)this.getMap().getCacheService();
                    PartitionSet parts = new PartitionSet(service.getPartitionCount());
                    parts.add((Integer)oParam);
                    oParam = parts;
                }
                aoFilterParam[i - 2] = oParam;
                ++i;
            }
            if (sFilterType.equals("All") ? true : sFilterType.equals("Any")) {
                int cFilters = aoFilterParam.length;
                Filter[] aFilter = new Filter[cFilters];
                System.arraycopy(aoFilterParam, 0, aFilter, 0, cFilters);
                aoFilterParam = new Object[]{aFilter};
            }
            Class<?> clzFilter = Class.forName(String.valueOf("com.tangosol.util.filter.") + sFilterType + "Filter");
            Filter filter = (Filter)ClassHelper.newInstance(clzFilter, aoFilterParam);
            mapFilter.put(sFilterName, filter);
            if (fSilent ^ true) {
                Component._trace(String.valueOf(filter));
            }
        }
        catch (Throwable e) {
            Coherence.printException("Invalid filter format: ", e);
        }
    }

    protected Object doFunction(String sFunction, Object[] aoParam, boolean fSilent) {
        Object oTarget = null;
        boolean fSetTarget = true;
        if (sFunction.startsWith("&&") ? true : sFunction.startsWith("&!")) {
            fSetTarget = sFunction.startsWith("&&");
            sFunction = sFunction.substring(2);
            oTarget = ((ThreadLocal)this.get_Sink()).get();
        } else if (sFunction.startsWith("&/")) {
            try {
                String sClass = sFunction.substring(2);
                int ofClz = sClass.indexOf(46);
                sFunction = sClass.substring(ofClz + 1);
                sClass = sClass.substring(0, ofClz).replace('/', '.');
                try {
                    oTarget = Class.forName(sClass);
                }
                catch (ClassNotFoundException e) {
                    oTarget = Class.forName(String.valueOf("java.lang.") + sClass);
                }
            }
            catch (Exception e) {
                Component._trace(String.valueOf("Invalid format: ") + e);
                return e;
            }
        } else if (sFunction.startsWith("&{")) {
            int ofTarget = sFunction.indexOf(125);
            if (ofTarget > 0) {
                oTarget = this.convertArgument(sFunction.substring(1, ++ofTarget));
                if (!(sFunction.length() > ofTarget) ? false : sFunction.charAt(ofTarget) == '.') {
                    ++ofTarget;
                }
                sFunction = sFunction.substring(ofTarget);
            }
        } else if (sFunction.startsWith("&~")) {
            sFunction = sFunction.substring(2);
            oTarget = this;
        } else {
            sFunction = sFunction.substring(1);
            oTarget = this.getMap();
            if (oTarget == null) {
                oTarget = Coherence.getSafeCluster();
            }
        }
        if (sFunction.length() > 0) {
            oTarget = Coherence.processFunction(oTarget, sFunction, fSilent, aoParam);
        } else {
            Coherence.processFunction(oTarget, "toString", fSilent, aoParam);
        }
        if (fSetTarget) {
            ((ThreadLocal)this.get_Sink()).set(oTarget);
        }
        return oTarget;
    }

    protected void doHistory(String[] asParam, boolean fSilent) throws InterruptedException {
        List listCommands = this.getCommandHistory();
        String sPattern = null;
        int nLimit = -1;
        switch (asParam.length) {
            case 0: {
                break;
            }
            case 1: {
                if (asParam[0].equals("clear")) {
                    if (listCommands != null) {
                        listCommands.clear();
                    }
                    return;
                }
                if (asParam[0].equals("on")) {
                    if (listCommands == null) {
                        this.setCommandHistory(new LinkedList());
                    }
                    return;
                }
                if (asParam[0].equals("off")) {
                    this.setCommandHistory(null);
                    return;
                }
                try {
                    nLimit = Integer.parseInt(asParam[0]);
                }
                catch (NumberFormatException e) {
                    sPattern = asParam[0];
                }
                break;
            }
            case 2: {
                sPattern = asParam[0];
                nLimit = Integer.parseInt(asParam[1]);
                break;
            }
            default: {
                Component._trace("history ([<pattern>] [<limit>]) | (['on' | 'off' | 'clear'])");
                return;
            }
        }
        if (fSilent ? true : listCommands == null) {
            return;
        }
        if (nLimit < 0) {
            nLimit = Integer.MAX_VALUE;
        }
        int cCommands = listCommands.size();
        if (sPattern == null) {
            int iCmd = Math.max(0, cCommands - nLimit);
            ListIterator iter = listCommands.listIterator(iCmd);
            while (iter.hasNext()) {
                Component._trace(String.valueOf("  ") + ++iCmd + "  " + iter.next());
            }
        } else {
            LinkedList<String> listOut = new LinkedList<String>();
            int cMatches = 0;
            int iCmd = cCommands;
            HashSet<String> setMatch = new HashSet<String>();
            Iterator<Object> iter = listCommands.listIterator(cCommands);
            while (!iter.hasPrevious() ? false : cMatches < nLimit) {
                String sCmd = (String)iter.previous();
                if ((sCmd.startsWith(sPattern) ? true : sCmd.matches(sPattern)) && setMatch.contains(sCmd) ^ true) {
                    setMatch.add(sCmd);
                    listOut.add(0, String.valueOf("  ") + iCmd + "  " + sCmd);
                    ++cMatches;
                }
                --iCmd;
            }
            iter = listOut.iterator();
            while (iter.hasNext()) {
                Component._trace((String)iter.next());
            }
        }
        Component._trace("\nenter !<index> to reissue a command");
    }

    protected void doIndex(String[] asParam, boolean fSilent) {
        boolean fFwd;
        String sMethod = asParam[0];
        boolean fRemove = !(asParam.length > 1) ? false : asParam[1].equals("remove");
        Filter filter = asParam.length > 2 ? (Filter)this.getFilters().get(asParam[2]) : null;
        boolean bl = fFwd = !(asParam.length > 3) ? false : Boolean.getBoolean(asParam[3]);
        ValueExtractor extractor = sMethod.startsWith("!") ? new KeyExtractor(sMethod.substring(1)) : (sMethod.indexOf(46) < 0 ? (ValueExtractor)new ReflectionExtractor(sMethod) : new ChainedExtractor(sMethod));
        if (filter != null) {
            extractor = new ConditionalExtractor(filter, extractor, fFwd);
        }
        if (fRemove) {
            this.getMap().removeIndex(extractor);
        } else {
            this.getMap().addIndex(extractor, true, new SafeComparator(null));
        }
    }

    protected void doInvoke(String sService, String[] asParam, boolean fSilent) {
        InvocationService srvc;
        block18: {
            try {
                srvc = (InvocationService)CacheFactory.getService(sService);
            }
            catch (IllegalArgumentException e) {
                srvc = (InvocationService)Coherence.getCluster().getService(sService);
                if (!(srvc == null)) break block18;
                throw e;
            }
        }
        int cParams = asParam.length;
        if (cParams == 0) {
            return;
        }
        String sCommand = asParam[0];
        String sTarget = cParams >= 2 ? asParam[1] : "all";
        boolean fAsync = !(cParams >= 3) ? false : asParam[2].startsWith("a");
        int iPriority = cParams >= 4 ? Integer.parseInt(asParam[3]) : 0;
        long cTimeout = cParams >= 5 ? Long.parseLong(asParam[4]) : 0L;
        Coherence$CacheItem task = new Coherence$CacheItem();
        task.setInvokeCommand(sCommand);
        task.setSchedulingPriority(iPriority);
        task.setExecutionTimeoutMillis(cTimeout);
        Set setMember = null;
        if (sTarget.equals("all") ^ true) {
            setMember = srvc.getInfo().getServiceMembers();
            if (sTarget.equals("other")) {
                setMember.remove(Coherence.getSafeCluster().getLocalMember());
            } else if (sTarget.equals("senior")) {
                setMember.clear();
                setMember.add(srvc.getInfo().getOldestMember());
            } else {
                setMember.clear();
                Set setAll = srvc.getInfo().getServiceMembers();
                try {
                    int nMember = Integer.parseInt(sTarget);
                    Iterator iter = setAll.iterator();
                    while (iter.hasNext()) {
                        Member member = (Member)iter.next();
                        if (!(member.getId() == nMember)) continue;
                        setMember.add(member);
                        break;
                    }
                }
                catch (NumberFormatException e) {
                    Component._trace(String.valueOf("Unknown target: ") + sTarget);
                    return;
                }
            }
        }
        if (fAsync) {
            srvc.execute(task, setMember, (Coherence$Worker)this._newChild("Worker"));
        } else {
            TreeMap mapResult = srvc.query(task, setMember);
            if (fSilent ^ true) {
                if (mapResult.isEmpty()) {
                    Component._trace("No results");
                } else {
                    if (mapResult.size() > 1) {
                        mapResult = new TreeMap(mapResult);
                    }
                    Iterator iter = mapResult.keySet().iterator();
                    while (iter.hasNext()) {
                        Member member = (Member)iter.next();
                        Object oResult = mapResult.get(member);
                        Component._trace(String.valueOf("Member ") + (member == null ? "Proxy" : String.valueOf(member.getId())) + ", Result=" + (oResult instanceof Throwable ? String.valueOf(oResult) + "\n" + Component.getStackTrace((Throwable)oResult) : String.valueOf(oResult)));
                    }
                }
            }
        }
    }

    protected void doJmx(String[] asParam) {
        String sName;
        int cParams = asParam.length;
        int nPort = 8082;
        String sUrl = "";
        try {
            if (cParams > 0) {
                nPort = Integer.parseInt(asParam[0]);
            }
        }
        catch (NumberFormatException e) {
            sUrl = asParam[0];
        }
        boolean fStart = cParams <= 1 ? true : asParam[1].equals("stop") ^ true;
        String string = sName = sUrl.length() == 0 ? "Adapter" : "Connector";
        if (fStart) {
            Component wrapper = this._findChild(sName);
            if (wrapper != null) {
                Component._trace(String.valueOf("Already started: ") + wrapper);
                return;
            }
            try {
                wrapper = sUrl.length() == 0 ? new HttpAdapter() : new ServerConnector();
            }
            catch (NoClassDefFoundError e) {
                Component._trace("JMX library is not on a classpath; only remote management is allowed");
                return;
            }
            try {
                if (wrapper instanceof HttpAdapter) {
                    ((HttpAdapter)wrapper).start(nPort, Coherence.getSafeCluster());
                } else {
                    ((ServerConnector)wrapper).start(sUrl, Coherence.getSafeCluster());
                }
            }
            catch (RuntimeException e) {
                if (cParams > 1) {
                    Component._trace(e);
                } else {
                    Component._trace(e.getMessage());
                }
                return;
            }
            this._addChild(wrapper, sName);
            ((ThreadLocal)this.get_Sink()).set(wrapper);
            Component._trace(String.valueOf("Installed: ") + wrapper);
        } else {
            Component wrapper = this._findChild(sName);
            if (wrapper != null) {
                if (wrapper instanceof HttpAdapter) {
                    ((HttpAdapter)wrapper).stop();
                } else {
                    ((ServerConnector)wrapper).stop();
                }
                this._removeChild(wrapper);
            }
        }
    }

    protected void doList(String[] asParam, boolean fSilent) {
        Set setEntry;
        NamedCache map = this.getMap();
        int cParams = asParam.length;
        if (cParams > 0) {
            String sName = asParam[0];
            if (this.getFilters().containsKey(sName)) {
                Comparator comparator = null;
                int nPage = -1;
                if (cParams > 1) {
                    String[] asMethod = Base.parseDelimitedString(asParam[1], ',');
                    int cMethods = asMethod.length;
                    if (cMethods > 1) {
                        Comparator[] acomp = new Comparator[cMethods];
                        int i = 0;
                        while (i < cMethods) {
                            String sMethod = asMethod[i];
                            acomp[i] = sMethod.startsWith("!") ? (Comparator)new KeyExtractor(sMethod.substring(1)) : new ReflectionExtractor(sMethod);
                            ++i;
                        }
                        comparator = new ChainedComparator(acomp);
                    } else {
                        String sMethod;
                        comparator = asMethod[0].equals("null") ? new SafeComparator(null) : ((sMethod = asMethod[0]).startsWith("!") ? (Comparator)new KeyExtractor(sMethod.substring(1)) : new ReflectionExtractor(sMethod));
                    }
                    if (!(cParams > 2) ? false : asParam[2].startsWith("desc")) {
                        comparator = new InverseComparator(comparator);
                    }
                    if (cParams > 3) {
                        nPage = Integer.parseInt(asParam[3]);
                    }
                }
                setEntry = this.applyFilter(sName, false, comparator, nPage);
            } else {
                map = this.getService().ensureCache(sName, null);
                setEntry = map.entrySet();
            }
        } else {
            setEntry = map.entrySet();
        }
        int cSize = setEntry.size();
        int cLimit = Math.min(cSize, 50);
        int c = 0;
        Iterator iter = setEntry.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (!(!(c++ < cLimit) ? false : fSilent ^ true)) continue;
            Component._trace(String.valueOf(entry.getKey()) + " = " + entry.getValue());
        }
        if (!(cLimit < cSize) ? false : fSilent ^ true) {
            Component._trace(String.valueOf("Only ") + cLimit + " out of total " + cSize + " items were printed");
        }
        if (c != cSize) {
            Component._trace(String.valueOf("Iterator returned ") + c + " items");
        }
        ((ThreadLocal)this.get_Sink()).set(setEntry);
    }

    protected void doListen(String sSource, boolean fStop, Filter filter, Object oKey, boolean fLite) {
        NamedCache map = this.getMap();
        CacheService service = map.getCacheService();
        ObservableMap mapListen = map;
        if (sSource.equals("local")) {
            BackingMapManager mgr = service.getBackingMapManager();
            if (mgr == null) {
                Component._trace(String.valueOf("Service ") + service.getInfo().getServiceName() + " does not have BackingMapManager;" + " use coherence-cache-config.xml and 'cache' command to create a cache");
                return;
            }
            String sCacheName = map.getCacheName();
            try {
                mapListen = (ObservableMap)ClassHelper.invoke(mgr, "getBackingMap", new Object[]{sCacheName});
            }
            catch (ClassCastException e) {
                Component._trace(String.valueOf("Local storage for cache: ") + sCacheName + " is not observable;" + " use coherence-cache-config.xml to configure");
                return;
            }
            catch (Exception e) {
                Component._trace(String.valueOf("Service ") + service.getInfo().getServiceName() + " uses unsupported BackingMapManager: " + mgr.getClass().getName());
                return;
            }
            if (mapListen == null) {
                Component._trace(String.valueOf("Local storage for cache: ") + sCacheName + " is missing");
                return;
            }
        }
        String sWorker = String.valueOf("Worker!") + sSource;
        Coherence$Worker worker = (Coherence$Worker)this._findChild(sWorker);
        if (fStop) {
            if (sSource.startsWith("trigger")) {
                int nAction = sSource.endsWith("remove") ? FilterTrigger.ACTION_REMOVE : (sSource.endsWith("ignore") ? FilterTrigger.ACTION_IGNORE : FilterTrigger.ACTION_ROLLBACK);
                mapListen.removeMapListener(new MapTriggerListener(new FilterTrigger(filter, nAction)));
            } else if (worker == null) {
                Component._trace("No listener to stop");
            } else {
                if (sSource.equals("members")) {
                    service.removeMemberListener(worker);
                } else if (sSource.equals("master")) {
                    service.getCluster().ensureService("Cluster", "Cluster").removeMemberListener(worker);
                } else if (sSource.equals("service")) {
                    service.removeServiceListener(worker);
                } else {
                    MapListener listener = worker;
                    if (sSource.endsWith("-sync")) {
                        listener = new MapListenerSupport.WrapperSynchronousListener(listener);
                    }
                    if (oKey == null) {
                        mapListen.removeMapListener(listener, filter);
                    } else {
                        mapListen.removeMapListener(listener, oKey);
                    }
                }
                int cRefCount = worker.getRefCount() - 1;
                if (cRefCount == 0) {
                    this._removeChild(worker);
                } else {
                    worker.setRefCount(cRefCount);
                }
            }
        } else if (sSource.startsWith("trigger")) {
            int nAction = sSource.endsWith("remove") ? FilterTrigger.ACTION_REMOVE : (sSource.endsWith("ignore") ? FilterTrigger.ACTION_IGNORE : FilterTrigger.ACTION_ROLLBACK);
            mapListen.addMapListener(new MapTriggerListener(new FilterTrigger(filter, nAction)));
        } else {
            if (worker == null) {
                worker = new Coherence$Worker();
                this._addChild(worker, sWorker);
                if (sSource.charAt(0) == '@') {
                    worker.setSilent(true);
                }
            }
            if (sSource.equals("members")) {
                service.addMemberListener(worker);
            } else if (sSource.equals("master")) {
                service.getCluster().ensureService("Cluster", "Cluster").addMemberListener(worker);
            } else if (sSource.equals("service")) {
                service.addServiceListener(worker);
            } else {
                MapListener listener = worker;
                if (sSource.endsWith("-sync")) {
                    listener = new MapListenerSupport.WrapperSynchronousListener(listener);
                }
                if (oKey == null) {
                    mapListen.addMapListener(listener, filter, fLite);
                } else {
                    mapListen.addMapListener(listener, oKey, fLite);
                }
            }
            worker.setRefCount(worker.getRefCount() + 1);
        }
    }

    protected void doLog(Object[] aoParam, boolean fSilent) {
        int cParams = aoParam.length;
        String sMsg = null;
        int cchMsg = 50;
        if (cParams >= 1) {
            if (aoParam[0] instanceof Number) {
                cchMsg = ((Number)aoParam[0]).intValue();
                cchMsg = Math.max(1, cchMsg);
            } else {
                sMsg = String.valueOf(aoParam[0]);
                cchMsg = sMsg.length();
            }
        }
        if (sMsg == null) {
            sMsg = Base.dup('*', cchMsg);
        }
        int cIters = 1;
        if (!(cParams >= 2) ? false : aoParam[1] instanceof Number) {
            cIters = ((Number)aoParam[1]).intValue();
        }
        cIters = Math.max(1, cIters);
        int nLevel = 3;
        if (!(cParams >= 3) ? false : aoParam[2] instanceof Number) {
            nLevel = ((Number)aoParam[2]).intValue();
        }
        if (fSilent ^ true) {
            Component._trace(String.valueOf("Logging ") + cIters + " messages of " + cchMsg + " characters at level " + nLevel + ":");
        }
        if (cIters == 1) {
            Component._trace(sMsg, nLevel);
        } else {
            int i = 1;
            while (i <= cIters) {
                Component._trace(String.valueOf(i) + ":" + sMsg, nLevel);
                ++i;
            }
        }
    }

    protected void doProcess(Object[] aoParam, boolean fSilent) {
        InvocableMap.EntryProcessor processor;
        NamedCache map = this.getMap();
        int cParams = aoParam.length;
        if (cParams < 2) {
            Component._trace("Processor name must be specified");
            return;
        }
        int iParam = 0;
        Object oTarget = aoParam[iParam++];
        Filter filter = aoParam[iParam] instanceof Filter ? (Filter)aoParam[iParam++] : null;
        String sProcessor = (String)aoParam[iParam++];
        Object[] aoProcessorParam = new Object[cParams -= iParam];
        if (cParams > 0) {
            System.arraycopy(aoParam, iParam, aoProcessorParam, 0, cParams);
        }
        try {
            Class<?> clzProcessor = Class.forName(String.valueOf("com.tangosol.util.processor.") + sProcessor);
            processor = (InvocableMap.EntryProcessor)ClassHelper.newInstance(clzProcessor, aoProcessorParam);
        }
        catch (Throwable e) {
            Coherence.printException(String.valueOf("Invalid processor format: ") + sProcessor + " " + Coherence.toString(aoProcessorParam) + "\n", e);
            return;
        }
        if (filter != null) {
            processor = new ConditionalProcessor(filter, processor);
        }
        Map oResult = (oTarget instanceof Filter ? true : oTarget == null) ? map.invokeAll((Filter)oTarget, processor) : (oTarget instanceof Collection ? map.invokeAll((Collection)oTarget, processor) : (oTarget.equals("*") ? map.invokeAll(map.keySet(), processor) : map.invoke(oTarget, processor)));
        ((ThreadLocal)this.get_Sink()).set(oResult);
        if (fSilent ^ true) {
            Component._trace(String.valueOf(oResult));
        }
    }

    protected void doReissueCommand(int nCmd, String sRemainder, boolean fSilent) throws InterruptedException {
        List list = this.getCommandHistory();
        if (list == null) {
            Component._trace("history is off");
            return;
        }
        if (nCmd <= 0 ? true : nCmd > list.size()) {
            Component._trace("history index out of range");
            return;
        }
        String sCmd = (String)list.get(nCmd - 1);
        if (!(sRemainder != null) ? false : sRemainder.length() > 0) {
            sCmd = String.valueOf(fSilent ? String.valueOf("@") + sCmd : sCmd) + " " + sRemainder;
            this.recordCommand(sCmd);
        } else if (fSilent) {
            sCmd = String.valueOf("@") + sCmd;
        }
        Component._trace(String.valueOf("reissuing: ") + sCmd);
        this.processCommand(sCmd);
    }

    protected void doRepeat(String sCmd, int cIter, boolean fForce) throws InterruptedException {
        ArrayList<String> list = new ArrayList<String>();
        int cch = sCmd.length();
        int ofPrev = 0;
        while (ofPrev < cch) {
            int ofNext;
            if (sCmd.charAt(ofPrev) == '{') {
                ++ofPrev;
                ofNext = sCmd.lastIndexOf(125);
            } else {
                ofNext = sCmd.indexOf(59, ofPrev);
            }
            if (ofNext < 0) {
                list.add(sCmd.substring(ofPrev));
                break;
            }
            list.add(sCmd.substring(ofPrev, ofNext));
            ofPrev = ofNext + 1;
        }
        int cCmds = list.size();
        String[] asCmd = list.toArray(new String[cCmds]);
        int i = 0;
        block1: while (i < cIter) {
            ((ThreadLocal)this.get_Sink()).set(new Integer(i));
            int j = 0;
            while (j < cCmds) {
                Object oResult;
                sCmd = asCmd[j].trim();
                if (sCmd.length() > 0 && (oResult = this.processCommand(sCmd)) instanceof Throwable) {
                    if (!fForce) break block1;
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    protected void doRestore(String[] asParam, boolean fSilent) {
        if (asParam.length == 0) {
            Component._trace("File name is expected");
            return;
        }
        NamedCache map = this.getMap();
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            File file = new File(asParam[0]);
            FileInputStream streamFile = new FileInputStream(file);
            DataInputStream streamData = new DataInputStream(new BufferedInputStream(streamFile, 32 * 1024));
            int cBlock = Integer.MAX_VALUE;
            if (asParam.length > 1) {
                try {
                    cBlock = Integer.parseInt(asParam[1]);
                    Component._assert(cBlock > 0);
                }
                catch (Exception e) {
                    Component._trace("Invalid block size");
                    return;
                }
            }
            int cEntries = ExternalizableHelper.readMap(streamData, map, cBlock, loader);
            if (fSilent ^ true) {
                Component._trace(String.valueOf(cEntries) + " entries restored from " + file.getAbsolutePath());
            }
            streamData.close();
            streamFile.close();
        }
        catch (IOException e) {
            Component._trace(String.valueOf("Failed to restore: ") + e);
        }
    }

    protected void doScan(String[] asParam) {
        int iFirst = 1;
        int cIters = 1000;
        try {
            iFirst = Integer.parseInt(asParam[0]);
            cIters = Integer.parseInt(asParam[1]);
        }
        catch (NumberFormatException e) {
            Component._trace(String.valueOf("Assuming first=") + iFirst + ", iterations=" + cIters);
        }
        NamedCache map = this.getMap();
        int iGapStart = 0;
        int iGapEnd = 0;
        int i = iFirst;
        int iLast = iFirst + cIters;
        while (i < iLast) {
            if (map.containsKey(new Integer(i)) ^ true) {
                iGapStart = i;
                iGapEnd = i;
                while (!(++i < iLast) ? false : map.containsKey(new Integer(i)) ^ true) {
                    iGapEnd = i;
                }
                if (iGapStart == iGapEnd) {
                    Component._trace(String.valueOf("\nMissing item: ") + iGapStart);
                } else {
                    Component._trace(String.valueOf("\nMissing items: ") + iGapStart + " .. " + iGapEnd);
                }
            }
            if (!(i > iGapStart + 1000) ? false : i % 1000 == 0) {
                System.out.print(String.valueOf("\b\b\b\b\b\b\b") + i);
                System.out.flush();
            }
            ++i;
        }
    }

    protected Object doSecure(String[] asParam, boolean fSilent) throws InterruptedException {
        Object subject;
        PrivilegedAction action;
        int cParams = asParam.length;
        if (cParams < 3) {
            return null;
        }
        String sName = asParam[0];
        char[] acPwd = asParam[1].toCharArray();
        String sCmd = asParam[2];
        int i = 3;
        while (i < cParams) {
            sCmd = String.valueOf(sCmd) + (String.valueOf(' ') + asParam[i]);
            ++i;
        }
        boolean fImpersonate = false;
        if (sName.startsWith("hack_")) {
            fImpersonate = true;
            sName = sName.substring("hack_".length());
        }
        try {
            Class<?> clz = Class.forName("com.tangosol.net.security.SimpleHandler");
            Object handler = ClassHelper.newInstance(clz, new Object[]{sName, acPwd});
            action = Security.createPrivilegedAction(this.getClass().getMethod("processCommand", Coherence.__sm0()), this, new Object[]{sCmd});
            subject = ClassHelper.invokeStatic(Class.forName("com.tangosol.net.security.Security"), "login", new Object[]{handler});
        }
        catch (Throwable e) {
            Coherence.printException(null, e);
            return null;
        }
        if (fImpersonate) {
            subject = Security.getInstance().impersonate(subject, sName, asParam[0]);
        }
        try {
            return ClassHelper.invokeStatic(Class.forName("com.tangosol.net.security.Security"), "runAs", new Object[]{subject, action});
        }
        catch (Throwable e) {
            Throwable eOrig = e;
            while (true) {
                if (e instanceof WrapperException) {
                    e = ((WrapperException)e).getOriginalException();
                    continue;
                }
                if (!(e instanceof InvocationTargetException)) break;
                e = eOrig = ((InvocationTargetException)e).getTargetException();
            }
            if (e instanceof AccessControlException) {
                Component._trace(String.valueOf("Permission rejected: ") + ((AccessControlException)e).getPermission(), 1);
            }
            Component._trace(eOrig);
            return null;
        }
    }

    protected void doTransaction(String sFunction, String[] asParam) {
        if (sFunction.equals("begin")) {
            int nIsolation;
            int nConcur;
            String sConcur = asParam[0];
            String sIsolation = asParam[1];
            int nTimeout = 20;
            try {
                nTimeout = Integer.parseInt(asParam[2]);
            }
            catch (Exception e) {
                // empty catch block
            }
            switch (sConcur.charAt(0)) {
                case 'E': 
                case 'e': {
                    nConcur = TransactionMap.CONCUR_EXTERNAL;
                    break;
                }
                case 'O': 
                case 'o': {
                    nConcur = TransactionMap.CONCUR_OPTIMISTIC;
                    break;
                }
                default: {
                    nConcur = TransactionMap.CONCUR_PESSIMISTIC;
                    break;
                }
            }
            switch (sIsolation.charAt(0)) {
                case 'C': 
                case 'c': {
                    nIsolation = TransactionMap.TRANSACTION_GET_COMMITTED;
                    break;
                }
                case 'R': 
                case 'r': {
                    nIsolation = TransactionMap.TRANSACTION_REPEATABLE_GET;
                    break;
                }
                default: {
                    nIsolation = TransactionMap.TRANSACTION_SERIALIZABLE;
                    break;
                }
            }
            this.txStart(nConcur, nIsolation, nTimeout);
        } else if (sFunction.equals("commit")) {
            try {
                ((TransactionMap)((Object)this.getMap())).prepare();
                ((TransactionMap)((Object)this.getMap())).commit();
            }
            finally {
                Object var4_6 = null;
                this.txEnd();
            }
        } else if (sFunction.equals("rollback")) {
            ((TransactionMap)((Object)this.getMap())).rollback();
            this.txEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Coherence$Logger ensureRunningLogger() {
        Coherence$Logger logger = this.getLogger();
        if (logger.isStarted() ^ true) {
            Coherence$Logger coherence$Logger = logger;
            synchronized (coherence$Logger) {
                if (!(logger.isStarted() ^ true) ? false : logger.isConfigured() ^ true) {
                    try {
                        logger.setConfigured(true);
                        logger.configure(Coherence.getServiceConfig("$Logger"));
                        logger.start();
                    }
                    catch (RuntimeException e) {
                        this.setLogger(null);
                        throw e;
                    }
                    catch (Error e) {
                        this.setLogger(null);
                        throw e;
                    }
                }
            }
        }
        return logger;
    }

    public static String getBuildNumber() {
        return __s_BuildNumber;
    }

    public static SafeCluster getCluster() {
        return __s_Cluster;
    }

    public List getCommandHistory() {
        return this.__m_CommandHistory;
    }

    public int getEdition() {
        return this.__m_Edition;
    }

    public Map getFilters() {
        HashMap mapFilter = this.__m_Filters;
        if (mapFilter == null) {
            mapFilter = new HashMap();
            this.setFilters(mapFilter);
        }
        return mapFilter;
    }

    public static TransactionMap getLocalTransaction(NamedCache cache) {
        Local mapTx = new Local();
        mapTx.initialize(cache);
        return mapTx;
    }

    public Object[] getLogParameters() {
        return this.__m_LogParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Coherence$Logger getLogger() {
        Coherence$Logger logger = this.__m_Logger;
        if (logger == null) {
            Coherence coherence = this;
            synchronized (coherence) {
                logger = this.__m_Logger;
                if (logger == null) {
                    logger = (Coherence$Logger)this._newChild("Logger");
                    this.setLogger(logger);
                }
            }
        }
        return logger;
    }

    public NamedCache getMap() {
        return this.__m_Map;
    }

    public int getMode() {
        return this.__m_Mode;
    }

    public String getProduct() {
        return this.__m_Product;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SafeCluster getSafeCluster() {
        SafeCluster cluster = Coherence.getCluster();
        if (cluster == null && (cluster = (SafeCluster)Coherence.getTloCluster().get()) == null) {
            Class clazz = Coherence.get_CLASS();
            synchronized (clazz) {
                cluster = Coherence.getCluster();
                if (cluster == null) {
                    cluster = new SafeCluster();
                    Coherence.getTloCluster().set(cluster);
                    try {
                        ((Coherence)Coherence.get_Instance()).ensureRunningLogger();
                        Gateway mgmt = Gateway.createGateway(Coherence.getServiceConfig("$Management"), cluster);
                        cluster.setManagement(mgmt);
                        Coherence.setCluster(cluster);
                    }
                    finally {
                        Object var3_5 = null;
                        Coherence.getTloCluster().set(null);
                    }
                }
            }
        }
        return cluster;
    }

    public CacheService getService() {
        return this.__m_Service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlElement getServiceConfig(String sServiceType) {
        XmlElement xml;
        Map mapConfig = Coherence.getServiceConfigMap();
        if (Coherence.isConfigurationLoaded() ^ true) {
            ((Coherence)Coherence.get_Instance()).ensureRunningLogger();
            Map map = mapConfig;
            synchronized (map) {
                if (Coherence.isConfigurationLoaded() ^ true) {
                    Coherence.loadConfiguration();
                    Coherence.validateEnvironment();
                }
            }
        }
        return (xml = (XmlElement)mapConfig.get(sServiceType)) == null ? null : (XmlElement)xml.clone();
    }

    protected static Map getServiceConfigMap() {
        return __s_ServiceConfigMap;
    }

    protected CacheService getSimpleCache(String sServiceName) {
        sServiceName = (sServiceName == null ? true : sServiceName.length() == 0) ? "Default" : sServiceName;
        com.tangosol.net.Cluster cluster = CacheFactory.ensureCluster();
        CacheService service = (CacheService)cluster.ensureService(sServiceName, "SimpleCache");
        if (service.isRunning() ^ true) {
            service.configure(Coherence.getServiceConfig("SimpleCache"));
            service.start();
        }
        return service;
    }

    private static ThreadLocal getTloCluster() {
        return __s_TloCluster;
    }

    protected ClassLoader getUniqueClassLoader() {
        return new ComponentClassLoader(this.getClass().getClassLoader(), new NullStorage());
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/application/console/Coherence".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        Component singleton = Application.__singleton;
        if (singleton == null) {
            singleton = new Coherence();
        } else if (!(singleton instanceof Coherence)) {
            throw new IllegalStateException("A singleton for \\\"Coherence\\\" has already been set to a different type");
        }
        return singleton;
    }

    private final Component get_Module() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get_Sink() {
        ThreadLocal oSink = super.get_Sink();
        if (oSink == null) {
            Coherence coherence = this;
            synchronized (coherence) {
                oSink = super.get_Sink();
                if (oSink == null) {
                    oSink = new ThreadLocal();
                    this.set_Sink(oSink);
                }
            }
        }
        return oSink;
    }

    public static boolean isConfigurationLoaded() {
        return __s_ConfigurationLoaded;
    }

    public boolean isDebugOutputEnabled(int iSeverity) {
        Coherence$Logger logger = this.getLogger();
        return logger == null ? super.isDebugOutputEnabled(iSeverity) : iSeverity <= logger.getLevel();
    }

    private static boolean isLicenseLoaded() {
        return __s_LicenseLoaded;
    }

    protected boolean isMapValid() {
        if (this.getMap() == null) {
            Component._trace("Please specify the current map using \"cache\" or \"map\" command");
            return false;
        }
        return true;
    }

    public boolean isStop() {
        return this.__m_Stop;
    }

    protected static void loadConfiguration() {
        Coherence.get_Instance();
        Map mapConfig = Coherence.getServiceConfigMap();
        XmlDocument xmlCoherence = XmlHelper.loadResource(FILE_CFG_COHERENCE, "operational configuration", Coherence.get_CLASS().getClassLoader());
        Coherence.replaceSystemProperties(xmlCoherence);
        XmlElement xmlLicense = xmlCoherence.ensureElement("license-config");
        String sModeDescription = Coherence.resolveMode(xmlLicense);
        mapConfig.put("$License", xmlLicense.clone());
        Coherence.loadOverrides(xmlCoherence, new HashSet());
        String sEditionDesc = Coherence.resolveEdition(xmlLicense);
        Component._trace(String.valueOf("\n") + TITLE + " Version " + VERSION + " Build " + Coherence.getBuildNumber() + "\n " + sEditionDesc + ": " + sModeDescription + " mode" + "\n" + COPYRIGHT + "\n");
        XmlElement xmlCluster = xmlCoherence.ensureElement("cluster-config");
        XmlElement xmlLogging = xmlCoherence.getSafeElement("logging-config");
        XmlElement xmlFactory = xmlCoherence.getSafeElement("configurable-cache-factory-config");
        XmlElement xmlBuilder = xmlCoherence.getSafeElement("cache-factory-builder-config");
        XmlElement xmlSecurity = xmlCoherence.getSafeElement("security-config");
        XmlElement xmlManagement = xmlCoherence.getSafeElement("management-config");
        xmlCluster.getElementList().addAll(xmlLicense.getElementList());
        mapConfig.put("Cluster", xmlCluster.clone());
        mapConfig.put("$License", xmlLicense.clone());
        mapConfig.put("$Logger", xmlLogging.clone());
        mapConfig.put("$CacheFactory", xmlFactory.clone());
        mapConfig.put("$CacheFactoryBuilder", xmlBuilder.clone());
        mapConfig.put("$Security", xmlSecurity.clone());
        mapConfig.put("$Management", xmlManagement.clone());
        Iterator iter = xmlCoherence.getSafeElement("cluster-config/services").getElements("service");
        while (iter.hasNext()) {
            XmlElement xmlSvc = (XmlElement)iter.next();
            String sSvcType = xmlSvc.getSafeElement("service-type").getString("service");
            SimpleElement xmlParams = new SimpleElement(sSvcType);
            XmlHelper.transformInitParams(xmlParams, xmlSvc.getSafeElement("init-params"));
            mapConfig.put(sSvcType, xmlParams);
        }
        Coherence.setConfigurationLoaded(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void loadLicenses(XmlElement xml, String sLicenseFile) {
        boolean bl;
        Signature signature;
        XmlDocument xmlLicenses;
        String sXml;
        URL url;
        InputStream stream = null;
        String sUrl = null;
        ClassLoader loader = Coherence.get_CLASS().getClassLoader();
        if (loader == null) {
            loader = Base.getContextClassLoader();
        }
        if ((url = loader.getResource(sLicenseFile)) != null) {
            try {
                stream = url.openStream();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (stream == null && (url = Coherence.__sm1().getClassLoader().getResource(sLicenseFile)) != null) {
            try {
                stream = url.openStream();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (stream == null) {
            String sErrorMsg = String.valueOf("Edition file (") + sLicenseFile + ") is missing from the " + TITLE + " libraries";
            Component._trace(sErrorMsg, 1);
            throw new RuntimeException(sErrorMsg);
        }
        sUrl = url.toString();
        try {
            try {
                sXml = new String(Base.read(stream), "ISO-8859-1");
            }
            catch (IOException e) {
                throw new WrapperException(e, "An exception occurred while reading the license data");
            }
            Object var8_13 = null;
        }
        catch (Throwable e) {
            Object var8_14 = null;
            try {
                stream.close();
                throw e;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw e;
        }
        try {}
        catch (IOException e2) {}
        stream.close();
        if (sXml == null ? true : sXml.length() == 0) {
            String sErrorMsg = String.valueOf("Edition data (") + sUrl + ") is missing or empty.";
            Component._trace(sErrorMsg, 1);
            throw new RuntimeException(sErrorMsg);
        }
        Component._trace(String.valueOf("Loaded edition data from \"") + sUrl + "\"", 6);
        try {
            xmlLicenses = new SimpleParser().parseXml(sXml);
        }
        catch (IOException e) {
            throw new WrapperException(e, "An exception occurred while parsing the license data");
        }
        xml.ensureElement("license-list").getElementList().addAll(xmlLicenses.getElementList());
        if (Coherence.isLicenseLoaded()) {
            return;
        }
        Coherence.setLicenseLoaded(true);
        InputStream streamCert = null;
        try {
            Certificate cert;
            try {
                streamCert = loader.getResourceAsStream(FILE_CFG_CERTIFICATE);
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                cert = factory.generateCertificate(streamCert);
                signature = Signature.getInstance("SHA1withDSA");
                signature.initVerify(cert.getPublicKey());
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e, "Error during license validation");
            }
            cert = null;
            bl = streamCert != null;
        }
        catch (Throwable e) {
            Object cert = null;
            if (!(streamCert != null)) throw e;
            try {
                streamCert.close();
                throw e;
            }
            catch (IOException e3) {
                // empty catch block
            }
            throw e;
        }
        if (bl) {
            try {}
            catch (IOException e3) {}
            streamCert.close();
        }
        ArrayList<LicensedObject.LicenseData> list = new ArrayList<LicensedObject.LicenseData>();
        Iterator iter = xmlLicenses.getElements("license");
        while (true) {
            int ofColon;
            if (!iter.hasNext()) {
                LicensedObject.setLicenseData(list.toArray(new LicensedObject.LicenseData[0]));
                return;
            }
            XmlElement xmlLicense = (XmlElement)iter.next();
            String sLicensee = xmlLicense.getSafeElement("licensee").getString(null);
            String sAgreement = xmlLicense.getSafeElement("agreement").getString(null);
            String sMode = xmlLicense.getSafeElement("type").getString(null);
            String sFromDate = xmlLicense.getSafeElement("from-date").getString(null);
            String sToDate = xmlLicense.getSafeElement("to-date").getString(null);
            String sRenewDate = xmlLicense.getSafeElement("maintenance-renewal-date").getString(null);
            int cSeats = xmlLicense.getSafeElement("max-seats").getInt();
            int cUsers = xmlLicense.getSafeElement("max-users").getInt();
            String sSite = xmlLicense.getSafeElement("site").getString(null);
            int cServers = xmlLicense.getSafeElement("max-servers").getInt();
            int cSockets = xmlLicense.getSafeElement("max-sockets").getInt();
            int cCores = xmlLicense.getSafeElement("max-cpus").getInt();
            String sUid = xmlLicense.getSafeElement("id").getString(null);
            String sKey = xmlLicense.getSafeElement("key").getString(null);
            String sSig = xmlLicense.getSafeElement("signature").getString(null);
            String sClass = null;
            String sSoftware = null;
            String sEdition = null;
            if (sUid == null) {
                String sMsg = String.valueOf("You are using an out-of-date license format; ") + "please contact Oracle to obtain a replacement license.";
                Component._trace(sMsg, 1);
                throw new RuntimeException(sMsg);
            }
            UID uid = new UID(sUid);
            long lDateFrom = sFromDate == null ? 0L : Coherence.parseDate(sFromDate);
            long lDateTo = sToDate == null ? 0L : Coherence.parseDate(sToDate);
            long lDateRenew = sRenewDate == null ? 0L : Coherence.parseDate(sRenewDate);
            int nMode = -1;
            if (!(sMode != null) ? false : sMode.length() > 0) {
                switch (sMode.charAt(0)) {
                    case 'e': {
                        nMode = 0;
                        break;
                    }
                    case 'd': {
                        nMode = 1;
                        break;
                    }
                    case 'p': {
                        nMode = 2;
                        break;
                    }
                }
            }
            if (nMode < 0) {
                String sErrorMsg = String.valueOf("Invalid license mode: \"") + sMode + "\"";
                Component._trace(sErrorMsg, 1);
                throw new RuntimeException(sErrorMsg);
            }
            if (sSig == null) {
                if (sKey == null) {
                    continue;
                }
            } else {
                sSoftware = xmlLicense.getSafeElement("software").getString();
                try {
                    StringBuffer sb = new StringBuffer();
                    sb.append(sSoftware).append(sLicensee).append(sAgreement == null ? "" : sAgreement).append(nMode).append(lDateFrom).append(lDateTo).append(lDateRenew).append(cSeats).append(cUsers).append(sSite).append(cServers).append(cSockets).append(cCores).append(uid);
                    ByteArrayOutputStream streamRaw = new ByteArrayOutputStream();
                    DataOutputStream streamSig = new DataOutputStream(streamRaw);
                    streamSig.writeUTF(sb.toString());
                    signature.update(streamRaw.toByteArray());
                    if (signature.verify(Base.parseHex(sSig)) ^ true) {
                        String sMsg = String.valueOf("The ") + sSoftware + " license signature " + "is not valid, please contact Oracle.";
                        System.err.println(sMsg);
                        Component._trace(sMsg, 1);
                        continue;
                    }
                }
                catch (Exception e) {
                    throw Base.ensureRuntimeException(e, String.valueOf("Error validating license signature for ") + sSoftware);
                }
                if (sSoftware.endsWith(": Grid Edition")) {
                    sEdition = DEFAULT_EDITION;
                    sClass = "com.tangosol.license.CoherenceDataGridEdition";
                } else if (sSoftware.endsWith(": Enterprise Edition") ? true : sSoftware.endsWith(": Application Edition")) {
                    sEdition = "EE";
                    sClass = "com.tangosol.license.CoherenceApplicationEdition";
                } else if (sSoftware.endsWith(": Standard Edition") ? true : sSoftware.endsWith(": Caching Edition")) {
                    sEdition = "SE";
                    sClass = "com.tangosol.license.CoherenceCachingEdition";
                } else if (sSoftware.endsWith(": Compute Client")) {
                    sEdition = "CC";
                    sClass = "com.tangosol.license.CoherenceComputeClient";
                } else if (sSoftware.endsWith(": Real-Time Client")) {
                    sEdition = "RTC";
                    sClass = "com.tangosol.license.CoherenceRealTimeClient";
                } else if (sSoftware.endsWith(": Data Client")) {
                    sEdition = "DC";
                    sClass = "com.tangosol.license.CoherenceDataClient";
                }
            }
            if (!(sClass == null) ? false : sKey != null) {
                try {
                    sClass = new Binary(Base.parseHex(sKey.substring(9, sKey.length() - 1))).getBufferInput().readUTF();
                }
                catch (IOException e) {
                    continue;
                }
                if (sClass.endsWith(".CoherenceEnterprise")) {
                    sSoftware = String.valueOf(TITLE) + ": Enterprise Edition";
                    sEdition = "EE";
                    sClass = "com.tangosol.license.CoherenceApplicationEdition";
                } else if (sClass.endsWith(".Coherence")) {
                    sSoftware = String.valueOf(TITLE) + ": Standard Edition";
                    sEdition = "SE";
                    sClass = "com.tangosol.license.CoherenceCachingEdition";
                } else {
                    if (!(sClass.endsWith(".CoherenceLocal") ? true : sClass.endsWith(".ClientAccess"))) continue;
                    sSoftware = String.valueOf(TITLE) + ": Data Client";
                    sEdition = "DC";
                    sClass = "com.tangosol.license.CoherenceDataClient";
                }
            }
            boolean fOem = sLicensee.startsWith("OEM:");
            String sApp = null;
            if (fOem && (ofColon = (sLicensee = sLicensee.substring(4)).lastIndexOf(58)) > 0) {
                sApp = sLicensee.substring(ofColon + 1);
                sLicensee = sLicensee.substring(0, ofColon);
            }
            list.add(new LicensedObject.LicenseData(sSoftware, sEdition, sLicensee, fOem, sAgreement, nMode, sClass, sSite, sApp, lDateFrom, lDateTo, lDateRenew, cSeats, cUsers, cServers, cSockets, cCores, uid));
        }
    }

    protected static void loadOverrides(XmlElement xml, Set setOverrides) {
        block9: {
            String ATTR_OVERRIDE = "xml-override";
            String ATTR_ID = "id";
            XmlValue attr = xml.getAttribute(ATTR_OVERRIDE);
            if (attr != null) {
                xml.setAttribute(ATTR_OVERRIDE, null);
                String sOverride = Coherence.calculateAttribute(attr.getString());
                try {
                    URL url;
                    XmlDocument xmlOverride = null;
                    File file = new File(sOverride);
                    if (!file.exists() ? false : file.isDirectory()) {
                        sOverride = new File(file, FILE_CFG_COHERENCE_OVERRIDE).getPath();
                    }
                    if ((url = Resources.findFileOrResource(sOverride, Coherence.get_CLASS().getClassLoader())) != null) {
                        xmlOverride = XmlHelper.loadXml(url);
                        Component._trace(String.valueOf("Loaded operational overrides from \"") + url + '\"', 3);
                    }
                    if (xmlOverride == null) {
                        Component._trace(String.valueOf("Optional configuration override \"") + sOverride + "\" is not specified", 5);
                        break block9;
                    }
                    if (xmlOverride.getName().equals(xml.getName())) {
                        Coherence.replaceSystemProperties(xmlOverride);
                        XmlValue attrOverride = xmlOverride.getAttribute(ATTR_OVERRIDE);
                        if (attrOverride == null ? true : setOverrides.add(attrOverride.getString())) {
                            Coherence.loadOverrides(xmlOverride, setOverrides);
                            XmlHelper.overrideElement(xml, xmlOverride, ATTR_ID);
                            break block9;
                        }
                        throw new IOException(String.valueOf("Document \"") + sOverride + "\" is cyclically referenced by the '" + ATTR_OVERRIDE + "' attribute of element '" + xml.getName() + "'");
                    }
                    throw new IOException(String.valueOf("Root name mismatch in the document: ") + sOverride + "; " + "expected name: \"" + xml.getName() + '\"');
                }
                catch (Exception e) {
                    throw Base.ensureRuntimeException(e, String.valueOf("Failed to apply the element override: ") + sOverride);
                }
            }
        }
        Iterator iter = xml.getElementList().iterator();
        while (iter.hasNext()) {
            Coherence.loadOverrides((XmlElement)iter.next(), new HashSet(setOverrides));
        }
    }

    public static void main(String[] asArgs) {
        Application.setArgument(asArgs);
        ((Coherence)Coherence.get_Instance()).run();
    }

    public static String[] parseArguments(String sArguments) {
        if (sArguments.length() == 0) {
            return new String[0];
        }
        char[] ach = sArguments.toCharArray();
        int cch = ach.length;
        boolean fEsc = false;
        boolean fQuote = false;
        char chQuote = (char)0;
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        int ofCur = 0;
        while (ofCur < cch) {
            char ch = ach[ofCur];
            if (fEsc) {
                switch (ch) {
                    case '\'': {
                        sb.append('\'');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case ' ': {
                        sb.append(' ');
                        break;
                    }
                    default: {
                        sb.append('\\').append(ch);
                        break;
                    }
                }
                fEsc = false;
            } else {
                switch (ch) {
                    case '\"': 
                    case '\'': {
                        if (fQuote) {
                            if (ch == chQuote) {
                                fQuote = false;
                                break;
                            }
                            sb.append(ch);
                            break;
                        }
                        fQuote = true;
                        chQuote = ch;
                        break;
                    }
                    case ' ': {
                        if (fQuote) {
                            sb.append(' ');
                            break;
                        }
                        if (!(sb.length() > 0)) break;
                        list.add(sb.toString());
                        sb.setLength(0);
                        break;
                    }
                    case '\\': {
                        fEsc = true;
                        break;
                    }
                    default: {
                        sb.append(ch);
                        break;
                    }
                }
            }
            ++ofCur;
        }
        if (fQuote) {
            throw new IllegalArgumentException(String.valueOf("Unmatched quote (") + chQuote + ") in command: " + sArguments);
        }
        if (sb.length() > 0) {
            list.add(sb.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    public static long parseDate(String s) {
        if (s == null ? true : s.length() == 0) {
            return 0L;
        }
        String[] asParts = Base.parseDelimitedString(s, '-');
        return Date.UTC(Integer.parseInt(asParts[0]) - 1900, Integer.parseInt(asParts[1]) - 1, Integer.parseInt(asParts[2]), 0, 0, 0);
    }

    public static int parseEditionName(String sEdition) {
        if (sEdition != null) {
            String[] asEdition = EDITION_NAMES;
            int i = 0;
            int c = asEdition.length;
            while (i < c) {
                if (sEdition.equals(asEdition[i])) {
                    return i;
                }
                ++i;
            }
        }
        Component._trace(String.valueOf("Unknown edition: ") + sEdition, 2);
        return 0;
    }

    public static int parseModeName(String sMode) {
        if (sMode != null) {
            String[] asMode = MODE_NAMES;
            int i = 0;
            int c = asMode.length;
            while (i < c) {
                if (sMode.equals(asMode[i])) {
                    return i;
                }
                ++i;
            }
        }
        Component._trace(String.valueOf("Unknown mode: ") + sMode, 2);
        return 1;
    }

    public static void printException(String sPrefix, Throwable e) {
        Object oPartial;
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        if (sPrefix == null) {
            Component._trace(e);
        } else {
            Component._trace(String.valueOf(sPrefix) + Component.getStackTrace(e), 1);
        }
        if (e instanceof RequestTimeoutException && (oPartial = ((RequestTimeoutException)e).getPartialResult()) != null) {
            Component._trace(String.valueOf("Partial result: ") + oPartial);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Object processCommand(String sCmd) throws InterruptedException {
        block183: {
            block209: {
                block208: {
                    block207: {
                        block206: {
                            block205: {
                                block204: {
                                    block203: {
                                        block202: {
                                            block201: {
                                                block200: {
                                                    block199: {
                                                        block198: {
                                                            block197: {
                                                                block196: {
                                                                    block195: {
                                                                        block194: {
                                                                            block193: {
                                                                                block192: {
                                                                                    block191: {
                                                                                        block190: {
                                                                                            block189: {
                                                                                                block188: {
                                                                                                    block187: {
                                                                                                        block186: {
                                                                                                            block185: {
                                                                                                                block184: {
                                                                                                                    service = this.getService();
                                                                                                                    map = this.getMap();
                                                                                                                    oResult = null;
                                                                                                                    fSilent = false;
                                                                                                                    if (sCmd.charAt(0) == '@') {
                                                                                                                        fSilent = true;
                                                                                                                        sCmd = sCmd.substring(1);
                                                                                                                    }
                                                                                                                    if ((ofFunction = sCmd.indexOf(32)) < 0) {
                                                                                                                        sFunction = sCmd;
                                                                                                                        sCmd = "";
                                                                                                                    } else {
                                                                                                                        sFunction = sCmd.substring(0, ofFunction);
                                                                                                                        sCmd = sCmd.substring(ofFunction + 1).trim();
                                                                                                                    }
                                                                                                                    if (sFunction.startsWith("#")) {
                                                                                                                        sIter = sFunction.substring(1);
                                                                                                                        fForce = false;
                                                                                                                        if (sIter.startsWith("#")) {
                                                                                                                            sIter = sIter.substring(1);
                                                                                                                            fForce = true;
                                                                                                                        }
                                                                                                                        try {
                                                                                                                            cIter = Integer.parseInt(sIter);
                                                                                                                            this.doRepeat(sCmd, cIter, fForce);
                                                                                                                        }
                                                                                                                        catch (NumberFormatException e) {
                                                                                                                            Component._trace(String.valueOf("invalid counter: ") + sIter);
                                                                                                                        }
                                                                                                                        return null;
                                                                                                                    }
                                                                                                                    asParam = Coherence.parseArguments(sCmd);
                                                                                                                    aoParam = this.convertArguments(asParam);
                                                                                                                    cParams = asParam.length;
                                                                                                                    if (sFunction.startsWith("!")) {
                                                                                                                        if (sFunction.length() == 1) {
                                                                                                                            this.doHistory(asParam, fSilent);
                                                                                                                        } else {
                                                                                                                            nCmd = Integer.parseInt(sFunction.substring(1));
                                                                                                                            this.doReissueCommand(nCmd, sCmd, fSilent);
                                                                                                                        }
                                                                                                                        return null;
                                                                                                                    }
                                                                                                                    if (!sFunction.startsWith("&")) break block184;
                                                                                                                    oResult = this.doFunction(sFunction, aoParam, fSilent);
                                                                                                                    break block183;
                                                                                                                }
                                                                                                                if (!(sFunction.equals("lock") != false ? true : sFunction.equals("unlock"))) break block185;
                                                                                                                if (this.isMapValid()) {
                                                                                                                    oResult = this.doFunction(String.valueOf('&') + sFunction, aoParam, fSilent);
                                                                                                                }
                                                                                                                break block183;
                                                                                                            }
                                                                                                            if (!sFunction.equals("bye")) break block186;
                                                                                                            CacheFactory.shutdown();
                                                                                                            this.setStop(true);
                                                                                                            break block183;
                                                                                                        }
                                                                                                        if (!sFunction.equals("help")) break block187;
                                                                                                        Component._trace("The commands are:");
                                                                                                        Component._trace("  aggregate ('{' <key> [, <key>]* '}' | '{filter:'<filter-name>'}' | '*') <aggregator-name> [<extractor>]");
                                                                                                        Component._trace("  assert <value>");
                                                                                                        Component._trace("  backup <path>");
                                                                                                        Component._trace("  batch <path>");
                                                                                                        Component._trace("  bulkput <# of iterations> <block size> <start key> [<batch size> | all]");
                                                                                                        Component._trace("  bulkremove <# of iterations> <start key> [all]");
                                                                                                        Component._trace("  bye");
                                                                                                        Component._trace("  cachefactory [<path>]");
                                                                                                        Component._trace("  cache <name>");
                                                                                                        Component._trace("  cohql [<paramValue>]*");
                                                                                                        Component._trace("  clear");
                                                                                                        Component._trace("  destroy");
                                                                                                        Component._trace("  filter <name> <type> [(<accessor> <value>) | [<paramValue>]+]");
                                                                                                        Component._trace("  get <key>");
                                                                                                        Component._trace("  hash");
                                                                                                        Component._trace("  help");
                                                                                                        Component._trace("  history ([<pattern>] [<limit>]) | (['on' | 'off' | 'clear'])");
                                                                                                        Component._trace("  inc <key> [<increment>]");
                                                                                                        Component._trace("  invoke <command> [('all' | 'other' | 'senior' | <id>) [('async' | 'sync')]]");
                                                                                                        Component._trace("  index <accessor> [add | remove]");
                                                                                                        Component._trace("  jmx [(<port> | <url>) [('start' | 'stop')]]");
                                                                                                        Component._trace("  kill");
                                                                                                        Component._trace("  list [<map name> | <filter name> [<accessor> [asc | desc]]]");
                                                                                                        Component._trace("  listen [('start' | 'stop') [('cluster' | 'local' | 'members')]] [<filter> | <key>] [<lite>]");
                                                                                                        Component._trace("  lock <key>");
                                                                                                        Component._trace("  log (<size> | <message>) [<iterations> [<level>]]");
                                                                                                        Component._trace("  maps");
                                                                                                        Component._trace("  memory");
                                                                                                        Component._trace("  process (<key> | '{' <key> [, <key>]* '}' | '{filter:'<filter-name>'}' | '*') <processor-name> [<paramValue>]+");
                                                                                                        Component._trace("  profile <command>");
                                                                                                        Component._trace("  put <key> <value>");
                                                                                                        Component._trace("  release");
                                                                                                        Component._trace("  remove <key>");
                                                                                                        Component._trace("  restore <path>");
                                                                                                        Component._trace("  runAs <name> <password> <command>");
                                                                                                        Component._trace("  service");
                                                                                                        Component._trace("  services");
                                                                                                        Component._trace("  size [<filter name>]");
                                                                                                        Component._trace("  sleep [interval]");
                                                                                                        Component._trace("  stats [cluster | service | p2p] [reset]");
                                                                                                        Component._trace("  unlock <key>");
                                                                                                        Component._trace("  waitkey <start key> <stop key>");
                                                                                                        Component._trace("  who | cluster");
                                                                                                        Component._trace("  whoami | service");
                                                                                                        Component._trace("  worker <command>");
                                                                                                        Component._trace("  #<repeat count> <command>");
                                                                                                        Component._trace("  &<functionName> [<paramValue>]*");
                                                                                                        Component._trace("  !<history index>");
                                                                                                        break block183;
                                                                                                    }
                                                                                                    if (!sFunction.equals("aggregate")) break block188;
                                                                                                    if (this.isMapValid()) {
                                                                                                        this.doAggregate(aoParam, fSilent);
                                                                                                    }
                                                                                                    break block183;
                                                                                                }
                                                                                                if (!sFunction.equals("assert")) break block189;
                                                                                                if (cParams >= 1 && (sValue = String.valueOf(aoParam[0])).equals(sResult = String.valueOf(((ThreadLocal)this.get_Sink()).get())) ^ true) {
                                                                                                    sMsg = String.valueOf("Assertion failed: expected=\"") + sValue + "\"; actual=\"" + sResult + '\"';
                                                                                                    Component._trace(sMsg, 1);
                                                                                                    oResult = new RuntimeException(sMsg);
                                                                                                }
                                                                                                break block183;
                                                                                            }
                                                                                            if (!sFunction.equals("backup")) break block190;
                                                                                            this.doBackup(asParam, fSilent);
                                                                                            break block183;
                                                                                        }
                                                                                        if (!sFunction.equals("batch")) break block191;
                                                                                        this.doBatch(asParam, fSilent);
                                                                                        break block183;
                                                                                    }
                                                                                    if (!sFunction.equals("bulkput")) break block192;
                                                                                    this.doBulkPut(asParam, fSilent);
                                                                                    break block183;
                                                                                }
                                                                                if (!sFunction.equals("bulkremove")) break block193;
                                                                                this.doBulkRemove(asParam, fSilent);
                                                                                break block183;
                                                                            }
                                                                            if (!sFunction.equals("cachefactory")) break block194;
                                                                            this.doCacheFactory(asParam, fSilent);
                                                                            break block183;
                                                                        }
                                                                        if (!sFunction.equals("cache")) break block195;
                                                                        if (cParams > 0) {
                                                                            this.doCache(asParam, fSilent);
                                                                        } else {
                                                                            Component._trace(String.valueOf(map));
                                                                        }
                                                                        break block183;
                                                                    }
                                                                    if (!sFunction.equals("cohql")) break block196;
                                                                    QueryPlus.main(asParam);
                                                                    break block183;
                                                                }
                                                                if (!sFunction.equals("clear")) break block197;
                                                                if (this.isMapValid()) {
                                                                    map.clear();
                                                                }
                                                                break block183;
                                                            }
                                                            if (!(sFunction.equals("cluster") != false ? true : sFunction.equals("who"))) break block198;
                                                            Component._trace(String.valueOf(Coherence.getSafeCluster()));
                                                            break block183;
                                                        }
                                                        if (!sFunction.equals("connector")) break block199;
                                                        this.doConnector(asParam, fSilent);
                                                        break block183;
                                                    }
                                                    if (!sFunction.equals("destroy")) break block200;
                                                    if (this.isMapValid()) {
                                                        CacheFactory.destroyCache(map);
                                                    }
                                                    break block183;
                                                }
                                                if (!sFunction.equals("filter")) break block201;
                                                if (this.isMapValid()) {
                                                    this.doFilter(aoParam, fSilent);
                                                }
                                                break block183;
                                            }
                                            if (!sFunction.equals("get")) break block202;
                                            if (this.isMapValid() == false ? false : cParams >= 1) {
                                                oResult = map.get(aoParam[0]);
                                                ((ThreadLocal)this.get_Sink()).set(oResult);
                                                if (fSilent ^ true) {
                                                    Component._trace(Coherence.toString(oResult));
                                                }
                                            }
                                            break block183;
                                        }
                                        if (!sFunction.equals("hash")) break block203;
                                        if (this.isMapValid() ^ true) {
                                            return null;
                                        }
                                        iHash = 0;
                                        iter = map.keySet().iterator();
                                        while (iter.hasNext()) {
                                            oKey = iter.next();
                                            oVal = map.get(oKey);
                                            if (oVal instanceof byte[]) {
                                                ab = (byte[])oVal;
                                                i = 0;
                                                c = ab.length;
                                                while (i < c) {
                                                    iHash += ab[i];
                                                    ++i;
                                                }
                                                continue;
                                            }
                                            if (!(oVal != null)) continue;
                                            iHash += oVal.hashCode();
                                        }
                                        Component._trace(String.valueOf("hash=") + iHash);
                                        break block183;
                                    }
                                    if (!sFunction.equals("history")) break block204;
                                    this.doHistory(asParam, fSilent);
                                    break block183;
                                }
                                if (sFunction.equals("inc")) {
                                    if (this.isMapValid() ^ true) {
                                        return null;
                                    }
                                    oKey = aoParam[0];
                                    cInc = 1;
                                    try {
                                        cInc = Integer.parseInt(asParam[1]);
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    v0 = fLock = cParams <= 2 != false ? true : asParam[2].startsWith("o") ^ true;
                                    if (fLock) {
                                        map.lock(oKey, -1);
                                    }
                                    try {
                                        oVal /* !! */  = map.get(oKey);
                                        v1 = sVal = fSilent != false ? null : String.valueOf(oVal /* !! */ );
                                        if (oVal /* !! */  instanceof Versionable) {
                                            ver = (Versionable)oVal /* !! */ ;
                                            i = 0;
                                            while (i < cInc) {
                                                ver.incrementVersion();
                                                ++i;
                                            }
                                        } else {
                                            nVal = 0;
                                            try {
                                                nVal = Integer.parseInt(String.valueOf(oVal /* !! */ ));
                                            }
                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                            oVal /* !! */  = new Integer(nVal + cInc);
                                        }
                                        map.put(oKey, oVal /* !! */ );
                                        if (fSilent ^ true) {
                                            Component._trace(String.valueOf("incremented ") + oKey + " from " + sVal + " to " + oVal /* !! */ );
                                        }
                                        ((ThreadLocal)this.get_Sink()).set(oVal /* !! */ );
                                    }
                                    finally {
                                        sVal = null;
                                        if (fLock) {
                                            map.unlock(oKey);
                                        }
                                    }
                                }
                                if (!sFunction.equals("index")) break block205;
                                if (this.isMapValid() ^ true) {
                                    return null;
                                }
                                this.doIndex(asParam, fSilent);
                                break block183;
                            }
                            if (!sFunction.equals("iterate")) break block206;
                            cItems = 0;
                            iter = (Iterator)((ThreadLocal)this.get_Sink()).get();
                            while (iter.hasNext()) {
                                oNext = iter.next();
                                ++cItems;
                            }
                            if (fSilent ^ true) {
                                Component._trace(String.valueOf(cItems) + " items");
                            }
                            break block183;
                        }
                        if (!sFunction.startsWith("invoke")) break block207;
                        ofName = sFunction.indexOf(58);
                        sName = ofName < 0 != false ? "InvocationService" : sFunction.substring(ofName + 1);
                        this.doInvoke(sName, asParam, fSilent);
                        break block183;
                    }
                    if (!sFunction.equals("jmx")) break block208;
                    this.doJmx(asParam);
                    break block183;
                }
                if (!sFunction.equals("kill")) break block209;
                if (!(cParams > 0)) ** GOTO lbl289
                if (asParam[0].equals("all")) {
                    CacheFactory.shutdown();
                } else {
                    svcCluster = ((Cluster)Coherence.getSafeCluster().getCluster()).getClusterService();
                    setMember = svcCluster.getClusterMemberSet();
                    member = setMember.getMember(Integer.parseInt(asParam[0]));
                    if (svcCluster.getThisMember().equals(member)) {
                        Coherence.getSafeCluster().shutdown();
                    } else {
                        svcCluster.doMemberLeft(member);
                        return null;
lbl289:
                        // 1 sources

                        if (service == null) {
                            Coherence.getSafeCluster().shutdown();
                        } else {
                            service.shutdown();
                        }
                    }
                }
                this.setService(null);
                this.setMap(null);
                this.getLogger().setPrompt("?");
                break block183;
            }
            if (sFunction.equals("list")) {
                if (this.isMapValid()) {
                    this.doList(asParam, fSilent);
                }
            } else if (sFunction.equals("listen")) {
                fStop = cParams >= 1 == false ? false : asParam[0].equals("stop");
                sSource = cParams >= 2 != false ? asParam[1] : "global";
                oKey = null;
                filter = null;
                fLite = false;
                if (cParams >= 3 && (filter = (Filter)this.getFilters().get(asParam[2])) == null) {
                    oKey = aoParam[2];
                }
                if (cParams >= 4) {
                    fLite = asParam[3].equals("lite");
                }
                this.doListen(sSource, fStop, filter, oKey, fLite);
            } else if (sFunction.equals("log")) {
                this.doLog(aoParam, fSilent);
            } else if (sFunction.equals("maps")) {
                enumS = CacheFactory.ensureCluster().getServiceNames();
                while (enumS.hasMoreElements()) {
                    sName = (String)enumS.nextElement();
                    srv = Coherence.getSafeCluster().getService(sName);
                    if (!(srv instanceof CacheService == false ? false : srv.isRunning())) continue;
                    rc = (CacheService)srv;
                    enumC = rc.getCacheNames();
                    while (enumC.hasMoreElements()) {
                        Component._trace(String.valueOf(srv.getInfo().getServiceName()) + ":" + enumC.nextElement());
                    }
                }
            } else if (sFunction.equals("memory")) {
                rt = Runtime.getRuntime();
                rt.gc();
                lTotal = rt.totalMemory();
                lFree = rt.freeMemory();
                Component._trace(String.valueOf("total=") + lTotal / (long)1000 + "K (" + lTotal + ")");
                Component._trace(String.valueOf("free =") + lFree / (long)1000 + "K (" + lFree + ")");
                try {
                    LMax = (Long)ClassHelper.invoke(rt, "maxMemory", ClassHelper.VOID);
                    Component._trace(String.valueOf("max  =") + LMax / (long)1000 + "K (" + LMax + ")");
                }
                catch (Throwable e) {
                    // empty catch block
                }
                oResult = new Long(lFree);
            } else if (sFunction.equals("new")) {
                if (cParams > 0) {
                    try {
                        sClass = asParam[0];
                        if (sClass.startsWith("Component")) {
                            oResult = Component._newInstance(sClass);
                        } else {
                            clz = Class.forName(sClass);
                            if (cParams > 1) {
                                ao = new Object[cParams - 1];
                                System.arraycopy(aoParam, 1, ao, 0, cParams - 1);
                                oResult = ClassHelper.newInstance(clz, ao);
                            } else {
                                oResult = clz.newInstance();
                            }
                        }
                    }
                    catch (Exception e) {
                        Coherence.printException(null, e);
                    }
                }
                if (fSilent ^ true) {
                    Component._trace(Coherence.toString(oResult));
                }
                ((ThreadLocal)this.get_Sink()).set(oResult);
            } else if (sFunction.equals("process")) {
                if (this.isMapValid()) {
                    this.doProcess(aoParam, fSilent);
                }
            } else if (sFunction.equals("profile")) {
                lBegin = Base.getSafeTimeMillis();
                this.processCommand(sCmd);
                lElapsed = Base.getSafeTimeMillis() - lBegin;
                Component._trace(String.valueOf("Elapsed ") + lElapsed + "ms");
            } else if (sFunction.equals("put")) {
                if (this.isMapValid() == false ? false : cParams >= 2) {
                    oResult = map.put(aoParam[0], aoParam[1]);
                    if (fSilent ^ true) {
                        Component._trace(Coherence.toString(oResult));
                    }
                }
            } else if (sFunction.equals("release")) {
                if (this.isMapValid()) {
                    CacheFactory.releaseCache(map);
                }
            } else if (sFunction.equals("remove")) {
                if (this.isMapValid() == false ? false : cParams >= 1) {
                    oResult = map.remove(aoParam[0]);
                    ((ThreadLocal)this.get_Sink()).set(oResult);
                    if (fSilent ^ true) {
                        Component._trace(Coherence.toString(oResult));
                    }
                }
            } else if (sFunction.equals("restore")) {
                this.doRestore(asParam, fSilent);
            } else if (sFunction.equalsIgnoreCase("runAs")) {
                oResult = this.doSecure(asParam, fSilent);
            } else if (sFunction.equals("scan")) {
                if (this.isMapValid()) {
                    this.doScan(asParam);
                }
            } else if (sFunction.equals("server")) {
                DefaultCacheServer.startDaemon();
            } else if (sFunction.equals("service") != false ? true : sFunction.equals("whoami")) {
                if (service == null) {
                    this.processCommand("who");
                } else {
                    Component._trace(String.valueOf(service));
                    Component._trace(String.valueOf(service.getInfo().getServiceMembers()));
                }
            } else if (sFunction.equals("services")) {
                enum = CacheFactory.ensureCluster().getServiceNames();
                while (enum.hasMoreElements()) {
                    sName = (String)enum.nextElement();
                    info = Coherence.getSafeCluster().getServiceInfo(sName);
                    if (!(info != null)) continue;
                    Component._trace(info.toString());
                }
            } else {
                if (sFunction.equals("sleep")) {
                    lMillis = 1L;
                    try {
                        lMillis = Long.parseLong(asParam[0]);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    oKey = null;
                    if (cParams > 1) {
                        if (this.isMapValid() ^ true) {
                            return null;
                        }
                        oKey = aoParam[1];
                    }
                    try {
                        block182: {
                            try {
                                lStart = Base.getSafeTimeMillis();
                                if (oKey != null) {
                                    map.lock(oKey, -1L);
                                }
                                if (lMillis > (long)0) {
                                    Thread.sleep(lMillis);
                                    lStop = Base.getSafeTimeMillis();
                                } else {
                                    do {
                                        i = 0;
                                        while (i < 100) {
                                            ++i;
                                        }
                                        Thread.yield();
                                    } while ((lStop = Base.getSafeTimeMillis()) < lStart - lMillis);
                                }
                                if (fSilent ^ true) {
                                    Component._trace(String.valueOf("Elapsed ") + (lStop - lStart) + "ms");
                                }
                            }
                            catch (InterruptedException e) {
                                Component._trace("Sleep was interrupted; re-setting the interrupt flag...", 3);
                                Thread.currentThread().interrupt();
                                if (!(fSilent ^ true)) break block182;
                                throw Base.ensureRuntimeException(e);
                            }
                        }
                        enumC = null;
                        ** if (!(oKey != null)) goto lbl-1000
                    }
                    catch (Throwable e) {
                        enumC = null;
                        if (oKey != null) {
                            map.unlock(oKey);
                        }
                        throw e;
                    }
lbl-1000:
                    // 1 sources

                    {
                        map.unlock(oKey);
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block183;
                    }
                }
                if (sFunction.equals("size")) {
                    if (this.isMapValid() ^ true) {
                        return null;
                    }
                    if (cParams > 0) {
                        sName = asParam[0];
                        if (this.getFilters().containsKey(sName)) {
                            nPage = -1;
                            if (cParams > 1) {
                                nPage = Integer.parseInt(asParam[1]);
                            }
                            setEntry = this.applyFilter(sName, true, null, nPage);
                        } else {
                            map = this.getService().ensureCache(sName, null);
                            setEntry = map.entrySet();
                        }
                    } else {
                        setEntry = map.entrySet();
                    }
                    cSize = setEntry.size();
                    if (fSilent ^ true) {
                        Component._trace(String.valueOf(cSize));
                    }
                    ((ThreadLocal)this.get_Sink()).set(setEntry);
                } else if (sFunction.equals("stats")) {
                    fCluster = true;
                    fP2p = false;
                    fReset = false;
                    iNext = 0;
                    if (cParams > iNext == false ? false : asParam[iNext].equals("service")) {
                        fCluster = false;
                        ++iNext;
                    } else if (cParams > iNext == false ? false : asParam[iNext].equals("p2p")) {
                        fCluster = false;
                        fP2p = true;
                        ++iNext;
                    }
                    if (cParams > iNext == false ? false : asParam[iNext].equals("reset")) {
                        fReset = true;
                    }
                    v2 = sSilent = fSilent != false ? "@" : "";
                    if (fCluster) {
                        v3 = sTarget = this.getMap() == null != false ? "&" : "&getCacheService.getService.";
                        if (fReset) {
                            this.processCommand(String.valueOf('@') + sTarget + "getCluster.resetStats");
                        }
                        oResult = this.processCommand(String.valueOf(sSilent) + sTarget + "getCluster.formatStats");
                    } else if (fP2p) {
                        v4 = sTarget = this.getMap() == null != false ? "&" : "&getCacheService.getService.";
                        if (fReset) {
                            this.processCommand(String.valueOf('@') + sTarget + "getCluster.resetPointToPointStats");
                        }
                        oResult = this.processCommand(String.valueOf(sSilent) + sTarget + "getCluster.formatPointToPointStats");
                    } else if (this.isMapValid()) {
                        if (fReset) {
                            this.processCommand("@&getCacheService.getService.resetStats");
                        }
                        oResult = this.processCommand(String.valueOf(sSilent) + "&getCacheService.getService.formatStats");
                    }
                } else if (sFunction.equals("sum")) {
                    if (this.isMapValid() ^ true) {
                        return null;
                    }
                    cSum = 0;
                    cNums = 0;
                    cNots = 0;
                    iter = map.values().iterator();
                    while (iter.hasNext()) {
                        oVal = iter.next();
                        if (oVal instanceof Number) {
                            ++cNums;
                            cSum += ((Number)oVal).longValue();
                            continue;
                        }
                        if (oVal instanceof Versionable) {
                            oVer = ((Versionable)oVal).getVersionIndicator();
                            if (oVer instanceof Number) {
                                ++cNums;
                                cSum += ((Number)oVer).longValue();
                                continue;
                            }
                            ++cNots;
                            continue;
                        }
                        ++cNots;
                    }
                    if (fSilent ^ true) {
                        Component._trace(String.valueOf("sum=") + cSum + " (" + cNums + " values were numbers, " + cNots + " were not)");
                    }
                    oResult = new Long(cSum);
                    ((ThreadLocal)this.get_Sink()).set(oResult);
                } else if (sFunction.equals("waitkey")) {
                    if (this.isMapValid() ^ true) {
                        return null;
                    }
                    oKeyStart = aoParam[0];
                    oKeyStop = aoParam[1];
                    Component._trace(String.valueOf("waiting for key: ") + oKeyStart);
                    while (map.containsKey(oKeyStart) ^ true) {
                        Thread.currentThread();
                        Thread.sleep(10);
                    }
                    Component._trace(String.valueOf("waiting for key: ") + oKeyStop);
                    lBegin = Base.getSafeTimeMillis();
                    while (map.containsKey(oKeyStop) ^ true) {
                        Thread.currentThread();
                        Thread.sleep(10);
                    }
                    lElapsed = Base.getSafeTimeMillis() - lBegin;
                    Component._trace(String.valueOf(new Date()) + ": done (" + lElapsed + "ms)");
                } else if (sFunction.equals("worker")) {
                    sName = null;
                    worker = null;
                    try {
                        sName = String.valueOf("Worker!") + Integer.parseInt(asParam[0]);
                        worker = (Coherence$Worker)this._findChild(sName);
                        if (worker == null) {
                            Component._trace(String.valueOf(sName) + " has been terminated.");
                            return null;
                        }
                        if (fSilent ^ true) {
                            Component._trace(worker.toString());
                        }
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                    if (worker == null) {
                        fWait = cParams == 1 == false ? false : asParam[0].equals("wait");
                        i = 0;
                        while (i < 1000) {
                            sName = String.valueOf("Worker!") + i;
                            worker = (Coherence$Worker)this._findChild(sName);
                            if (worker == null) {
                                if (cParams > 0 == false ? false : fWait ^ true) {
                                    break;
                                }
                            } else if (fWait) {
                                worker.getThread().join();
                            } else if (cParams == 0) {
                                Component._trace(worker.toString());
                            }
                            ++i;
                        }
                        if ((fWait ^ true) == false ? false : cParams > 0) {
                            worker = new Coherence$Worker();
                            this._addChild((Component)worker, sName);
                            worker.setThreadName(sName);
                            worker.getQueue().add(sCmd);
                            worker.start();
                        }
                    }
                    ((ThreadLocal)this.get_Sink()).set(worker == null != false ? (Object)Coherence$Worker.getWorkerGroup() : worker);
                } else if ((sFunction.equals("begin") != false ? true : sFunction.equals("commit")) != false ? true : sFunction.equals("rollback")) {
                    if (this.isMapValid()) {
                        this.doTransaction(sFunction, asParam);
                    }
                } else if (sFunction.equals("pause")) {
                    cluster = Coherence.getSafeCluster();
                    member = (com.tangosol.coherence.component.net.Member)cluster.getLocalMember();
                    while (member.getId() == 0) {
                        Component._trace("pausing input; waiting to join cluster");
                        Thread.sleep(1000);
                        member = (com.tangosol.coherence.component.net.Member)cluster.getLocalMember();
                    }
                    file = new File(String.valueOf("member") + member.getId());
                    Component._trace(String.valueOf("pausing input; create file ") + file + " to continue");
                    while (file.exists() ^ true) {
                        Thread.sleep(1000);
                    }
                    file.delete();
                } else {
                    Component._trace(String.valueOf("Unknown command: \"") + sFunction + '\"' + "\nPrint \"help\" for command list");
                }
            }
        }
        return oResult;
    }

    public static Object processFunction(Object target, String sFunction, boolean fSilent, Object[] aoParam) {
        boolean fLast = false;
        try {
            do {
                String sMethod = sFunction;
                int ofNext = sFunction.indexOf(46);
                if (ofNext == -1) {
                    ofNext = sFunction.length();
                    fLast = true;
                } else {
                    sMethod = sFunction.substring(0, ofNext);
                    sFunction = sFunction.substring(ofNext + 1);
                }
                int nIx = -1;
                int ofIx = sMethod.indexOf(91);
                if (ofIx != -1) {
                    nIx = Integer.parseInt(sMethod.substring(ofIx + 1, sMethod.indexOf(93)));
                    sMethod = sMethod.substring(0, ofIx);
                }
                if (sMethod.endsWith("lock") && (!(aoParam.length > 0) ? false : "*".equals(aoParam[0]))) {
                    aoParam[0] = ConcurrentMap.LOCK_ALL;
                }
                boolean fTryStatic = target instanceof Class;
                boolean fTryInstance = fTryStatic ^ true;
                if (fTryStatic) {
                    try {
                        target = ClassHelper.invokeStatic((Class)target, sMethod, fLast ? aoParam : ClassHelper.VOID);
                    }
                    catch (NoSuchMethodException e) {
                        fTryInstance = true;
                    }
                }
                if (fTryInstance) {
                    target = ClassHelper.invoke(target, sMethod, fLast ? aoParam : ClassHelper.VOID);
                }
                if (nIx >= 0) {
                    target = Array.get(target, nIx);
                }
                if (fLast) {
                    if (!(fSilent ^ true)) continue;
                    Component._trace(Coherence.toString(target));
                    continue;
                }
                if (!(target == null)) continue;
                if (!(fSilent ^ true)) break;
                Component._trace(String.valueOf("Exception: ") + sMethod + " returned null");
                break;
            } while (fLast ^ true);
        }
        catch (Throwable e) {
            target = e;
            Coherence.printException(null, e);
        }
        return target;
    }

    protected String readLine(Object oReader) throws Exception {
        if (oReader instanceof Reader) {
            char[] ach = new char[256];
            int cch = ((Reader)oReader).read(ach);
            return cch <= 1 ? "" : new String(ach).trim();
        }
        return (String)ClassHelper.invoke(oReader, "readLine", ClassHelper.VOID);
    }

    protected void recordCommand(String sCmd) throws InterruptedException {
        List list = this.getCommandHistory();
        if (((list == null ? true : sCmd.startsWith("history")) ? true : sCmd.startsWith("!")) ? true : (!(list.isEmpty() ^ true) ? false : list.get(list.size() - 1).equals(sCmd))) {
            return;
        }
        list.add(sCmd);
    }

    protected static void replaceSystemProperties(XmlElement xml) {
        XmlHelper.replaceSystemProperties(xml, "system-property");
    }

    protected static String resolveEdition(XmlElement xmlLicense) {
        String sDescription;
        String sLicenseFile;
        String sEdition = xmlLicense.getSafeElement("edition-name").getString(DEFAULT_EDITION);
        int nEdition = 0;
        if ((sEdition.equalsIgnoreCase("ge") ? true : sEdition.equalsIgnoreCase("grid")) ? true : sEdition.equalsIgnoreCase("dge")) {
            sLicenseFile = "coherence-grid.xml";
            sEdition = DEFAULT_EDITION;
            sDescription = "Grid Edition";
            nEdition = 5;
        } else if ((sEdition.equalsIgnoreCase("ee") ? true : sEdition.equalsIgnoreCase("enterprise")) ? true : sEdition.equalsIgnoreCase("ae")) {
            sLicenseFile = "coherence-enterprise.xml";
            sEdition = "EE";
            sDescription = "Enterprise Edition";
            nEdition = 4;
        } else if ((sEdition.equalsIgnoreCase("se") ? true : sEdition.equalsIgnoreCase("standard")) ? true : sEdition.equalsIgnoreCase("ce")) {
            sLicenseFile = "coherence-standard.xml";
            sEdition = "SE";
            sDescription = "Standard Edition";
            nEdition = 3;
        } else if (((sEdition.equalsIgnoreCase("rtc") ? true : sEdition.equalsIgnoreCase("realtime")) ? true : sEdition.equalsIgnoreCase("cc")) ? true : sEdition.equalsIgnoreCase("compute")) {
            sLicenseFile = "coherence-rtc.xml";
            sEdition = "RTC";
            sDescription = "Real-Time Client";
            nEdition = 1;
        } else if (sEdition.equalsIgnoreCase("dc") ? true : sEdition.equalsIgnoreCase("client")) {
            sLicenseFile = "coherence-client.xml";
            sEdition = "DC";
            sDescription = "Data Client";
            nEdition = 0;
        } else {
            String sErrorMsg = String.valueOf("Invalid \"edition-name\" specified: \"") + sEdition + "\" (valid editions are GE/EE/SE/RTC/DC)";
            Component._trace(sErrorMsg, 1);
            throw new RuntimeException(sErrorMsg);
        }
        Coherence.loadLicenses(xmlLicense, sLicenseFile);
        LicensedObject.LicenseData[] aLicense = LicensedObject.getLicenseData();
        Component._assert(aLicense != null);
        Coherence app = (Coherence)Coherence.get_Instance();
        app.setEdition(nEdition);
        app.setProduct(String.valueOf(TITLE) + ' ' + sEdition);
        xmlLicense.ensureElement("edition-name").setString(sEdition);
        return sDescription;
    }

    protected static String resolveMode(XmlElement xmlLicense) {
        String sDescription;
        int nMode = 0;
        String sMode = xmlLicense.getSafeElement("license-mode").getString(DEFAULT_MODE);
        switch (sMode.length() > 0 ? (int)sMode.charAt(0) : 63) {
            case 69: 
            case 101: {
                nMode = 0;
                sDescription = "Evaluation";
                break;
            }
            case 68: 
            case 100: {
                nMode = 1;
                sDescription = "Development";
                break;
            }
            case 80: 
            case 112: {
                nMode = 2;
                sDescription = "Production";
                break;
            }
            default: {
                String sErrorMsg = String.valueOf("Invalid \"mode\" specified: \"") + sMode + "\" (valid modes are eval/dev/prod)";
                Component._trace(sErrorMsg, 1);
                throw new RuntimeException(sErrorMsg);
            }
        }
        sMode = MODE_NAMES[nMode];
        ((Coherence)Coherence.get_Instance()).setMode(nMode);
        xmlLicense.ensureElement("license-mode").setString(sMode);
        return sDescription;
    }

    public void run() {
        super.run();
        String sCmd = "";
        String[] asArg = Application.getArgument();
        if (asArg.length > 0) {
            sCmd = asArg[0].startsWith("@") ? asArg[0].substring(1) : String.valueOf("cache ") + asArg[0];
            int i = 1;
            int c = asArg.length;
            while (i < c) {
                sCmd = String.valueOf(sCmd) + (String.valueOf(' ') + asArg[i]);
                ++i;
            }
            Coherence.getSafeCluster();
        } else {
            CacheFactory.ensureCluster();
        }
        Object oReader = this.createReader();
        this.ensureRunningLogger().setPrompt("?");
        while (true) {
            if (sCmd.length() > 0) {
                try {
                    this.recordCommand(sCmd);
                    this.processCommand(sCmd);
                }
                catch (Throwable e) {
                    Coherence.printException(null, e);
                }
            }
            if (this.isStop()) {
                return;
            }
            try {
                Coherence$Logger logger = this.getLogger();
                Thread.currentThread();
                Thread.sleep(50);
                logger.setCommandPrompt(true);
                sCmd = this.readLine(oReader);
                logger.setCommandPrompt(false);
                logger.setPendingLineFeed(false);
                continue;
            }
            catch (Exception e) {
                System.out.println(String.valueOf("resetting reader due to ") + e);
                oReader = this.createReader();
                sCmd = "";
                this.ensureRunningLogger();
                continue;
            }
            break;
        }
    }

    protected static void setBuildNumber(String s) {
        __s_BuildNumber = s;
    }

    protected static void setCluster(SafeCluster cluster) {
        __s_Cluster = cluster;
    }

    protected void setCommandHistory(List list) {
        this.__m_CommandHistory = list;
    }

    protected static void setConfigurationLoaded(boolean fLoaded) {
        __s_ConfigurationLoaded = fLoaded;
    }

    private void setEdition(int nEdition) {
        this.__m_Edition = nEdition;
    }

    protected void setFilters(Map map) {
        this.__m_Filters = map;
    }

    private static void setLicenseLoaded(boolean fLoaded) {
        if (fLoaded) {
            __s_LicenseLoaded = fLoaded;
        }
    }

    protected void setLogParameters(Object[] ao) {
        this.__m_LogParameters = ao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLogger(Coherence$Logger logger) {
        if (logger == null) {
            logger = this.getLogger();
            if (logger != null) {
                logger.shutdown();
                Coherence coherence = this;
                synchronized (coherence) {
                    if (logger == this.getLogger()) {
                        this.__m_Logger = null;
                    }
                }
            }
        } else {
            this.__m_Logger = logger;
        }
    }

    protected void setMap(NamedCache map) {
        this.__m_Map = map;
    }

    private void setMode(int nMode) {
        this.__m_Mode = nMode;
    }

    protected void setProduct(String sProduct) {
        Component._assert(this.getProduct() == null ? true : this.getProduct().equals(sProduct));
        this.__m_Product = sProduct;
        this.setLogParameters(null);
    }

    protected void setService(CacheService service) {
        this.__m_Service = service;
    }

    public static void setServiceConfig(String sServiceType, XmlElement xmlCfg) {
        SafeCluster cluster;
        if (Coherence.getServiceConfig(sServiceType) == null) {
            throw new IllegalArgumentException(String.valueOf("Unknown service type: ") + sServiceType);
        }
        Coherence.getServiceConfigMap().put(sServiceType, xmlCfg.clone());
        if ("$Logger".equals(sServiceType)) {
            Coherence app = (Coherence)Coherence.get_Instance();
            Coherence$Logger logger = app.getLogger();
            if (logger.isStarted()) {
                app.setLogger(null);
            }
            app.ensureRunningLogger();
        }
        if ("$Management".equals(sServiceType) && (cluster = Coherence.getSafeCluster()).isRunning() ^ true) {
            Gateway mgmt = Gateway.createGateway(xmlCfg, cluster);
            cluster.setManagement(mgmt);
        }
    }

    protected static void setServiceConfigMap(Map map) {
        __s_ServiceConfigMap = map;
    }

    protected void setStop(boolean fStop) {
        this.__m_Stop = fStop;
    }

    private static void setTloCluster(ThreadLocal tloCluster) {
        __s_TloCluster = tloCluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        SafeCluster cluster = Coherence.getCluster();
        if (cluster != null) {
            Serializable serializable = cluster;
            synchronized (serializable) {
                Map mapConfig;
                cluster.shutdown();
                Map map = mapConfig = Coherence.getServiceConfigMap();
                synchronized (map) {
                    Coherence.setConfigurationLoaded(false);
                    mapConfig.clear();
                }
                ((Coherence)Coherence.get_Instance()).setLogger(null);
            }
            serializable = Coherence.get_CLASS();
            synchronized (serializable) {
                if (cluster == Coherence.getCluster()) {
                    Coherence.setCluster(null);
                }
            }
        }
    }

    public static String toString(Object oResult) {
        int MAX_TRACE = 50;
        String BEGIN = " {\n ";
        String NEXT = "\n ";
        String END = "\n }";
        Class<?> clzArrayType = oResult == null ? null : oResult.getClass().getComponentType();
        if (clzArrayType == null) {
            if (oResult instanceof Iterator) {
                StringBuffer sb = new StringBuffer();
                sb.append(oResult.getClass().getName());
                Iterator iter = (Iterator)oResult;
                if (iter.hasNext()) {
                    sb.append(BEGIN);
                    int i = 0;
                    while (!iter.hasNext() ? false : i < MAX_TRACE) {
                        sb.append(Coherence.toString(iter.next()));
                        if (iter.hasNext()) {
                            sb.append(NEXT);
                        }
                        ++i;
                    }
                    if (iter.hasNext()) {
                        sb.append("...");
                    }
                    sb.append(END);
                }
                return sb.toString();
            }
            if (oResult instanceof Enumeration) {
                StringBuffer sb = new StringBuffer();
                sb.append(oResult.getClass().getName()).append(BEGIN);
                Enumeration enumeration = (Enumeration)oResult;
                int i = 0;
                while (!enumeration.hasMoreElements() ? false : i < MAX_TRACE) {
                    sb.append(Coherence.toString(enumeration.nextElement()));
                    if (enumeration.hasMoreElements()) {
                        sb.append(NEXT);
                    }
                    ++i;
                }
                if (enumeration.hasMoreElements()) {
                    sb.append("...");
                }
                sb.append(END);
                return sb.toString();
            }
            if (oResult instanceof Class) {
                return Base.toString((Class)oResult);
            }
            return String.valueOf(oResult);
        }
        int c = Array.getLength(oResult);
        StringBuffer sb = new StringBuffer();
        sb.append(clzArrayType.getName()).append('[').append(c).append(']');
        if (c > 0) {
            sb.append(BEGIN);
            int cTrace = Math.min(c, MAX_TRACE);
            int i = 0;
            while (i < cTrace) {
                if (i > 0) {
                    sb.append(NEXT);
                }
                sb.append(Coherence.toString(Array.get(oResult, i)));
                ++i;
            }
            if (c > cTrace) {
                sb.append(", ...");
            }
            sb.append(END);
        }
        return sb.toString();
    }

    protected void txEnd() {
        NamedCache map = this.getMap();
        if (map instanceof TransactionMap) {
            NamedCache cache = (NamedCache)((TransactionMap)((Object)map)).getBaseMap();
            this.setMap(cache);
            Coherence$Logger logger = this.getLogger();
            logger.setPrompt(logger.getPrompt().substring(3));
        }
    }

    protected void txStart(int nConcur, int nIsolation, int nTimeout) {
        TransactionMap mapTx;
        NamedCache map = this.getMap();
        if (map instanceof TransactionMap) {
            mapTx = (TransactionMap)((Object)map);
        } else {
            mapTx = CacheFactory.getLocalTransaction(map);
            mapTx.setConcurrency(nConcur);
            mapTx.setTransactionIsolation(nIsolation);
            mapTx.setTransactionTimeout(nTimeout);
            mapTx.setValidator(new SimpleValidator());
            this.setMap((NamedCache)((Object)mapTx));
            Coherence$Logger logger = this.getLogger();
            logger.setPrompt(String.valueOf("Tx-") + logger.getPrompt());
        }
        mapTx.begin();
    }

    protected static void validateEnvironment() {
        String sVMName = System.getProperty("java.vm.name", "");
        String sOSName = System.getProperty("os.name", "");
        String sOSArch = System.getProperty("os.arch", "");
        String sDataModel = System.getProperty("sun.arch.data.model", "");
        if (!(!(!(!(sOSName.indexOf("SunOS") != -1) ? false : sOSArch.indexOf("sparc") != -1) ? false : sVMName.indexOf("HotSpot") != -1) ? false : sVMName.indexOf("Client VM") != -1) ? false : sDataModel.equals("32")) {
            String sMsg = String.valueOf("Coherence requires the 32-bit Hotspot JVM to be run in ") + "server mode on Solaris-sparc. Include the '-server' option on " + "the command line to run the server JVM.";
            Component._trace(sMsg, 1);
            throw new RuntimeException(sMsg);
        }
    }
}

