/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Member$FlowControl$DeferredQueue;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;

public class Member$FlowControl
extends Net {
    private transient int __m_DeferredPacketCount;
    private transient Queue __m_DeferredQueue;
    private volatile transient int __m_OutstandingPacketCount;
    private transient int __m_OutstandingPacketHighMark;
    private transient int __m_OutstandingPacketThreshold;
    private transient long __m_PauseStartMillis;
    private transient boolean __m_Paused;
    private transient int __m_SequentialConfirmedCount;
    private transient int __m_SequentialLostCount;
    private transient long __m_StatsPausedMillis;
    private static transient int __s_AggressionFactor;
    private static transient boolean __s_Enabled;
    private static transient int __s_LostPacketThreshold;
    private static transient int __s_OutstandingPacketMaximum;
    private static transient int __s_OutstandingPacketMinimum;
    private static transient int __s_PacketThreshold;
    private static transient int __s_SuccessGoal;

    static {
        Member$FlowControl._initStatic();
    }

    public Member$FlowControl() {
        this(null, null, true);
    }

    public Member$FlowControl(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this._addChild(new Member$FlowControl$DeferredQueue("DeferredQueue", this, true), "DeferredQueue");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        try {
            Member$FlowControl.setAggressionFactor(20);
            __s_PacketThreshold = -1;
            Member$FlowControl.setSuccessGoal(200);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    private static void _initStatic$Default() {
        Member$FlowControl.__initStatic();
    }

    protected static void _initStatic() {
        Member$FlowControl._initStatic$Default();
        try {
            String sGoal = System.getProperty("tangosol.coherence.flowcontrol.goal");
            String sAggression = System.getProperty("tangosol.coherence.flowcontrol.aggressive");
            String sThreshold = System.getProperty("tangosol.coherence.flowcontrol.threshold");
            if (sGoal != null) {
                Member$FlowControl.setSuccessGoal(Integer.parseInt(sGoal));
            }
            if (sAggression != null) {
                Member$FlowControl.setAggressionFactor(Integer.parseInt(sAggression));
            }
            if (sThreshold != null) {
                Member$FlowControl.setPacketThreshold(Integer.parseInt(sThreshold));
            }
        }
        catch (Exception exception) {}
    }

    public String formatStats(boolean fVerbose) {
        double dPaused = this.getStatsPauseRate();
        dPaused = (double)((int)(dPaused * 10000.0)) / 10000.0;
        String sStats = String.valueOf("PauseRate=") + dPaused + ", Threshold=" + this.getOutstandingPacketThreshold();
        if (fVerbose) {
            int cDeferred = this.getDeferredQueue().size();
            int cReady = this.getDeferredPacketCount() - cDeferred;
            sStats = String.valueOf(sStats) + (String.valueOf(", Paused=") + this.isPaused() + ", Deferring=" + this.isDeferring() + ", OutstandingPackets=" + this.getOutstandingPacketCount() + ", DeferredPackets=" + cDeferred + ", ReadyPackets=" + cReady);
        }
        return sStats;
    }

    public static int getAggressionFactor() {
        return __s_AggressionFactor;
    }

    public int getDeferredPacketCount() {
        return this.__m_DeferredPacketCount;
    }

    public Queue getDeferredQueue() {
        return this.__m_DeferredQueue;
    }

    public static int getLostPacketThreshold() {
        return __s_LostPacketThreshold;
    }

    public Member getMember() {
        return (Member)this.get_Parent();
    }

    public int getOutstandingPacketCount() {
        return this.__m_OutstandingPacketCount;
    }

    public int getOutstandingPacketHighMark() {
        return this.__m_OutstandingPacketHighMark;
    }

    public static int getOutstandingPacketMaximum() {
        return __s_OutstandingPacketMaximum;
    }

    public static int getOutstandingPacketMinimum() {
        return __s_OutstandingPacketMinimum;
    }

    public int getOutstandingPacketThreshold() {
        return this.__m_OutstandingPacketThreshold;
    }

    private static int getPacketThreshold() {
        return __s_PacketThreshold;
    }

    public long getPauseStartMillis() {
        return this.__m_PauseStartMillis;
    }

    public int getPendingPacketCount() {
        return this.getDeferredQueue().size() + this.getOutstandingPacketCount();
    }

    public int getSequentialConfirmedCount() {
        return this.__m_SequentialConfirmedCount;
    }

    public int getSequentialLostCount() {
        return this.__m_SequentialLostCount;
    }

    public double getStatsPauseRate() {
        long ldtNow = Base.getSafeTimeMillis();
        long cPausedMillis = this.getStatsPausedMillis();
        return cPausedMillis == 0L ? 0.0 : (double)cPausedMillis / (double)(ldtNow - this.getMember().getStatsReset());
    }

    public long getStatsPausedMillis() {
        long lMillis = this.__m_StatsPausedMillis;
        if (this.isPaused()) {
            lMillis += Base.getSafeTimeMillis() - this.getPauseStartMillis();
        }
        return lMillis;
    }

    public static int getSuccessGoal() {
        return __s_SuccessGoal;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/Member$FlowControl".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Member$FlowControl();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public boolean isAdjustable() {
        return Member$FlowControl.getOutstandingPacketMaximum() != Member$FlowControl.getOutstandingPacketMinimum();
    }

    public boolean isDeferring() {
        return this.getDeferredPacketCount() > 0;
    }

    public static boolean isEnabled() {
        return __s_Enabled;
    }

    public boolean isPaused() {
        return this.__m_Paused;
    }

    public void onInit() {
        int cThreshold = Member$FlowControl.getPacketThreshold();
        if (cThreshold < 0) {
            this.setOutstandingPacketThreshold((Member$FlowControl.getOutstandingPacketMaximum() + Member$FlowControl.getOutstandingPacketMinimum()) / 2);
        } else {
            this.setOutstandingPacketThreshold(cThreshold);
        }
        this.setDeferredQueue((Member$FlowControl$DeferredQueue)this._findChild("DeferredQueue"));
        super.onInit();
    }

    public void onPauseStart() {
        this.setPauseStartMillis(Base.getSafeTimeMillis());
        if (Component._isTraceEnabled(6)) {
            Component._trace(String.valueOf(this.getMember()) + " has failed to respond to " + this.getSequentialLostCount() + " packets; declaring this member as paused.", 6);
        }
    }

    public void onPauseStop() {
        int iLogLevel;
        long lDelta = Base.getSafeTimeMillis() - this.getPauseStartMillis();
        int n = lDelta > 1000L ? 2 : (iLogLevel = lDelta > 100L ? 6 : (lDelta > 10L ? 8 : 9));
        if (lDelta > (long)0) {
            this.setStatsPausedMillis(this.getStatsPausedMillis() + lDelta);
        }
        if (Component._isTraceEnabled(iLogLevel)) {
            Component._trace(String.valueOf("Experienced a ") + lDelta + " ms communication delay (probable remote GC) with " + this.getMember() + "; " + this.getSequentialLostCount() + " packets rescheduled, " + this.formatStats(false), iLogLevel);
        }
    }

    public void resetStats() {
        this.setStatsPausedMillis(0L);
    }

    public static void setAggressionFactor(int iFactor) {
        __s_AggressionFactor = Math.max(1, iFactor);
    }

    public void setDeferredPacketCount(int cPackets) {
        if (cPackets < 0) {
            throw new IllegalStateException(String.valueOf("DeferredPacketCount for ") + this.getMember() + " cannot be negative");
        }
        this.__m_DeferredPacketCount = cPackets;
    }

    public void setDeferredQueue(Queue queue) {
        this.__m_DeferredQueue = queue;
    }

    public static void setEnabled(boolean fEnabled) {
        __s_Enabled = fEnabled;
    }

    public static void setLostPacketThreshold(int nThreshold) {
        __s_LostPacketThreshold = nThreshold;
    }

    public void setOutstandingPacketCount(int cPackets) {
        if (cPackets < 0) {
            throw new IllegalStateException(String.valueOf("OutstandingPacketCount for ") + this.getMember() + " cannot be negative");
        }
        if (cPackets > this.getOutstandingPacketHighMark()) {
            this.setOutstandingPacketHighMark(cPackets);
        }
        this.__m_OutstandingPacketCount = cPackets;
    }

    public void setOutstandingPacketHighMark(int cPackets) {
        this.__m_OutstandingPacketHighMark = cPackets;
    }

    public static void setOutstandingPacketMaximum(int cPackets) {
        __s_OutstandingPacketMaximum = cPackets;
    }

    public static void setOutstandingPacketMinimum(int cPackets) {
        __s_OutstandingPacketMinimum = cPackets;
    }

    public void setOutstandingPacketThreshold(int cPackets) {
        this.__m_OutstandingPacketThreshold = cPackets = Math.max(Member$FlowControl.getOutstandingPacketMinimum(), Math.min(cPackets, Member$FlowControl.getOutstandingPacketMaximum()));
    }

    private static void setPacketThreshold(int cPacketThreshold) {
        __s_PacketThreshold = cPacketThreshold;
    }

    public void setPauseStartMillis(long ldtPauseStartMillis) {
        this.__m_PauseStartMillis = ldtPauseStartMillis;
    }

    public void setPaused(boolean fPaused) {
        if (fPaused ^ this.isPaused() ^ true) {
            return;
        }
        this.__m_Paused = fPaused;
        if (fPaused) {
            this.onPauseStart();
        } else {
            this.onPauseStop();
        }
    }

    public void setSequentialConfirmedCount(int cPackets) {
        this.__m_SequentialConfirmedCount = cPackets;
    }

    public void setSequentialLostCount(int cPackets) {
        this.__m_SequentialLostCount = cPackets;
    }

    public void setStatsPausedMillis(long cMillis) {
        this.__m_StatsPausedMillis = cMillis;
    }

    public static void setSuccessGoal(int iGoal) {
        __s_SuccessGoal = Math.max(1, iGoal);
    }

    public String toString() {
        return this.formatStats(true);
    }
}

