/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.packetBufferPool;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.PacketBufferPool;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.io.WriteBuffer;

public class SplitPacketBufferPool
extends PacketBufferPool {
    private int __m_MaximumPacketLength;
    private MultiBufferWriteBuffer.WriteBufferPool __m_MaximumPool;
    private int __m_PreferredPacketLength;
    private MultiBufferWriteBuffer.WriteBufferPool __m_PreferredPool;

    public SplitPacketBufferPool() {
        this(null, null, true);
    }

    public SplitPacketBufferPool(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public WriteBuffer allocate(int cb) {
        return cb <= this.getPreferredPacketLength() ? this.getPreferredPool().allocate(0) : this.getMaximumPool().allocate(0);
    }

    public int getMaximumPacketLength() {
        return this.__m_MaximumPacketLength;
    }

    public MultiBufferWriteBuffer.WriteBufferPool getMaximumPool() {
        return this.__m_MaximumPool;
    }

    public int getPreferredPacketLength() {
        return this.__m_PreferredPacketLength;
    }

    public MultiBufferWriteBuffer.WriteBufferPool getPreferredPool() {
        return this.__m_PreferredPool;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/packetBufferPool/SplitPacketBufferPool".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new SplitPacketBufferPool();
    }

    private final Component get_Module() {
        return this;
    }

    public WriteBuffer reallocate(WriteBuffer buffer, int cb) {
        boolean fMaxPool;
        int cbUsed = buffer.length();
        int cbCap = buffer.getCapacity();
        int cbPref = this.getPreferredPacketLength();
        boolean bl = fMaxPool = cbCap >= this.getMaximumPacketLength();
        if (fMaxPool) {
            if (cb <= cbPref) {
                WriteBuffer bufferNew = this.getPreferredPool().allocate(0);
                bufferNew.write(0, ((ByteArrayWriteBuffer)buffer).getRawByteArray(), 0, Math.min(cb, cbUsed));
                this.getMaximumPool().release(buffer);
                return bufferNew;
            }
        } else if (cb >= cbCap) {
            WriteBuffer bufferNew = this.getMaximumPool().allocate(0);
            bufferNew.write(0, ((ByteArrayWriteBuffer)buffer).getRawByteArray(), 0, cbUsed);
            this.getPreferredPool().release(buffer);
            return bufferNew;
        }
        return buffer;
    }

    public void release(WriteBuffer buffer) {
        if (buffer.getCapacity() < this.getMaximumPacketLength()) {
            this.getPreferredPool().release(buffer);
        } else {
            this.getMaximumPool().release(buffer);
        }
    }

    public void setMaximumPacketLength(int pMaximumPacketLength) {
        this.__m_MaximumPacketLength = pMaximumPacketLength;
    }

    public void setMaximumPool(MultiBufferWriteBuffer.WriteBufferPool pMaximumPool) {
        this.__m_MaximumPool = pMaximumPool;
    }

    public void setPreferredPacketLength(int pMaximumPacketLength) {
        this.__m_PreferredPacketLength = pMaximumPacketLength;
    }

    public void setPreferredPool(MultiBufferWriteBuffer.WriteBufferPool pMaximumPool) {
        this.__m_PreferredPool = pMaximumPool;
    }
}

