/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel.ast;

import com.tangosol.coherence.mvel.MVEL;
import com.tangosol.coherence.mvel.ParserContext;
import com.tangosol.coherence.mvel.ast.ASTNode;
import com.tangosol.coherence.mvel.ast.Assignment;
import com.tangosol.coherence.mvel.ast.Proto;
import com.tangosol.coherence.mvel.compiler.ExecutableStatement;
import com.tangosol.coherence.mvel.integration.VariableResolverFactory;
import com.tangosol.coherence.mvel.util.ParseTools;

public class ProtoVarNode
extends ASTNode
implements Assignment {
    private String name;
    private char[] stmt;
    private ExecutableStatement statement;

    public ProtoVarNode(String name, Proto type) {
        this.name = name;
        this.egressType = Proto.ProtoInstance.class;
    }

    public ProtoVarNode(char[] expr, int fields, Proto type, ParserContext pCtx) {
        this.egressType = Proto.ProtoInstance.class;
        this.fields = fields;
        ((ASTNode)this).name = expr;
        int assignStart = ParseTools.find(expr, '=');
        if (assignStart != -1) {
            this.name = ParseTools.createStringTrimmed(expr, 0, assignStart);
            ParseTools.checkNameSafety(this.name);
            if (((fields |= 0x80) & 0x10) != 0) {
                this.stmt = ParseTools.subset(expr, assignStart + 1);
                this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.stmt, pCtx);
            } else {
                this.stmt = ParseTools.subset(expr, assignStart + 1);
            }
        } else {
            this.name = new String(expr);
            ParseTools.checkNameSafety(this.name);
        }
        if ((fields & 0x10) != 0) {
            pCtx.addVariable(this.name, this.egressType, true);
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.statement == null) {
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.stmt);
        }
        ctx = this.statement.getValue(ctx, thisValue, factory);
        factory.createVariable(this.name, ctx, this.egressType);
        return ctx;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ctx = MVEL.eval(this.stmt, thisValue, factory);
        factory.createVariable(this.name, ctx, this.egressType);
        return ctx;
    }

    public String getName() {
        return this.name;
    }

    public String getAssignmentVar() {
        return this.name;
    }

    public char[] getExpression() {
        return this.stmt;
    }

    public boolean isNewDeclaration() {
        return true;
    }

    public void setValueStatement(ExecutableStatement stmt) {
        this.statement = stmt;
    }
}

