/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal;

import com.tangosol.coherence.transaction.TransactionId;
import com.tangosol.coherence.transaction.internal.ServiceContext;
import com.tangosol.coherence.transaction.internal.SimpleXid;
import com.tangosol.coherence.transaction.internal.TransactionImpl;
import com.tangosol.coherence.transaction.internal.XidManager;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.Schema;
import com.tangosol.coherence.transaction.internal.storage.Session;
import com.tangosol.coherence.transaction.internal.storage.SyntheticKey;
import com.tangosol.coherence.transaction.internal.storage.TableInfoImpl;
import com.tangosol.coherence.transaction.internal.storage.XidSyntheticKey;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Member;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.NamedCache;
import com.tangosol.net.Service;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.extractor.KeyExtractor;
import com.tangosol.util.filter.EqualsFilter;
import com.tangosol.util.filter.ExtractorFilter;
import com.tangosol.util.filter.NotFilter;
import com.tangosol.util.filter.PresentFilter;
import com.tangosol.util.processor.ConditionalPut;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RecoveryManager {
    private volatile ServiceContext m_context;

    public void initiateRecovery(MemberEvent event) {
        ServiceContext context;
        if (!event.isLocal() && CacheFactory.getCluster().isRunning() && (context = ServiceContext.getContext(event.getService().getInfo().getServiceName())) != null) {
            CacheFactory.log(String.format("%s %s", "RecoveryManager - Member Left:", event.getMember().toString()), 3);
            context.getThreadPool().execute(new RecoveryHandler(event, context));
        }
    }

    public static class RecoveryFilter
    extends ExtractorFilter {
        private String m_sService;
        private Collection m_setBlocks;

        public RecoveryFilter() {
            this.m_setBlocks = new HashSet();
        }

        public RecoveryFilter(String sService, Set setBlocks) {
            super(new KeyExtractor(IdentityExtractor.INSTANCE));
            this.m_sService = sService;
            this.m_setBlocks = new HashSet(setBlocks);
        }

        @Override
        public boolean evaluateExtracted(Object oKey) {
            XidSyntheticKey key = (XidSyntheticKey)oKey;
            SimpleXid xid = (SimpleXid)key.getXid();
            if (!this.m_setBlocks.contains(xid.getBlockId())) {
                return false;
            }
            SyntheticKey synKey = new SyntheticKey(key.getKey());
            return LocalMemberState.getMemberState(this.m_sService).getLocalPartitionState(synKey.getPartition()).getDependencyManager().containsDependency(xid);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            super.writeExternal(out);
            RecoveryFilter.writeObject(out, this.m_sService);
            RecoveryFilter.writeCollection(out, this.m_setBlocks);
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            super.readExternal(in);
            this.m_sService = (String)RecoveryFilter.readObject(in);
            RecoveryFilter.readCollection(in, this.m_setBlocks, null);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            super.writeExternal(out);
            out.writeString(1, this.m_sService);
            out.writeCollection(2, this.m_setBlocks);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            super.readExternal(in);
            this.m_sService = in.readString(1);
            in.readCollection(2, this.m_setBlocks);
        }
    }

    public static class XidExtractor
    implements ValueExtractor,
    ExternalizableLite,
    PortableObject {
        @Override
        public Object extract(Object o) {
            TransactionId xid = null;
            if (o instanceof XidSyntheticKey) {
                xid = ((XidSyntheticKey)o).getXid();
            }
            return xid == null ? null : Long.valueOf(xid.getId());
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
        }
    }

    private class RecoveryHandler
    implements Runnable {
        private volatile MemberEvent m_event;

        private RecoveryHandler(MemberEvent event, ServiceContext context) {
            this.m_event = event;
            RecoveryManager.this.m_context = context;
        }

        @Override
        public void run() {
            block4: {
                try {
                    Thread.sleep(2000L);
                    if (!this.attemptToTakeOwnership()) {
                        return;
                    }
                    CacheFactory.log(String.format("%s %s", "Took recovery ownership of member:", this.m_event.getMember().toString()), 3);
                    Member failedMember = this.m_event.getMember();
                    XidManager xidManager = RecoveryManager.this.m_context.getXidManager();
                    Set<Member> setMembers = this.getMembersToRecover(failedMember);
                    for (Member member : setMembers) {
                        Set setBlocks = xidManager.getBlockIds(member);
                        if (setBlocks == null) continue;
                        this.recoverMember(member, setBlocks);
                    }
                }
                catch (Exception e) {
                    if (!RecoveryManager.this.m_context.hasOwnershipEnabledMembers()) break block4;
                    CacheFactory.log("An exception occurred during recovery: " + e, 2);
                    CacheFactory.log(e);
                }
            }
        }

        private boolean attemptToTakeOwnership() {
            try {
                Schema schema = RecoveryManager.this.m_context.getSchema();
                Member failedMember = this.m_event.getMember();
                ConditionalPut ownershipProcessor = new ConditionalPut(new NotFilter(PresentFilter.INSTANCE), schema.getLocalMember(), true);
                return schema.getRecoveryTable().invoke(failedMember, ownershipProcessor) == null;
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("%s %s : %s", "An exception occurred attempting to take recovery ownership of", this.m_event.getMember(), e), e);
            }
        }

        private void recoverMember(Member member, Set setBlocks) {
            CacheFactory.log(String.format("%s %s", "Recovering member:", member.toString()), 5);
            Map<String, Map<Long, Set<XidSyntheticKey>>> mapLockedKeys = this.getXidsNeedingRecovery(setBlocks);
            this.completeTransactions(mapLockedKeys);
            RecoveryManager.this.m_context.getSchema().getRecoveryTable().remove(member);
        }

        private Set<Member> getMembersToRecover(Member member) {
            HashSet<Member> set = new HashSet<Member>();
            set.add(member);
            Set<Member> setMembers = this.getRecoveryOwnership(member);
            for (Member m : setMembers) {
                set.addAll(this.getMembersToRecover(m));
            }
            return set;
        }

        private Set<Member> getRecoveryOwnership(Member member) {
            return RecoveryManager.this.m_context.getSchema().getRecoveryTable().keySet(new EqualsFilter(IdentityExtractor.INSTANCE, (Object)member));
        }

        private Map<String, Map<Long, Set<XidSyntheticKey>>> getXidsNeedingRecovery(Set setBlocks) {
            Service service = this.m_event.getService();
            String sService = service.getInfo().getServiceName();
            XidManager xidManager = RecoveryManager.this.m_context.getXidManager();
            Schema schema = RecoveryManager.this.m_context.getSchema();
            Set<String> setTables = schema.getLogicalTableNames();
            HashMap<String, Map<Long, Set<XidSyntheticKey>>> mapLockedKeys = new HashMap<String, Map<Long, Set<XidSyntheticKey>>>();
            for (String sTable : setTables) {
                RecoveryFilter filter;
                TableInfoImpl tableInfo = new TableInfoImpl(sTable, sService);
                InvocableMap.EntryAggregator aggregator = xidManager.getLockedXidsAggregator(tableInfo);
                NamedCache cache = schema.getValuesTableByName(sTable);
                Map mapKeys = (Map)cache.aggregate(filter = new RecoveryFilter(sService, setBlocks), aggregator);
                if (mapKeys == null || mapKeys.isEmpty()) continue;
                mapLockedKeys.put(sTable, mapKeys);
            }
            return mapLockedKeys;
        }

        private void completeTransactions(Map<String, Map<Long, Set<XidSyntheticKey>>> mapTableKeys) {
            Service service = this.m_event.getService();
            String sService = service.getInfo().getServiceName();
            for (Map.Entry<String, Map<Long, Set<XidSyntheticKey>>> entry : mapTableKeys.entrySet()) {
                Map<Long, Set<XidSyntheticKey>> mapKeys = entry.getValue();
                String sTable = entry.getKey();
                for (Map.Entry<Long, Set<XidSyntheticKey>> keysEntry : mapKeys.entrySet()) {
                    this.completeTransaction(sService, sTable, keysEntry);
                }
            }
        }

        private void completeTransaction(String sService, String sTable, Map.Entry<Long, Set<XidSyntheticKey>> entry) {
            long lXid = entry.getKey();
            Set<XidSyntheticKey> setKeys = entry.getValue();
            SimpleXid xid = new SimpleXid(lXid);
            Set<Map.Entry<XidSyntheticKey, Long>> setResults = this.determineEndState(sService, sTable, lXid);
            Session session = new Session();
            session.recordSyntheticKeys(sTable, setKeys);
            TransactionImpl tx = new TransactionImpl(xid, session, true, true, RecoveryManager.this.m_context);
            if (setResults != null && !setResults.isEmpty()) {
                Map.Entry<XidSyntheticKey, Long> resultEntry = setResults.iterator().next();
                tx.setCommitVersion(resultEntry.getValue());
                tx.commit();
            } else {
                tx.rollback();
            }
            LocalMemberState.getMemberState(sService).getJmxStats().incrementRecoveredCount();
        }

        private Set<Map.Entry<XidSyntheticKey, Long>> determineEndState(String sService, String sTable, long xid) {
            Schema schema = ServiceContext.getContext(sService).getSchema();
            NamedCache versionTable = schema.getVersionsTableByName(sTable);
            return versionTable.entrySet(new EqualsFilter(new KeyExtractor(new XidExtractor()), (Object)xid));
        }
    }
}

