/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.composition;

import com.tangosol.coherence.transaction.internal.Endpoint;
import com.tangosol.coherence.transaction.internal.component.AddIndex;
import com.tangosol.coherence.transaction.internal.component.ClientAutoCommit;
import com.tangosol.coherence.transaction.internal.component.ClientErrorHandler;
import com.tangosol.coherence.transaction.internal.component.CommitVersionFetch;
import com.tangosol.coherence.transaction.internal.component.Component;
import com.tangosol.coherence.transaction.internal.component.CompositeComponent;
import com.tangosol.coherence.transaction.internal.component.JmxBegin;
import com.tangosol.coherence.transaction.internal.component.JmxGetEnd;
import com.tangosol.coherence.transaction.internal.component.JmxIncrementCommitCount;
import com.tangosol.coherence.transaction.internal.component.JmxIncrementRollbackCount;
import com.tangosol.coherence.transaction.internal.component.JmxPutEnd;
import com.tangosol.coherence.transaction.internal.component.MemberVersionFetch;
import com.tangosol.coherence.transaction.internal.component.MemberVersionWrite;
import com.tangosol.coherence.transaction.internal.component.OperationInitializer;
import com.tangosol.coherence.transaction.internal.component.ReadVersionFetch;
import com.tangosol.coherence.transaction.internal.component.RemoveIndex;
import com.tangosol.coherence.transaction.internal.component.SessionFetch;
import com.tangosol.coherence.transaction.internal.component.SessionReconciler;
import com.tangosol.coherence.transaction.internal.component.SessionWrite;
import com.tangosol.coherence.transaction.internal.component.StorageAggregate;
import com.tangosol.coherence.transaction.internal.component.StorageAutoCommit;
import com.tangosol.coherence.transaction.internal.component.StorageCommit;
import com.tangosol.coherence.transaction.internal.component.StorageEntrySet;
import com.tangosol.coherence.transaction.internal.component.StorageFetch;
import com.tangosol.coherence.transaction.internal.component.StorageInvoke;
import com.tangosol.coherence.transaction.internal.component.StorageInvokeFilter;
import com.tangosol.coherence.transaction.internal.component.StorageKeySet;
import com.tangosol.coherence.transaction.internal.component.StorageLock;
import com.tangosol.coherence.transaction.internal.component.StorageRollback;
import com.tangosol.coherence.transaction.internal.component.StorageSize;
import com.tangosol.coherence.transaction.internal.component.StorageUnlock;
import com.tangosol.coherence.transaction.internal.component.StorageWrite;
import com.tangosol.coherence.transaction.internal.component.SyncSyntheticKeys;
import com.tangosol.coherence.transaction.internal.component.UpdateVersionDependencies;
import com.tangosol.coherence.transaction.internal.router.LocalDirector;
import java.util.HashMap;
import java.util.Map;

public class EndpointManager {
    public static final String LOCAL_DIRECTOR = "local-director";
    public static final String SESSION_FETCH = "session.fetch";
    public static final String SESSION_WRITE = "session.write";
    public static final String SESSION_RECONCILE = "session.reconcile";
    public static final String STORAGE = "storage";
    public static final String STORAGE_FETCH = "storage.fetch";
    public static final String STORAGE_WRITE = "storage.write";
    public static final String STORAGE_QUERY_KEY = "storage.query.key";
    public static final String STORAGE_QUERY_ENTRY = "storage.query.entry";
    public static final String STORAGE_AGGREGATE = "storage.aggregate";
    public static final String STORAGE_INVOKE = "storage.invoke";
    public static final String STORAGE_INVOKE_FILTER = "storage.invoke.filter";
    public static final String STORAGE_COMMIT = "storage.commit";
    public static final String STORAGE_COMMIT_AUTO = "storage.commit.auto";
    public static final String STORAGE_ROLLBACK = "storage.rollback";
    public static final String STORAGE_INDEX_ADD = "storage.index.add";
    public static final String STORAGE_INDEX_REMOVE = "storage.index.remove";
    public static final String STORAGE_SIZE = "storage.size";
    public static final String CLIENT_COMMIT_AUTO = "client.commit.auto";
    public static final String CLIENT_ERROR_HANDLER = "client.error";
    public static final String CLIENT_INIT = "client.init";
    public static final String CLIENT_KEYS_SYNC = "client.keys.sync";
    public static final String VERSION_READ_BIND = "version.read.bind";
    public static final String VERSION_MEMBER_BIND = "version.member.bind";
    public static final String VERSION_COMMIT_BIND = "version.commit.bind";
    public static final String VERSION_COMMIT_UPDATE = "version.commit.update";
    public static final String VERSION_MEMBER_WRITE = "version.member.write";
    public static final String JMX_COMMIT_INCREMENT = "jmx.commit.increment";
    public static final String JMX_ROLLBACK_INCREMENT = "jmx.rollback.increment";
    public static final String JMX_REQUEST_BEGIN = "jmx.request.begin";
    public static final String JMX_GET_END = "jmx.get.end";
    public static final String JMX_PUT_END = "jmx.put.end";
    private Map<String, Endpoint> m_mapEndpoint = new HashMap<String, Endpoint>();

    public void initializeEndpoints() {
        Endpoint localDirectorEndpoint = new Endpoint(LOCAL_DIRECTOR);
        this.registerEndpoint(localDirectorEndpoint);
        localDirectorEndpoint.setRouter(new LocalDirector());
        this.registerEndpoint(new Endpoint(SESSION_FETCH, new SessionFetch()));
        this.registerEndpoint(new Endpoint(SESSION_WRITE, new SessionWrite()));
        this.registerEndpoint(new Endpoint(SESSION_RECONCILE, new SessionReconciler()));
        this.registerEndpoint(new Endpoint(STORAGE));
        this.registerEndpoint(new Endpoint(STORAGE_FETCH, new StorageFetch()));
        this.registerEndpoint(new Endpoint(STORAGE_WRITE, this.createComposite(new StorageUnlock(), new StorageLock(), new StorageWrite())));
        this.registerEndpoint(new Endpoint(STORAGE_COMMIT, new StorageCommit()));
        this.registerEndpoint(new Endpoint(STORAGE_COMMIT_AUTO, new StorageAutoCommit()));
        this.registerEndpoint(new Endpoint(STORAGE_ROLLBACK, new StorageRollback()));
        this.registerEndpoint(new Endpoint(STORAGE_QUERY_KEY, new StorageKeySet()));
        this.registerEndpoint(new Endpoint(STORAGE_QUERY_ENTRY, new StorageEntrySet()));
        this.registerEndpoint(new Endpoint(STORAGE_AGGREGATE, new StorageAggregate()));
        this.registerEndpoint(new Endpoint(STORAGE_INVOKE, new StorageInvoke()));
        this.registerEndpoint(new Endpoint(STORAGE_INVOKE_FILTER, new StorageInvokeFilter()));
        this.registerEndpoint(new Endpoint(STORAGE_INDEX_ADD, new AddIndex()));
        this.registerEndpoint(new Endpoint(STORAGE_INDEX_REMOVE, new RemoveIndex()));
        this.registerEndpoint(new Endpoint(STORAGE_SIZE, new StorageSize()));
        this.registerEndpoint(new Endpoint(VERSION_READ_BIND, new ReadVersionFetch()));
        this.registerEndpoint(new Endpoint(VERSION_MEMBER_BIND, new MemberVersionFetch()));
        this.registerEndpoint(new Endpoint(VERSION_COMMIT_BIND, new CommitVersionFetch()));
        this.registerEndpoint(new Endpoint(VERSION_COMMIT_UPDATE, new UpdateVersionDependencies()));
        this.registerEndpoint(new Endpoint(VERSION_MEMBER_WRITE, new MemberVersionWrite()));
        this.registerEndpoint(new Endpoint(CLIENT_COMMIT_AUTO, new ClientAutoCommit()));
        this.registerEndpoint(new Endpoint(CLIENT_ERROR_HANDLER, new ClientErrorHandler()));
        this.registerEndpoint(new Endpoint(CLIENT_INIT, new OperationInitializer()));
        this.registerEndpoint(new Endpoint(CLIENT_KEYS_SYNC, new SyncSyntheticKeys()));
        this.registerEndpoint(new Endpoint(JMX_COMMIT_INCREMENT, new JmxIncrementCommitCount()));
        this.registerEndpoint(new Endpoint(JMX_ROLLBACK_INCREMENT, new JmxIncrementRollbackCount()));
        this.registerEndpoint(new Endpoint(JMX_REQUEST_BEGIN, new JmxBegin()));
        this.registerEndpoint(new Endpoint(JMX_GET_END, new JmxGetEnd()));
        this.registerEndpoint(new Endpoint(JMX_PUT_END, new JmxPutEnd()));
    }

    public void registerEndpoint(Endpoint endpoint) {
        this.m_mapEndpoint.put(endpoint.getAddress(), endpoint);
    }

    public Endpoint getEndpoint(String sAddress) {
        return this.m_mapEndpoint.get(sAddress);
    }

    private CompositeComponent createComposite(Component errorHandler, Component ... components) {
        CompositeComponent compositeWrite = new CompositeComponent(components);
        compositeWrite.setErrorComponent(errorHandler);
        return compositeWrite;
    }
}

