/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.Aaload;
import com.tangosol.dev.assembler.Baload;
import com.tangosol.dev.assembler.Caload;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Daload;
import com.tangosol.dev.assembler.Faload;
import com.tangosol.dev.assembler.Iaload;
import com.tangosol.dev.assembler.Laload;
import com.tangosol.dev.assembler.Op;
import com.tangosol.dev.assembler.Saload;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.UnaryExpression;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.Map;

public class ArrayAccessExpression
extends UnaryExpression {
    private static final String CLASS = "ArrayAccessExpression";
    private static final DataType INT = DataType.INT;
    private Expression index;

    public ArrayAccessExpression(Token operator, Expression expr, Expression index, Token tokLast) {
        super(operator, expr);
        this.setStartToken(expr.getStartToken());
        this.setEndToken(tokLast);
        this.index = index;
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression exprArray = this.getArray();
        Expression exprIndex = this.getIndex();
        exprArray = (Expression)exprArray.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        exprIndex = (Expression)exprIndex.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        if (exprArray.checkArray(errlist) && exprIndex.checkAssignable(ctx, INT, errlist)) {
            exprIndex = exprIndex.promoteNumeric();
            this.setType(exprArray.getType().getElementType());
        }
        this.setArray(exprArray);
        this.setIndex(exprIndex);
        return this;
    }

    @Override
    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        if (!ctx.isDebug() && this.isConstant() && !(this.getValue() instanceof Object[])) {
            return super.compile(ctx, code, fReached, errlist);
        }
        this.getArray().compile(ctx, code, fReached, errlist);
        this.getIndex().compile(ctx, code, fReached, errlist);
        Op opLoad = null;
        switch (this.getType().getTypeString().charAt(0)) {
            case 'B': 
            case 'Z': {
                opLoad = new Baload();
                break;
            }
            case 'C': {
                opLoad = new Caload();
                break;
            }
            case 'S': {
                opLoad = new Saload();
                break;
            }
            case 'I': {
                opLoad = new Iaload();
                break;
            }
            case 'J': {
                opLoad = new Laload();
                break;
            }
            case 'F': {
                opLoad = new Faload();
                break;
            }
            case 'D': {
                opLoad = new Daload();
                break;
            }
            case 'L': 
            case 'N': 
            case 'R': 
            case '[': {
                opLoad = new Aaload();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        code.add(opLoad);
        return fReached;
    }

    public Expression getArray() {
        return this.getExpression();
    }

    protected void setArray(Expression expr) {
        this.setExpression(expr);
    }

    public Expression getIndex() {
        return this.index;
    }

    protected void setIndex(Expression expr) {
        this.index = expr;
    }

    @Override
    public boolean isConstant() {
        if (this.getArray().isConstant() && this.getIndex().isConstant()) {
            Object[] a = (Object[])this.getArray().getValue();
            int i = ((Number)this.getIndex().getValue()).intValue();
            return a != null && i >= 0 && i < a.length;
        }
        return false;
    }

    @Override
    public Object getValue() {
        Object[] a = (Object[])this.getArray().getValue();
        int i = ((Number)this.getIndex().getValue()).intValue();
        return a[i];
    }

    @Override
    protected boolean checkAssignable(ErrorList errlist) throws CompilerException {
        return true;
    }

    @Override
    public void print(String sIndent) {
        super.print(sIndent);
        ArrayAccessExpression.out(sIndent + "  Index:");
        this.index.print(sIndent + "    ");
    }
}

