/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.disassembler;

import com.tangosol.dev.disassembler.Constant;
import com.tangosol.dev.disassembler.UtfConstant;
import java.io.DataInput;
import java.io.IOException;

public class ClassConstant
extends Constant {
    private int m_iName;

    public ClassConstant(DataInput stream) throws IOException {
        this.m_iName = stream.readUnsignedShort();
    }

    public int getNameIndex() {
        return this.m_iName;
    }

    public String getName() {
        return ((UtfConstant)this.m_aconst[this.m_iName]).getText().replace('/', '.');
    }

    public String getSimpleName() {
        String sName = this.getName();
        int ofSep = sName.lastIndexOf(46);
        if (ofSep > 0) {
            return sName.substring(ofSep + 1);
        }
        return sName;
    }

    public String getPackageName() {
        String sName = this.getName();
        int ofSep = sName.lastIndexOf(46);
        if (ofSep > 0) {
            return sName.substring(0, ofSep);
        }
        return "";
    }

    public String toString() {
        return "Class:  Name Index=" + this.m_iName + " (" + ClassConstant.format(this.getName()) + ")";
    }
}

