/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.cluster;

import com.tangosol.internal.net.InetAddressRangeFilter;
import com.tangosol.internal.net.cluster.DefaultClusterDependencies;
import com.tangosol.internal.net.cluster.DefaultMemberIdentity;
import com.tangosol.internal.net.cluster.DefaultServiceFailurePolicy;
import com.tangosol.internal.net.cluster.LegacyXmlConfigurableQuorumPolicy;
import com.tangosol.io.ConfigurableSerializerFactory;
import com.tangosol.io.WrapperStreamFactory;
import com.tangosol.net.AddressProvider;
import com.tangosol.net.CompositeAddressProvider;
import com.tangosol.net.ConfigurableAddressProvider;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.ServiceFailurePolicy;
import com.tangosol.net.SocketOptions;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.LiteMap;
import com.tangosol.util.SafeLinkedList;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LegacyXmlClusterDependencies
extends DefaultClusterDependencies {
    public LegacyXmlClusterDependencies fromXml(XmlElement xml) {
        Base.azzert(xml.getName().equals("cluster-config"));
        DefaultMemberIdentity memberIdentity = new DefaultMemberIdentity();
        this.configureMemberIdentity(xml, memberIdentity);
        this.configureMulticastListener(xml);
        this.configureUnicastListener(xml, memberIdentity);
        this.setMemberIdentity(memberIdentity);
        this.configureTcpRingListener(xml);
        this.configureShutdownListener(xml);
        this.configureServiceGuardian(xml);
        this.configurePacketSpeaker(xml);
        this.configurePacketPublisher(xml);
        this.configureIncomingMessageHandler(xml);
        this.configureOutgoingMessageHandler(xml);
        this.configureAuthorizedHosts(xml);
        this.configureServices(xml);
        this.configureFilters(xml);
        this.configureSerializers(xml);
        this.configureSocketProviders(xml);
        this.configureClusterQuorumPolicy(xml);
        String sEdition = xml.getSafeElement("edition-name").getString("GE");
        this.setEdition(this.translateEditionName(sEdition));
        String sMode = xml.getSafeElement("license-mode").getString("dev");
        this.setMode(this.translateModeName(sMode));
        return this;
    }

    private void configureMemberIdentity(XmlElement xml, DefaultMemberIdentity memberIdentity) {
        XmlElement xmlCat = xml.getSafeElement("member-identity");
        memberIdentity.setClusterName(xmlCat.getSafeElement("cluster-name").getString(""));
        memberIdentity.setSiteName(xmlCat.getSafeElement("site-name").getString(""));
        memberIdentity.setRackName(xmlCat.getSafeElement("rack-name").getString(memberIdentity.getRackName()));
        memberIdentity.setMachineName(xmlCat.getSafeElement("machine-name").getString(memberIdentity.getMachineName()));
        memberIdentity.setProcessName(xmlCat.getSafeElement("process-name").getString(memberIdentity.getProcessName()));
        memberIdentity.setMemberName(xmlCat.getSafeElement("member-name").getString(memberIdentity.getMemberName()));
        memberIdentity.setRoleName(xmlCat.getSafeElement("role-name").getString(memberIdentity.getRoleName()));
        memberIdentity.setPriority(xmlCat.getSafeElement("priority").getInt(memberIdentity.getPriority()));
    }

    private void configureMulticastListener(XmlElement xml) {
        XmlElement xmlCat = xml.getSafeElement("multicast-listener");
        this.setGroupInterface(this.resolveGroupInterface(xmlCat.getSafeElement("interface").getString("")));
        this.setGroupAddress(this.resolveGroupAddress(xmlCat.getSafeElement("address").getString("224.0.0.87")));
        this.setGroupPort(xmlCat.getSafeElement("port").getInt(this.getGroupPort()));
        this.setGroupTimeToLive(xmlCat.getSafeElement("time-to-live").getInt(this.getGroupTimeToLive()));
        XmlElement xmlSub = xmlCat.getSafeElement("packet-buffer");
        XmlElement xmlVal = xmlSub.getElement("maximum-packets");
        if (xmlVal == null) {
            this.setGroupBufferSize((int)Base.parseMemorySize(xmlSub.getSafeElement("size").getString(Integer.toString(this.getGroupBufferSize()))));
        } else {
            this.setGroupBufferSize(-xmlVal.getInt());
            if (xmlSub.getElement("size") != null) {
                throw new IllegalArgumentException("cannot specify maximum-packets and size within packet-buffer");
            }
        }
        this.setGroupListenerPriority(xmlCat.getSafeElement("priority").getInt(this.getGroupListenerPriority()));
        this.setClusterAnnounceTimeoutMillis(xmlCat.getSafeElement("join-timeout-milliseconds").getInt(this.getClusterAnnounceTimeoutMillis()));
        this.setPublisherGroupThreshold(xmlCat.getSafeElement("multicast-threshold-percent").getInt(this.getPublisherGroupThreshold()));
    }

    private void configureUnicastListener(XmlElement xml, DefaultMemberIdentity memberIdentity) {
        XmlElement xmlCat = xml.getSafeElement("unicast-listener");
        this.setUnicastSocketProviderXml(xmlCat.getSafeElement("socket-provider"));
        this.setReliableTransport(xmlCat.getSafeElement("reliable-transport").getString(this.getReliableTransport()));
        this.setTcpDatagramSocketOptions(SocketOptions.load(xmlCat.getSafeElement("socket-options")));
        memberIdentity.setMachineId(Integer.parseInt(xmlCat.getSafeElement("machine-id").getString("0")));
        String sAddr = xmlCat.getSafeElement("address").getString();
        if (sAddr != null) {
            try {
                this.setLocalAddress(InetAddressHelper.getLocalAddress(sAddr));
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("unresolvable localhost " + sAddr, e);
            }
        }
        this.setLocalPort(xmlCat.getSafeElement("port").getInt(this.getLocalPort()));
        this.setLocalPortAutoAdjust(xmlCat.getSafeElement("port-auto-adjust").getBoolean(this.isLocalPortAutoAdjust()));
        XmlElement xmlSub = xmlCat.getSafeElement("packet-buffer");
        XmlElement xmlVal = xmlSub.getElement("maximum-packets");
        if (xmlVal == null) {
            this.setLocalBufferSize((int)Base.parseMemorySize(xmlSub.getSafeElement("size").getString(Integer.toString(this.getLocalBufferSize()))));
        } else {
            this.setLocalBufferSize(-xmlVal.getInt());
            if (xmlSub.getElement("size") != null) {
                throw new IllegalArgumentException("cannot specify maximum-packets and size within packet-buffer");
            }
        }
        this.setLocalListenerPriority(xmlCat.getSafeElement("priority").getInt(this.getLocalListenerPriority()));
        this.setWellKnownAddresses(this.createWkaAddressProvider(xmlCat.getSafeElement("well-known-addresses")));
    }

    private void configureTcpRingListener(XmlElement xml) {
        XmlElement xmlCat = xml.getSafeElement("tcp-ring-listener");
        this.setTcpRingEnabled(xmlCat.getSafeElement("enabled").getBoolean(this.isTcpRingEnabled()));
        this.setIpMonitorTimeoutMillis(XmlHelper.parseTime(xmlCat, "ip-timeout", this.getIpMonitorTimeoutMillis()));
        this.setIpMonitorAttempts(xmlCat.getSafeElement("ip-attempts").getInt(this.getIpMonitorAttempts()));
        this.setTcpBacklog(xmlCat.getSafeElement("listen-backlog").getInt(this.getTcpBacklog()));
        this.setIpMonitorPriority(xmlCat.getSafeElement("priority").getInt(this.getIpMonitorPriority()));
        this.setTcpRingSocketOptions(SocketOptions.load(xmlCat.getSafeElement("socket-options")));
    }

    private void configureShutdownListener(XmlElement xml) {
        XmlElement xmlCat = xml.getSafeElement("shutdown-listener");
        String sShutdownOption = xmlCat.getSafeElement("enabled").getString();
        int nShutdownOption = this.getShutdownHookOption();
        if (sShutdownOption.equals("force") || sShutdownOption.equals("true")) {
            nShutdownOption = 1;
        } else if (sShutdownOption.equals("none") || sShutdownOption.equals("false")) {
            nShutdownOption = 0;
        } else if (sShutdownOption.equals("graceful")) {
            nShutdownOption = 2;
        }
        this.setShutdownHookOption(nShutdownOption);
    }

    private void configureServiceGuardian(XmlElement xml) {
        XmlElement xmlCat = xml.getSafeElement("service-guardian");
        XmlElement xmlSub = xmlCat.getSafeElement("service-failure-policy");
        ServiceFailurePolicy policy = this.parseServiceFailurePolicy(xmlSub);
        if (policy != null) {
            this.setServiceFailurePolicy(policy);
        }
        this.setGuardTimeoutMillis(xmlCat.getSafeElement("timeout-milliseconds").getLong(this.getGuardTimeoutMillis()));
    }

    private void configurePacketSpeaker(XmlElement xml) {
        XmlElement xmlCat = xml.getSafeElement("packet-speaker");
        XmlElement xmlSub = xmlCat.getSafeElement("volume-threshold");
        this.setSpeakerVolumeMinimum(xmlSub.getSafeElement("minimum-packets").getInt(this.getSpeakerVolumeMinimum()));
        this.setSpeakerPriority(xmlCat.getSafeElement("priority").getInt(this.getSpeakerPriority()));
    }

    private void configurePacketPublisher(XmlElement xml) {
        XmlElement xmlCat = xml.getSafeElement("packet-publisher");
        XmlElement xmlSub = xmlCat.getSafeElement("packet-size");
        this.setPacketMaxLength(xmlSub.getSafeElement("maximum-length").getInt(this.getPacketMaxLength()));
        this.setPacketPreferredLength(xmlSub.getSafeElement("preferred-length").getInt(this.getPacketPreferredLength()));
        xmlSub = xmlCat.getSafeElement("packet-delivery");
        this.setPublisherResendDelayMillis(xmlSub.getSafeElement("resend-milliseconds").getInt(this.getPublisherResendDelayMillis()));
        this.setPublisherResendTimeoutMillis(xmlSub.getSafeElement("timeout-milliseconds").getInt(this.getPublisherResendTimeoutMillis()));
        this.setClusterHeartbeatDelayMillis(xmlSub.getSafeElement("heartbeat-milliseconds").getInt(this.getClusterHeartbeatDelayMillis()));
        XmlElement xmlSub2 = xmlSub.getSafeElement("flow-control");
        this.setFlowControlEnabled(xmlSub2.getSafeElement("enabled").getBoolean(this.isFlowControlEnabled()));
        this.setLostPacketThreshold(xmlSub2.getSafeElement("pause-detection/maximum-packets").getInt(this.getLostPacketThreshold()));
        XmlElement xmlVal = xmlSub2.getSafeElement("outstanding-packets");
        this.setOutstandingPacketMaximum(xmlVal.getSafeElement("maximum-packets").getInt(this.getOutstandingPacketMaximum()));
        this.setOutstandingPacketMinimum(xmlVal.getSafeElement("minimum-packets").getInt(this.getOutstandingPacketMinimum()));
        xmlSub2 = xmlSub.getSafeElement("packet-bundling");
        String sTime = xmlSub2.getSafeElement("maximum-deferral-time").getString();
        if (sTime.length() > 0) {
            this.setPacketBundlingThresholdNanos(Base.parseTimeNanos(sTime));
        }
        this.setPacketBundlingAggression(xmlSub2.getSafeElement("aggression-factor").getDouble(this.getPacketBundlingAggression()));
        xmlSub = xmlCat.getSafeElement("notification-queueing");
        this.setPublisherAckDelayMillis(xmlSub.getSafeElement("ack-delay-milliseconds").getInt(this.getPublisherAckDelayMillis()));
        this.setPublisherNackDelayMillis(xmlSub.getSafeElement("nack-delay-milliseconds").getInt(this.getPublisherNackDelayMillis()));
        xmlSub = xmlCat.getSafeElement("traffic-jam");
        this.setPublisherCloggedCount(xmlSub.getSafeElement("maximum-packets").getInt(this.getPublisherCloggedCount()));
        this.setPublisherCloggedDelayMillis(xmlSub.getSafeElement("pause-milliseconds").getInt(this.getPublisherCloggedDelayMillis()));
        xmlSub = xmlCat.getSafeElement("packet-buffer");
        xmlVal = xmlSub.getElement("maximum-packets");
        if (xmlVal == null) {
            this.setPublisherSocketBufferSize((int)Base.parseMemorySize(xmlSub.getSafeElement("size").getString(Integer.toString(this.getPublisherSocketBufferSize()))));
        } else {
            this.setPublisherSocketBufferSize(-xmlVal.getInt());
            if (xmlSub.getElement("size") != null) {
                throw new IllegalArgumentException("cannot specify maximum-packets and size within packet-buffer");
            }
        }
        xmlSub = xmlCat.getSafeElement("packet-pool");
        this.setPublisherPacketAllocatorSize((int)Base.parseMemorySize(xmlSub.getSafeElement("size").getString(Integer.toString(this.getPublisherPacketAllocatorSize()))));
        this.setPublisherPriority(xmlCat.getSafeElement("priority").getInt(this.getPublisherPriority()));
        this.setTcmpEnabled(xmlCat.getSafeElement("enabled").getBoolean(this.isTcmpEnabled()));
    }

    private void configureIncomingMessageHandler(XmlElement xml) {
        XmlElement xmlCat = xml.getSafeElement("incoming-message-handler");
        this.setClusterTimestampMaxVarianceMillis(xmlCat.getSafeElement("maximum-time-variance").getInt(this.getClusterTimestampMaxVarianceMillis()));
        this.setReceiverNackEnabled(xmlCat.getSafeElement("use-nack-packets").getBoolean(this.isReceiverNackEnabled()));
        XmlElement xmlSub = xmlCat.getSafeElement("packet-pool");
        this.setReceiverPacketAllocatorSize((int)Base.parseMemorySize(xmlSub.getSafeElement("size").getString(Integer.toString(this.getReceiverPacketAllocatorSize()))));
        this.setReceiverPriority(xmlCat.getSafeElement("priority").getInt(this.getReceiverPriority()));
    }

    private void configureOutgoingMessageHandler(XmlElement xml) {
        XmlElement xmlCat = xml.getSafeElement("outgoing-message-handler");
        SafeLinkedList listFilter = new SafeLinkedList();
        listFilter.addAll(this.parseFilterList(xmlCat));
        this.setFilterList(listFilter);
        XmlElement xmlSub = xmlCat.getSafeElement("message-pool");
        this.setMessageAllocatorSegments(xmlSub.getSafeElement("segments").getInt(this.getMessageAllocatorSegments()));
        this.setMessageAllocatorSegmentSize((int)Base.parseMemorySize(xmlSub.getSafeElement("segment-size").getString(Integer.toString(this.getMessageAllocatorSegmentSize()))));
        this.setMessageAllocatorMinBufferSize((int)Base.parseMemorySize(xmlSub.getSafeElement("min-buffer-size").getString(Integer.toString(this.getMessageAllocatorMinBufferSize()))));
        this.setMessageAllocatorGrowthFactor(xmlSub.getSafeElement("growth-factor").getInt(this.getMessageAllocatorGrowthFactor()));
    }

    private void configureAuthorizedHosts(XmlElement xml) {
        XmlElement xmlCat = xml.getSafeElement("authorized-hosts");
        XmlElement xmlVal = xmlCat.getElement("host-filter");
        if (xmlVal != null && !XmlHelper.isEmpty(xmlVal)) {
            this.setAuthorizedHostFilter((Filter)XmlHelper.createInstance(xmlVal, null, null, Filter.class));
            return;
        }
        InetAddressRangeFilter filter = new InetAddressRangeFilter();
        boolean fFilterAdded = false;
        Iterator iter = xmlCat.getElements("host-address");
        while (iter.hasNext()) {
            xmlVal = (XmlElement)iter.next();
            fFilterAdded = this.addAuthorizedHostsToFilter(filter, xmlVal.getString(), null);
        }
        iter = xmlCat.getElements("host-range");
        while (iter.hasNext()) {
            xmlVal = (XmlElement)iter.next();
            fFilterAdded = this.addAuthorizedHostsToFilter(filter, xmlVal.getSafeElement("from-address").getString(), xmlVal.getSafeElement("to-address").getString());
        }
        if (fFilterAdded) {
            this.setAuthorizedHostFilter(filter);
        }
    }

    private void configureServices(XmlElement xml) {
        LiteMap mapService = new LiteMap();
        LiteMap mapServiceFilter = new LiteMap();
        Iterator iter = xml.getSafeElement("services").getElements("service");
        while (iter.hasNext()) {
            XmlElement xmlService = (XmlElement)iter.next();
            String sType = xmlService.getSafeElement("service-type").getString();
            String sComponent = xmlService.getSafeElement("service-component").getString();
            mapService.put(sType, sComponent);
            mapServiceFilter.put(sType, this.parseFilterList(xmlService));
        }
        this.setServiceMap(mapService);
        this.setServiceFilterMap(mapServiceFilter);
    }

    private void configureFilters(XmlElement xml) {
        LiteMap mapFilter = new LiteMap();
        Iterator iter = xml.getSafeElement("filters").getElements("filter");
        while (iter.hasNext()) {
            XmlElement xmlFilter = (XmlElement)iter.next();
            this.addFilterToMap(xmlFilter, mapFilter);
        }
        this.setFilterMap(mapFilter);
    }

    private void configureSerializers(XmlElement xml) {
        LiteMap mapSerializer = new LiteMap();
        Iterator iter = xml.getSafeElement("serializers").getElements("serializer");
        while (iter.hasNext()) {
            XmlElement xmlSerializer = (XmlElement)iter.next();
            XmlElement xmlConf = (XmlElement)xmlSerializer.clone();
            String sName = xmlSerializer.getSafeAttribute("id").getString();
            xmlConf.getAttributeMap().remove("id");
            ConfigurableSerializerFactory factory = new ConfigurableSerializerFactory();
            factory.setConfig(xmlConf);
            mapSerializer.put(sName, factory);
        }
        this.setSerializerMap(mapSerializer);
    }

    private void configureSocketProviders(XmlElement xml) {
        this.getSocketProviderFactory().setConfig(xml.getSafeElement("socket-providers"));
    }

    private void configureClusterQuorumPolicy(XmlElement xml) {
        XmlElement xmlCat = xml.getSafeElement("cluster-quorum-policy");
        this.setClusterActionPolicy(new LegacyXmlConfigurableQuorumPolicy().createPolicy(xmlCat, Base.getContextClassLoader()));
    }

    private boolean addAuthorizedHostsToFilter(InetAddressRangeFilter filter, String sAddrFrom, String sAddrTo) {
        InetAddress addrTo;
        InetAddress addrFrom;
        if (sAddrFrom == null || sAddrFrom.length() == 0) {
            if (sAddrTo != null && sAddrTo.length() != 0) {
                this.ensureAuthorizedHostFilter();
                Base.azzertFailed("Both <from-ip> and <to-ip> elements must be specified");
            }
            return false;
        }
        try {
            addrFrom = InetAddress.getByName(sAddrFrom);
            addrTo = sAddrTo == null ? addrFrom : InetAddress.getByName(sAddrTo);
        }
        catch (UnknownHostException e) {
            Base.trace("Unresolvable authorized host will be ignored: " + e);
            return false;
        }
        filter.addRange(addrFrom, addrTo);
        return true;
    }

    private void addFilterToMap(XmlElement xmlFilter, Map<String, WrapperStreamFactory> mapFilter) {
        String sClass = xmlFilter.getSafeElement("filter-class").getString();
        String sName = xmlFilter.getSafeElement("filter-name").getString();
        if (sName.length() == 0) {
            sName = xmlFilter.getSafeAttribute("id").getString();
        }
        SimpleElement xmlConfig = new SimpleElement("filter");
        XmlElement xmlInstance = xmlConfig.ensureElement("instance");
        xmlInstance.ensureElement("class-name").setString(sClass);
        XmlElement xmlParams = xmlFilter.getElement("init-params");
        if (xmlParams != null) {
            xmlInstance.getElementList().add(xmlParams);
        }
        try {
            WrapperStreamFactory factory = (WrapperStreamFactory)XmlHelper.createInstance(xmlConfig, Base.getContextClassLoader(), null, WrapperStreamFactory.class);
            mapFilter.put(sName, factory);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Error instantiating Filter with name: " + sName);
        }
    }

    private AddressProvider createWkaAddressProvider(XmlElement xml) {
        AddressProvider provider = ConfigurableAddressProvider.createAddressProvider(xml, null);
        if (!(provider instanceof Set)) {
            CompositeAddressProvider providerComposite = new CompositeAddressProvider();
            providerComposite.addProvider(provider);
            provider = providerComposite;
        }
        return ((Set)((Object)provider)).isEmpty() ? null : provider;
    }

    private void ensureAuthorizedHostFilter() {
        Filter filter = this.getAuthorizedHostFilter();
        if (filter == null) {
            filter = new InetAddressRangeFilter();
            this.setAuthorizedHostFilter(filter);
        }
    }

    private List<String> parseFilterList(XmlElement xml) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator iter = xml.getSafeElement("use-filters").getElements("filter-name");
        while (iter.hasNext()) {
            String sName = ((XmlElement)iter.next()).getString();
            if (sName.length() <= 0) continue;
            list.add(sName);
        }
        return list.size() == 0 ? Collections.EMPTY_LIST : list;
    }

    private InetAddress resolveGroupAddress(String sAddr) {
        InetAddress addr = null;
        if (sAddr != null && sAddr.trim().length() > 0) {
            try {
                addr = InetAddress.getByName(sAddr);
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e, "Address=" + sAddr);
            }
        }
        return addr;
    }

    private InetAddress resolveGroupInterface(String sAddr) {
        InetAddress addr = null;
        if (sAddr != null && sAddr.trim().length() > 0) {
            try {
                addr = InetAddress.getByName(sAddr);
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e, "Interface=" + sAddr);
            }
        }
        return addr;
    }

    private ServiceFailurePolicy parseServiceFailurePolicy(XmlElement xml) {
        ServiceFailurePolicy policy = null;
        String sPolicy = xml.getString();
        if (sPolicy.length() != 0) {
            int nPolicyType;
            if (sPolicy.equals("exit-cluster")) {
                nPolicyType = 1;
            } else if (sPolicy.equals("exit-process")) {
                nPolicyType = 2;
            } else if (sPolicy.equals("logging")) {
                nPolicyType = 3;
            } else {
                throw new IllegalArgumentException("Unknown service-failure-policy \"" + sPolicy + "\"");
            }
            policy = new DefaultServiceFailurePolicy(nPolicyType);
        } else if (!xml.getElementList().isEmpty()) {
            try {
                policy = (ServiceFailurePolicy)XmlHelper.createInstance(xml, Base.getContextClassLoader(), null);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to instantiate custom ServiceFailurePolicy:", e);
            }
        }
        return policy;
    }

    private int translateEditionName(String sName) {
        Base.checkNotNull(sName, "Edition name");
        String[] names = new String[]{"DC", "RTC", "", "SE", "EE", "GE"};
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equalsIgnoreCase(sName)) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid edition name " + sName);
    }

    private int translateModeName(String sName) {
        Base.checkNotNull(sName, "Mode ");
        String[] names = new String[]{"eval", "dev", "prod"};
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equalsIgnoreCase(sName)) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid mode " + sName);
    }
}

