/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.journal;

import com.tangosol.io.journal.AbstractJournalRM;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.Daemon;
import com.tangosol.util.SingleWaiterMultiNotifier;
import com.tangosol.util.WrapperException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class FlashJournalRM
extends AbstractJournalRM {
    protected static final int SHIFT_FILE_ID = 54;
    protected static final long MASK_FILE_ID = 9205357638345293824L;
    protected static final int SHIFT_OFFSET = 26;
    protected static final int SHIFT_OFFSET_RAW = 22;
    protected static final long MASK_OFFSET = 18014398442373120L;
    protected static final int SHIFT_LENGTH = 0;
    protected static final long MASK_LENGTH = 0x3FFFFFFL;
    public static final int MAX_VALUE_SIZE = 0x3FFFFFF;
    public static final int MIN_BACKLOG_SIZE = 4096;
    public static final int MAX_BACKLOG_SIZE = 0x40000000;
    public static final int DFT_BACKLOG_SIZE = 0x1000000;
    public static final long MIN_FILE_SIZE = 0x100000L;
    public static final long MAX_FILE_SIZE = 0x100000000L;
    public static final long DFT_FILE_SIZE = 0x80000000L;
    public static final int MIN_BLOCK_SIZE = 4096;
    public static final int MAX_BLOCK_SIZE = 0x100000;
    public static final int DFT_BLOCK_SIZE = 262144;
    public static final int MAX_POOL_SIZE = 0x40000000;
    public static final int DFT_POOL_SIZE = 0x1000000;
    public static final double DFT_COLLECT_PCT = 0.25;
    public static final int DFT_PURGE_DELAY_MILLIS = 0x6DDD00;
    protected File m_dirTemp;
    protected boolean m_fLoggedDirectory;
    protected AtomicInteger m_cbBacklog = new AtomicInteger();
    protected int m_cbMaxBacklog = 0x1000000;
    protected int m_cbBlock = 262144;
    protected int m_cMaxPooledBlocks = 0x1000000 / this.m_cbBlock;
    protected long m_cPurgeDelayMillis = 0x6DDD00L;
    protected ConcurrentMap<Long, Binary> m_mapLocators = new ConcurrentHashMap<Long, Binary>();
    protected BufferPool m_pool;
    protected PreparerDaemon m_daemonPreparer;
    protected WriterDaemon m_daemonWriter;

    public FlashJournalRM(Cluster cluster) {
        super(cluster);
    }

    @Override
    public synchronized void configure(XmlElement xml) {
        super.configure(xml);
    }

    @Override
    public synchronized void stop() {
        super.stop();
        if (this.getState() == 4) {
            this.m_daemonPreparer = null;
            this.m_daemonWriter = null;
            this.m_mapLocators = null;
            this.m_pool = null;
        }
    }

    @Override
    public long getMaxTotalRam() {
        return -1L;
    }

    @Override
    public boolean isNioRam() {
        return false;
    }

    @Override
    public int getMaxBacklogSize() {
        return this.m_cbMaxBacklog;
    }

    @Override
    public int getBacklogSize() {
        return this.m_cbBacklog.get();
    }

    @Override
    public int getBacklogCount() {
        ConcurrentMap<Long, Binary> map = this.m_mapLocators;
        return map == null ? 0 : this.m_mapLocators.size();
    }

    @Override
    public int getBufferSize() {
        return this.m_cbBlock;
    }

    @Override
    public long getMaxPoolSize() {
        return this.m_cMaxPooledBlocks * this.m_cbBlock;
    }

    @Override
    public int getPoolSize() {
        BufferPool pool = this.m_pool;
        return pool == null ? 0 : pool.getSize() * this.m_cbBlock;
    }

    @Override
    public void setMaxValueSize(int cb) {
        if (cb == 0) {
            cb = 0x3FFFFFF;
        } else {
            if (cb < 0 || cb > 0x3FFFFFF) {
                throw new IllegalArgumentException("Illegal maximum value size of " + cb + "; maximum allowed size is " + 0x3FFFFFF);
            }
            if ((long)cb > this.getMaxFileSize() / 2L) {
                throw new IllegalArgumentException("Illegal maximum value size of " + cb + "; maximum allowed size is 1/2 of the maximum file size of " + this.getMaxFileSize());
            }
        }
        this.m_cbMaxValue = cb;
    }

    public void setMaxBacklogSize(int cb) {
        if (cb < 4096 || cb > 0x40000000) {
            throw new IllegalArgumentException("Illegal maximum backlog size of " + cb + "; allowed range is " + 4096 + " to " + 0x40000000);
        }
        this.m_cbMaxBacklog = cb;
    }

    public void setBufferSize(int cb) {
        this.checkInitializing();
        int cbOld = this.m_cbBlock;
        if (cb == cbOld) {
            return;
        }
        if (cb < 4096 || cb > 0x100000) {
            throw new IllegalArgumentException("Illegal BufferSize of " + cb + "; allowed range is " + 4096 + " to " + 0x100000);
        }
        if ((cb & cb - 1) != 0) {
            throw new IllegalArgumentException("BufferSize of " + cb + " is not a power of two");
        }
        long cbMaxFile = this.m_cbMaxFile;
        if (cbMaxFile % (long)cb != 0L) {
            this.m_cbMaxFile = Math.max(cbMaxFile / (long)cb, 1L) * (long)cb;
        }
        this.m_cMaxPooledBlocks = Math.max(1, this.m_cMaxPooledBlocks * cbOld / cb);
        this.m_cbBlock = cb;
    }

    public void setMaxPoolSize(int cb) {
        this.checkInitializing();
        if (cb < 0 || cb > 0x40000000) {
            throw new IllegalArgumentException("Illegal pool size of " + cb + "; maximum pool size is " + 0x40000000);
        }
        this.m_cMaxPooledBlocks = Math.max(1, cb / this.m_cbBlock);
    }

    public File getDirectory() {
        return this.m_dirTemp;
    }

    public void setDirectory(File dirTemp) {
        this.checkInitializing();
        if (!(dirTemp == null || dirTemp.exists() && dirTemp.isDirectory())) {
            throw new IllegalArgumentException("Invalid directory: " + dirTemp.getPath());
        }
        this.m_dirTemp = dirTemp;
    }

    @Override
    public void setMaxFileSize(long cb) {
        long cbLimitValue;
        int cbMaxValue;
        this.checkInitializing();
        if (cb < 0x100000L || cb > 0x100000000L) {
            throw new IllegalArgumentException("Illegal maximum file size of " + cb + "; allowed range is " + 0x100000L + " to " + 0x100000000L);
        }
        int cbBlock = this.m_cbBlock;
        if (cb % (long)cbBlock != 0L) {
            cb = Math.max(1L, cb / (long)cbBlock) * (long)cbBlock;
        }
        if ((long)(cbMaxValue = this.m_cbMaxValue) > (cbLimitValue = cb / 2L)) {
            this.m_cbMaxValue = (int)cbLimitValue;
        }
        this.m_cbMaxFile = cb;
    }

    public long getPurgeDelayMillis() {
        return this.m_cPurgeDelayMillis;
    }

    public void setPurgeDelayMillis(long cPurgeDelayMillis) {
        this.checkInitializing();
        this.m_cPurgeDelayMillis = cPurgeDelayMillis;
    }

    @Override
    protected void applyConfig(String sName, XmlElement xmlConfig) {
        if (sName.equals("maximum-value-size")) {
            long cbMaxValue = Base.parseMemorySize(xmlConfig.getString("0"));
            if (cbMaxValue > 0L) {
                long cbMaxFile;
                if (cbMaxValue > 0x3FFFFFFL) {
                    CacheFactory.log("Journal Resource Manager: Maximum value size is 1GB (overriding setting of " + cbMaxValue + ")", 2);
                    cbMaxValue = 0x3FFFFFFL;
                }
                if (cbMaxValue > (cbMaxFile = this.m_cbMaxFile) / 2L) {
                    CacheFactory.log("Journal Resource Manager: Maximum value size (" + cbMaxValue + ") cannot be larger than 1/2 maximum file size (" + cbMaxFile + ")", 2);
                    cbMaxValue = cbMaxFile / 2L;
                }
                this.m_cbMaxValue = (int)cbMaxValue;
            }
        } else if (sName.equals("directory")) {
            File dirTemp = null;
            String sDirTemp = xmlConfig.getString();
            if (sDirTemp.length() > 0) {
                try {
                    File dirTest = new File(sDirTemp);
                    if (dirTest.exists() && dirTest.isDirectory()) {
                        dirTemp = dirTest;
                    } else {
                        CacheFactory.log("Journal Resource Manager: Invalid temporary directory: \"" + sDirTemp + "\"", 2);
                    }
                }
                catch (RuntimeException e) {
                    CacheFactory.log("Journal Resource Manager: Unable to validate directory: \"" + sDirTemp + "\"", 2);
                    CacheFactory.log(e.toString(), 2);
                }
            }
            this.m_dirTemp = dirTemp;
        } else if (sName.equals("async-limit")) {
            long cbMaxBacklog = Base.parseMemorySize(xmlConfig.getString("0"));
            if (cbMaxBacklog > 0L) {
                if (cbMaxBacklog < 4096L) {
                    CacheFactory.log("Journal Resource Manager: Minimum backlog size is 4KB (overriding setting of " + cbMaxBacklog + ")", 2);
                    cbMaxBacklog = 4096L;
                } else if (cbMaxBacklog > 0x40000000L) {
                    CacheFactory.log("Journal Resource Manager: Maximum backlog size is 1GB (overriding setting of " + cbMaxBacklog + ")", 2);
                    cbMaxBacklog = 0x40000000L;
                }
                this.m_cbMaxBacklog = (int)cbMaxBacklog;
            }
        } else if (sName.equals("block-size")) {
            long cbBlock = Base.parseMemorySize(xmlConfig.getString("0"));
            if (cbBlock > 0L) {
                if (cbBlock < 4096L) {
                    CacheFactory.log("Journal Resource Manager: Minimum block size is 4KB (overriding setting of " + cbBlock + ")", 2);
                    cbBlock = 4096L;
                } else if (cbBlock > 0x100000L) {
                    CacheFactory.log("Journal Resource Manager: Maximum block size is 1MB (overriding setting of " + cbBlock + ")", 2);
                    cbBlock = 0x100000L;
                } else if ((cbBlock & cbBlock - 1L) != 0L) {
                    long cbBlockOld = cbBlock;
                    cbBlock |= cbBlock >> 1;
                    cbBlock |= cbBlock >> 2;
                    cbBlock |= cbBlock >> 4;
                    cbBlock |= cbBlock >> 8;
                    cbBlock |= cbBlock >> 16;
                    CacheFactory.log("Journal Resource Manager: Block size must be a power-of-two (overriding setting of " + cbBlockOld + " with " + ++cbBlock + ")", 2);
                }
                this.m_cbBlock = (int)cbBlock;
            }
        } else if (sName.equals("maximum-file-size")) {
            long cbMaxFile = Base.parseMemorySize(xmlConfig.getString("0"));
            if (cbMaxFile > 0L) {
                int cbBlock;
                if (cbMaxFile < 0x100000L) {
                    CacheFactory.log("Journal Resource Manager: Minimum file size is 1048576", 2);
                    cbMaxFile = 0x100000L;
                }
                if (cbMaxFile > 0x100000000L) {
                    CacheFactory.log("Journal Resource Manager: Maximum file size is 4294967296", 2);
                    cbMaxFile = 0x100000000L;
                }
                if (cbMaxFile % (long)(cbBlock = this.m_cbBlock) != 0L) {
                    CacheFactory.log("Journal Resource Manager: Maximum file size (" + cbMaxFile + ") must be a multiple of the block size (" + cbBlock + ")", 2);
                    cbMaxFile = Math.max(cbMaxFile / (long)cbBlock, 1L) * (long)cbBlock;
                }
                this.m_cbMaxFile = cbMaxFile;
                this.applyConfig("maximum-value-size", new SimpleElement("maximum-value-size", new Long(this.m_cbMaxValue)));
            }
        } else if (sName.equals("maximum-pool-size")) {
            long cbPool = Base.parseMemorySize(xmlConfig.getString("0"));
            if (cbPool > 0L) {
                if (cbPool > 0x40000000L) {
                    CacheFactory.log("Journal Resource Manager: Maximum pool size (" + cbPool + ") cannot be larger than 1GB", 2);
                    cbPool = 0x40000000L;
                }
                this.m_cMaxPooledBlocks = Math.max(1, (int)cbPool / this.m_cbBlock);
            }
        } else if (sName.equals("tmp-purge-delay")) {
            long cPurgeDelay = Base.parseTime(xmlConfig.getString("0"));
            this.setPurgeDelayMillis(cPurgeDelay);
        } else {
            super.applyConfig(sName, xmlConfig);
        }
    }

    @Override
    protected void startThreads() {
        this.purgeOldTempFiles();
        this.m_pool = this.instantiateBufferPool();
        this.m_daemonPreparer = this.instantiatePreparerDaemon();
        this.m_daemonWriter = this.instantiateWriterDaemon();
        this.m_daemonPreparer.start();
        this.m_daemonWriter.start();
        super.startThreads();
    }

    protected void purgeOldTempFiles() {
        FilenameFilter filter = new FilenameFilter(){
            final long ldtCutoff;
            {
                this.ldtCutoff = System.currentTimeMillis() - FlashJournalRM.this.getPurgeDelayMillis();
            }

            @Override
            public boolean accept(File dir, String sName) {
                return sName.startsWith("coh") && sName.endsWith(".tmp") && (FlashJournalRM.this.getPurgeDelayMillis() <= 0L || new File(dir, sName).lastModified() <= this.ldtCutoff);
            }
        };
        File dir = this.getDirectory();
        if (dir == null && !(dir = new File(System.getProperty("java.io.tmpdir"))).exists()) {
            throw new IllegalStateException("A temporary directory (java.io.tmpdir) must exist, and must be readable and writable from this process.");
        }
        for (File file : dir.listFiles(filter)) {
            CacheFactory.log("Deleting file " + file.getAbsolutePath() + " left over from previous run.", 6);
            file.delete();
        }
    }

    @Override
    protected void stopThreads() {
        super.stopThreads();
        try {
            if (this.m_daemonPreparer.isRunning() && !this.m_daemonPreparer.isStopping()) {
                this.m_daemonPreparer.shutdown(10000L);
            }
        }
        catch (Throwable t) {
            CacheFactory.log("Journal Resource Manager: Exception while stopping the 'preparer' thread: " + t, 6);
        }
        try {
            if (this.m_daemonWriter.isRunning() && !this.m_daemonWriter.isStopping()) {
                this.m_daemonWriter.shutdown(10000L);
            }
        }
        catch (Throwable t) {
            CacheFactory.log("Journal Resource Manager: Exception while stopping the write-behind thread: " + t, 6);
        }
    }

    @Override
    protected String getDescription() {
        return super.getDescription() + ", Directory=" + this.getDirectory() + ", Backlog=" + this.getBacklogCount() + ", BacklogSize=" + this.getBacklogSize() + ", MaxBacklogSize=" + this.getMaxBacklogSize() + ", BufferSize=" + this.getBufferSize() + ", PoolSize=" + this.getPoolSize() + ", MaxPoolSize=" + this.getMaxPoolSize() + ", Preparer=" + this.m_daemonPreparer + ", Writer=" + this.m_daemonWriter;
    }

    @Override
    protected long getDefaultMaxFileSize() {
        return 0x80000000L;
    }

    @Override
    protected int getDefaultMaxValueSize() {
        return 0x3FFFFFF;
    }

    @Override
    protected double getDefaultCollectorLoadFactor() {
        return 0.25;
    }

    @Override
    protected JournalFile getJournalFile(int nFileId) {
        return (JournalFile)super.getJournalFile(nFileId);
    }

    @Override
    protected JournalFile ensureCurrentJournalFile() {
        return (JournalFile)super.ensureCurrentJournalFile();
    }

    @Override
    protected JournalFile instantiateJournalFile(int nFile) {
        return new JournalFile(nFile);
    }

    protected BufferPool instantiateBufferPool() {
        return new BufferPool(this.m_cbBlock, this.m_cMaxPooledBlocks);
    }

    protected BufferPool getBufferPool() {
        return this.m_pool;
    }

    protected PreparerDaemon instantiatePreparerDaemon() {
        return new PreparerDaemon();
    }

    protected PreparerDaemon getPreparerDaemon() {
        return this.m_daemonPreparer;
    }

    protected WriterDaemon instantiateWriterDaemon() {
        return new WriterDaemon();
    }

    protected WriterDaemon getWriterDaemon() {
        return this.m_daemonWriter;
    }

    @Override
    protected long getEvacuationMask() {
        return -18014398509481984L;
    }

    @Override
    protected int extractFileId(long lTicket) {
        assert (!this.isCompact(lTicket));
        return (int)((lTicket & 0x7FC0000000000000L) >>> 54);
    }

    @Override
    protected long extractOffset(long lTicket) {
        assert (!this.isCompact(lTicket));
        return (lTicket & 0x3FFFFFFC000000L) >>> 22;
    }

    @Override
    protected int extractLength(long lTicket) {
        return (int)(this.isCompact(lTicket) ? (lTicket & 0x700000000000000L) >>> 56 : (lTicket & 0x3FFFFFFL) >>> 0);
    }

    @Override
    protected long encodeTicket(int nFile, long of, int cb) {
        assert (nFile >= 0);
        assert (nFile <= 511);
        assert (of >= 0L);
        assert (of <= 0xFFFFFFFFL);
        assert ((of & 0xFL) == 0L);
        assert (cb >= 0);
        assert (cb <= 0x3FFFFFF);
        long lTicket = (long)nFile << 54 | of << 22 | (long)cb << 0;
        assert (this.extractFileId(lTicket) == nFile);
        assert (this.extractOffset(lTicket) == of);
        assert (this.extractLength(lTicket) == cb);
        return lTicket;
    }

    protected class WriterDaemon
    extends Daemon {
        protected BlockingQueue<Runnable> m_queue;
        protected long m_cSingleBlockWrites;
        protected long m_cMillisSingleBlockWrites;
        protected long m_cMultiBlockWrites;
        protected long m_cMillisMultiBlockWrites;
        protected boolean m_fPreferSingleBlockWrites;

        public WriterDaemon() {
            super("Journal-Writer");
            this.m_queue = new LinkedBlockingQueue<Runnable>();
        }

        @Override
        public synchronized void stop() {
            super.stop();
            this.getThread().interrupt();
        }

        @Override
        public void run() {
            boolean fDecided = false;
            BlockingQueue<Runnable> queue = this.m_queue;
            while (!Thread.interrupted()) {
                try {
                    Runnable task = queue.take();
                    task.run();
                    if (fDecided || this.m_cMultiBlockWrites <= 1023L) continue;
                    if (this.m_cSingleBlockWrites > 1023L) {
                        double dflAvgSingle = (double)this.m_cMillisSingleBlockWrites / (double)this.m_cSingleBlockWrites;
                        double dflAvgMulti = (double)this.m_cMillisMultiBlockWrites / (double)this.m_cMultiBlockWrites;
                        this.m_fPreferSingleBlockWrites = 93.75 * dflAvgSingle < dflAvgMulti;
                        fDecided = true;
                        continue;
                    }
                    this.m_fPreferSingleBlockWrites = true;
                }
                catch (InterruptedException eInterrupt) {
                    CacheFactory.log("WriterDaemon interrupted, shutting down.", 6);
                    Thread.currentThread().interrupt();
                }
                catch (Throwable e) {
                    CacheFactory.log("Journal Resource Manager: An error has occurred writing the journal:", 1);
                    CacheFactory.log(e.toString(), 1);
                    CacheFactory.log("The Journal Resource Manager will stop.", 1);
                    this.changeState(3, this.getWorker());
                    Thread.currentThread().interrupt();
                    FlashJournalRM.this.stop();
                }
            }
        }

        @Override
        protected String getDescription() {
            return super.getDescription() + ", BlockWriteCount=" + this.getBlockWriteCount() + ", SingleBlockWriteCount=" + this.getSingleBlockWriteCount() + ", MultiBlockWriteCount=" + this.getMultiBlockWriteCount() + ", AvgBlockWriteMillis=" + this.getAvgBlockWriteMillis() + ", AvgSingleBlockWriteMillis=" + this.getAvgSingleBlockWriteMillis() + ", AvgMultiBlockWriteMillis=" + this.getAvgMultiBlockWriteMillis() + ", SingleBlockWritePreferred=" + this.isSingleBlockWritePreferred();
        }

        public boolean isSingleBlockWritePreferred() {
            return this.m_fPreferSingleBlockWrites;
        }

        public long getBlockWriteCount() {
            return this.m_cSingleBlockWrites + this.m_cMultiBlockWrites;
        }

        public long getSingleBlockWriteCount() {
            return this.m_cSingleBlockWrites;
        }

        public long getMultiBlockWriteCount() {
            return this.m_cMultiBlockWrites;
        }

        public int getAvgBlockWriteMillis() {
            long cBlocks = this.m_cSingleBlockWrites + this.m_cMultiBlockWrites;
            if (cBlocks == 0L) {
                return 0;
            }
            long cMillis = this.m_cMillisSingleBlockWrites + this.m_cMillisMultiBlockWrites;
            return (int)(cMillis / cBlocks);
        }

        public int getAvgSingleBlockWriteMillis() {
            long cBlocks = this.m_cSingleBlockWrites;
            return cBlocks == 0L ? 0 : (int)(this.m_cMillisSingleBlockWrites / cBlocks);
        }

        public int getAvgMultiBlockWriteMillis() {
            long cBlocks = this.m_cMultiBlockWrites;
            return cBlocks == 0L ? 0 : (int)(this.m_cMillisMultiBlockWrites / cBlocks);
        }

        public void enqueueBuffer(JournalFile jrnlfile, Buffer buf, int cbBuffer) {
            try {
                this.m_queue.put(new PendingWriteTask(jrnlfile, buf, cbBuffer));
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }

        public void notifyFileFull(JournalFile jrnlfile) {
            try {
                this.m_queue.put(new FileFullTask(jrnlfile));
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }

        protected class FileFullTask
        implements Runnable {
            private JournalFile m_jrnlfile;

            public FileFullTask(JournalFile jrnlfile) {
                this.m_jrnlfile = jrnlfile;
            }

            @Override
            public void run() {
                this.m_jrnlfile.notifyWriteBehindCompleted();
            }
        }

        protected class PendingWriteTask
        implements Runnable {
            private JournalFile m_jrnlfile;
            private Buffer m_buf;
            private int m_cbBuffer;

            public PendingWriteTask(JournalFile jrnlfile, Buffer buf, int cbBuffer) {
                this.m_jrnlfile = jrnlfile;
                this.m_buf = buf;
                this.m_cbBuffer = cbBuffer;
            }

            @Override
            public void run() {
                JournalFile jrnlfile = this.m_jrnlfile;
                Buffer buf = this.m_buf;
                int cb = this.m_cbBuffer;
                ByteBuffer niobuf = buf.getByteBuffer();
                BufferPool pool = FlashJournalRM.this.getBufferPool();
                long ldtStart = System.currentTimeMillis();
                niobuf.limit(cb).position(0);
                WriterDaemon daemon = WriterDaemon.this;
                BlockingQueue<Runnable> queue = daemon.m_queue;
                if (!daemon.isSingleBlockWritePreferred() && queue.peek() instanceof PendingWriteTask) {
                    ArrayList<ByteBuffer> listNiobuf = new ArrayList<ByteBuffer>();
                    ArrayList<Buffer> listBuffer = new ArrayList<Buffer>();
                    listNiobuf.add(niobuf);
                    listBuffer.add(buf);
                    while (queue.peek() instanceof PendingWriteTask) {
                        PendingWriteTask task;
                        try {
                            task = (PendingWriteTask)queue.take();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                        buf = task.m_buf;
                        niobuf = buf.getByteBuffer();
                        int cbTask = task.m_cbBuffer;
                        cb += cbTask;
                        niobuf.limit(cbTask).position(0);
                        listNiobuf.add(niobuf);
                        listBuffer.add(buf);
                    }
                    int cBlocks = listNiobuf.size();
                    ByteBuffer[] aniobuf = listNiobuf.toArray(new ByteBuffer[cBlocks]);
                    try {
                        FileChannel channel = jrnlfile.getWriteChannel();
                        int cbWritten = 0;
                        do {
                            cbWritten = (int)((long)cbWritten + channel.write(aniobuf));
                            channel.force(false);
                        } while (cbWritten < cb);
                    }
                    catch (ClosedByInterruptException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (ClosedChannelException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (IOException e) {
                        if (Base.equals(e.getMessage(), "Bad address")) {
                            Base.err("Journal Resource Manager: Detected Java Bug ID 4641545, \"Bad Address\" during NIO scatter/gather operation; performing file integrity check.");
                            try {
                                File file = jrnlfile.getFile();
                                long cbBefore = jrnlfile.getBytesWritten();
                                FileChannel channel = jrnlfile.getWriteChannel();
                                channel.force(true);
                                long cbActual = file.length();
                                if (cbActual > cbBefore) {
                                    FileChannel channelRead = new RandomAccessFile(jrnlfile.getFile(), "r").getChannel();
                                    long ofCmp = cbBefore;
                                    int cbCmp = (int)(cbActual - cbBefore);
                                    Buffer bufCmp = pool.allocate(null);
                                    byte[] abCmp = bufCmp.getByteArray();
                                    ByteBuffer niobufCmp = bufCmp.getByteBuffer();
                                    for (int i = 0; i < cBlocks; ++i) {
                                        niobuf = aniobuf[i];
                                        if (cbCmp > 0) {
                                            int cbBlock = Math.min(cbCmp, niobuf.limit());
                                            niobufCmp.position(0).limit(cbBlock);
                                            for (int cbRead = 0; cbRead < cbBlock; cbRead += channelRead.read(niobufCmp, ofCmp + (long)cbRead)) {
                                            }
                                            if (!Binary.equals(abCmp, 0, ((Buffer)listBuffer.get(i)).getByteArray(), 0, cbBlock)) {
                                                throw new IllegalStateException("Unrecoverable NIO exception; data corruption detected.", e);
                                            }
                                            niobuf.position(cbBlock);
                                            ofCmp += (long)cbBlock;
                                            cbCmp -= cbBlock;
                                            continue;
                                        }
                                        niobuf.position(0);
                                    }
                                    pool.release(bufCmp);
                                    channelRead.close();
                                } else {
                                    for (int i = 0; i < cBlocks; ++i) {
                                        aniobuf[i].position(0);
                                    }
                                }
                                for (int i = 0; i < cBlocks; ++i) {
                                    niobuf = aniobuf[i];
                                    int cbRemain = niobuf.remaining();
                                    for (int cbWritten = 0; cbWritten < cbRemain; cbWritten += channel.write(niobuf)) {
                                        channel.force(false);
                                    }
                                }
                                Base.err("Journal Resource Manager: File recovered; disabling NIO scatter/gather capability.");
                                WriterDaemon.this.m_fPreferSingleBlockWrites = true;
                            }
                            catch (IOException eAgain) {
                                throw new IllegalStateException(eAgain);
                            }
                        }
                        throw new IllegalStateException(e);
                    }
                    for (Buffer bufRelease : listBuffer) {
                        pool.release(bufRelease);
                    }
                    WriterDaemon.this.m_cMultiBlockWrites += (long)cBlocks;
                    long cMillis = System.currentTimeMillis() - ldtStart;
                    if (cMillis > 0L) {
                        WriterDaemon.this.m_cMillisMultiBlockWrites += cMillis;
                    }
                } else {
                    try {
                        FileChannel channel = jrnlfile.getWriteChannel();
                        int cbWritten = 0;
                        do {
                            channel.force(false);
                        } while ((cbWritten += channel.write(niobuf)) < cb);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                    pool.release(buf);
                    ++WriterDaemon.this.m_cSingleBlockWrites;
                    long cMillis = System.currentTimeMillis() - ldtStart;
                    if (cMillis > 0L) {
                        WriterDaemon.this.m_cMillisSingleBlockWrites += cMillis;
                    }
                }
                jrnlfile.notifyWriteOccurred(cb);
            }
        }
    }

    protected class PreparerDaemon
    extends Daemon {
        private final SingleWaiterMultiNotifier m_notifier;

        public PreparerDaemon() {
            super("Journal-Preparer");
            this.m_notifier = new SingleWaiterMultiNotifier();
        }

        @Override
        protected Daemon.DaemonWorker instantiateWorker() {
            return new Daemon.DaemonWorker(){

                @Override
                public void run() {
                    block2: {
                        try {
                            super.run();
                        }
                        catch (Throwable e) {
                            Base.err("Journal Resource Manager: An error has occurred managing the journal:");
                            Base.err(e);
                            Base.err("The Journal Resource Manager will stop.");
                            if (!FlashJournalRM.this.isRunning()) break block2;
                            FlashJournalRM.this.stop();
                        }
                    }
                }
            };
        }

        @Override
        public void run() {
            SingleWaiterMultiNotifier notifier = this.m_notifier;
            FlashJournalRM mgr = FlashJournalRM.this;
            ConcurrentMap<Long, Binary> mapLocators = mgr.m_mapLocators;
            WriterDaemon daemonWriter = mgr.getWriterDaemon();
            BufferPool pool = mgr.getBufferPool();
            JournalFile jrnlfile = mgr.ensureCurrentJournalFile();
            int nFileId = jrnlfile.getFileId();
            long ofNext = 0L;
            Buffer buffer = jrnlfile.allocateBuffer();
            int ofBuffer = 0;
            int cbBuffer = mgr.m_cbBlock;
            assert (cbBuffer == buffer.getByteArray().length);
            while (!this.isStopping()) {
                while (true) {
                    long lLocator;
                    Binary bin;
                    if ((bin = (Binary)mapLocators.get(new Long(lLocator = FlashJournalRM.this.encodeTicket(nFileId, ofNext, 0)))) == null) {
                        JournalFile jrnlfileNext;
                        if (jrnlfile.isAppending() || ofNext != jrnlfile.getOffset() || (jrnlfileNext = jrnlfile.getNextJournalFile()) == null) break;
                        if (ofBuffer == 0) {
                            pool.release(buffer);
                        } else {
                            daemonWriter.enqueueBuffer(jrnlfile, buffer, ofBuffer);
                        }
                        daemonWriter.notifyFileFull(jrnlfile);
                        jrnlfile = jrnlfileNext;
                        nFileId = jrnlfile.getFileId();
                        ofNext = 0L;
                        buffer = jrnlfile.allocateBuffer();
                        ofBuffer = 0;
                        continue;
                    }
                    int ofValue = 0;
                    int cbValue = bin.length();
                    int cbEntry = cbValue + 15 & 0xFFFFFFF0;
                    int cbSpace = cbBuffer - ofBuffer;
                    int cbRemain = cbValue;
                    if (cbSpace >= cbRemain) {
                        buffer.render(bin, ofBuffer);
                        ofBuffer += cbEntry;
                    } else {
                        while (cbRemain > 0) {
                            int cbRender = Math.min(cbRemain, cbSpace);
                            if (cbRender > 0) {
                                buffer.render(bin.toBinary(ofValue, cbRender), ofBuffer);
                                int cbChunk = cbRender + 15 & 0xFFFFFFF0;
                                ofBuffer += cbChunk;
                                cbSpace -= cbChunk;
                                ofValue += cbRender;
                                cbRemain -= cbRender;
                            }
                            if (cbSpace != 0) continue;
                            daemonWriter.enqueueBuffer(jrnlfile, buffer, cbBuffer);
                            buffer = jrnlfile.allocateBuffer();
                            ofBuffer = 0;
                            cbSpace = cbBuffer;
                        }
                    }
                    ofNext += (long)cbEntry;
                }
                try {
                    notifier.await();
                }
                catch (InterruptedException eInterrupt) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        @Override
        protected synchronized void changeState(int nState, Daemon.DaemonWorker worker) {
            super.changeState(nState, worker);
            this.m_notifier.signal();
        }

        @Override
        public synchronized void stop() {
            super.stop();
            this.getThread().interrupt();
        }

        public void notifyItemQueued(JournalFile jrnlfile, long lTicket) {
            assert (jrnlfile != null);
            assert (lTicket != 0L);
            assert (FlashJournalRM.this.extractFileId(lTicket) == jrnlfile.getFileId());
            this.notifyJournalFileChanged(jrnlfile);
        }

        public void notifyJournalFileFull(JournalFile jrnlfile) {
            assert (jrnlfile != null);
            this.notifyJournalFileChanged(jrnlfile);
        }

        private void notifyJournalFileChanged(JournalFile jrnlfile) {
            assert (jrnlfile != null);
            this.m_notifier.signal();
        }
    }

    protected static class BufferPool {
        private final int m_cbBuffer;
        private final int m_cMaxBuffers;
        private final AtomicInteger m_cBuffers = new AtomicInteger();
        private final AtomicReference<Buffer> m_bufferHead = new AtomicReference();

        public BufferPool(int cbBuffer, int cMaxBuffers) {
            this.m_cbBuffer = cbBuffer;
            this.m_cMaxBuffers = cMaxBuffers;
        }

        public Buffer allocate(byte[] abOv) {
            AtomicReference<Buffer> refHead = this.m_bufferHead;
            Buffer buf = refHead.get();
            while (buf != null) {
                if (refHead.compareAndSet(buf, buf.getNext())) {
                    this.m_cBuffers.decrementAndGet();
                    buf.setNext(null);
                    break;
                }
                buf = refHead.get();
            }
            if (buf == null) {
                buf = new Buffer(this.m_cbBuffer);
            }
            buf.setOverlay(abOv);
            return buf;
        }

        public void release(Buffer buf) {
            assert (buf != null);
            buf.setOverlay(null);
            AtomicInteger cBuffers = this.m_cBuffers;
            AtomicReference<Buffer> refHead = this.m_bufferHead;
            while (cBuffers.get() < this.m_cMaxBuffers) {
                Buffer bufHead = refHead.get();
                buf.setNext(bufHead);
                if (!refHead.compareAndSet(bufHead, buf)) continue;
                cBuffers.incrementAndGet();
                return;
            }
        }

        public int getSize() {
            return this.m_cBuffers.get();
        }

        public String toString() {
            return "BufferPool{CurrentPoolSize=" + this.m_cBuffers.get() + ", MaxPoolSize=" + this.m_cMaxBuffers + ", MaxBufferSize=" + this.m_cbBuffer + "}";
        }
    }

    protected static class Buffer {
        private final byte[] m_ab;
        private final ByteBuffer m_buf;
        private byte[] m_abOv;
        private volatile Buffer m_bufNext;

        public Buffer(int cbBuffer) {
            byte[] ab = new byte[cbBuffer];
            this.m_ab = ab;
            this.m_buf = ByteBuffer.wrap(ab);
        }

        public byte[] getByteArray() {
            return this.m_ab;
        }

        public ByteBuffer getByteBuffer() {
            return this.m_buf;
        }

        public void setOverlay(byte[] abOv) {
            assert (abOv == null || abOv.length == 256);
            this.m_abOv = abOv;
        }

        public void render(Binary bin, int of) {
            int ofRnd;
            int ofCur;
            assert (bin != null);
            assert (of >= 0);
            assert (of + bin.length() <= this.m_ab.length);
            byte[] ab = this.m_ab;
            int cb = bin.length();
            bin.copyBytes(0, cb, ab, of);
            byte[] abOv = this.m_abOv;
            int ofEnd = ofCur + cb;
            for (ofCur = of; ofCur < ofEnd; ++ofCur) {
                ab[ofCur] = (byte)(ab[ofCur] ^ abOv[ofCur & 0xFF]);
            }
            Random rnd = Base.getRandom();
            int ofEnd2 = ofRnd + 15 & 0xFFFFFFF0;
            for (ofRnd = of + cb; ofRnd < ofEnd2; ++ofRnd) {
                ab[ofRnd] = (byte)rnd.nextInt();
            }
        }

        public Buffer getNext() {
            return this.m_bufNext;
        }

        public void setNext(Buffer buf) {
            this.m_bufNext = buf;
        }

        public String toString() {
            byte[] ab = this.m_ab;
            return "Buffer{Size=" + (ab == null ? "n/a" : Integer.valueOf(ab.length)) + ", hasNext=" + (this.m_bufNext != null) + "}";
        }
    }

    protected class JournalFile
    extends AbstractJournalRM.JournalFile {
        protected final File m_file;
        protected FileChannel m_channelRead;
        protected final FileChannel m_channelWrite;
        protected final byte[] m_abOv;
        protected long m_ofNextFlush;

        public JournalFile(int nFile) {
            File file;
            super(nFile);
            this.m_abOv = new byte[256];
            try {
                this.m_file = file = File.createTempFile("coh", ".tmp", FlashJournalRM.this.getDirectory());
                file.deleteOnExit();
                FileOutputStream stream = new FileOutputStream(file, true);
                this.m_channelWrite = stream.getChannel();
                RandomAccessFile iofile = new RandomAccessFile(file, "r");
                this.m_channelRead = iofile.getChannel();
            }
            catch (IOException e) {
                try {
                    this.dispose();
                }
                catch (Exception eIgnore) {
                    // empty catch block
                }
                throw new IllegalStateException(e);
            }
            if (!FlashJournalRM.this.m_fLoggedDirectory) {
                CacheFactory.log("Journal Resource Manager: The Flash Journal is using " + file.getParent() + " as the temporary directory.", 3);
                FlashJournalRM.this.m_fLoggedDirectory = true;
            }
            byte[] abRnd = this.m_abOv;
            Base.getRandom().nextBytes(abRnd);
        }

        @Override
        public long enqueue(Binary bin) {
            int cbValue = bin.length();
            assert (cbValue > 0);
            if (cbValue > FlashJournalRM.this.m_cbMaxValue) {
                throw new IllegalArgumentException("Maximum value size is " + FlashJournalRM.this.m_cbMaxValue);
            }
            int cbEntry = cbValue + 15 & 0xFFFFFFF0;
            AtomicLong lStateOffset = this.m_lStateOffset;
            while (true) {
                long ofBefore;
                long lState;
                if ((lState = (ofBefore = lStateOffset.get()) & 0xF000000000000000L) == 0L) {
                    long ofAfter = ofBefore + (long)cbEntry;
                    if (ofAfter > FlashJournalRM.this.m_cbMaxFile) {
                        if (!lStateOffset.compareAndSet(ofBefore, 0x2000000000000000L | ofBefore)) continue;
                        return 0L;
                    }
                    if (!lStateOffset.compareAndSet(ofBefore, ofAfter)) continue;
                    int nFileId = this.m_nFile;
                    long lLocator = FlashJournalRM.this.encodeTicket(nFileId, ofBefore, 0);
                    long lTicket = FlashJournalRM.this.encodeTicket(nFileId, ofBefore, cbValue);
                    FlashJournalRM.this.m_mapLocators.put(new Long(lLocator), bin);
                    FlashJournalRM.this.m_daemonPreparer.notifyItemQueued(this, lTicket);
                    this.congestionCheck(cbEntry);
                    return lTicket;
                }
                if (lState != 0x1000000000000000L) break;
                this.congestionDelay();
            }
            return 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public Binary read(long lTicket) {
            long lLocator;
            Binary bin;
            long of = FlashJournalRM.this.extractOffset(lTicket);
            int cb = FlashJournalRM.this.extractLength(lTicket);
            ConcurrentMap<Long, Binary> map = FlashJournalRM.this.m_mapLocators;
            if (map != null && (bin = (Binary)map.get(new Long(lLocator = FlashJournalRM.this.encodeTicket(this.m_nFile, of, 0)))) != null) {
                assert (bin.length() == cb);
                return bin;
            }
            assert (of + (long)cb <= this.m_cbWritten.get());
            boolean fReopened = false;
            while (true) {
                try {
                    return Binary.readBinary(this.getReadChannel(), of, cb, this.m_abOv);
                }
                catch (ClosedByInterruptException e) {
                    throw new WrapperException(e);
                }
                catch (ClosedChannelException e) {
                    if (fReopened) {
                        throw new WrapperException(e, "Failed to reopen a read channel");
                    }
                    JournalFile journalFile = this;
                    synchronized (journalFile) {
                        if (!this.getReadChannel().isOpen()) {
                            try {
                                this.m_channelRead = new RandomAccessFile(this.getFile(), "r").getChannel();
                            }
                            catch (FileNotFoundException fnfe) {
                                throw new IllegalStateException(fnfe);
                            }
                        }
                    }
                    fReopened = true;
                    continue;
                }
                break;
            }
            catch (IOException e) {
                throw new WrapperException(e);
            }
        }

        @Override
        public void release(int cbValue) {
            super.release(cbValue + 15 & 0xFFFFFFF0);
        }

        @Override
        public JournalFile getNextJournalFile() {
            return (JournalFile)super.getNextJournalFile();
        }

        public File getFile() {
            return this.m_file;
        }

        public FileChannel getReadChannel() {
            return this.m_channelRead;
        }

        public FileChannel getWriteChannel() {
            return this.m_channelWrite;
        }

        @Override
        public void touch() {
            File file = this.getFile();
            long ldt = System.currentTimeMillis();
            long TEN_MINUTES = 600000L;
            if (file.lastModified() < ldt - 600000L) {
                file.setLastModified(ldt);
            }
        }

        @Override
        protected String getDescription() {
            return super.getDescription() + ", BytesWritten=" + this.m_cbWritten.get() + ", OffsetNextFlush=" + this.m_ofNextFlush;
        }

        public void notifyWriteOccurred(int cbWritten) {
            assert (cbWritten > 0);
            long cbTotal = this.m_cbWritten.addAndGet(cbWritten);
            ConcurrentMap<Long, Binary> mapLocators = FlashJournalRM.this.m_mapLocators;
            int nFileId = this.getFileId();
            long ofFlush = this.m_ofNextFlush;
            if (cbTotal > ofFlush) {
                while (ofFlush < cbTotal) {
                    Long LLocator = new Long(FlashJournalRM.this.encodeTicket(nFileId, ofFlush, 0));
                    Binary bin = (Binary)mapLocators.get(LLocator);
                    assert (bin != null);
                    assert (bin.length() > 0);
                    int cbValue = bin.length();
                    int cbEntry = cbValue + 15 & 0xFFFFFFF0;
                    long ofNext = ofFlush + (long)cbEntry;
                    if (cbTotal < ofNext) break;
                    mapLocators.remove(LLocator);
                    ofFlush = ofNext;
                }
            }
            this.m_ofNextFlush = ofFlush;
            this.congestionCheck(-cbWritten);
        }

        public void notifyWriteBehindCompleted() {
            try {
                FileChannel channelWrite = this.m_channelWrite;
                if (channelWrite != null) {
                    channelWrite.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.congestionCheck(0);
        }

        @Override
        public void dispose() {
            try {
                FileChannel channelWrite = this.m_channelWrite;
                if (channelWrite != null) {
                    channelWrite.close();
                }
            }
            catch (IOException eIgnore) {
                // empty catch block
            }
            try {
                FileChannel channelRead = this.m_channelRead;
                if (channelRead != null) {
                    channelRead.close();
                }
            }
            catch (IOException eIgnore) {
                // empty catch block
            }
            try {
                File file = this.m_file;
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception eIgnore) {
                // empty catch block
            }
            byte[] ab = this.m_abOv;
            int cb = ab.length;
            for (int of = 0; of < cb; ++of) {
                ab[of] = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void congestionCheck(int cbDelta) {
            AtomicLong lStateOffset = this.m_lStateOffset;
            boolean fCongested = (lStateOffset.get() & 0xF000000000000000L) == 0x1000000000000000L;
            AtomicInteger cbBacklog = FlashJournalRM.this.m_cbBacklog;
            int cbNewBacklog = cbBacklog.addAndGet(cbDelta);
            int cbMaxBacklog = FlashJournalRM.this.m_cbMaxBacklog;
            if (cbDelta > 0) {
                if (!fCongested && cbNewBacklog > cbMaxBacklog) {
                    long lStatePrev = lStateOffset.get();
                    while ((lStatePrev & 0xF000000000000000L) == 0L && cbBacklog.get() > cbMaxBacklog) {
                        long lStateNew = 0x1000000000000000L | lStatePrev;
                        if (lStateOffset.compareAndSet(lStatePrev, lStateNew)) {
                            return;
                        }
                        lStatePrev = lStateOffset.get();
                    }
                }
            } else if (cbNewBacklog < cbMaxBacklog) {
                JournalFile jrnlfile;
                if (fCongested) {
                    long lStatePrev = lStateOffset.get();
                    while ((lStatePrev & 0xF000000000000000L) == 0x1000000000000000L && cbBacklog.get() < cbMaxBacklog) {
                        long lStateNew = lStatePrev & 0xFFFFFFFFFFFFFFFL;
                        if (lStateOffset.compareAndSet(lStatePrev, lStateNew)) {
                            JournalFile journalFile = this;
                            synchronized (journalFile) {
                                this.notifyAll();
                                break;
                            }
                        }
                        lStatePrev = lStateOffset.get();
                    }
                }
                if ((jrnlfile = this.getNextJournalFile()) != null) {
                    jrnlfile.congestionCheck(0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void congestionDelay() {
            AtomicLong lStateOffset = this.m_lStateOffset;
            JournalFile journalFile = this;
            synchronized (journalFile) {
                while ((lStateOffset.get() & 0xF000000000000000L) == 0x1000000000000000L) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new WrapperException(e);
                    }
                }
            }
        }

        public Buffer allocateBuffer() {
            return FlashJournalRM.this.getBufferPool().allocate(this.m_abOv);
        }
    }
}

