/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.journal;

import com.tangosol.io.journal.BackupJournalRM;
import com.tangosol.io.journal.FlashJournalRM;
import com.tangosol.io.journal.RamJournalRM;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Disposable;

public class JournalService
implements Disposable {
    private volatile RamJournalRM m_ramJournalRM;
    private volatile FlashJournalRM m_flashJournalRM;
    private volatile BackupJournalRM m_backupJournalRM;
    private final Cluster m_cluster;

    public JournalService(Cluster cluster) {
        this.m_cluster = cluster;
    }

    @Override
    public void dispose() {
        FlashJournalRM jrmFlash;
        RamJournalRM jrmRam;
        BackupJournalRM jrmBackup = this.m_backupJournalRM;
        if (jrmBackup != null) {
            this.m_backupJournalRM = null;
            jrmBackup.dispose();
        }
        if ((jrmRam = this.m_ramJournalRM) != null) {
            this.m_ramJournalRM = null;
            jrmRam.dispose();
        }
        if ((jrmFlash = this.m_flashJournalRM) != null) {
            this.m_flashJournalRM = null;
            jrmFlash.dispose();
        }
    }

    public synchronized FlashJournalRM ensureFlashJournalRM() {
        FlashJournalRM jrmFlash = this.m_flashJournalRM;
        if (jrmFlash == null) {
            XmlElement xmlConfig = CacheFactory.getClusterConfig();
            XmlElement xmlFlash = xmlConfig.getSafeElement("journaling-config/flashjournal-manager");
            if (XmlHelper.isEmpty(xmlFlash)) {
                CacheFactory.log("No Flash Journal configuration - using default settings", 2);
            }
            jrmFlash = new FlashJournalRM(this.m_cluster);
            jrmFlash.configure(xmlFlash);
            jrmFlash.start();
            this.m_flashJournalRM = jrmFlash;
        }
        return jrmFlash;
    }

    public synchronized RamJournalRM ensureRamJournalRM() {
        RamJournalRM jrmRam = this.m_ramJournalRM;
        if (jrmRam == null) {
            XmlElement xmlConfig = CacheFactory.getClusterConfig();
            XmlElement xmlRam = xmlConfig.getSafeElement("journaling-config/ramjournal-manager");
            if (XmlHelper.isEmpty(xmlRam)) {
                CacheFactory.log("No RAM Journal configuration - using default settings", 2);
            }
            jrmRam = new RamJournalRM(this.m_cluster);
            FlashJournalRM jrmFlash = this.ensureFlashJournalRM();
            jrmRam.setFlashJournalRM(jrmFlash);
            jrmRam.configure(xmlRam);
            jrmRam.start();
            this.m_ramJournalRM = jrmRam;
        }
        return jrmRam;
    }

    public synchronized BackupJournalRM ensureBackupJournalRM() {
        BackupJournalRM jrmBackup = this.m_backupJournalRM;
        if (jrmBackup == null) {
            this.m_backupJournalRM = jrmBackup = new BackupJournalRM(this.ensureRamJournalRM(), 0.92);
        }
        return jrmBackup;
    }
}

