/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.lh;

import com.tangosol.io.lh.LHTable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Hashtable;
import java.util.Properties;

class LHVolume {
    String m_Name;
    boolean m_ReadOnly;
    int m_FillCharacter;
    boolean m_FlushAllUpdates;
    boolean m_FlushFileSizeUpdates;
    Hashtable m_LHTables;

    static String ConvertToLocalPath(String DirName, Properties properties) {
        String LocalPath;
        if (properties != null && (LocalPath = properties.getProperty(DirName)) != null) {
            return LocalPath;
        }
        return DirName;
    }

    LHVolume(String Name2) {
        block17: {
            this.m_Name = LHVolume.ConvertToLocalPath(Name2, null);
            this.m_ReadOnly = false;
            this.m_FillCharacter = 0;
            this.m_FlushAllUpdates = false;
            this.m_FlushFileSizeUpdates = false;
            this.m_LHTables = new Hashtable();
            try {
                File file = new File(this.m_Name, "REVPARAM");
                if (!file.exists()) break block17;
                StreamTokenizer st = new StreamTokenizer(new FileInputStream(file));
                st.lowerCaseMode(true);
                st.ordinaryChar(47);
                st.nextToken();
                block12: while (true) {
                    block1 : switch (st.ttype) {
                        case -1: {
                            break block17;
                        }
                        case -3: {
                            switch (st.sval.length()) {
                                case 8: {
                                    if (st.sval.equals("readonly")) {
                                        if (!this.SkipEquals(st) || !this.LoadBoolean(st)) continue block12;
                                        this.m_ReadOnly = st.nval != 0.0;
                                        st.nextToken();
                                        break block1;
                                    }
                                    st.nextToken();
                                    break block1;
                                }
                                case 13: {
                                    if (st.sval.equals("fillcharacter")) {
                                        if (!this.SkipEquals(st)) continue block12;
                                        if (st.ttype != -2) continue block12;
                                        this.m_FillCharacter = (int)st.nval;
                                        st.nextToken();
                                        break block1;
                                    }
                                    st.nextToken();
                                    break block1;
                                }
                                case 15: {
                                    if (st.sval.equals("flushallupdates")) {
                                        if (!this.SkipEquals(st) || !this.LoadBoolean(st)) continue block12;
                                        this.m_FlushAllUpdates = st.nval != 0.0;
                                        st.nextToken();
                                        break block1;
                                    }
                                    st.nextToken();
                                    break block1;
                                }
                                case 20: {
                                    if (st.sval.equals("flushfilesizeupdates")) {
                                        if (!this.SkipEquals(st) || !this.LoadBoolean(st)) continue block12;
                                        this.m_FlushFileSizeUpdates = st.nval != 0.0;
                                        st.nextToken();
                                        break block1;
                                    }
                                    st.nextToken();
                                    break block1;
                                }
                            }
                            st.nextToken();
                            break;
                        }
                        default: {
                            st.nextToken();
                            break;
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean SkipEquals(StreamTokenizer st) throws IOException {
        st.nextToken();
        if (st.ttype != 61) {
            return false;
        }
        st.nextToken();
        return true;
    }

    private boolean LoadBoolean(StreamTokenizer st) {
        switch (st.ttype) {
            case -3: {
                switch (st.sval.length()) {
                    case 2: {
                        if (!st.sval.equals("no")) break;
                        st.nval = 0.0;
                        return true;
                    }
                    case 3: {
                        if (!st.sval.equals("yes")) break;
                        st.nval = 1.0;
                        return true;
                    }
                    case 4: {
                        if (!st.sval.equals("true")) break;
                        st.nval = 1.0;
                        return true;
                    }
                    case 5: {
                        if (!st.sval.equals("false")) break;
                        st.nval = 0.0;
                        return true;
                    }
                }
                break;
            }
            case -2: {
                return true;
            }
        }
        return false;
    }

    LHTable get(String fileName) {
        return (LHTable)this.m_LHTables.get(fileName);
    }

    LHTable put(String fileName, LHTable lhTable) {
        return this.m_LHTables.put(fileName, lhTable);
    }
}

