/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.java.type;

import com.tangosol.java.type.ArrayType;
import com.tangosol.java.type.ClassType;
import com.tangosol.java.type.NullType;
import com.tangosol.java.type.PrimitiveType;
import com.tangosol.java.type.UnknownType;
import com.tangosol.java.type.VoidType;
import com.tangosol.util.Base;

public abstract class Type
extends Base {
    public static final ClassType OBJECT = new ClassType("java.lang.Object");
    public static final PrimitiveType BOOLEAN = new PrimitiveType("Z");
    public static final PrimitiveType CHAR = new PrimitiveType("C");
    public static final PrimitiveType BYTE = new PrimitiveType("B");
    public static final PrimitiveType SHORT = new PrimitiveType("S");
    public static final PrimitiveType INT = new PrimitiveType("I");
    public static final PrimitiveType LONG = new PrimitiveType("J");
    public static final PrimitiveType FLOAT = new PrimitiveType("F");
    public static final PrimitiveType DOUBLE = new PrimitiveType("D");
    public static final VoidType VOID = new VoidType();
    public static final NullType NULL = new NullType();
    public static final UnknownType UNKNOWN = new UnknownType();
    private String m_sSig;

    protected Type(String sSig) {
        this.m_sSig = sSig;
    }

    public static Type parseSignature(String sSig) {
        int cch = sSig.length();
        block0 : switch (cch) {
            case 0: {
                break;
            }
            case 1: {
                switch (sSig.charAt(0)) {
                    case 'Z': {
                        return BOOLEAN;
                    }
                    case 'C': {
                        return CHAR;
                    }
                    case 'B': {
                        return BYTE;
                    }
                    case 'S': {
                        return SHORT;
                    }
                    case 'I': {
                        return INT;
                    }
                    case 'J': {
                        return LONG;
                    }
                    case 'F': {
                        return FLOAT;
                    }
                    case 'D': {
                        return DOUBLE;
                    }
                    case 'V': {
                        return VOID;
                    }
                }
                break;
            }
            default: {
                switch (sSig.charAt(0)) {
                    case '[': {
                        return new ArrayType(Type.parseSignature(sSig.substring(1)));
                    }
                    case 'L': {
                        if (sSig.charAt(cch - 1) != ';') break block0;
                        return new ClassType(sSig.substring(1, sSig.length() - 1));
                    }
                }
            }
        }
        throw new IllegalArgumentException("Illegal signature: " + sSig);
    }

    public ArrayType getArrayType() {
        return new ArrayType(this);
    }

    public String getSignature() {
        return this.m_sSig;
    }

    public void setSignature(String sSig) {
        throw new UnsupportedOperationException();
    }

    public int getWordCount() {
        return 1;
    }

    public abstract String toString();

    public int hashCode() {
        return this.m_sSig.hashCode();
    }

    public boolean equals(Object o) {
        return this.m_sSig.equals(((Type)o).m_sSig);
    }
}

