/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.events.internal;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.InterceptorRegistry;
import com.tangosol.util.Base;
import com.tangosol.util.Disposable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Registry
implements InterceptorRegistry,
Disposable {
    protected static final Registry INSTANCE = new Registry();
    protected static final String RESOURCE_REGISTRY_NAME = "InterceptorRegistry;";
    protected static boolean s_fRegistered;
    protected final Map<String, EventInterceptor> m_mapInterceptors = new LinkedHashMap<String, EventInterceptor>();
    protected final Set<EventDispatcher> m_setDispatchers = Collections.newSetFromMap(new ConcurrentHashMap());

    protected Registry() {
    }

    @Override
    public synchronized void registerEventInterceptor(String sIdentifier, EventInterceptor interceptor) {
        Map<String, EventInterceptor> mapInterceptors = this.m_mapInterceptors;
        if (mapInterceptors.containsKey(sIdentifier)) {
            throw new IllegalArgumentException("EventInterceptor " + sIdentifier + " is already registered");
        }
        mapInterceptors.put(sIdentifier, interceptor);
        try {
            this.introduceInterceptor(sIdentifier, interceptor);
        }
        catch (Exception e) {
            this.unregisterEventInterceptor(sIdentifier);
            throw Base.ensureRuntimeException(e);
        }
    }

    @Override
    public synchronized void unregisterEventInterceptor(String sIdentifier) {
        EventInterceptor interceptor = this.m_mapInterceptors.remove(sIdentifier);
        if (interceptor != null) {
            this.removeInterceptorFromDispatchers(sIdentifier);
        }
    }

    @Override
    public synchronized Map<String, EventInterceptor> getRegisteredInterceptors() {
        return Collections.unmodifiableMap(new HashMap<String, EventInterceptor>(this.m_mapInterceptors));
    }

    @Override
    public synchronized void dispose() {
        s_fRegistered = false;
        this.m_setDispatchers.clear();
        this.m_mapInterceptors.clear();
    }

    public synchronized void registerEventDispatcher(EventDispatcher dispatcher) {
        this.m_setDispatchers.add(dispatcher);
        this.introduceDispatcher(dispatcher);
    }

    public synchronized void unregisterEventDispatcher(EventDispatcher dispatcher) {
        this.m_setDispatchers.remove(dispatcher);
    }

    protected void introduceDispatcher(EventDispatcher dispatcher) {
        for (Map.Entry<String, EventInterceptor> entry : this.m_mapInterceptors.entrySet()) {
            entry.getValue().introduceEventDispatcher(entry.getKey(), dispatcher);
        }
    }

    protected void introduceInterceptor(String sIdentifier, EventInterceptor interceptor) {
        for (EventDispatcher dispatcher : this.m_setDispatchers) {
            interceptor.introduceEventDispatcher(sIdentifier, dispatcher);
        }
    }

    protected void removeInterceptorFromDispatchers(String sIdentifier) {
        for (EventDispatcher dispatcher : this.m_setDispatchers) {
            dispatcher.removeEventInterceptor(sIdentifier);
        }
    }

    public static Registry ensureRegistry() {
        return Registry.ensureRegistry(CacheFactory.getCluster());
    }

    public static Registry ensureRegistry(Cluster cluster) {
        if (!s_fRegistered) {
            cluster.registerResource(RESOURCE_REGISTRY_NAME, INSTANCE);
            s_fRegistered = true;
        }
        return INSTANCE;
    }
}

