/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.collections;

import com.oracle.common.collections.ArrayIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Collections {
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static final Iterator EMPTY_ITERATOR = new EmptyIterator();

    private Collections() {
    }

    public static <T> Enumeration<? extends T> emptyEnumeration() {
        return (Enumeration)((Object)EMPTY_ITERATOR);
    }

    public static <T> Enumeration<T> singletonEnumeration(T o) {
        return new SingletonIterator(o);
    }

    public static <T> Enumeration<T> iteratorEnumeration(Iterator<? extends T> iter) {
        return new UnmodifiableIterator(iter);
    }

    public static <T> Iterator<? extends T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <T> Iterator<T> singletonIterator(T o) {
        return new SingletonIterator(o);
    }

    public static <T> Iterator<T> unmodifiableIterator(Iterator<? extends T> iter) {
        return new UnmodifiableIterator(iter);
    }

    public static <T> Iterator<T> enumerationIterator(Enumeration<? extends T> enumeration) {
        return new EnumerationIterator<T>(enumeration);
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        try {
            return o1.equals(o2);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static Object[] toArray(Iterator iter) {
        if (!iter.hasNext()) {
            return EMPTY_ARRAY;
        }
        if (iter instanceof ArrayIterator) {
            return ((ArrayIterator)iter).toArray();
        }
        ArrayList list = new ArrayList();
        do {
            list.add(iter.next());
        } while (iter.hasNext());
        return list.toArray();
    }

    public static <T> T[] toArray(Iterator<? extends T> iter, T[] ao) {
        if (!iter.hasNext()) {
            if (ao == null) {
                ao = EMPTY_ARRAY;
            } else if (ao.length > 0) {
                ao[0] = null;
            }
            return ao;
        }
        if (iter instanceof ArrayIterator) {
            return ((ArrayIterator)iter).toArray(ao);
        }
        ArrayList<T> list = new ArrayList<T>();
        do {
            list.add(iter.next());
        } while (iter.hasNext());
        return ao == null ? list.toArray() : list.toArray(ao);
    }

    public static Object[] toArray(Enumeration enmr) {
        if (!enmr.hasMoreElements()) {
            return EMPTY_ARRAY;
        }
        if (enmr instanceof ArrayIterator) {
            return ((ArrayIterator)enmr).toArray();
        }
        ArrayList list = new ArrayList();
        do {
            list.add(enmr.nextElement());
        } while (enmr.hasMoreElements());
        return list.toArray();
    }

    public static <T> T[] toArray(Enumeration<? extends T> enmr, T[] ao) {
        if (!enmr.hasMoreElements()) {
            if (ao.length > 0) {
                ao[0] = null;
            }
            return ao;
        }
        if (enmr instanceof ArrayIterator) {
            return ((ArrayIterator)enmr).toArray(ao);
        }
        ArrayList<T> list = new ArrayList<T>();
        do {
            list.add(enmr.nextElement());
        } while (enmr.hasMoreElements());
        return list.toArray(ao);
    }

    static class EnumerationIterator<T>
    implements Iterator<T>,
    Serializable {
        private Enumeration<? extends T> m_enum;

        EnumerationIterator(Enumeration<? extends T> enumeration) {
            this.m_enum = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.m_enum.hasMoreElements();
        }

        @Override
        public T next() {
            return this.m_enum.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class UnmodifiableIterator<T>
    implements Iterator<T>,
    Enumeration<T>,
    Serializable {
        private Iterator<? extends T> m_iter;

        private UnmodifiableIterator(Iterator<? extends T> iter) {
            this.m_iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.m_iter.hasNext();
        }

        @Override
        public T next() {
            return this.m_iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_iter.hasNext();
        }

        @Override
        public T nextElement() {
            return this.m_iter.next();
        }
    }

    private static class SingletonIterator<T>
    implements Iterator<T>,
    Enumeration<T>,
    Serializable {
        private boolean m_fHasNext = true;
        private T m_oElement;

        private SingletonIterator(T o) {
            this.m_oElement = o;
        }

        @Override
        public boolean hasNext() {
            return this.m_fHasNext;
        }

        @Override
        public T next() {
            if (!this.m_fHasNext) {
                throw new IllegalStateException();
            }
            this.m_fHasNext = false;
            return this.m_oElement;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }

        @Override
        public T nextElement() {
            return this.next();
        }
    }

    private static class EmptyIterator<T>
    implements Iterator<T>,
    Enumeration<T>,
    Serializable {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public T nextElement() {
            throw new NoSuchElementException();
        }
    }
}

