/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.internal.net;

import com.oracle.common.base.Factory;
import com.oracle.common.net.SelectionService;
import java.io.IOException;
import java.nio.channels.SelectableChannel;

public class HashSelectionService
implements SelectionService {
    protected final SelectionService[] m_aServices;

    public HashSelectionService(int cServices, Factory<? extends SelectionService> factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        SelectionService[] aSvc = new SelectionService[cServices];
        for (int i = 0; i < cServices; ++i) {
            aSvc[i] = factory.create();
        }
        this.m_aServices = aSvc;
    }

    @Override
    public void register(SelectableChannel chan, SelectionService.Handler handler) throws IOException {
        SelectionService[] aSvc = this.m_aServices;
        aSvc[Math.abs(chan.hashCode()) % aSvc.length].register(chan, handler);
    }

    @Override
    public void invoke(SelectableChannel chan, Runnable runnable) throws IOException {
        SelectionService[] aSvc = this.m_aServices;
        aSvc[Math.abs(chan.hashCode()) % aSvc.length].invoke(chan, runnable);
    }

    @Override
    public void shutdown() {
        for (SelectionService svc : this.m_aServices) {
            svc.shutdown();
        }
    }

    public static class ServiceFactory
    implements Factory<HashSelectionService> {
        private int m_cServices;
        private Factory<? extends SelectionService> m_factoryChild;

        public ServiceFactory(int cServices, Factory<? extends SelectionService> factoryChild) {
            this.m_cServices = cServices;
            this.m_factoryChild = factoryChild;
        }

        @Override
        public HashSelectionService create() {
            return new HashSelectionService(this.m_cServices, this.m_factoryChild);
        }
    }
}

