/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.internal.net;

import com.oracle.common.net.SelectionService;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.IllegalSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RunnableSelectionService
implements SelectionService,
Runnable {
    private Selector m_selector;
    private final Map<SelectableChannel, SelectionService.Handler> m_mapRegistrations = new HashMap<SelectableChannel, SelectionService.Handler>();
    private volatile Object m_oRunnables;
    private volatile boolean m_fPendingRegistrations;
    private long m_cMillisTimeout;

    @Override
    public synchronized void register(SelectableChannel chan, SelectionService.Handler handler) throws IOException {
        SelectionKey key;
        Selector selector = this.ensureSelector(chan);
        this.m_mapRegistrations.put(chan, handler);
        if (handler == null && (key = chan.keyFor(selector)) != null) {
            key.cancel();
        }
        this.m_fPendingRegistrations = true;
        selector.wakeup();
    }

    @Override
    public synchronized void invoke(SelectableChannel chan, Runnable runnable) throws IOException {
        Object oRunnables = this.m_oRunnables;
        if (oRunnables == null) {
            this.m_oRunnables = runnable;
        } else if (oRunnables instanceof Runnable) {
            ArrayList<Runnable> listRunnable;
            this.m_oRunnables = listRunnable = new ArrayList<Runnable>();
            listRunnable.add((Runnable)oRunnables);
            listRunnable.add(runnable);
        } else {
            ((List)oRunnables).add(runnable);
        }
        this.ensureSelector(chan).wakeup();
    }

    private Selector ensureSelector(SelectableChannel chan) throws IOException {
        if (chan.isBlocking()) {
            throw new IllegalBlockingModeException();
        }
        Selector selector = this.m_selector;
        if (selector == null) {
            this.m_selector = selector = chan.provider().openSelector();
            this.notifyAll();
        } else {
            if (!selector.isOpen()) {
                throw new ClosedSelectorException();
            }
            if (!chan.provider().equals(selector.provider())) {
                throw new IllegalSelectorException();
            }
        }
        return selector;
    }

    @Override
    public synchronized void shutdown() {
        Selector selector = this.m_selector;
        if (selector != null) {
            try {
                selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setIdleTimeout(long cMillis) {
        this.m_cMillisTimeout = cMillis;
    }

    public long getIdleTimeout() {
        return this.m_cMillisTimeout;
    }

    public synchronized boolean isIdle() {
        Selector selector = this.m_selector;
        return selector == null || !selector.isOpen() || selector.keys().isEmpty() && this.m_mapRegistrations.isEmpty() && this.m_oRunnables == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block9: {
            Selector selector = null;
            try {
                RunnableSelectionService runnableSelectionService = this;
                synchronized (runnableSelectionService) {
                    while ((selector = this.m_selector) == null) {
                        long cWait = this.getIdleTimeout();
                        this.wait(cWait);
                        if (cWait == 0L || this.m_selector != null) continue;
                        return;
                    }
                }
                this.process();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (InterruptedIOException e) {
                Thread.currentThread().interrupt();
            }
            catch (ClosedSelectorException e) {
            }
            catch (IOException e) {
                if (!selector.isOpen()) break block9;
                throw new RuntimeException(e);
            }
        }
    }

    public String toString() {
        return "SelectionService(" + this.m_selector + ")";
    }

    protected void process() throws IOException {
        Selector selector = this.m_selector;
        Set<SelectionKey> setReg = selector.keys();
        Set<SelectionKey> setReady = selector.selectedKeys();
        boolean fImmediate = false;
        while (true) {
            if (!fImmediate && this.m_fPendingRegistrations) {
                this.processRegistrations();
            }
            try {
                if (fImmediate) {
                    selector.selectNow();
                    fImmediate = false;
                } else {
                    long cMillisTimeout = this.getIdleTimeout();
                    if (selector.select(cMillisTimeout) == 0 && cMillisTimeout != 0L && setReg.isEmpty() && this.isIdle()) {
                        return;
                    }
                }
            }
            catch (CancelledKeyException e) {
                fImmediate = true;
            }
            for (SelectionKey key : setReady) {
                try {
                    SelectionService.Handler handler = (SelectionService.Handler)key.attachment();
                    key.interestOps(handler.onReady(key.readyOps()));
                }
                catch (Throwable t) {
                    key.cancel();
                    fImmediate = true;
                }
            }
            setReady.clear();
            if (this.m_oRunnables == null) continue;
            this.processRunnables();
        }
    }

    protected synchronized void processRegistrations() throws IOException {
        Map<SelectableChannel, SelectionService.Handler> mapReg = this.m_mapRegistrations;
        Selector selector = this.m_selector;
        for (Map.Entry<SelectableChannel, SelectionService.Handler> entry : mapReg.entrySet()) {
            SelectableChannel chan = entry.getKey();
            SelectionService.Handler handler = entry.getValue();
            if (handler == null) {
                SelectionKey key = chan.keyFor(selector);
                if (key == null) continue;
                key.cancel();
                continue;
            }
            try {
                chan.register(selector, chan.validOps(), handler);
            }
            catch (IOException e) {
            }
            catch (CancelledKeyException e) {}
        }
        mapReg.clear();
        this.m_fPendingRegistrations = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRunnables() {
        Object oRunnables;
        RunnableSelectionService runnableSelectionService = this;
        synchronized (runnableSelectionService) {
            oRunnables = this.m_oRunnables;
            this.m_oRunnables = null;
        }
        if (oRunnables == null) {
            return;
        }
        if (oRunnables instanceof Runnable) {
            try {
                ((Runnable)oRunnables).run();
            }
            catch (Throwable t) {}
        } else {
            for (Runnable runnable : (List)oRunnables) {
                try {
                    runnable.run();
                }
                catch (Throwable thr) {}
            }
        }
    }
}

