/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.internal.net;

import com.oracle.common.base.Converter;
import com.oracle.common.collections.ConverterCollections;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Set;

public class WrapperSelector
extends AbstractSelector {
    protected final Selector m_delegate;
    protected final Set m_setKeys;
    protected final Set m_setSelectedKeys;

    public WrapperSelector(Selector selector, SelectorProvider provider) throws IOException {
        super(provider);
        this.m_delegate = selector;
        this.m_setKeys = new KeySet(selector.keys());
        this.m_setSelectedKeys = new KeySet(selector.selectedKeys());
    }

    public Selector getDelegate() {
        return this.m_delegate;
    }

    public static Selector open() {
        throw new UnsupportedOperationException();
    }

    public Set keys() {
        return this.m_setKeys;
    }

    public Set selectedKeys() {
        return this.m_setSelectedKeys;
    }

    @Override
    public int select() throws IOException {
        return this.select(0L);
    }

    @Override
    public int selectNow() throws IOException {
        return this.select(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int select(long timeout) throws IOException {
        WrapperSelector wrapperSelector = this;
        synchronized (wrapperSelector) {
            Set set = this.m_setKeys;
            synchronized (set) {
                Set set2 = this.m_setSelectedKeys;
                synchronized (set2) {
                    return timeout > 0L ? this.m_delegate.select(timeout) : (timeout == 0L ? this.m_delegate.select() : this.m_delegate.selectNow());
                }
            }
        }
    }

    @Override
    public Selector wakeup() {
        this.m_delegate.wakeup();
        return this;
    }

    @Override
    protected void implCloseSelector() throws IOException {
        this.m_delegate.close();
    }

    @Override
    protected SelectionKey register(AbstractSelectableChannel ch, int ops, Object att) {
        try {
            return ((WrapperSelectableChannel)((Object)ch)).registerInternal(this, ops, att);
        }
        catch (IOException e) {
            return new WrapperSelectionKey(this, null, att){

                @Override
                public SelectableChannel channel() {
                    throw new CancelledKeyException();
                }

                @Override
                public boolean isValid() {
                    return false;
                }

                @Override
                public void cancel() {
                }

                @Override
                public int interestOps() {
                    throw new CancelledKeyException();
                }

                @Override
                public SelectionKey interestOps(int ops) {
                    throw new CancelledKeyException();
                }

                @Override
                public int readyOps() {
                    throw new CancelledKeyException();
                }
            };
        }
    }

    public class KeySet
    extends ConverterCollections.ConverterSet {
        protected KeySet(Set setBack) {
            super(setBack, new Converter(){

                public Object convert(Object o) {
                    return ((SelectionKey)o).attachment();
                }
            }, new Converter(){

                public Object convert(Object o) {
                    return ((WrapperSelectionKey)o).m_delegate;
                }
            });
        }
    }

    public static abstract class WrapperSelectionKey
    extends SelectionKey {
        protected final WrapperSelector m_selector;
        protected final SelectionKey m_delegate;

        public WrapperSelectionKey(WrapperSelector selector, SelectionKey key, Object att) {
            this.m_selector = selector;
            this.m_delegate = key;
            this.attach(att);
            if (key != null) {
                key.attach(this);
            }
        }

        @Override
        public abstract SelectableChannel channel();

        @Override
        public Selector selector() {
            return this.m_selector;
        }

        @Override
        public boolean isValid() {
            return this.m_delegate.isValid();
        }

        @Override
        public void cancel() {
            this.m_delegate.cancel();
        }

        @Override
        public int interestOps() {
            return this.m_delegate.interestOps();
        }

        @Override
        public SelectionKey interestOps(int ops) {
            this.m_delegate.interestOps(ops);
            return this;
        }

        @Override
        public int readyOps() {
            return this.m_delegate.readyOps();
        }

        protected String getKeyString(SelectionKey key) {
            return key.isValid() ? "interest=" + key.interestOps() + ", ready=" + key.readyOps() : "cancelled";
        }

        public String toString() {
            return this.getKeyString(this);
        }
    }

    public static interface WrapperSelectableChannel {
        public WrapperSelectionKey registerInternal(WrapperSelector var1, int var2, Object var3) throws IOException;
    }
}

