/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.internal.net.socketbus;

import com.oracle.common.base.Collector;
import com.oracle.common.internal.net.socketbus.SocketBusDriver;
import com.oracle.common.net.SafeSelectionHandler;
import com.oracle.common.net.SelectionService;
import com.oracle.common.net.Sockets;
import com.oracle.common.net.exabus.Bus;
import com.oracle.common.net.exabus.EndPoint;
import com.oracle.common.net.exabus.Event;
import com.oracle.common.net.exabus.util.SimpleEvent;
import com.oracle.common.net.exabus.util.UrlEndPoint;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public abstract class AbstractSocketBus
implements Bus {
    protected static volatile Timer s_timer;
    protected static int s_cBus;
    protected final SocketBusDriver m_driver;
    private ServerSocketChannel m_channelServer;
    private volatile BusState m_nState = BusState.INITIAL;
    private final ReadWriteLock m_lockState = new ReentrantReadWriteLock();
    private EndPoint m_pointLocal;
    private Collector<Event> m_collectorEvent;
    private final ConcurrentMap<EndPoint, Connection> m_mapConnections = new ConcurrentHashMap<EndPoint, Connection>();
    private final Set<Connection> m_setFlush = Collections.newSetFromMap(new ConcurrentHashMap());

    public AbstractSocketBus(SocketBusDriver driver, UrlEndPoint pointLocal) throws IOException {
        this.m_driver = driver;
        String sProtocol = this.getProtocolName();
        if (pointLocal != null && !sProtocol.equals(pointLocal.getProtocol())) {
            throw new IllegalArgumentException("unsupported protocol: " + pointLocal.getProtocol());
        }
        ServerSocketChannel chan = driver.getDependencies().getSocketProvider().openServerSocketChannel();
        chan.configureBlocking(false);
        this.configureSocket(chan.socket());
        chan.socket().bind(pointLocal == null ? null : pointLocal.getAddress());
        this.m_channelServer = chan;
        this.m_pointLocal = driver.resolveBindPoint(sProtocol, chan.socket());
    }

    @Override
    public EndPoint getLocalEndPoint() {
        return this.m_pointLocal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        Lock lock = this.m_lockState.writeLock();
        lock.lock();
        try {
            this.verifyState(BusState.INITIAL);
            this.m_nState = BusState.OPEN;
            Class<AbstractSocketBus> clazz = AbstractSocketBus.class;
            synchronized (AbstractSocketBus.class) {
                ++s_cBus;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.emitEvent(new SimpleEvent(Event.Type.OPEN, this.getLocalEndPoint()));
                try {
                    ServerSocketChannel channel = this.m_channelServer;
                    this.getSelectionService().register(channel, new AcceptHandler(channel));
                    this.onOpen();
                }
                catch (IOException e) {
                    this.close();
                }
            }
        }
        finally {
            lock.unlock();
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Lock lock = this.m_lockState.writeLock();
        lock.lock();
        boolean fInterrupted = Thread.interrupted();
        try {
            Connection connection;
            Connection conn;
            this.verifyState(BusState.OPEN);
            this.m_nState = BusState.CLOSED;
            try {
                this.m_channelServer.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            Iterator i$ = this.m_mapConnections.values().iterator();
            while (i$.hasNext()) {
                connection = conn = (Connection)i$.next();
                synchronized (connection) {
                    if (conn.m_next != null) {
                        conn.m_next.close(null);
                        conn.m_next = null;
                    }
                    conn.scheduleShutdown(null, true);
                }
            }
            i$ = this.m_mapConnections.values().iterator();
            while (i$.hasNext()) {
                connection = conn = (Connection)i$.next();
                synchronized (connection) {
                    if (conn.m_state != ConnectionState.FINAL) {
                        try {
                            conn.wait();
                        }
                        catch (InterruptedException e) {
                            fInterrupted = true;
                        }
                    }
                }
            }
            this.onClose();
            this.emitEvent(new SimpleEvent(Event.Type.CLOSE, this.getLocalEndPoint()));
            Class<AbstractSocketBus> clazz = AbstractSocketBus.class;
            synchronized (AbstractSocketBus.class) {
                Timer timer = s_timer;
                if (--s_cBus == 0 && timer != null) {
                    timer.cancel();
                    s_timer = null;
                }
                // ** MonitorExit[var3_4] (shouldn't be in output)
            }
        }
        finally {
            lock.unlock();
            if (fInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(EndPoint peer) {
        Lock lock = this.m_lockState.readLock();
        lock.lock();
        try {
            Connection conn;
            this.verifyState(BusState.OPEN);
            if (((Object)this.getLocalEndPoint()).equals(peer)) {
                throw new IllegalArgumentException("SocketBus does not support connections to self");
            }
            Connection connection = conn = this.makeConnection(this.verifyEndPoint(peer));
            synchronized (connection) {
                Connection connOld = this.m_mapConnections.putIfAbsent(peer, conn);
                if (connOld == null) {
                    conn.open();
                    try {
                        conn.connect();
                    }
                    catch (IOException e) {
                        conn.scheduleDisconnect(e);
                    }
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(EndPoint peer) {
        Connection conn;
        Connection connection = conn = this.ensureConnection(peer);
        synchronized (connection) {
            conn.ensureValid().scheduleDisconnect(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(EndPoint peer) {
        Connection conn;
        Connection connection = conn = this.ensureConnection(peer);
        synchronized (connection) {
            conn.ensureValid().scheduleShutdown(null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signal(EndPoint peer, Object receipt) {
        Connection conn;
        Connection connection = conn = this.ensureConnection(peer);
        synchronized (connection) {
            conn.ensureValid().signal(receipt);
            this.addFlushable(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        this.verifyState(BusState.OPEN);
        Iterator<Connection> iter = this.m_setFlush.iterator();
        while (iter.hasNext()) {
            Connection conn = iter.next();
            iter.remove();
            try {
                Connection connection = conn;
                synchronized (connection) {
                    conn.ensureValid().flush();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEventCollector(Collector<Event> collector) {
        Lock lock = this.m_lockState.readLock();
        lock.lock();
        try {
            this.verifyState(BusState.INITIAL);
            this.m_collectorEvent = collector;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Collector<Event> getEventCollector() {
        return this.m_collectorEvent;
    }

    protected void onOpen() {
    }

    protected void onClose() {
    }

    protected Collection<Connection> getRegisteredConnections() {
        return this.m_mapConnections.values();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('(').append(this.getLocalEndPoint()).append(')').append(", State=").append((Object)this.m_nState);
        ConcurrentMap<EndPoint, Connection> mapCon = this.m_mapConnections;
        int cConnections = 0;
        int cActive = 0;
        for (Connection conn : mapCon.values()) {
            ++cConnections;
            if (conn.m_state != ConnectionState.ACTIVE) continue;
            ++cActive;
        }
        sb.append(", Connections ").append(mapCon.values()).append(cActive).append('/').append(cConnections).append(')');
        return sb.toString();
    }

    protected Logger getLogger() {
        return this.getSocketDriver().getDependencies().getLogger();
    }

    protected LogRecord makeRecord(Level level, String sMsg, Object ... oaParams) {
        LogRecord rec = new LogRecord(level, sMsg);
        rec.setParameters(oaParams);
        return rec;
    }

    protected LogRecord makeExceptionRecord(Level level, Throwable t, String sMsg, Object ... oaParams) {
        LogRecord rec = this.makeRecord(level, sMsg, oaParams);
        rec.setThrown(t);
        return rec;
    }

    protected void addFlushable(Connection conn) {
        this.m_setFlush.add(conn);
    }

    protected void removeFlushable(Connection conn) {
        this.m_setFlush.remove(conn);
    }

    protected void emitEvent(Event event) {
        Collector<Event> coll = this.m_collectorEvent;
        if (coll != null) {
            try {
                coll.add(event);
                coll.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void addEvent(Event event) {
        Collector<Event> coll = this.m_collectorEvent;
        if (coll != null) {
            try {
                coll.add(event);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void flushEvents() {
        Collector<Event> coll = this.m_collectorEvent;
        if (coll != null) {
            try {
                coll.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void configureSocket(Socket socket) throws IOException {
        Sockets.configure(socket, this.getSocketDriver().getDependencies().getSocketOptions());
    }

    protected void configureSocket(ServerSocket socket) throws IOException {
        Sockets.configure(socket, this.getSocketDriver().getDependencies().getSocketOptions());
    }

    protected void verifyState(BusState nState) {
        BusState nStateCurr = this.m_nState;
        if (nStateCurr != nState) {
            throw new IllegalStateException("invalid bus state: required " + (Object)((Object)nState) + ", actual " + (Object)((Object)nStateCurr));
        }
    }

    protected UrlEndPoint verifyEndPoint(EndPoint peer) {
        if (!(peer instanceof UrlEndPoint) || !((UrlEndPoint)peer).getProtocol().equals(this.getProtocolName())) {
            throw new IllegalArgumentException("unsupported EndPoint " + peer);
        }
        return (UrlEndPoint)peer;
    }

    protected SelectionService getSelectionService() {
        return this.getSocketDriver().getDependencies().getSelectionService();
    }

    protected SocketBusDriver getSocketDriver() {
        return this.m_driver;
    }

    protected Connection ensureConnection(EndPoint peer) {
        Connection conn = (Connection)this.m_mapConnections.get(peer);
        if (conn == null) {
            this.verifyState(BusState.OPEN);
            throw new IllegalArgumentException("unknown peer " + peer);
        }
        return conn;
    }

    protected int getProtocolIdentifier() {
        return this.getClass().getName().hashCode() ^ this.getSocketDriver().getClass().getName().hashCode();
    }

    protected String getProtocolName() {
        return this.getClass().getSimpleName();
    }

    protected short getMinimumProtocolVersion() {
        return 0;
    }

    protected short getMaximumProtocolVersion() {
        return 0;
    }

    protected abstract Connection makeConnection(UrlEndPoint var1);

    protected static synchronized void scheduleTask(final Runnable proc, long cMillis, boolean fRepeat) {
        TimerTask task;
        Timer timer = s_timer;
        if (timer == null) {
            timer = s_timer = new Timer("SocketBusTimer", true);
        }
        TimerTask timerTask = task = proc instanceof TimerTask ? (TimerTask)proc : new TimerTask(){

            @Override
            public void run() {
                proc.run();
            }
        };
        if (fRepeat) {
            timer.scheduleAtFixedRate(task, cMillis, cMillis);
        } else {
            timer.schedule(task, cMillis);
        }
    }

    static {
        s_cBus = 0;
    }

    protected static enum BusState {
        INITIAL,
        OPEN,
        CLOSED;

    }

    protected class AcceptHandler
    extends SafeSelectionHandler<ServerSocketChannel> {
        protected AcceptHandler(ServerSocketChannel channel) {
            super(channel);
        }

        @Override
        public int onReadySafe(int nOps) {
            SocketChannel chan = null;
            try {
                chan = ((ServerSocketChannel)this.getChannel()).accept();
                if (chan != null) {
                    AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeRecord(Level.FINEST, "{0} starting phase IDENTIFY on {1}", AbstractSocketBus.this.getLocalEndPoint(), chan.socket()));
                    chan.configureBlocking(false);
                    AbstractSocketBus.this.configureSocket(chan.socket());
                    AbstractSocketBus.this.getSelectionService().register(chan, new HandshakeHandler(chan, null));
                }
            }
            catch (IOException e) {
                if (chan == null) {
                    throw new RuntimeException(e);
                }
                try {
                    chan.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            return 16;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int onException(Throwable t) {
            ServerSocketChannel channel = (ServerSocketChannel)this.getChannel();
            if (channel.isOpen()) {
                AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeExceptionRecord(Level.WARNING, t, "{0} unexpected exception during Bus accept, ignoring", AbstractSocketBus.this.getLocalEndPoint()));
                return 16;
            }
            AbstractSocketBus abstractSocketBus = AbstractSocketBus.this;
            synchronized (abstractSocketBus) {
                if (AbstractSocketBus.this.m_nState == BusState.OPEN && channel == AbstractSocketBus.this.m_channelServer) {
                    try {
                        channel = AbstractSocketBus.this.getSocketDriver().getDependencies().getSocketProvider().openServerSocketChannel();
                        channel.socket().bind(((UrlEndPoint)AbstractSocketBus.this.getLocalEndPoint()).getAddress());
                        AbstractSocketBus.this.m_channelServer = channel;
                        AbstractSocketBus.this.getSelectionService().register(channel, new AcceptHandler(channel));
                    }
                    catch (IOException e) {
                        AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeExceptionRecord(Level.SEVERE, e, "{0} bus acceptor could not be reopened", AbstractSocketBus.this.getLocalEndPoint()));
                        AbstractSocketBus.this.close();
                    }
                }
                return 0;
            }
        }
    }

    private class HandshakeHandler
    extends SafeSelectionHandler<SocketChannel> {
        Connection connection;
        public HandshakePhase phase;
        public ByteBuffer headerOut;
        public ByteBuffer headerIn;

        public HandshakeHandler(SocketChannel channel, Connection connection) {
            super(channel);
            this.phase = HandshakePhase.IDENTIFY;
            this.connection = connection;
            byte[] abName = AbstractSocketBus.this.getLocalEndPoint().getCanonicalName().getBytes();
            this.headerIn = ByteBuffer.allocate(10);
            this.headerOut = ByteBuffer.allocate(10 + abName.length);
            this.headerOut.putInt(AbstractSocketBus.this.getProtocolIdentifier()).putShort(AbstractSocketBus.this.getMinimumProtocolVersion()).putShort(AbstractSocketBus.this.getMaximumProtocolVersion()).putShort((short)abName.length).put(abName).flip();
        }

        @Override
        public int onReadySafe(int nOps) throws IOException {
            SocketChannel channel = (SocketChannel)this.getChannel();
            int nInterest = 0;
            if (channel.isConnectionPending()) {
                try {
                    if (!channel.finishConnect()) {
                        return 8;
                    }
                    AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeRecord(Level.FINEST, "{0} socket connected for {1} on {2}", AbstractSocketBus.this.getLocalEndPoint(), this.connection.getPeer(), channel.socket()));
                }
                catch (SocketException e) {
                    this.connection.onSocketConnectException(e);
                    return 0;
                }
            }
            channel.write(this.headerOut);
            if ((nOps & 1) != 0 && channel.read(this.headerIn) < 0) {
                this.close(new IOException("InputShutdown"));
                return 0;
            }
            if (this.headerIn.hasRemaining()) {
                nInterest = 1;
            }
            if (this.headerOut.hasRemaining()) {
                nInterest |= 4;
            }
            if (nInterest == 0) {
                AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeRecord(Level.FINEST, "{0} moving to handshake phase {1} for {2} on {3}", new Object[]{AbstractSocketBus.this.getLocalEndPoint(), this.phase, this.connection == null ? null : this.connection.getPeer(), channel.socket()}));
                switch (this.phase) {
                    case IDENTIFY: {
                        nInterest = this.onIdentify();
                        break;
                    }
                    case INTRODUCE: {
                        nInterest = this.onIntroduce();
                        break;
                    }
                    case ACCEPT: {
                        nInterest = this.onAccept();
                        break;
                    }
                    default: {
                        nInterest = this.onAbandon();
                    }
                }
            }
            return nInterest;
        }

        @Override
        public int onException(Throwable t) {
            AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeExceptionRecord(Level.FINER, t, "{0} exception during handshake for {1} on {2}", AbstractSocketBus.this.getLocalEndPoint(), this.connection == null ? null : this.connection.getPeer(), ((SocketChannel)this.getChannel()).socket()));
            this.close(t);
            return 0;
        }

        public int onIdentify() {
            this.headerIn.flip();
            int nId = this.headerIn.getInt();
            int nIdReq = AbstractSocketBus.this.getProtocolIdentifier();
            if (nId != nIdReq) {
                if (nId >>> 8 == (nIdReq & 0xFFFFFF)) {
                    nId = nIdReq;
                    this.headerIn.position(3);
                } else {
                    AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeRecord(Level.WARNING, "{0} rejecting connection from {1} using incompatible protocol id {2}, required {3}", AbstractSocketBus.this.getLocalEndPoint(), ((SocketChannel)this.getChannel()).socket().getInetAddress(), nId, nIdReq));
                    this.close(new IOException("incompatible protocol"));
                    return 0;
                }
            }
            short nMin = this.headerIn.getShort();
            short nMax = this.headerIn.getShort();
            if (nMin > AbstractSocketBus.this.getMaximumProtocolVersion() || nMax < AbstractSocketBus.this.getMinimumProtocolVersion()) {
                AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeRecord(Level.WARNING, "{0} rejecting connection from {1} using unsupported protocol {2} version ({3} ... {4}), supported ({5} ... {6})", AbstractSocketBus.this.getLocalEndPoint(), ((SocketChannel)this.getChannel()).socket().getInetAddress(), nId, nMin, nMax, AbstractSocketBus.this.getMinimumProtocolVersion(), AbstractSocketBus.this.getMaximumProtocolVersion()));
                this.close(new IOException("protocol version mismatch"));
                return 0;
            }
            this.headerIn = ByteBuffer.allocate(this.headerIn.getShort()).put(this.headerIn);
            this.phase = HandshakePhase.INTRODUCE;
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int onIntroduce() throws IOException {
            int nInterest;
            UrlEndPoint peer = AbstractSocketBus.this.m_driver.resolveSocketEndPoint(new String(this.headerIn.array()));
            if (this.connection == null) {
                Connection connNew = AbstractSocketBus.this.makeConnection(peer);
                connNew.m_channel = (SocketChannel)this.getChannel();
                Connection connection = connNew;
                synchronized (connection) {
                    Connection connOld;
                    Lock lock = AbstractSocketBus.this.m_lockState.readLock();
                    lock.lock();
                    try {
                        BusState nStateCurr = AbstractSocketBus.this.m_nState;
                        if (nStateCurr != BusState.OPEN) {
                            this.close(null);
                            int n = 0;
                            return n;
                        }
                        connOld = AbstractSocketBus.this.m_mapConnections.putIfAbsent(peer, connNew);
                        if (connOld == null) {
                            this.connection = connNew;
                            this.connection.open();
                        }
                    }
                    finally {
                        lock.unlock();
                    }
                    if (connOld == null) {
                        nInterest = 5;
                    } else {
                        Connection connection2 = connOld;
                        synchronized (connection2) {
                            switch (connOld.m_state) {
                                case OPEN: {
                                    EndPoint self = AbstractSocketBus.this.getLocalEndPoint();
                                    if (self.getCanonicalName().compareTo(peer.getCanonicalName()) < 0) {
                                        AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeRecord(Level.FINER, "{0} wins simultaneous connect with {1} on {2}", self, peer, ((SocketChannel)this.getChannel()).socket()));
                                        this.phase = HandshakePhase.ABANDON;
                                        this.headerIn.clear().limit(2);
                                        this.headerOut.clear().flip();
                                        return 1;
                                    }
                                    AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeRecord(Level.FINER, "{0} loses simultaneous connect with {1} on {2}", self, peer, ((SocketChannel)this.getChannel()).socket()));
                                    this.connection = connOld;
                                    connOld.m_channel.close();
                                    connOld.m_channel = (SocketChannel)this.getChannel();
                                    nInterest = 5;
                                    break;
                                }
                                case ACTIVE: 
                                case DEFUNCT: {
                                    if (connOld.m_next != null) {
                                        AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeRecord(Level.FINE, "{0} rejecting reconnect attempt from {1} on {2}, pending release", AbstractSocketBus.this.getLocalEndPoint(), peer, ((SocketChannel)this.getChannel()).socket()));
                                        connOld.m_next.close(null);
                                    }
                                    this.connection = connNew;
                                    connOld.m_next = this;
                                    nInterest = 0;
                                    break;
                                }
                                case FINAL: {
                                    return 4;
                                }
                                default: {
                                    throw new IllegalStateException("state = " + (Object)((Object)connOld.m_state));
                                }
                            }
                        }
                    }
                }
            } else if (!((Object)this.connection.getPeer()).equals(peer)) {
                AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeRecord(Level.WARNING, "{0} Out-bound connection to {1}, found {2}, single connection pair cannot be ensured", AbstractSocketBus.this.getLocalEndPoint(), this.connection.getPeer(), peer));
                nInterest = 5;
            } else {
                nInterest = 5;
            }
            this.phase = HandshakePhase.ACCEPT;
            this.headerIn.clear().limit(1);
            this.headerOut.clear();
            this.headerOut.put((byte)0).flip();
            return nInterest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int onAccept() throws IOException {
            Connection connection = this.connection;
            synchronized (connection) {
                if (this.connection.m_state != ConnectionState.OPEN) {
                    throw new IllegalStateException("state = " + (Object)((Object)this.connection.m_state));
                }
                this.connection.m_state = ConnectionState.ACTIVE;
                AbstractSocketBus.this.getSelectionService().register((SelectableChannel)this.getChannel(), this.connection);
            }
            return 0;
        }

        public int onAbandon() {
            this.close(new IOException("protocol error"));
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close(Throwable eReason) {
            SocketChannel channel = (SocketChannel)this.getChannel();
            if (this.connection != null) {
                Connection connection = this.connection;
                synchronized (connection) {
                    if (this.connection.m_channel == channel && this.connection.isValid()) {
                        this.connection.scheduleDisconnect(eReason);
                        return;
                    }
                }
            }
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected abstract class Connection
    implements SelectionService.Handler,
    GatheringByteChannel,
    ScatteringByteChannel {
        private final UrlEndPoint m_peer;
        private volatile ConnectionState m_state;
        private SocketChannel m_channel;
        private final Queue<Object> m_queueReceipts = new ConcurrentLinkedQueue<Object>();
        private HandshakeHandler m_next;

        public Connection(UrlEndPoint peer) {
            this.m_peer = peer;
        }

        private void open() {
            if (this.m_state != null) {
                throw new IllegalStateException("state = " + (Object)((Object)this.m_state));
            }
            this.m_state = ConnectionState.OPEN;
            UrlEndPoint peer = this.m_peer;
            if (this.m_channel == null) {
                AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeRecord(Level.FINER, "{0} opening connection with {1}", AbstractSocketBus.this.getLocalEndPoint(), peer));
            } else {
                AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeRecord(Level.FINER, "{0} opening unsolicited connection with {1} on {2}", AbstractSocketBus.this.getLocalEndPoint(), peer, this.m_channel.socket()));
            }
            AbstractSocketBus.this.emitEvent(new SimpleEvent(Event.Type.CONNECT, peer));
        }

        protected boolean isValid() {
            return this.m_state != null && this.m_state != ConnectionState.FINAL;
        }

        protected Connection ensureValid() {
            if (this.isValid()) {
                return this;
            }
            throw new IllegalArgumentException("connection to " + this.m_peer + " is not open");
        }

        private void connect() throws IOException {
            if (this.m_state != ConnectionState.OPEN) {
                throw new IllegalStateException("state = " + (Object)((Object)this.m_state));
            }
            if (this.m_channel != null && this.m_channel.isOpen()) {
                throw new IllegalStateException();
            }
            SocketChannel channel = this.m_channel = AbstractSocketBus.this.getSocketDriver().getDependencies().getSocketProvider().openSocketChannel();
            channel.configureBlocking(false);
            AbstractSocketBus.this.configureSocket(channel.socket());
            try {
                channel.connect(this.m_peer.getAddress());
                AbstractSocketBus.this.getSelectionService().register(channel, new HandshakeHandler(channel, this));
            }
            catch (SocketException e) {
                this.onSocketConnectException(e);
            }
        }

        public void onSocketConnectException(SocketException eReason) {
            AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeExceptionRecord(Level.FINE, eReason, "{0} connect attempt to {1} failed with {2}, retrying", AbstractSocketBus.this.getLocalEndPoint(), this.m_peer, eReason.getMessage()));
            try {
                this.m_channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            AbstractSocketBus.scheduleTask(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Connection connection = Connection.this;
                        synchronized (connection) {
                            if (Connection.this.m_state == ConnectionState.OPEN) {
                                Connection.this.connect();
                            }
                        }
                    }
                    catch (Exception e) {
                        Connection.this.scheduleDisconnect(e);
                    }
                }
            }, AbstractSocketBus.this.m_driver.getDependencies().getSocketReconnectDelayMillis(), false);
        }

        protected void scheduleDisconnect(Throwable eReason) {
            this.scheduleShutdown(eReason, false);
        }

        protected void scheduleShutdown(final Throwable eReason, final boolean fRelease) {
            this.invoke(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        HandshakeHandler handlerNext;
                        try {
                            Connection.this.m_channel.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        UrlEndPoint peer = Connection.this.m_peer;
                        boolean fEmitDisconnect = false;
                        Connection connection = Connection.this;
                        synchronized (connection) {
                            handlerNext = Connection.this.m_next;
                            switch (Connection.this.m_state) {
                                case OPEN: 
                                case ACTIVE: {
                                    fEmitDisconnect = true;
                                    Connection.this.m_state = ConnectionState.DEFUNCT;
                                }
                                case DEFUNCT: {
                                    if (!fRelease) break;
                                    Connection.this.m_next = null;
                                    Connection.this.m_state = ConnectionState.FINAL;
                                    break;
                                }
                                case FINAL: {
                                    return;
                                }
                                default: {
                                    throw new IllegalStateException("state = " + (Object)((Object)Connection.this.m_state));
                                }
                            }
                        }
                        if (fEmitDisconnect) {
                            AbstractSocketBus.this.addEvent(new SimpleEvent(Event.Type.DISCONNECT, peer, eReason));
                        }
                        Queue queue = Connection.this.m_queueReceipts;
                        for (Object receipt : queue) {
                            AbstractSocketBus.this.addEvent(new SimpleEvent(Event.Type.RECEIPT, peer, receipt));
                        }
                        queue.clear();
                        if (fRelease) {
                            Lock lockRead = AbstractSocketBus.this.m_lockState.readLock();
                            if (handlerNext != null && !((SocketChannel)handlerNext.getChannel()).socket().isInputShutdown() && lockRead.tryLock()) {
                                try {
                                    Object receipt;
                                    receipt = handlerNext.connection;
                                    synchronized (receipt) {
                                        AbstractSocketBus.this.m_mapConnections.replace(peer, handlerNext.connection);
                                        AbstractSocketBus.this.addEvent(new SimpleEvent(Event.Type.RELEASE, peer));
                                        Connection.this.onReleased();
                                        handlerNext.connection.open();
                                        try {
                                            AbstractSocketBus.this.getSelectionService().register((SelectableChannel)handlerNext.getChannel(), handlerNext);
                                        }
                                        catch (IOException e) {
                                            handlerNext.connection.scheduleDisconnect(e);
                                        }
                                    }
                                }
                                finally {
                                    lockRead.unlock();
                                }
                                handlerNext = null;
                            } else {
                                AbstractSocketBus.this.m_mapConnections.remove(peer);
                                AbstractSocketBus.this.addEvent(new SimpleEvent(Event.Type.RELEASE, peer));
                                Connection.this.onReleased();
                            }
                            if (handlerNext != null) {
                                try {
                                    ((SocketChannel)handlerNext.getChannel()).close();
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            Connection connection2 = Connection.this;
                            synchronized (connection2) {
                                Connection.this.notifyAll();
                            }
                        }
                        AbstractSocketBus.this.flushEvents();
                    }
                    catch (Exception e) {
                        AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeExceptionRecord(Level.SEVERE, e, "Unexpected Exception", new Object[0]));
                        throw new IllegalStateException(e);
                    }
                }
            });
        }

        public abstract void onReleased();

        protected abstract void signal(Object var1);

        protected abstract void flush();

        protected boolean wakeup() throws IOException {
            if (this.m_state.ordinal() >= ConnectionState.ACTIVE.ordinal()) {
                AbstractSocketBus.this.getSelectionService().register(this.m_channel, this);
                return true;
            }
            return false;
        }

        protected int getSendBufferSize() throws SocketException {
            SocketChannel chan = this.m_channel;
            if (chan == null) {
                return -1;
            }
            return chan.socket().getSendBufferSize();
        }

        protected int getReceiveBufferSize() throws SocketException {
            SocketChannel chan = this.m_channel;
            if (chan == null) {
                return -1;
            }
            return chan.socket().getReceiveBufferSize();
        }

        public void addReceipt(Object oReceipt) {
            if (this.m_state == ConnectionState.FINAL) {
                throw new IllegalArgumentException("peer has been released");
            }
            if (oReceipt == null) {
                throw new IllegalArgumentException("receipt cannot be null");
            }
            this.m_queueReceipts.add(oReceipt);
        }

        public Event removeReceipt() {
            Object oReceipt = this.m_queueReceipts.poll();
            if (oReceipt == null) {
                throw new IllegalStateException("insufficient receipts");
            }
            return new SimpleEvent(Event.Type.RECEIPT, this.m_peer, oReceipt);
        }

        public void returnReceipts(int c) {
            if (c > 0) {
                Queue<Object> queue = this.m_queueReceipts;
                UrlEndPoint peer = this.m_peer;
                while (c-- > 0) {
                    Object oReceipt = queue.poll();
                    if (oReceipt == null) {
                        throw new IllegalStateException("insufficient receipts");
                    }
                    AbstractSocketBus.this.addEvent(new SimpleEvent(Event.Type.RECEIPT, peer, oReceipt));
                }
            }
        }

        public EndPoint getPeer() {
            return this.m_peer;
        }

        protected void invoke(Runnable runnable) {
            try {
                AbstractSocketBus.this.getSelectionService().invoke(this.m_channel, runnable);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() throws IOException {
            this.scheduleDisconnect(null);
        }

        @Override
        public boolean isOpen() {
            return this.m_state.ordinal() < ConnectionState.FINAL.ordinal();
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            switch (this.m_state) {
                case OPEN: {
                    return 0L;
                }
                case ACTIVE: {
                    long cb;
                    SocketChannel chan = this.m_channel;
                    long cbWrite = 0L;
                    do {
                        cb = chan.write(srcs, offset, length);
                        cbWrite += cb;
                        while (cb != 0L && length > 0 && !srcs[offset].hasRemaining()) {
                            ++offset;
                            --length;
                        }
                    } while (cb != 0L && length > 0);
                    return cbWrite;
                }
            }
            throw new ClosedChannelException();
        }

        @Override
        public long write(ByteBuffer[] srcs) throws IOException {
            switch (this.m_state) {
                case OPEN: {
                    return 0L;
                }
                case ACTIVE: {
                    return this.write(srcs, 0, srcs.length);
                }
            }
            throw new ClosedChannelException();
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            switch (this.m_state) {
                case OPEN: {
                    return 0;
                }
                case ACTIVE: {
                    return this.m_channel.write(src);
                }
            }
            throw new ClosedChannelException();
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            switch (this.m_state) {
                case OPEN: {
                    return 0L;
                }
                case ACTIVE: {
                    return this.m_channel.read(dsts, offset, length);
                }
            }
            return -1L;
        }

        @Override
        public long read(ByteBuffer[] dsts) throws IOException {
            switch (this.m_state) {
                case OPEN: {
                    return 0L;
                }
                case ACTIVE: {
                    return this.read(dsts, 0, dsts.length);
                }
            }
            return -1L;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            switch (this.m_state) {
                case OPEN: {
                    return 0;
                }
                case ACTIVE: {
                    return this.m_channel.read(dst);
                }
            }
            return -1;
        }

        protected abstract int onReadySafe(int var1) throws IOException;

        protected int onException(Throwable t) {
            this.scheduleDisconnect(t);
            return 0;
        }

        @Override
        public final int onReady(int nOps) {
            try {
                return this.onReadySafe(nOps);
            }
            catch (Throwable t) {
                return this.onException(t);
            }
        }

        public String toString() {
            return "Peer=" + this.getPeer() + ", State=" + (Object)((Object)this.m_state) + ", Socket=" + this.m_channel.socket() + ", Receipts=" + this.m_queueReceipts.size();
        }
    }

    protected static enum HandshakePhase {
        IDENTIFY,
        INTRODUCE,
        ACCEPT,
        ABANDON;

    }

    protected static enum ConnectionState {
        OPEN,
        ACTIVE,
        DEFUNCT,
        FINAL;

    }
}

