/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.internal.net.socketbus;

import com.oracle.common.base.Disposable;
import com.oracle.common.internal.net.socketbus.AbstractSocketBus;
import com.oracle.common.internal.net.socketbus.BufferedSocketBus;
import com.oracle.common.internal.net.socketbus.MultiBufferMessageEvent;
import com.oracle.common.internal.net.socketbus.SharedBuffer;
import com.oracle.common.internal.net.socketbus.SingleBufferMessageEvent;
import com.oracle.common.internal.net.socketbus.SocketBusDriver;
import com.oracle.common.io.BufferManager;
import com.oracle.common.io.BufferSequence;
import com.oracle.common.io.BufferSequenceInputStream;
import com.oracle.common.net.exabus.EndPoint;
import com.oracle.common.net.exabus.Event;
import com.oracle.common.net.exabus.MessageBus;
import com.oracle.common.net.exabus.util.SimpleEvent;
import com.oracle.common.net.exabus.util.UrlEndPoint;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class SocketMessageBus
extends BufferedSocketBus
implements MessageBus {
    protected final AtomicLong m_cBacklogLocal = new AtomicLong(0L);
    protected static final int MSG_HEADER_SIZE = 4;
    protected static final int READ_AHEAD_SIZE = 65536;

    public SocketMessageBus(SocketBusDriver driver, UrlEndPoint pointLocal) throws IOException {
        super(driver, pointLocal);
    }

    @Override
    protected String getProtocolName() {
        return this.getSocketDriver().getDependencies().getMessageBusProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(EndPoint peer, BufferSequence bufseq, Object receipt) {
        MessageConnection conn;
        MessageConnection messageConnection = conn = (MessageConnection)this.ensureConnection(peer);
        synchronized (messageConnection) {
            conn.ensureValid();
            boolean fFlushReq = conn.isFlushRequired();
            conn.send(bufseq, receipt);
            if (fFlushReq != conn.isFlushRequired()) {
                if (fFlushReq) {
                    this.removeFlushable(conn);
                } else {
                    this.addFlushable(conn);
                }
            }
        }
    }

    @Override
    protected AbstractSocketBus.Connection makeConnection(UrlEndPoint peer) {
        return new MessageConnection(peer);
    }

    public class MessageConnection
    extends BufferedSocketBus.BufferedConnection {
        protected final ReadBatch m_readBatch;
        protected long m_cbReadThreshold;
        protected final AtomicLong m_cbEventQueue;
        protected volatile boolean m_fBacklogLocal;
        protected ByteBuffer m_bufferMsgHdr;

        public MessageConnection(UrlEndPoint peer) {
            super(peer);
            this.m_readBatch = new ReadBatch();
            this.m_cbEventQueue = new AtomicLong();
            this.m_bufferMsgHdr = SocketMessageBus.this.getSocketDriver().getDependencies().getBufferManager().acquire(4096);
        }

        protected long getReadThrottleThreshold() {
            long cb = this.m_cbReadThreshold;
            if (cb <= 0L) {
                try {
                    this.m_cbReadThreshold = cb = (long)(this.getReceiveBufferSize() * 8);
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                if (cb <= 0L) {
                    cb = 65536L;
                }
            }
            return cb;
        }

        @Override
        protected boolean processReads(boolean fReady) throws IOException {
            boolean fAllow;
            boolean bl = fAllow = this.m_cbEventQueue.get() < this.getReadThrottleThreshold();
            if (fReady && fAllow) {
                this.m_readBatch.read();
            }
            return fAllow;
        }

        @Override
        public void onReleased() {
            super.onReleased();
            this.m_readBatch.dispose();
            SocketMessageBus.this.getSocketDriver().getDependencies().getBufferManager().release(this.m_bufferMsgHdr);
        }

        public void send(BufferSequence bufseq, Object receipt) {
            ByteBuffer bufferMsgHdr;
            long cbMsg = bufseq.getLength();
            if (cbMsg < 0L || cbMsg > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("unsupported message size " + cbMsg);
            }
            BufferedSocketBus.BufferedConnection.WriteBatch batch = this.m_writeBatchUnflushed;
            if (batch == null) {
                batch = this.m_writeBatchUnflushed = new BufferedSocketBus.BufferedConnection.WriteBatch();
            }
            if ((bufferMsgHdr = this.m_bufferMsgHdr).remaining() > 4) {
                ByteBuffer buffLength = bufferMsgHdr.slice();
                buffLength.putInt((int)cbMsg).flip();
                bufferMsgHdr.position(bufferMsgHdr.position() + 4);
                batch.append(buffLength, false);
            } else {
                bufferMsgHdr.mark();
                bufferMsgHdr.putInt((int)cbMsg).reset();
                batch.append(bufferMsgHdr, true);
                this.m_bufferMsgHdr = SocketMessageBus.this.getSocketDriver().getDependencies().getBufferManager().acquire(bufferMsgHdr.limit());
            }
            batch.append(bufseq);
            if (receipt != null) {
                this.addReceipt(receipt);
                ++this.m_cReceiptsUnflushed;
            }
            if (batch.getLength() > this.getAutoFlushThreshold()) {
                this.flush(true);
            }
        }

        public void onMessageDispose(BufferSequence bufseq) {
            long cbCur;
            AtomicLong atomicCb = this.m_cbEventQueue;
            long cbSeq = bufseq.getLength();
            while (!atomicCb.compareAndSet(cbCur = atomicCb.get(), Math.max(0L, cbCur - cbSeq))) {
            }
        }

        public class ReadBatch
        implements Disposable {
            protected ByteBuffer[] m_aBuffer = new ByteBuffer[2];
            protected int m_ofWritable;
            protected int m_cBufferWritable;
            protected long m_cbWritable;
            protected int m_ofReadable;
            protected long m_cbReadable;
            protected long m_cbRequired = 4L;
            protected boolean m_fHeader = true;
            protected SharedBuffer m_bufferShared;
            protected final SharedBuffer.Disposer m_disposer = new SharedBufferDisposer();
            protected final AtomicReference<ByteBuffer> m_refBufferRecycledInbound = new AtomicReference();

            public ByteBuffer[] ensureCapacity(long cb) {
                BufferManager manager = SocketMessageBus.this.getSocketDriver().getDependencies().getBufferManager();
                Object[] aBuffer = this.m_aBuffer;
                int ofReadable = this.m_ofReadable;
                int ofWritable = this.m_ofWritable;
                long cbWritable = this.m_cbWritable;
                int cBufferWritable = this.m_cBufferWritable;
                int cBuffer = aBuffer.length;
                long cbAlloc = cb - cbWritable;
                while (cbAlloc > 0L) {
                    int ofAlloc;
                    int ofEnd = ofWritable + cBufferWritable;
                    if (ofEnd < cBuffer && aBuffer[ofEnd] == null) {
                        ofAlloc = ofEnd;
                    } else if (ofEnd + 1 < cBuffer) {
                        ofAlloc = ofEnd + 1;
                    } else if (ofReadable > 0) {
                        ofAlloc = ofEnd - ofReadable;
                        System.arraycopy(aBuffer, ofReadable, aBuffer, 0, ofAlloc);
                        Arrays.fill(aBuffer, ofAlloc, ofAlloc + ofReadable, null);
                        ofWritable -= ofReadable;
                        ofEnd -= ofReadable;
                        ofReadable = 0;
                    } else {
                        ByteBuffer[] aBufferNew = new ByteBuffer[cBuffer * 2];
                        System.arraycopy(aBuffer, 0, aBufferNew, 0, cBuffer);
                        aBuffer = aBufferNew;
                        ofAlloc = cBuffer;
                        cBuffer = aBuffer.length;
                    }
                    long cbStop = cbWritable + cbAlloc + 65536L;
                    AtomicReference<ByteBuffer> refBuffer = this.m_refBufferRecycledInbound;
                    for (int i = ofAlloc; i < cBuffer && cbWritable < cbStop; ++i) {
                        ByteBuffer buff = refBuffer.getAndSet(null);
                        if (buff == null) {
                            buff = manager.acquirePref((int)Math.min(Integer.MAX_VALUE, 65536L + cbAlloc));
                        }
                        buff.clear().mark();
                        int cbBuff = buff.remaining();
                        cbAlloc -= Math.min((long)cbBuff, cbAlloc);
                        cbWritable += (long)cbBuff;
                        ++cBufferWritable;
                        aBuffer[i] = buff;
                    }
                }
                this.m_aBuffer = aBuffer;
                this.m_ofReadable = ofReadable;
                this.m_ofWritable = ofWritable;
                this.m_cbWritable = cbWritable;
                this.m_cBufferWritable = cBufferWritable;
                return aBuffer;
            }

            @Override
            public void dispose() {
                int of = this.m_ofReadable;
                SharedBuffer buffShared = this.m_bufferShared;
                ByteBuffer[] aBuffer = this.m_aBuffer;
                ByteBuffer buffer0 = aBuffer[of];
                AtomicReference<ByteBuffer> refBuffer = this.m_refBufferRecycledInbound;
                if (buffShared != null && buffShared.get() == buffer0) {
                    buffShared.dispose();
                    ++of;
                }
                BufferManager manager = SocketMessageBus.this.getSocketDriver().getDependencies().getBufferManager();
                int c = this.m_ofWritable + this.m_cBufferWritable;
                while (of < c) {
                    manager.release(aBuffer[of]);
                    ++of;
                }
                ByteBuffer buf = refBuffer.get();
                if (buf != null) {
                    manager.release(buf);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void read() throws IOException {
                int cBuffer;
                int of;
                long cbAlloc = Math.abs(this.m_cbRequired) - this.m_cbWritable;
                ByteBuffer[] aBuffer = cbAlloc > 0L ? this.ensureCapacity(cbAlloc) : this.m_aBuffer;
                long cb = MessageConnection.this.read(aBuffer, of = this.m_ofWritable, cBuffer = this.m_cBufferWritable);
                if (cb > 0L) {
                    while (cBuffer > 0 && !aBuffer[of].hasRemaining()) {
                        aBuffer[of].reset();
                        ++of;
                        --cBuffer;
                    }
                    this.m_ofWritable = of;
                    this.m_cBufferWritable = cBuffer;
                    this.m_cbWritable -= cb;
                    long cbReady = this.m_cbReadable += cb;
                    if (cbReady >= Math.abs(this.m_cbRequired)) {
                        if (cBuffer > 0 && aBuffer[of].position() > 0) {
                            ByteBuffer buffLast = aBuffer[of];
                            int iPosWrite = buffLast.position();
                            try {
                                buffLast.limit(iPosWrite).reset();
                                this.onReady();
                            }
                            finally {
                                buffLast.mark();
                                buffLast.limit(buffLast.capacity()).position(iPosWrite);
                            }
                        } else {
                            this.onReady();
                        }
                    }
                } else if (cb < 0L) {
                    MessageConnection.this.scheduleDisconnect(new IOException("input shutdown"));
                }
            }

            public void onReady() throws IOException {
                ByteBuffer[] aBuffer = this.m_aBuffer;
                int ofReadable = this.m_ofReadable;
                long cbReadable = this.m_cbReadable;
                long cbRequired = this.m_cbRequired;
                boolean fHeader = this.m_fHeader;
                SharedBuffer buffShared = this.m_bufferShared;
                BufferManager buffManager = SocketMessageBus.this.getSocketDriver().getDependencies().getBufferManager();
                SharedBuffer.Disposer disposer = this.m_disposer;
                Event eventLast = null;
                AtomicLong cbEvents = MessageConnection.this.m_cbEventQueue;
                while (cbReadable >= Math.abs(cbRequired)) {
                    BufferSequence event;
                    long cbEnd;
                    long cbMsg;
                    if (fHeader) {
                        int cbMsg2;
                        int of = ofReadable;
                        if (aBuffer[of].remaining() >= 4) {
                            cbMsg2 = aBuffer[of].getInt();
                        } else {
                            cbMsg2 = 0;
                            for (int n = 24; n >= 0; n -= 8) {
                                while (!aBuffer[of].hasRemaining()) {
                                    ++of;
                                }
                                cbMsg2 |= (aBuffer[of].get() & 0xFF) << n;
                            }
                        }
                        cbReadable -= 4L;
                        cbRequired = cbMsg2;
                        fHeader = false;
                    }
                    if (cbReadable < (cbMsg = Math.abs(cbRequired))) continue;
                    int ofEnd = ofReadable;
                    int cbBuf = aBuffer[ofEnd].remaining();
                    for (cbEnd = cbMsg; cbEnd > (long)cbBuf; cbEnd -= (long)cbBuf) {
                        cbBuf = aBuffer[++ofEnd].remaining();
                    }
                    int cBufferMsg = ofEnd - ofReadable + 1;
                    ByteBuffer bufferN = aBuffer[ofEnd];
                    int iLimitN = bufferN.limit();
                    bufferN.limit(bufferN.position() + (int)cbEnd);
                    ByteBuffer buffer0 = aBuffer[ofReadable];
                    if (buffShared == null) {
                        buffShared = new SharedBuffer(buffer0, disposer);
                    } else if (buffShared.get() != buffer0) {
                        buffShared.dispose();
                        buffShared = new SharedBuffer(buffer0, disposer);
                    }
                    switch (cBufferMsg) {
                        case 0: 
                        case 1: {
                            event = new SingleBufferMessageEvent(MessageConnection.this, buffShared.attach());
                            break;
                        }
                        default: {
                            ByteBuffer[] aBufferMsg = new ByteBuffer[cBufferMsg];
                            System.arraycopy(aBuffer, ofReadable + 1, aBufferMsg, 1, cBufferMsg - 2);
                            aBufferMsg[0] = buffer0;
                            SharedBuffer buffShared0 = buffShared;
                            buffShared = new SharedBuffer(bufferN, disposer);
                            aBufferMsg[cBufferMsg - 1] = bufferN.slice();
                            event = new MultiBufferMessageEvent(MessageConnection.this, buffManager, aBufferMsg, 0, cBufferMsg, cbMsg, buffShared0.attach(), buffShared.attach());
                            buffShared0.dispose();
                        }
                    }
                    cbEvents.addAndGet(((BufferSequence)event).getLength());
                    if (cbRequired < 0L) {
                        eventLast = this.onControlMessage((Event)((Object)event), eventLast);
                    } else if (eventLast == null) {
                        eventLast = event;
                    } else {
                        SocketMessageBus.this.addEvent(eventLast);
                        eventLast = event;
                    }
                    bufferN.position(bufferN.limit()).limit(iLimitN);
                    while (ofReadable < ofEnd) {
                        aBuffer[ofReadable] = null;
                        ++ofReadable;
                    }
                    cbReadable -= cbMsg;
                    fHeader = true;
                    cbRequired = 4L;
                }
                if (eventLast != null) {
                    this.onLastEvent(eventLast);
                }
                this.m_ofReadable = ofReadable;
                this.m_cbReadable = cbReadable;
                this.m_cbRequired = cbRequired;
                this.m_fHeader = fHeader;
                this.m_bufferShared = buffShared;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Event issueLocalBacklog(Event event) {
                long cCur;
                MessageConnection.this.m_fBacklogLocal = true;
                final AtomicLong cBacklogLocal = SocketMessageBus.this.m_cBacklogLocal;
                do {
                    if ((cCur = cBacklogLocal.get()) > 1L) continue;
                    AtomicLong atomicLong = cBacklogLocal;
                    synchronized (atomicLong) {
                        cCur = cBacklogLocal.get();
                        if (cCur == 0L) {
                            SocketMessageBus.this.addEvent(event);
                            event = new SimpleEvent(Event.Type.BACKLOG_EXCESSIVE, SocketMessageBus.this.getLocalEndPoint());
                            cBacklogLocal.set(1L);
                            break;
                        }
                        if (cCur == 1L) {
                            cBacklogLocal.set(2L);
                            break;
                        }
                    }
                } while (!cBacklogLocal.compareAndSet(cCur, cCur + 1L));
                return new TaskEvent(event, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            long cCur;
                            do {
                                if ((cCur = cBacklogLocal.get()) != 1L) continue;
                                AtomicLong atomicLong = cBacklogLocal;
                                synchronized (atomicLong) {
                                    cCur = cBacklogLocal.get();
                                    if (cCur == 1L) {
                                        SocketMessageBus.this.emitEvent(new SimpleEvent(Event.Type.BACKLOG_NORMAL, SocketMessageBus.this.getLocalEndPoint()));
                                        cBacklogLocal.set(0L);
                                        break;
                                    }
                                }
                            } while (!cBacklogLocal.compareAndSet(cCur, cCur - 1L));
                            MessageConnection.this.m_fBacklogLocal = false;
                            MessageConnection.this.m_cbEventQueue.set(0L);
                            MessageConnection.this.wakeup();
                        }
                        catch (IOException e) {
                            MessageConnection.this.scheduleDisconnect(e);
                        }
                    }
                });
            }

            public void onLastEvent(Event event) {
                if (!MessageConnection.this.m_fBacklogLocal && MessageConnection.this.m_cbEventQueue.get() > MessageConnection.this.getReadThrottleThreshold() * 2L / 3L) {
                    event = this.issueLocalBacklog(event);
                }
                SocketMessageBus.this.emitEvent(event);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Event onControlMessage(Event event, Event eventLast) throws IOException {
                try {
                    if (event.getType() != Event.Type.MESSAGE) {
                        throw new IllegalStateException("unexpected control event: " + event);
                    }
                    BufferSequenceInputStream in = new BufferSequenceInputStream((BufferSequence)event.getContent());
                    byte nType = in.readByte();
                    switch (nType) {
                        case 0: {
                            if (eventLast != null) {
                                SocketMessageBus.this.emitEvent(eventLast);
                            }
                            SimpleEvent simpleEvent = new SimpleEvent(Event.Type.SIGNAL, MessageConnection.this.getPeer());
                            return simpleEvent;
                        }
                        case 1: {
                            int cReturned;
                            int cReceiptsRequested = in.readInt();
                            if (cReceiptsRequested < 0) {
                                MessageConnection.this.m_cReceiptsReturn.addAndGet(-cReceiptsRequested);
                                if (MessageConnection.this.isReceiptFlushRequired()) {
                                    MessageConnection messageConnection = MessageConnection.this;
                                    synchronized (messageConnection) {
                                        MessageConnection.this.flush();
                                    }
                                }
                            } else {
                                MessageConnection.this.m_cReceiptsReturn.addAndGet(cReceiptsRequested);
                            }
                            if ((cReturned = in.readInt()) > 0) {
                                MessageConnection.this.m_cBytesUnacked.set(0L);
                                if (eventLast != null) {
                                    SocketMessageBus.this.emitEvent(eventLast);
                                }
                            }
                            switch (cReturned) {
                                default: {
                                    MessageConnection.this.returnReceipts(cReturned - 1);
                                }
                                case 1: {
                                    Event event2 = MessageConnection.this.removeReceipt();
                                    return event2;
                                }
                                case 0: 
                            }
                            Event event3 = eventLast;
                            return event3;
                        }
                    }
                    throw new IllegalStateException("unexpected control message type: " + nType);
                }
                finally {
                    event.dispose();
                }
            }

            protected class SharedBufferDisposer
            implements SharedBuffer.Disposer {
                protected SharedBufferDisposer() {
                }

                @Override
                public void dispose(ByteBuffer buffer) {
                    AtomicReference<ByteBuffer> bufferRef = ReadBatch.this.m_refBufferRecycledInbound;
                    if (!bufferRef.compareAndSet(null, buffer)) {
                        SocketMessageBus.this.getSocketDriver().getDependencies().getBufferManager().release(buffer);
                    }
                }
            }

            public class TaskEvent
            implements Event {
                private final Event m_event;
                private final Runnable[] m_aTask;

                public TaskEvent(Event event, Runnable ... aTask) {
                    this.m_event = event;
                    this.m_aTask = aTask;
                }

                @Override
                public Event.Type getType() {
                    return this.m_event.getType();
                }

                @Override
                public EndPoint getEndPoint() {
                    return this.m_event.getEndPoint();
                }

                @Override
                public Object getContent() {
                    return this.m_event.getContent();
                }

                @Override
                public void dispose() {
                    this.m_event.dispose();
                    for (Runnable task : this.m_aTask) {
                        task.run();
                    }
                }

                public String toString() {
                    return this.m_event.toString();
                }
            }
        }
    }
}

