/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.io;

import com.oracle.common.io.BufferSequence;
import com.oracle.common.io.BufferSequenceInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class Buffers {
    public static ByteBuffer[] getEmptyBufferArray() {
        return EmptyBufferArray.INSTANCE;
    }

    public static BufferSequence getEmptyBufferSequence() {
        return EmptySequenceHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean equals(BufferSequence bufseqA, BufferSequence bufseqB) {
        if (bufseqA == bufseqB) {
            return true;
        }
        if (bufseqA == null || bufseqB == null) {
            return false;
        }
        long cb = bufseqA.getLength();
        if (cb == bufseqB.getLength()) {
            if (bufseqA.getBufferCount() == 1 && bufseqB.getBufferCount() == 1) {
                return bufseqA.getBuffer(0).equals(bufseqB.getBuffer(0));
            }
            BufferSequenceInputStream streamA = new BufferSequenceInputStream(bufseqA);
            BufferSequenceInputStream streamB = new BufferSequenceInputStream(bufseqB);
            try {
                while (cb > 0L && ((InputStream)streamA).read() == ((InputStream)streamB).read()) {
                    --cb;
                }
                boolean bl = cb == 0L;
                return bl;
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    ((InputStream)streamA).close();
                    ((InputStream)streamB).close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    private static class EmptySequenceHolder {
        public static BufferSequence INSTANCE = new BufferSequence(){

            @Override
            public long getLength() {
                return 0L;
            }

            @Override
            public int getBufferCount() {
                return 0;
            }

            @Override
            public ByteBuffer getBuffer(int iBuffer) {
                throw new IndexOutOfBoundsException();
            }

            @Override
            public ByteBuffer[] getBuffers() {
                return Buffers.getEmptyBufferArray();
            }

            @Override
            public void getBuffers(int iBuffer, int cBuffers, ByteBuffer[] abufDest, int iDest) {
                if (iBuffer < 0 || cBuffers != 0 || iDest >= abufDest.length) {
                    throw new IndexOutOfBoundsException();
                }
            }

            @Override
            public void dispose() {
            }
        };

        private EmptySequenceHolder() {
        }
    }

    private static class EmptyBufferArray {
        public static ByteBuffer[] INSTANCE = new ByteBuffer[0];

        private EmptyBufferArray() {
        }
    }
}

