/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.io;

import com.oracle.common.io.BufferManager;
import com.oracle.common.io.BufferSequence;
import java.nio.ByteBuffer;

public class SingleBufferSequence
implements BufferSequence {
    protected final BufferManager m_manager;
    protected ByteBuffer m_buffer;
    protected final int m_nPosition;
    protected final int m_nLimit;
    protected boolean m_fSafe = true;

    public SingleBufferSequence(BufferManager manager, ByteBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null");
        }
        this.m_manager = manager;
        this.m_buffer = buffer;
        this.m_nPosition = buffer.position();
        this.m_nLimit = buffer.limit();
    }

    @Override
    public long getLength() {
        return this.m_nLimit - this.m_nPosition;
    }

    @Override
    public int getBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer getBuffer(int iBuffer) {
        if (iBuffer == 0) {
            return this.getSafeBuffer();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuffer[] getBuffers() {
        return new ByteBuffer[]{this.getSafeBuffer()};
    }

    @Override
    public void getBuffers(int iBuffer, int cBuffers, ByteBuffer[] abufDest, int iDest) {
        if (iBuffer != 0 || cBuffers > 1) {
            throw new IndexOutOfBoundsException();
        }
        if (cBuffers == 1) {
            abufDest[iDest] = this.getSafeBuffer();
        }
    }

    @Override
    public void dispose() {
        ByteBuffer buff = this.m_buffer;
        this.m_buffer = null;
        if (buff == null) {
            throw new IllegalStateException("already disposed");
        }
        BufferManager manager = this.m_manager;
        if (manager != null) {
            manager.release(buff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ByteBuffer getSafeBuffer() {
        ByteBuffer buff = this.m_buffer;
        if (this.m_fSafe) {
            SingleBufferSequence singleBufferSequence = this;
            synchronized (singleBufferSequence) {
                if (this.m_fSafe) {
                    this.m_fSafe = false;
                    return buff;
                }
            }
        }
        buff = buff.duplicate();
        buff.limit(this.m_nLimit).position(this.m_nPosition);
        return buff;
    }
}

