/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.net;

import com.oracle.common.net.InetAddressComparator;
import com.oracle.common.net.InetSocketAddress32;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Comparator;

public class InetSocketAddressComparator
implements Comparator<SocketAddress> {
    public static final InetSocketAddressComparator INSTANCE = new InetSocketAddressComparator();

    @Override
    public int compare(SocketAddress addrA, SocketAddress addrB) {
        int n;
        if (addrA == addrB) {
            return 0;
        }
        if (addrA == null) {
            return -1;
        }
        if (addrB == null) {
            return 1;
        }
        InetAddress ipA = InetSocketAddressComparator.getAddress(addrA);
        InetAddress ipB = InetSocketAddressComparator.getAddress(addrB);
        if (ipA == null && ipB == null) {
            String sHostB;
            String sHostA = InetSocketAddressComparator.getHostName(addrA);
            n = sHostA == (sHostB = InetSocketAddressComparator.getHostName(addrB)) ? 0 : (sHostA == null ? -1 : (sHostB == null ? 1 : sHostA.compareTo(sHostB)));
        } else if (ipA != null && ipB != null) {
            n = InetAddressComparator.INSTANCE.compare(ipA, ipB);
        } else {
            throw new IllegalArgumentException("cannot compare resolved to unresolved addresses");
        }
        return n == 0 ? InetSocketAddressComparator.getPort(addrA) - InetSocketAddressComparator.getPort(addrB) : n;
    }

    static String getHostName(SocketAddress addr) {
        return addr instanceof InetSocketAddress ? ((InetSocketAddress)addr).getHostName() : ((InetSocketAddress32)addr).getHostName();
    }

    static InetAddress getAddress(SocketAddress addr) {
        return addr instanceof InetSocketAddress ? ((InetSocketAddress)addr).getAddress() : ((InetSocketAddress32)addr).getAddress();
    }

    static int getPort(SocketAddress addr) {
        return addr instanceof InetSocketAddress ? ((InetSocketAddress)addr).getPort() : ((InetSocketAddress32)addr).getPort();
    }
}

