/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.net.exabus.util;

import com.oracle.common.base.Hasher;
import com.oracle.common.net.SocketProvider;
import com.oracle.common.net.exabus.EndPoint;
import java.net.SocketAddress;

public class UrlEndPoint
implements EndPoint {
    public static final String PROTOCOL_DELIMITER = "://";
    private String m_sName;
    private String m_sProtocol;
    private SocketAddress m_address;
    private Hasher<? super SocketAddress> m_hasher;

    public UrlEndPoint(String sName, SocketProvider provider, Hasher<? super SocketAddress> hasher) {
        if (sName == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        int ofProtocolEnd = sName.indexOf(PROTOCOL_DELIMITER);
        if (ofProtocolEnd == -1) {
            throw new IllegalArgumentException("name does not contain a protocol");
        }
        String sProtocol = sName.substring(0, ofProtocolEnd);
        String sRemainder = sName.substring(ofProtocolEnd + PROTOCOL_DELIMITER.length());
        if (sRemainder.indexOf(47, ofProtocolEnd) != -1) {
            throw new IllegalArgumentException("URL paths are not supported");
        }
        this.m_sName = sName;
        this.m_sProtocol = sProtocol;
        this.m_hasher = hasher;
        this.m_address = provider.resolveAddress(sRemainder);
    }

    public SocketAddress getAddress() {
        return this.m_address;
    }

    public String getProtocol() {
        return this.m_sProtocol;
    }

    @Override
    public String getCanonicalName() {
        return this.m_sName;
    }

    @Override
    public int hashCode() {
        return this.getProtocol().hashCode() + this.m_hasher.hashCode(this.getAddress());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UrlEndPoint) {
            UrlEndPoint that = (UrlEndPoint)o;
            return this.getProtocol().equals(that.getProtocol()) && this.m_hasher.equals(this.getAddress(), that.getAddress());
        }
        return false;
    }

    public String toString() {
        return this.m_sName;
    }
}

