/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.net.socket.UdpSocket;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.Base;
import java.net.SocketAddress;

public class UdpPacket
extends Net {
    private int __m_MaximumBundleLength;
    private SocketAddress __m_SocketAddress;
    private UdpSocket __m_UdpSocket;
    private WriteBuffer __m_WriteBuffer;

    public UdpPacket() {
        this(null, null, true);
    }

    public UdpPacket(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public boolean append(UdpPacket packet) {
        int cbThat;
        WriteBuffer bufferThis;
        int cbThis;
        int cbTotal;
        if (packet != null && (!((cbTotal = (cbThis = (bufferThis = this.getWriteBuffer()).length()) + (cbThat = packet.getWriteBuffer().length())) <= this.getMaximumBundleLength()) ? false : this.isCommonDestination(packet))) {
            bufferThis.write(cbThis, packet.getReadBuffer());
            return true;
        }
        return false;
    }

    public String getAddressDescription() {
        return this.getSocketAddress().toString();
    }

    public int getMaximumBundleLength() {
        return this.__m_MaximumBundleLength;
    }

    public ReadBuffer getReadBuffer() {
        return this.getWriteBuffer().getUnsafeReadBuffer();
    }

    public SocketAddress getSocketAddress() {
        return this.__m_SocketAddress;
    }

    public UdpSocket getUdpSocket() {
        return this.__m_UdpSocket;
    }

    public WriteBuffer getWriteBuffer() {
        return this.__m_WriteBuffer;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/UdpPacket".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new UdpPacket();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isCommonDestination(UdpPacket packet) {
        return !(packet != null) ? false : Base.equals(this.getSocketAddress(), packet.getSocketAddress());
    }

    public void onInit() {
        super.onInit();
        Component cdParent = this.get_Parent();
        if (cdParent instanceof UdpSocket) {
            this.setUdpSocket((UdpSocket)cdParent);
        }
    }

    public boolean receive() {
        return this.getUdpSocket().receive(this);
    }

    public void reset() {
        this.getWriteBuffer().retain(0, 0);
    }

    public void send() {
        this.getUdpSocket().send(this);
    }

    public void setMaximumBundleLength(int pMaximumBundleLength) {
        this.__m_MaximumBundleLength = pMaximumBundleLength;
    }

    public void setSocketAddress(SocketAddress addr) {
        this.__m_SocketAddress = addr;
    }

    public void setUdpSocket(UdpSocket socket) {
        this.__m_UdpSocket = socket;
    }

    public void setWriteBuffer(WriteBuffer pWriteBuffer) {
        this.__m_WriteBuffer = pWriteBuffer;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean fVerbose) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.get_Name()).append("@").append(this.hashCode()).append(", socket=").append(this.getUdpSocket()).append(", address=").append(this.getAddressDescription());
        if (fVerbose) {
            sb.append(", buffer={").append(Base.toHexEscape(this.getWriteBuffer().toByteArray(), 0, this.getWriteBuffer().length())).append(String.valueOf("} [") + this.getWriteBuffer().length() + "]");
        }
        return sb.toString();
    }
}

