/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.extend;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Extend;
import com.tangosol.coherence.component.net.extend.Channel;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$MessageFactory$AcceptChannelRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$MessageFactory$NotifyConnectionClosed;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$MessageFactory$OpenChannelRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$MessageFactory$PingRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$Protocol;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.Member;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.ConnectionAcceptor;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.ConnectionManager;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.net.messaging.Request;
import com.tangosol.util.Base;
import com.tangosol.util.LongArray;
import com.tangosol.util.SparseArray;
import com.tangosol.util.ThreadGate;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.security.auth.Subject;

public class Connection
extends Extend
implements com.tangosol.net.messaging.Connection {
    private static final int MAX_PENDING = 100;
    private LongArray __m_ChannelArray;
    private LongArray __m_ChannelPendingArray;
    private volatile boolean __m_CloseNotify;
    private volatile boolean __m_CloseOnExit;
    private volatile Throwable __m_CloseThrowable;
    private volatile ConnectionManager __m_ConnectionManager;
    private UUID __m_Id;
    private Member __m_Member;
    private transient Map __m_MessageFactoryMap;
    private volatile boolean __m_Open;
    private int __m_PeerEdition;
    private UUID __m_PeerId;
    private transient long __m_PingLastMillis;
    private transient long __m_StatsBytesReceived;
    private transient long __m_StatsBytesSent;
    private transient long __m_StatsReceived;
    private transient long __m_StatsReset;
    private transient long __m_StatsSent;
    private ThreadGate __m_ThreadGate;

    public Connection() {
        this(null, null, true);
    }

    public Connection(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setChannelArray(new SparseArray());
            this.setChannelPendingArray(new SparseArray());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public com.tangosol.net.messaging.Channel acceptChannel(URI uri, ClassLoader loader, Channel.Receiver receiver, Subject subject) {
        return ((Peer)this.getConnectionManager()).acceptChannel(this, uri, loader, receiver, subject);
    }

    public Request.Status acceptChannelInternal(URI uri, Serializer serializer, Channel.Receiver receiver, Subject subject, byte[] abToken) {
        Protocol.MessageFactory factory;
        int nId;
        this.assertOpen();
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null");
        }
        try {
            nId = Integer.valueOf(uri.getSchemeSpecificPart());
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(String.valueOf("illegal URI: ") + uri);
        }
        if (nId == 0) {
            throw new IllegalArgumentException("channel 0 is reserved");
        }
        if (this.getChannel(nId) != null) {
            throw new IllegalArgumentException(String.valueOf("duplicate channel: ") + nId);
        }
        String sProtocol = uri.getFragment();
        if (sProtocol == null) {
            new IllegalArgumentException(String.valueOf("illegal URI: ") + uri);
        }
        if ((factory = (Protocol.MessageFactory)this.getMessageFactoryMap().get(sProtocol)) == null) {
            throw new IllegalArgumentException(String.valueOf("unknown protocol: ") + sProtocol);
        }
        if (receiver != null && receiver.getProtocol() != factory.getProtocol()) {
            throw new IllegalArgumentException(String.valueOf("protocol mismatch; expected ") + factory.getProtocol() + ", retrieved " + receiver.getProtocol() + ")");
        }
        Channel channel0 = (Channel)this.getChannel(0);
        Protocol.MessageFactory factory0 = channel0.getMessageFactory();
        Peer$MessageFactory$AcceptChannelRequest request = (Peer$MessageFactory$AcceptChannelRequest)factory0.createMessage(Peer$MessageFactory$AcceptChannelRequest.TYPE_ID);
        request.setChannelId(nId);
        request.setIdentityToken(abToken);
        request.setMessageFactory(factory);
        request.setProtocolName(sProtocol);
        request.setReceiver(receiver);
        request.setSerializer(serializer);
        request.setSubject(subject);
        return channel0.send(request);
    }

    public void acceptChannelRequest(int nId, Subject subject) {
        if (nId == 0) {
            throw new IllegalArgumentException("channel 0 is reserved");
        }
        if (this.getChannel(nId) != null) {
            throw new IllegalArgumentException(String.valueOf("channel already exists: ") + nId);
        }
        Channel channel = (Channel)this.getChannelPendingArray().remove(nId);
        if (channel == null) {
            throw new IllegalArgumentException(String.valueOf("no such channel: ") + nId);
        }
        channel.setSubject(subject);
        channel.openInternal();
        this.registerChannel(channel);
    }

    public com.tangosol.net.messaging.Channel acceptChannelResponse(int nId, Protocol.MessageFactory factory, Serializer serializer, Channel.Receiver receiver, Subject subject) {
        this.assertOpen();
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null");
        }
        Channel channel = new Channel();
        channel.setId(nId);
        channel.setConnection(this);
        channel.setMessageFactory(factory);
        channel.setReceiver(receiver);
        channel.setSerializer(serializer);
        channel.setSubject(subject);
        channel.openInternal();
        this.registerChannel(channel);
        return channel;
    }

    protected void assertOpen() {
        if (this.isOpen() ^ true) {
            throw new ConnectionException("connection is closed", (com.tangosol.net.messaging.Connection)this);
        }
    }

    public void close() {
        this.close(true, null);
    }

    public void close(boolean fNotify, Throwable e) {
        if (this.isOpen()) {
            Peer manager = (Peer)this.getConnectionManager();
            if (Thread.currentThread() == manager.getThread()) {
                this.closeInternal(fNotify, e, 0L);
            } else {
                Component._assert(this.isActiveThread() ^ true, "cannot close a connection while executing within the connection");
                manager.closeConnection(this, fNotify, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeInternal(boolean fNotify, Throwable e, long cMillis) {
        Object var9_13;
        Channel channel0;
        LongArray la;
        if (this.isOpen() ^ true) {
            return false;
        }
        LongArray longArray = la = this.getChannelArray();
        synchronized (longArray) {
            channel0 = (Channel)la.get(0);
            LongArray.Iterator iter = la.iterator();
            while (iter.hasNext()) {
                Channel channel = (Channel)iter.next();
                if (!(channel != channel0)) continue;
                iter.remove();
                channel.closeInternal(false, e, 0L);
            }
        }
        boolean fClose = this.gateClose(cMillis);
        try {
            if (fClose ^ true) {
                this.setCloseOnExit(true);
                this.setCloseNotify(fNotify);
                this.setCloseThrowable(e);
                fClose = this.gateClose(0L);
            }
            if (!fClose ? false : this.isOpen()) {
                if (fNotify) {
                    try {
                        Protocol.MessageFactory factory0 = channel0.getMessageFactory();
                        Peer$MessageFactory$NotifyConnectionClosed message = (Peer$MessageFactory$NotifyConnectionClosed)factory0.createMessage(Peer$MessageFactory$NotifyConnectionClosed.TYPE_ID);
                        message.setCause(e);
                        channel0.send(message);
                    }
                    catch (RuntimeException ee) {
                        // empty catch block
                    }
                }
            } else {
                boolean ee = false;
                var9_13 = null;
                if (fClose) {
                    this.gateOpen();
                }
                return ee;
            }
            channel0.closeInternal(false, e, -1L);
            this.getChannelPendingArray().clear();
            this.setPeerId(null);
            this.setOpen(false);
            var9_13 = null;
            if (fClose) {
                this.gateOpen();
            }
        }
        catch (Throwable ee) {
            var9_13 = null;
            if (fClose) {
                this.gateOpen();
            }
            throw ee;
        }
        Peer manager = (Peer)this.getConnectionManager();
        if (e == null) {
            manager.onConnectionClosed(this);
        } else {
            manager.onConnectionError(this, e);
        }
        return true;
    }

    public URI createChannel(Protocol protocol, ClassLoader loader, Channel.Receiver receiver) {
        Peer manager = (Peer)this.getConnectionManager();
        if (Thread.currentThread() == manager.getThread()) {
            return this.createChannelInternal(protocol, manager.ensureSerializer(loader), receiver);
        }
        return manager.createChannel(this, protocol, loader, receiver);
    }

    public URI createChannelInternal(Protocol protocol, Serializer serializer, Channel.Receiver receiver) {
        this.assertOpen();
        if (protocol == null) {
            throw new IllegalArgumentException("protocol cannot be null");
        }
        String sProtocol = protocol.getName();
        if (sProtocol == null) {
            throw new IllegalArgumentException(String.valueOf("missing protocol name: ") + protocol);
        }
        Protocol.MessageFactory factory = (Protocol.MessageFactory)this.getMessageFactoryMap().get(sProtocol);
        if (factory == null) {
            throw new IllegalArgumentException(String.valueOf("unsupported protocol: ") + protocol);
        }
        int nId = this.generateChannelId();
        Channel channel = new Channel();
        channel.setId(nId);
        channel.setConnection(this);
        channel.setReceiver(receiver);
        channel.setMessageFactory(factory);
        channel.setSerializer(serializer);
        LongArray la = this.getChannelPendingArray();
        if (la.getSize() > MAX_PENDING) {
            Object oChannel = la.remove(la.getFirstIndex());
            Component._trace(String.valueOf("Maximum pending channel count reached; discarding: ") + oChannel, 2);
        }
        la.set(nId, channel);
        try {
            return new URI("channel", String.valueOf(nId), sProtocol);
        }
        catch (URISyntaxException e) {
            la.remove(nId);
            throw Extend.ensureRuntimeException(e, "error creating URI");
        }
    }

    protected boolean gateClose(long cMillis) {
        return this.getThreadGate().close(cMillis);
    }

    public void gateEnter() {
        ThreadGate gate = this.getThreadGate();
        if (!this.isCloseOnExit() ? false : gate.isEnteredByCurrentThread() ^ true) {
            throw new ConnectionException("connection is closing", (com.tangosol.net.messaging.Connection)this);
        }
        if (gate.enter(0L)) {
            try {
                this.assertOpen();
            }
            catch (Throwable e) {
                gate.exit();
                throw Extend.ensureRuntimeException(e);
            }
        } else {
            throw new ConnectionException("connection is closing", (com.tangosol.net.messaging.Connection)this);
        }
    }

    public void gateExit() {
        ThreadGate gate = this.getThreadGate();
        gate.exit();
        if (!this.isCloseOnExit() ? false : gate.isEnteredByCurrentThread() ^ true) {
            boolean fClose;
            block5: {
                fClose = this.gateClose(0L);
                try {
                    if (!(!fClose ? false : this.isOpen())) break block5;
                    this.gateOpen();
                    fClose = false;
                    this.close(this.isCloseNotify(), this.getCloseThrowable());
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (fClose) {
                        this.gateOpen();
                    }
                    throw throwable;
                }
            }
            Object var4_3 = null;
            if (fClose) {
                this.gateOpen();
            }
        }
    }

    protected void gateOpen() {
        this.getThreadGate().open();
    }

    protected int generateChannelId() {
        int nId;
        LongArray la = this.getChannelPendingArray();
        int nScale = this.getConnectionManager() instanceof ConnectionAcceptor ? 1 : -1;
        while (((nId = Base.getRandom().nextInt(Integer.MAX_VALUE) * nScale) == 0 ? true : this.getChannel(nId) != null) ? true : la.get(nId) != null) {
        }
        return nId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public com.tangosol.net.messaging.Channel getChannel(int nId) {
        LongArray la = this.getChannelArray();
        if (((Peer)this.getConnectionManager()).isServiceThread(false)) {
            return (Channel)la.get(nId);
        }
        LongArray longArray = la;
        synchronized (longArray) {
            Channel channel = (Channel)la.get(nId);
            return channel;
        }
    }

    public LongArray getChannelArray() {
        return this.__m_ChannelArray;
    }

    public LongArray getChannelPendingArray() {
        return this.__m_ChannelPendingArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection getChannels() {
        LongArray la;
        LongArray longArray = la = this.getChannelArray();
        synchronized (longArray) {
            ArrayList list = new ArrayList(la.getSize());
            LongArray.Iterator iter = la.iterator();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
            ArrayList arrayList = list;
            return arrayList;
        }
    }

    public Throwable getCloseThrowable() {
        return this.__m_CloseThrowable;
    }

    public ConnectionManager getConnectionManager() {
        return this.__m_ConnectionManager;
    }

    protected String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("Id=").append(this.getId()).append(", Open=").append(this.isOpen());
        Member member = this.getMember();
        if (member != null) {
            sb.append(", ").append(member.toString());
        }
        return sb.toString();
    }

    public UUID getId() {
        return this.__m_Id;
    }

    public Member getMember() {
        return this.__m_Member;
    }

    public Map getMessageFactoryMap() {
        return this.__m_MessageFactoryMap;
    }

    public int getPeerEdition() {
        return this.__m_PeerEdition;
    }

    public UUID getPeerId() {
        return this.__m_PeerId;
    }

    public long getPingLastMillis() {
        return this.__m_PingLastMillis;
    }

    public long getStatsBytesReceived() {
        return this.__m_StatsBytesReceived;
    }

    public long getStatsBytesSent() {
        return this.__m_StatsBytesSent;
    }

    public long getStatsReceived() {
        return this.__m_StatsReceived;
    }

    public long getStatsReset() {
        return this.__m_StatsReset;
    }

    public long getStatsSent() {
        return this.__m_StatsSent;
    }

    protected ThreadGate getThreadGate() {
        return this.__m_ThreadGate;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/extend/Connection".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Connection();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isActiveThread() {
        return this.getThreadGate().isEnteredByCurrentThread();
    }

    public boolean isCloseNotify() {
        return this.__m_CloseNotify;
    }

    public boolean isCloseOnExit() {
        return this.__m_CloseOnExit;
    }

    public boolean isOpen() {
        return this.__m_Open;
    }

    public void onInit() {
        Channel channel0 = new Channel();
        channel0.setConnection(this);
        this.registerChannel(channel0);
        this.setThreadGate(new ThreadGate());
        super.onInit();
    }

    public void open() {
        if (this.isOpen() ^ true) {
            ((Peer)this.getConnectionManager()).openConnection(this);
        }
    }

    public com.tangosol.net.messaging.Channel openChannel(Protocol protocol, String sName, ClassLoader loader, Channel.Receiver receiver, Subject subject) {
        return ((Peer)this.getConnectionManager()).openChannel(this, protocol, sName, loader, receiver, subject);
    }

    public Request.Status openChannelInternal(Protocol protocol, String sName, Serializer serializer, Channel.Receiver receiver, Subject subject, byte[] abToken) {
        this.assertOpen();
        if (protocol == null) {
            throw new IllegalArgumentException("protocol cannot be null");
        }
        if (sName == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null");
        }
        String sProtocol = protocol.getName();
        Component._assert(sProtocol != null);
        Protocol.MessageFactory factory = (Protocol.MessageFactory)this.getMessageFactoryMap().get(sProtocol);
        if (factory == null) {
            throw new IllegalArgumentException(String.valueOf("unknown protocol: ") + sProtocol);
        }
        if (receiver != null && receiver.getProtocol() != factory.getProtocol()) {
            throw new IllegalArgumentException(String.valueOf("protocol mismatch; expected ") + factory.getProtocol() + ", retrieved " + receiver.getProtocol() + ")");
        }
        Channel channel0 = (Channel)this.getChannel(0);
        Protocol.MessageFactory factory0 = channel0.getMessageFactory();
        Peer$MessageFactory$OpenChannelRequest request = (Peer$MessageFactory$OpenChannelRequest)factory0.createMessage(Peer$MessageFactory$OpenChannelRequest.TYPE_ID);
        request.setIdentityToken(abToken);
        request.setMessageFactory(factory);
        request.setProtocolName(sProtocol);
        request.setReceiver(receiver);
        request.setReceiverName(sName);
        request.setSerializer(serializer);
        request.setSubject(subject);
        return channel0.send(request);
    }

    public int openChannelRequest(String sProtocol, Serializer serializer, Channel.Receiver receiver, Subject subject) {
        this.assertOpen();
        if (sProtocol == null) {
            throw new IllegalArgumentException("protocol name cannot be null");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null");
        }
        Protocol.MessageFactory factory = (Protocol.MessageFactory)this.getMessageFactoryMap().get(sProtocol);
        if (factory == null) {
            throw new IllegalArgumentException(String.valueOf("unknown protocol: ") + sProtocol);
        }
        if (receiver != null && receiver.getProtocol() != factory.getProtocol()) {
            throw new IllegalArgumentException(String.valueOf("protocol mismatch; expected ") + factory.getProtocol() + ", retrieved " + receiver.getProtocol() + ')');
        }
        int nId = this.generateChannelId();
        Channel channel = new Channel();
        channel.setConnection(this);
        channel.setId(nId);
        channel.setMessageFactory(factory);
        channel.setReceiver(receiver);
        channel.setSerializer(serializer);
        channel.setSubject(subject);
        channel.openInternal();
        this.registerChannel(channel);
        return nId;
    }

    public com.tangosol.net.messaging.Channel openChannelResponse(int nId, Protocol.MessageFactory factory, Serializer serializer, Channel.Receiver receiver, Subject subject) {
        this.assertOpen();
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null");
        }
        Channel channel = new Channel();
        channel.setId(nId);
        channel.setConnection(this);
        channel.setMessageFactory(factory);
        channel.setReceiver(receiver);
        channel.setSerializer(serializer);
        channel.setSubject(subject);
        channel.openInternal();
        this.registerChannel(channel);
        return channel;
    }

    public void openInternal() {
        if (this.isOpen()) {
            return;
        }
        Peer manager = (Peer)this.getConnectionManager();
        Component._assert(manager != null);
        Peer$Protocol protocol = (Peer$Protocol)manager.getProtocol(Peer$Protocol.PROTOCOL_NAME);
        Component._assert(protocol != null);
        Map map = this.getMessageFactoryMap();
        if (map == null) {
            map = manager.getMessageFactoryMap();
            this.setMessageFactoryMap(map);
        }
        Component._assert(map != null);
        Protocol.MessageFactory factory = (Protocol.MessageFactory)map.get(protocol.getName());
        Component._assert(factory != null);
        Channel channel0 = (Channel)this.getChannel(0);
        channel0.setMessageFactory(factory);
        channel0.setReceiver(manager);
        channel0.setSerializer(manager.ensureSerializer());
        channel0.openInternal();
        this.setOpen(true);
    }

    public boolean ping() {
        if (this.getPingLastMillis() == (long)0) {
            Channel channel0 = (Channel)this.getChannel(0);
            Protocol.MessageFactory factory = channel0.getMessageFactory();
            Peer$MessageFactory$PingRequest request = (Peer$MessageFactory$PingRequest)factory.createMessage(Peer$MessageFactory$PingRequest.TYPE_ID);
            try {
                channel0.send(request);
            }
            catch (RuntimeException e) {
                return false;
            }
            this.setPingLastMillis(Base.getSafeTimeMillis());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerChannel(Channel channel) {
        LongArray la;
        LongArray longArray = la = this.getChannelArray();
        synchronized (longArray) {
            Object oChannel = la.set(channel.getId(), channel);
            if (oChannel != null) {
                la.set(channel.getId(), oChannel);
                throw new IllegalArgumentException(String.valueOf("duplicate channel: ") + channel);
            }
        }
    }

    protected void releaseReadBuffer(ReadBuffer rb) {
    }

    public void resetStats() {
        this.setStatsBytesReceived(0L);
        this.setStatsBytesSent(0L);
        this.setStatsReceived(0L);
        this.setStatsSent(0L);
        this.setStatsReset(Base.getSafeTimeMillis());
    }

    public void send(WriteBuffer wb) throws ConnectionException {
        this.assertOpen();
        this.setStatsBytesSent(this.getStatsBytesSent() + (long)wb.length());
        this.setStatsSent(this.getStatsSent() + (long)1);
    }

    protected void setChannelArray(LongArray list) {
        this.__m_ChannelArray = list;
    }

    protected void setChannelPendingArray(LongArray list) {
        this.__m_ChannelPendingArray = list;
    }

    public void setCloseNotify(boolean f) {
        this.__m_CloseNotify = f;
    }

    public void setCloseOnExit(boolean fClose) {
        this.__m_CloseOnExit = fClose;
    }

    public void setCloseThrowable(Throwable e) {
        this.__m_CloseThrowable = e;
    }

    public void setConnectionManager(ConnectionManager manager) {
        Component._assert(this.isOpen() ^ true);
        this.__m_ConnectionManager = manager;
    }

    public void setId(UUID uuid) {
        Component._assert(this.getId() == null);
        this.__m_Id = uuid;
    }

    public void setMember(Member member) {
        this.__m_Member = member;
    }

    public void setMessageFactoryMap(Map map) {
        this.__m_MessageFactoryMap = map;
    }

    protected void setOpen(boolean fOpen) {
        this.__m_Open = fOpen;
    }

    public void setPeerEdition(int nEdition) {
        this.__m_PeerEdition = nEdition;
    }

    public void setPeerId(UUID uuid) {
        this.__m_PeerId = uuid;
    }

    public void setPingLastMillis(long ldt) {
        this.__m_PingLastMillis = ldt;
    }

    public void setStatsBytesReceived(long cb) {
        this.__m_StatsBytesReceived = cb;
    }

    public void setStatsBytesSent(long cb) {
        this.__m_StatsBytesSent = cb;
    }

    public void setStatsReceived(long cMessage) {
        this.__m_StatsReceived = cMessage;
    }

    public void setStatsReset(long ldt) {
        this.__m_StatsReset = ldt;
    }

    public void setStatsSent(long cMessage) {
        this.__m_StatsSent = cMessage;
    }

    protected void setThreadGate(ThreadGate gate) {
        this.__m_ThreadGate = gate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterChannel(com.tangosol.net.messaging.Channel channel) {
        LongArray la;
        if (channel.getId() == 0) {
            return;
        }
        LongArray longArray = la = this.getChannelArray();
        synchronized (longArray) {
            la.remove(channel.getId());
        }
    }
}

