/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.extend.proxy;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.Proxy;
import com.tangosol.coherence.component.net.extend.message.request.NamedCacheRequest;
import com.tangosol.coherence.component.net.extend.protocol.NamedCacheProtocol;
import com.tangosol.coherence.component.net.extend.proxy.NamedCacheProxy$EntrySet;
import com.tangosol.coherence.component.net.extend.proxy.NamedCacheProxy$KeySet;
import com.tangosol.coherence.component.net.extend.proxy.NamedCacheProxy$Values;
import com.tangosol.coherence.component.net.extend.proxy.serviceProxy.CacheServiceProxy;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.Message;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ListMap;
import com.tangosol.util.MapListener;
import com.tangosol.util.SegmentedConcurrentMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class NamedCacheProxy
extends Proxy
implements NamedCache,
Channel.Receiver,
Runnable {
    public static final String ATTR_LISTENER_FILTER_MAP = "named-cache-listener-filter-map";
    public static final String ATTR_LISTENER_KEY_MAP = "named-cache-listener-key-map";
    public static final String ATTR_LOCK_MAP = "named-cache-lock-map";
    private CacheServiceProxy __m_CacheServiceProxy;
    private Channel __m_Channel;
    private boolean __m_LockEnabled;
    private NamedCache __m_NamedCache;
    private boolean __m_ReadOnly;
    private long __m_TransferThreshold;
    private String __m__CacheName;
    private CacheService __m__CacheService;
    private String __m__CacheServiceName;
    private static ListMap __mapChildren;

    static {
        NamedCacheProxy.__initStatic();
    }

    public NamedCacheProxy() {
        this(null, null, true);
    }

    public NamedCacheProxy(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setEnabled(true);
            this.setTransferThreshold(524288L);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("EntrySet", NamedCacheProxy$EntrySet.get_CLASS());
        Class clazz2 = __mapChildren.put("KeySet", NamedCacheProxy$KeySet.get_CLASS());
        Class clazz3 = __mapChildren.put("Values", NamedCacheProxy$Values.get_CLASS());
    }

    private void addIndex$Router(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        this.getNamedCache().addIndex(extractor, fOrdered, comparator);
    }

    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        this.assertWriteable();
        this.addIndex$Router(extractor, fOrdered, comparator);
    }

    public void addMapListener(MapListener listener) {
        this.getNamedCache().addMapListener(listener);
    }

    public void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        this.getNamedCache().addMapListener(listener, filter, fLite);
    }

    public void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        this.getNamedCache().addMapListener(listener, oKey, fLite);
    }

    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        return this.getNamedCache().aggregate(filter, agent);
    }

    public Object aggregate(Collection colKeys, InvocableMap.EntryAggregator agent) {
        return this.getNamedCache().aggregate(colKeys, agent);
    }

    public void assertLockEnabled() {
        if (this.isLockEnabled()) {
            return;
        }
        throw new SecurityException(String.valueOf("lock operations are prohibited on NamedCache \"") + this.getCacheName() + '\"');
    }

    public void assertWriteable() {
        if (this.isReadOnly()) {
            throw new SecurityException(String.valueOf("NamedCache \"") + this.getCacheName() + "\" is read-only");
        }
    }

    private void clear$Router() {
        this.getNamedCache().clear();
    }

    public void clear() {
        this.assertWriteable();
        this.clear$Router();
    }

    public boolean containsKey(Object oKey) {
        return this.getNamedCache().containsKey(oKey);
    }

    public boolean containsValue(Object oValue) {
        return this.getNamedCache().containsValue(oValue);
    }

    public void destroy() {
        throw new UnsupportedOperationException();
    }

    private Set entrySet$Router() {
        return this.getNamedCache().entrySet();
    }

    public Set entrySet() {
        NamedCacheProxy$EntrySet set = (NamedCacheProxy$EntrySet)this._newChild("EntrySet");
        set.setSet(this.entrySet$Router());
        return set;
    }

    public Set entrySet(Filter filter) {
        return this.getNamedCache().entrySet(filter);
    }

    public Set entrySet(Filter filter, Comparator comparator) {
        return this.getNamedCache().entrySet(filter, comparator);
    }

    public Object get(Object oKey) {
        return this.getNamedCache().get(oKey);
    }

    public Map getAll(Collection colKeys) {
        return this.getNamedCache().getAll(colKeys);
    }

    public String getCacheName() {
        return this.getNamedCache().getCacheName();
    }

    public CacheService getCacheService() {
        return this.getNamedCache().getCacheService();
    }

    private CacheServiceProxy getCacheServiceProxy() {
        return this.__m_CacheServiceProxy;
    }

    public Channel getChannel() {
        return this.__m_Channel;
    }

    protected String getDescription() {
        String sName = this.get_CacheName();
        return String.valueOf("NamedCache=") + (sName == null ? "N/A" : sName);
    }

    public String getName() {
        return this.toString();
    }

    public NamedCache getNamedCache() {
        return this.__m_NamedCache;
    }

    public Protocol getProtocol() {
        return NamedCacheProtocol.getInstance();
    }

    public long getTransferThreshold() {
        return this.__m_TransferThreshold;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/extend/proxy/NamedCacheProxy".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public String get_CacheName() {
        return this.__m__CacheName;
    }

    public CacheService get_CacheService() {
        return this.__m__CacheService;
    }

    public String get_CacheServiceName() {
        return this.__m__CacheServiceName;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new NamedCacheProxy();
    }

    private final Component get_Module() {
        return this;
    }

    private Object invoke$Router(Object oKey, InvocableMap.EntryProcessor agent) {
        return this.getNamedCache().invoke(oKey, agent);
    }

    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        this.assertWriteable();
        return this.invoke$Router(oKey, agent);
    }

    private Map invokeAll$Router(Filter filter, InvocableMap.EntryProcessor agent) {
        return this.getNamedCache().invokeAll(filter, agent);
    }

    private Map invokeAll$Router(Collection colKeys, InvocableMap.EntryProcessor agent) {
        return this.getNamedCache().invokeAll(colKeys, agent);
    }

    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        this.assertWriteable();
        return this.invokeAll$Router(filter, agent);
    }

    public Map invokeAll(Collection colKeys, InvocableMap.EntryProcessor agent) {
        this.assertWriteable();
        return this.invokeAll$Router(colKeys, agent);
    }

    public boolean isActive() {
        return this.getNamedCache().isActive();
    }

    public boolean isEmpty() {
        return this.getNamedCache().isEmpty();
    }

    public boolean isLockEnabled() {
        return this.__m_LockEnabled;
    }

    public boolean isReadOnly() {
        return this.__m_ReadOnly;
    }

    private Set keySet$Router() {
        return this.getNamedCache().keySet();
    }

    public Set keySet() {
        NamedCacheProxy$KeySet set = (NamedCacheProxy$KeySet)this._newChild("KeySet");
        set.setSet(this.keySet$Router());
        return set;
    }

    public Set keySet(Filter filter) {
        return this.getNamedCache().keySet(filter);
    }

    private boolean lock$Router(Object oKey) {
        return this.getNamedCache().lock(oKey);
    }

    private boolean lock$Router(Object oKey, long cWait) {
        return this.getNamedCache().lock(oKey, cWait);
    }

    public boolean lock(Object oKey) {
        this.assertLockEnabled();
        return this.lock$Router(oKey);
    }

    public boolean lock(Object oKey, long cWait) {
        this.assertLockEnabled();
        return this.lock$Router(oKey, cWait);
    }

    public void onMessage(Message message) {
        if (message instanceof NamedCacheRequest) {
            NamedCacheRequest request = (NamedCacheRequest)message;
            request.setNamedCache(this);
            request.setTransferThreshold(this.getTransferThreshold());
        }
        message.run();
    }

    private Object put$Router(Object oKey, Object oValue) {
        return this.getNamedCache().put(oKey, oValue);
    }

    private Object put$Router(Object oKey, Object oValue, long cMillis) {
        return this.getNamedCache().put(oKey, oValue, cMillis);
    }

    public Object put(Object oKey, Object oValue) {
        this.assertWriteable();
        return this.put$Router(oKey, oValue);
    }

    public Object put(Object oKey, Object oValue, long cMillis) {
        this.assertWriteable();
        return this.put$Router(oKey, oValue, cMillis);
    }

    private void putAll$Router(Map map) {
        this.getNamedCache().putAll(map);
    }

    public void putAll(Map map) {
        this.assertWriteable();
        this.putAll$Router(map);
    }

    public void registerChannel(Channel channel) {
        Component._assert(this.getChannel() == null);
        channel.setAttribute(ATTR_LISTENER_FILTER_MAP, new SegmentedConcurrentMap());
        channel.setAttribute(ATTR_LISTENER_KEY_MAP, new SegmentedConcurrentMap());
        channel.setAttribute(ATTR_LOCK_MAP, new SegmentedConcurrentMap());
        this.setChannel(channel);
        CacheServiceProxy proxy = (CacheServiceProxy)channel.getConnection().getConnectionManager().getReceiver("CacheServiceProxy");
        Component._assert(proxy != null);
        this.setCacheServiceProxy(proxy);
        proxy.registerNamedCacheProxy(this);
    }

    public void release() {
        throw new UnsupportedOperationException();
    }

    private Object remove$Router(Object oKey) {
        return this.getNamedCache().remove(oKey);
    }

    public Object remove(Object oKey) {
        this.assertWriteable();
        return this.remove$Router(oKey);
    }

    private void removeIndex$Router(ValueExtractor extractor) {
        this.getNamedCache().removeIndex(extractor);
    }

    public void removeIndex(ValueExtractor extractor) {
        this.assertWriteable();
        this.removeIndex$Router(extractor);
    }

    public void removeMapListener(MapListener listener) {
        this.getNamedCache().removeMapListener(listener);
    }

    public void removeMapListener(MapListener listener, Filter filter) {
        this.getNamedCache().removeMapListener(listener, filter);
    }

    public void removeMapListener(MapListener listener, Object oKey) {
        this.getNamedCache().removeMapListener(listener, oKey);
    }

    public void run() {
    }

    public void setCacheService(CacheService service) {
        if (service instanceof CacheServiceProxy) {
            this.setCacheServiceProxy((CacheServiceProxy)service);
        }
    }

    protected void setCacheServiceProxy(CacheServiceProxy proxy) {
        this.__m_CacheServiceProxy = proxy;
        this.setLockEnabled(proxy.isLockEnabled());
        this.setReadOnly(proxy.isReadOnly());
        this.setTransferThreshold(proxy.getTransferThreshold());
    }

    protected void setChannel(Channel set) {
        this.__m_Channel = set;
    }

    public void setLockEnabled(boolean fEnabled) {
        this.__m_LockEnabled = fEnabled;
    }

    public void setNamedCache(NamedCache cache) {
        this.__m_NamedCache = cache;
    }

    public void setReadOnly(boolean fReadOnly) {
        this.__m_ReadOnly = fReadOnly;
    }

    public void setTransferThreshold(long cb) {
        this.__m_TransferThreshold = cb;
    }

    public void set_CacheName(String sName) {
        this.__m__CacheName = sName;
    }

    public void set_CacheService(CacheService service) {
        this.__m__CacheService = service;
        this.set_CacheServiceName(service.getInfo().getServiceName());
    }

    protected void set_CacheServiceName(String sName) {
        this.__m__CacheServiceName = sName;
    }

    public int size() {
        return this.getNamedCache().size();
    }

    private boolean unlock$Router(Object oKey) {
        return this.getNamedCache().unlock(oKey);
    }

    public boolean unlock(Object oKey) {
        this.assertLockEnabled();
        return this.unlock$Router(oKey);
    }

    public void unregisterChannel(Channel channel) {
        Component._assert(this.getChannel() == channel);
        NamedCache cache = this.getNamedCache();
        Component._assert(cache != null);
        Map mapFilter = (Map)channel.getAttribute(ATTR_LISTENER_FILTER_MAP);
        Component._assert(mapFilter != null);
        Map mapKey = (Map)channel.getAttribute(ATTR_LISTENER_KEY_MAP);
        Component._assert(mapKey != null);
        Map mapLock = (Map)channel.getAttribute(ATTR_LOCK_MAP);
        Component._assert(mapLock != null);
        try {
            MapListener listener;
            Map.Entry entry;
            Iterator iter = mapFilter.entrySet().iterator();
            while (iter.hasNext()) {
                entry = (Map.Entry)iter.next();
                Filter filter = (Filter)entry.getKey();
                listener = (MapListener)entry.getValue();
                cache.removeMapListener(listener, filter);
            }
            iter = mapKey.entrySet().iterator();
            while (iter.hasNext()) {
                entry = (Map.Entry)iter.next();
                Object oKey = entry.getKey();
                listener = (MapListener)entry.getValue();
                cache.removeMapListener(listener, oKey);
            }
            iter = mapLock.keySet().iterator();
            while (iter.hasNext()) {
                cache.unlock(iter.next());
            }
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        channel.setAttribute(ATTR_LISTENER_FILTER_MAP, null);
        channel.setAttribute(ATTR_LISTENER_KEY_MAP, null);
        channel.setAttribute(ATTR_LOCK_MAP, null);
        this.setChannel(null);
        CacheServiceProxy proxy = this.getCacheServiceProxy();
        Component._assert(proxy != null);
        proxy.unregisterNamedCacheProxy(this);
    }

    private Collection values$Router() {
        return this.getNamedCache().values();
    }

    public Collection values() {
        NamedCacheProxy$Values col = (NamedCacheProxy$Values)this._newChild("Values");
        col.setCollection(this.values$Router());
        return col;
    }
}

