/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.net.Management;
import com.tangosol.coherence.component.net.management.Connector$Announce;
import com.tangosol.coherence.component.net.management.Connector$Notify;
import com.tangosol.coherence.component.net.management.Connector$Register;
import com.tangosol.coherence.component.net.management.Connector$Subscribe;
import com.tangosol.coherence.component.net.management.Connector$Unregister;
import com.tangosol.coherence.component.net.management.Gateway;
import com.tangosol.coherence.component.net.management.gateway.Local;
import com.tangosol.coherence.component.net.management.listenerHolder.LocalHolder;
import com.tangosol.coherence.component.net.management.listenerHolder.RemoteHolder;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.component.net.management.model.RemoteModel;
import com.tangosol.coherence.component.net.management.model.localModel.WrapperModel;
import com.tangosol.coherence.component.net.management.notificationHandler.RemoteHandler;
import com.tangosol.coherence.component.util.SafeService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.license.LicenseException;
import com.tangosol.net.Cluster;
import com.tangosol.net.InvocationService;
import com.tangosol.net.Member;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.Resources;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.WrapperException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.Notification;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class Connector
extends Management
implements MemberListener {
    public static final int REFRESH_AHEAD = 1;
    public static final int REFRESH_BEHIND = 2;
    public static final int REFRESH_EXPIRED = 0;
    public static final int REFRESH_ONQUERY = 3;
    private boolean __m_Announced;
    private Local __m_LocalGateway;
    private Map __m_LocalRegistry;
    private boolean __m_ManagingNode;
    private long __m_RefreshAttributeTimeoutMillis;
    private int __m_RefreshPolicy;
    private long __m_RefreshRequestTimeoutMillis;
    private long __m_RefreshTimeoutMillis;
    private Map __m_RemoteModels;
    private Set __m_RemoteServers;
    private InvocationService __m_Service;
    private long __m_StatsNotificationCount;
    private long __m_StatsRefreshCount;
    private long __m_StatsRefreshExcessCount;
    private long __m_StatsRefreshPredictionCount;
    private long __m_StatsRefreshTimeoutCount;
    private static ListMap __mapChildren;
    private static transient String __s_MsgLicense;

    static {
        Connector.__initStatic();
    }

    public Connector() {
        this(null, null, true);
    }

    public Connector(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setLocalRegistry(new SafeHashMap());
            this.setRefreshAttributeTimeoutMillis(250L);
            this.setRefreshPolicy(0);
            this.setRefreshRequestTimeoutMillis(60000L);
            this.setRefreshTimeoutMillis(1000L);
            this.setRemoteModels(new SafeHashMap());
            this.setRemoteServers(new SafeHashSet());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Announce", Connector$Announce.get_CLASS());
        Class clazz2 = __mapChildren.put("Notify", Connector$Notify.get_CLASS());
        Class clazz3 = __mapChildren.put("Register", Connector$Register.get_CLASS());
        Class clazz4 = __mapChildren.put("Subscribe", Connector$Subscribe.get_CLASS());
        Class clazz5 = __mapChildren.put("Unregister", Connector$Unregister.get_CLASS());
    }

    protected void announce(InvocationService service) {
        Member memberThis = service.getCluster().getLocalMember();
        Set setOther = service.getInfo().getServiceMembers();
        setOther.remove(memberThis);
        Connector$Announce task = (Connector$Announce)this._newChild("Announce");
        task.setMemberFrom(memberThis.getId());
        task.setManagingNode(this.isManagingNode());
        service.execute(task, setOther, task);
    }

    public void configure(XmlElement xmlConfig) {
        this.setRefreshTimeoutMillis(Base.parseTime(xmlConfig.getSafeElement("refresh-expiry").getString(Long.toString(this.getRefreshTimeoutMillis()))));
        this.setRefreshPolicy(this.convertRefreshPolicy(xmlConfig.getSafeElement("refresh-policy").getString(this.formatRefreshPolicy(this.getRefreshPolicy()))));
        this.setRefreshRequestTimeoutMillis(Base.parseTime(xmlConfig.getSafeElement("refresh-timeout").getString(Long.toString(this.getRefreshRequestTimeoutMillis()))));
    }

    public int convertRefreshPolicy(String sRefreshPolicy) {
        int nRefreshPolicy;
        if (sRefreshPolicy.equals("refresh-behind")) {
            nRefreshPolicy = REFRESH_BEHIND;
        } else if (sRefreshPolicy.equals("refresh-ahead")) {
            nRefreshPolicy = REFRESH_AHEAD;
        } else if (sRefreshPolicy.equals("refresh-onquery")) {
            nRefreshPolicy = REFRESH_ONQUERY;
        } else {
            if (sRefreshPolicy.equals("refresh-expired") ^ true) {
                Component._trace("Invalid refresh-policy selected; using \"refresh-expired\"", 2);
            }
            nRefreshPolicy = REFRESH_EXPIRED;
        }
        return nRefreshPolicy;
    }

    public LocalModel ensureFreshSnapshot(RemoteModel model) {
        int nPolicy = this.getRefreshPolicy();
        if (nPolicy == REFRESH_ONQUERY) {
            model.acquireExecuteMutex();
            model.releaseExecuteMutex();
        } else if (model.isRefreshRequired()) {
            this.setStatsRefreshCount(this.getStatsRefreshCount() + 1L);
            if (model.isAccessed() ^ true) {
                this.setStatsRefreshExcessCount(this.getStatsRefreshExcessCount() + 1L);
            }
            switch (nPolicy) {
                case 0: {
                    model.invokeRemote(RemoteModel.OP_GET, null, null);
                    break;
                }
                case 1: {
                    model.invokeRemote(RemoteModel.OP_GET, null, null);
                    this.refreshActiveModels(model);
                    break;
                }
                case 2: {
                    boolean fInvoked = model.invokeRemoteAsync();
                    if (!fInvoked) break;
                    this.setStatsRefreshPredictionCount(this.getStatsRefreshPredictionCount() + 1L);
                    break;
                }
            }
        }
        return model.getSnapshot();
    }

    public String formatRefreshPolicy(int nPolicy) {
        switch (nPolicy) {
            case 0: {
                return "refresh-expired";
            }
            case 1: {
                return "refresh-ahead";
            }
            case 2: {
                return "refresh-behind";
            }
            case 3: {
                return "refresh-onquery";
            }
        }
        return "n/a";
    }

    public Cluster getCluster() {
        InvocationService service = this.getService();
        return service == null ? Coherence.getCluster() : service.getCluster();
    }

    public Local getLocalGateway() {
        return this.__m_LocalGateway;
    }

    public int getLocalMemberId() {
        Cluster cluster = this.getCluster();
        return cluster == null ? 0 : cluster.getLocalMember().getId();
    }

    public Map getLocalRegistry() {
        return this.__m_LocalRegistry;
    }

    public Member getMember(int nId) {
        Grid service;
        SafeService serviceSafe = (SafeService)((Object)this.getService());
        if (serviceSafe != null && (!((service = (Grid)serviceSafe.getService()) != null) ? false : service.isRunning())) {
            return service.getServiceMemberSet().getMember(nId);
        }
        return null;
    }

    private static String getMsgLicense() {
        return __s_MsgLicense;
    }

    public long getRefreshAttributeTimeoutMillis() {
        return this.__m_RefreshAttributeTimeoutMillis;
    }

    public int getRefreshPolicy() {
        return this.__m_RefreshPolicy;
    }

    public long getRefreshRequestTimeoutMillis() {
        return this.__m_RefreshRequestTimeoutMillis;
    }

    public long getRefreshTimeoutMillis() {
        return this.__m_RefreshTimeoutMillis;
    }

    public Map getRemoteModels() {
        return this.__m_RemoteModels;
    }

    public Set getRemoteServers() {
        return this.__m_RemoteServers;
    }

    public InvocationService getService() {
        return this.__m_Service;
    }

    public long getStatsNotificationCount() {
        return this.__m_StatsNotificationCount;
    }

    public long getStatsRefreshCount() {
        return this.__m_StatsRefreshCount;
    }

    public long getStatsRefreshExcessCount() {
        return this.__m_StatsRefreshExcessCount;
    }

    public long getStatsRefreshPredictionCount() {
        return this.__m_StatsRefreshPredictionCount;
    }

    public long getStatsRefreshTimeoutCount() {
        return this.__m_StatsRefreshTimeoutCount;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/management/Connector".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new Connector();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isAnnounced() {
        return this.__m_Announced;
    }

    public boolean isManagingNode() {
        return this.__m_ManagingNode;
    }

    public boolean isRegisteredModel(String sName) {
        return this.getLocalRegistry().containsKey(MBeanHelper.stripDomain(sName));
    }

    public boolean isStarted() {
        return this.getService() != null;
    }

    public void memberJoined(MemberEvent event) {
        if (event.isLocal()) {
            this.announce(this.getService());
        }
    }

    public void memberLeaving(MemberEvent event) {
    }

    public void memberLeft(MemberEvent event) {
        Local localGateway = this.getLocalGateway();
        Member member = event.getMember();
        String sNodeId = String.valueOf("nodeId=") + member.getId();
        if (event.isLocal()) {
            if (localGateway != null) {
                localGateway.reset();
            }
            this.getRemoteServers().clear();
            this.getRemoteModels().clear();
            this.setService(null);
        } else {
            this.getRemoteServers().remove(member);
            this.removeRemoteSubscriptions(member);
            Gateway.removeByPattern(this.getRemoteModels(), sNodeId);
            if (localGateway != null) {
                localGateway.unregisterModelMBean(String.valueOf(sNodeId) + ",*");
            }
        }
    }

    public void onAnnouncement(Connector$Announce taskAnnounce) {
        Member memberFrom;
        if (taskAnnounce.isManagingNode() && (memberFrom = this.getMember(taskAnnounce.getMemberFrom())) != null) {
            this.getRemoteServers().add(memberFrom);
            this.registerAll(Collections.singleton(memberFrom));
        }
        taskAnnounce.setResult(this.isManagingNode() ? Boolean.TRUE : Boolean.FALSE);
    }

    public void onAnnouncementCompleted() {
        InvocationService service = this.getService();
        if (!(service != null) ? false : service.isRunning()) {
            this.setAnnounced(true);
            this.registerAll(this.getRemoteServers());
        }
    }

    public void onNotify(Connector$Notify taskNotify) {
        String sName = taskNotify.getName();
        RemoteModel model = (RemoteModel)this.getRemoteModels().get(sName);
        if (model == null) {
            Component._trace(String.valueOf("Error handling notification ") + sName, 5);
        } else {
            model._handleNotification(taskNotify.getNotification());
            this.setStatsNotificationCount(this.getStatsNotificationCount() + 1L);
        }
    }

    public void onRegister(Connector$Register taskRegister) {
        block7: {
            Local localGateway = this.getLocalGateway();
            if (!(localGateway != null)) break block7;
            Member member = this.getMember(taskRegister.getMemberFrom());
            if (member == null) {
                return;
            }
            try {
                LocalModel[] aModel = taskRegister.getSnapshot();
                int i = 0;
                int c = aModel.length;
                while (i < c) {
                    LocalModel model = aModel[i];
                    String sName = model.get_ModelName();
                    try {
                        RemoteModel modelRemote = new RemoteModel();
                        modelRemote.set_ModelName(sName);
                        modelRemote.setSnapshot(model);
                        modelRemote.setModelOwner(member);
                        modelRemote.setConnector(this);
                        modelRemote.setAccessed(false);
                        Map mapRemoteModels = this.getRemoteModels();
                        if (mapRemoteModels == null) {
                            mapRemoteModels = new SafeHashMap();
                            this.setRemoteModels(mapRemoteModels);
                        }
                        mapRemoteModels.put(sName, modelRemote);
                        localGateway.registerModelMBean(sName, modelRemote);
                    }
                    catch (RuntimeException e) {
                        Component._trace(String.valueOf("Failed to register MBean: ") + sName, 1);
                        Component._trace(e);
                    }
                    ++i;
                }
            }
            catch (RuntimeException e) {
                Component._trace(String.valueOf("Ignoring RegisterRequest exception\n") + Component.getStackTrace(e), 5);
            }
        }
    }

    public void onSubscribe(Connector$Subscribe taskSubscribe) {
        String sName = taskSubscribe.getName();
        LocalModel model = (LocalModel)this.getLocalRegistry().get(sName);
        if (model == null) {
            Component._trace(String.valueOf("Error updating subscription; unable to locate local model: ") + sName, 2);
        } else if (taskSubscribe.getAction() == Connector$Subscribe.ACTION_SUBSCRIBE) {
            model._addRemoteNotificationListener(taskSubscribe.getHolder(), this);
        } else {
            int nMemberId = taskSubscribe.getMemberId();
            long[] alId = taskSubscribe.getHolderId();
            int i = 0;
            int c = alId.length;
            while (i < c) {
                model._removeRemoteNotificationListener(nMemberId, alId[i]);
                ++i;
            }
        }
    }

    public void onUnregister(Connector$Unregister taskUnregister) {
        block3: {
            Local localGateway = this.getLocalGateway();
            if (!(localGateway != null)) break block3;
            try {
                String sName = taskUnregister.getName();
                Map mapModels = this.getRemoteModels();
                localGateway.unregisterModelMBean(sName);
                if (sName.endsWith(",*")) {
                    String sPattern = sName.substring(0, sName.length() - 2);
                    Gateway.removeByPattern(mapModels, sPattern);
                    break block3;
                }
                mapModels.remove(sName);
            }
            catch (RuntimeException e) {
                Component._trace(String.valueOf("Ignoring UnregisterRequest exception\n") + Component.getStackTrace(e), 5);
            }
        }
    }

    public void refreshActiveModels(RemoteModel model) {
        long cRefresh = 0L;
        Iterator iter = this.getRemoteModels().values().iterator();
        while (iter.hasNext()) {
            RemoteModel modelNext = (RemoteModel)iter.next();
            if (!(!(!modelNext.isRefreshRequired() ? false : modelNext.isAccessed()) ? false : modelNext.invokeRemoteAsync())) continue;
            ++cRefresh;
        }
        this.setStatsRefreshPredictionCount(this.getStatsRefreshPredictionCount() + cRefresh);
    }

    public void refreshRemoteModels(Set setModels) {
        if (setModels != null) {
            Map mapModels = this.getRemoteModels();
            long cRefresh = 0L;
            Iterator iter = setModels.iterator();
            while (iter.hasNext()) {
                Object oMBean = iter.next();
                ObjectName oname = oMBean instanceof ObjectInstance ? ((ObjectInstance)oMBean).getObjectName() : (ObjectName)oMBean;
                RemoteModel model = (RemoteModel)mapModels.get(oname.getKeyPropertyListString());
                if (!(model != null)) continue;
                if (model.isAccessed() ^ true) {
                    this.setStatsRefreshExcessCount(this.getStatsRefreshExcessCount() + 1L);
                }
                if (!model.invokeRemoteAsync()) continue;
                ++cRefresh;
            }
            this.setStatsRefreshPredictionCount(this.getStatsRefreshPredictionCount() + cRefresh);
            this.setStatsRefreshCount(this.getStatsRefreshCount() + cRefresh);
        }
    }

    protected void registerAll(Set setMembers) {
        LocalModel[] aModel = this.getLocalRegistry().values().toArray(new LocalModel[0]);
        if (!(aModel != null) ? false : aModel.length > 0) {
            this.sendRegister(setMembers, aModel);
        }
    }

    public void registerMemberListener(MemberListener listener) {
        this.getService().addMemberListener(listener);
    }

    public void registerModel(LocalModel model) {
        Set setServers;
        InvocationService service;
        String sName = model.get_ModelName();
        Component._assert(model.is_Snapshot() ^ true);
        Component._assert(sName != null);
        LocalModel modelOld = this.getLocalRegistry().put(sName, model);
        if (modelOld != null) {
            boolean fSkipSend;
            if (!(model instanceof WrapperModel) ? false : modelOld instanceof WrapperModel) {
                fSkipSend = ((WrapperModel)model).getMBean().getClass() == ((WrapperModel)modelOld).getMBean().getClass();
            } else {
                boolean bl = fSkipSend = model.getClass() == modelOld.getClass();
            }
            if (fSkipSend) {
                return;
            }
        }
        if ((!(!((service = this.getService()) != null) ? false : this.isAnnounced()) ? false : Gateway.isGlobal(sName)) && (setServers = this.getRemoteServers()).isEmpty() ^ true) {
            this.sendRegister(setServers, new LocalModel[]{model});
        }
    }

    protected void removeRemoteSubscriptions(Member member) {
        Iterator iter = this.getLocalRegistry().values().iterator();
        while (iter.hasNext()) {
            LocalModel model = (LocalModel)iter.next();
            RemoteHandler handler = model.get_RemoteNotificationHandler();
            if (!(handler != null)) continue;
            handler.unsubscribeMember(member.getId());
        }
    }

    public String reportSubscriptions() {
        StringBuffer sb = new StringBuffer("LocalModels=\n");
        Iterator iter = this.getLocalRegistry().values().iterator();
        while (iter.hasNext()) {
            LocalModel local = (LocalModel)iter.next();
            sb.append("Name=").append(local.get_ModelName()).append(",LocalHandler=").append(local.get_LocalNotificationHandler()).append(",RemoteHandler=").append(local.get_RemoteNotificationHandler()).append('\n');
        }
        sb.append("RemoteModels=\n");
        iter = this.getRemoteModels().values().iterator();
        while (iter.hasNext()) {
            RemoteModel remote = (RemoteModel)iter.next();
            sb.append("Name=").append(remote.get_ModelName()).append(",LocalHandler=").append(remote.get_LocalNotificationHandler()).append('\n');
        }
        return sb.toString();
    }

    public void resetStatistics() {
        this.setStatsRefreshCount(0L);
        this.setStatsRefreshPredictionCount(0L);
        this.setStatsRefreshExcessCount(0L);
        this.setStatsRefreshTimeoutCount(0L);
        this.setStatsNotificationCount(0L);
    }

    public void sendNotification(Set setMembers, String sName, Notification notification) {
        Connector$Notify task = (Connector$Notify)this._newChild("Notify");
        task.setName(sName);
        task.setNotification(notification);
        this.getService().execute(task, setMembers, null);
    }

    protected void sendRegister(Set setMembers, LocalModel[] aModel) {
        Connector$Register task = (Connector$Register)this._newChild("Register");
        task.setMemberFrom(this.getLocalMemberId());
        task.setSnapshot(aModel);
        try {
            this.getService().execute(task, setMembers, null);
        }
        catch (Exception e) {
            Component._trace(String.valueOf("Failed to register ") + aModel.length + " MBeans " + Component.getStackTrace(e), 1);
        }
    }

    protected void setAnnounced(boolean f) {
        this.__m_Announced = f;
    }

    public void setLocalGateway(Local gateway) {
        this.__m_LocalGateway = gateway;
    }

    protected void setLocalRegistry(Map map) {
        this.__m_LocalRegistry = map;
    }

    public void setManagingNode(boolean fManagingNode) {
        this.__m_ManagingNode = fManagingNode;
    }

    private static void setMsgLicense(String sMsg) {
        __s_MsgLicense = sMsg;
    }

    protected void setRefreshAttributeTimeoutMillis(long cMillis) {
        this.__m_RefreshAttributeTimeoutMillis = cMillis;
    }

    public void setRefreshPolicy(int nPolicy) {
        this.__m_RefreshPolicy = nPolicy;
    }

    protected void setRefreshRequestTimeoutMillis(long cMillis) {
        this.__m_RefreshRequestTimeoutMillis = cMillis;
    }

    public void setRefreshTimeoutMillis(long cMillis) {
        this.__m_RefreshTimeoutMillis = cMillis;
    }

    protected void setRemoteModels(Map mapModels) {
        this.__m_RemoteModels = mapModels;
    }

    protected void setRemoteServers(Set setMember) {
        this.__m_RemoteServers = setMember;
    }

    protected void setService(InvocationService service) {
        this.__m_Service = service;
    }

    protected void setStatsNotificationCount(long cNotifications) {
        this.__m_StatsNotificationCount = cNotifications;
    }

    protected void setStatsRefreshCount(long cSync) {
        this.__m_StatsRefreshCount = cSync;
    }

    protected void setStatsRefreshExcessCount(long cMiss) {
        this.__m_StatsRefreshExcessCount = cMiss;
    }

    protected void setStatsRefreshPredictionCount(long cRefresh) {
        this.__m_StatsRefreshPredictionCount = cRefresh;
    }

    public void setStatsRefreshTimeoutCount(long cCount) {
        this.__m_StatsRefreshTimeoutCount = cCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startService(Cluster cluster, String sServiceName) {
        Connector connector = this;
        synchronized (connector) {
            if (this.isStarted()) {
                return;
            }
            if (Connector.getMsgLicense() != null) return;
            boolean bl = false;
            if (bl) {
                return;
            }
            try {
                InvocationService service = (InvocationService)cluster.ensureService(sServiceName, InvocationService.TYPE_DEFAULT);
                this.setService(service);
                service.setContextClassLoader(this.getClass().getClassLoader());
                service.setUserContext(this);
                service.addMemberListener(this);
                URL url = Resources.findResource("management-config.xml", null);
                if (url != null) {
                    try {
                        XmlDocument xml = XmlHelper.loadXml(url.openStream());
                        if (xml != null) {
                            service.configure(xml);
                        }
                    }
                    catch (Exception e) {
                        throw Base.ensureRuntimeException(e);
                    }
                }
                if (((SafeService)((Object)service)).isRestarting()) {
                    Component._trace(String.valueOf("Resetting the JMX Connector; State=") + ((SafeService)((Object)service)).getSafeServiceState(), 3);
                } else {
                    service.start();
                }
            }
            catch (LicenseException e) {
                String sMsg = e.getMessage();
                Connector.setMsgLicense(sMsg);
                Component._trace(String.valueOf("Unable to initialize JMX remote management. ") + sMsg + " It will not be possible to manage this node remotely.", 2);
            }
            return;
        }
    }

    public void subscribe(String sName, Member memberTarget, RemoteHolder holder) {
        holder.setMemberId(this.getLocalMemberId());
        Connector$Subscribe task = new Connector$Subscribe();
        task.setAction(Connector$Subscribe.ACTION_SUBSCRIBE);
        task.setName(sName);
        task.setHolder(holder);
        this.getService().execute(task, Collections.singleton(memberTarget), null);
    }

    public void unregisterModel(String sGivenName) {
        Set setServers;
        Map mapRegistry = this.getLocalRegistry();
        String sName = MBeanHelper.stripDomain(sGivenName);
        if (sName.endsWith(",*")) {
            String sPattern = sName.substring(0, sName.length() - 2);
            Gateway.removeByPattern(mapRegistry, sPattern);
        } else {
            mapRegistry.remove(sName);
        }
        InvocationService service = this.getService();
        if ((!(!(service != null) ? false : this.isAnnounced()) ? false : Gateway.isGlobal(sName)) && (setServers = this.getRemoteServers()).isEmpty() ^ true) {
            Connector$Unregister task = (Connector$Unregister)this._newChild("Unregister");
            task.setMemberFrom(this.getLocalMemberId());
            task.setName(sName);
            service.execute(task, setServers, null);
        }
    }

    public void unsubscribe(String sName, Member memberTarget, Set setHolders) {
        long[] alId = new long[setHolders.size()];
        int ix = 0;
        Iterator iter = setHolders.iterator();
        while (iter.hasNext()) {
            LocalHolder holder = (LocalHolder)iter.next();
            RemoteHolder hRemote = holder.getRemoteHolder();
            if (!(hRemote != null)) continue;
            alId[ix++] = hRemote.getHolderId();
        }
        Connector$Subscribe task = new Connector$Subscribe();
        task.setAction(Connector$Subscribe.ACTION_UNSUBSCRIBE);
        task.setName(sName);
        task.setMemberId(this.getLocalMemberId());
        task.setHolderId(alId);
        this.getService().execute(task, Collections.singleton(memberTarget), null);
    }
}

