/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management.gateway;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Manageable;
import com.tangosol.coherence.component.manageable.ModelAdapter;
import com.tangosol.coherence.component.net.management.Gateway;
import com.tangosol.coherence.component.net.management.Model;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.reporter.ReportBatch;
import com.tangosol.coherence.reporter.ReportControl;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.net.management.Registry;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.WrapperException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class Local
extends Gateway {
    private transient Map __m_ObjectNameCache;
    private transient Gateway __m_RemoteGateway;
    private MBeanServer __m_Server;

    public Local() {
        this(null, null, true);
    }

    public Local(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setCustomBeans(new SafeHashMap());
            this.setDomainName("Coherence");
            this.setLocalModels(new SafeHashMap());
            this.setReadOnly(false);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void configure(XmlElement xmlConfig) {
        String sDomain;
        super.configure(xmlConfig);
        this.setObjectNameCache(new LocalCache(100));
        this.setServer(MBeanHelper.findMBeanServer(xmlConfig.getSafeElement("default-domain-name").getString()));
        String sPrefix = this.getDomainName();
        String sSuffix = "";
        int iClone = 0;
        while (this.isClusterRunning(sDomain = String.valueOf(sPrefix) + sSuffix)) {
            sSuffix = String.valueOf("@") + ++iClone;
        }
        this.setDomainName(sDomain);
        this.unregisterModelMBean("*");
        XmlElement xmlReporter = xmlConfig.getSafeElement("reporter");
        ReportControl reportControl = this.getReportControl();
        reportControl.setDependencies(new ReportBatch.LegacyXmlReporterDependencies().fromXml(xmlReporter));
    }

    protected ObjectName getObjectName(String sName) throws MalformedObjectNameException {
        Map map = this.getObjectNameCache();
        ObjectName name = (ObjectName)map.get(sName);
        if (name == null) {
            String sDomain = this.getDomainName();
            int ofDomain = sName.indexOf(58);
            int ofEquals = sName.indexOf(61);
            if (!(0 <= ofEquals) ? false : ofEquals < ofDomain) {
                ofDomain = -1;
            }
            name = ofDomain == -1 ? new ObjectName(MBeanHelper.quoteCanonical(String.valueOf(sDomain) + ':' + sName)) : (ofDomain == 0 ? new ObjectName(MBeanHelper.quoteCanonical(String.valueOf(sDomain) + sName)) : new ObjectName(MBeanHelper.quoteCanonical(sName)));
            map.put(sName, name);
        }
        return name;
    }

    public Map getObjectNameCache() {
        return this.__m_ObjectNameCache;
    }

    public Gateway getRemoteGateway() {
        return this.__m_RemoteGateway;
    }

    public MBeanServer getServer() {
        return this.__m_Server;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/management/gateway/Local".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Local();
    }

    private final Component get_Module() {
        return this;
    }

    public Manageable instantiateModelMBean(Model model) {
        String sName = model.get_MBeanComponent();
        ModelAdapter mbean = (ModelAdapter)Component._newInstance(sName);
        Component._assert(mbean != null, String.valueOf("Invalid MBean name: ") + sName);
        mbean.set_Model(model);
        return mbean;
    }

    protected boolean isClusterRunning(String sDomain) {
        try {
            Boolean FRunning;
            ObjectName nameCluster = new ObjectName(String.valueOf(sDomain) + ':' + Registry.CLUSTER_TYPE);
            if (this.getServer().isRegistered(nameCluster) && (FRunning = (Boolean)this.getServer().getAttribute(nameCluster, "Running")).booleanValue()) {
                return true;
            }
        }
        catch (JMException jMException) {}
        return false;
    }

    public boolean isRegistered(String sCanonicalName) {
        try {
            return this.getServer().isRegistered(this.getObjectName(sCanonicalName));
        }
        catch (JMException e) {
            return false;
        }
    }

    public void onRegistration(int nAction, String sCanonicalName, String sBeanClassName) {
    }

    public void registerLocalModel(String sCanonicalName, LocalModel model) {
        super.registerLocalModel(sCanonicalName, model);
        this.registerModelMBean(sCanonicalName, model);
        Gateway gatewayRemote = this.getRemoteGateway();
        if (gatewayRemote != null) {
            gatewayRemote.registerLocalModel(sCanonicalName, model);
        }
    }

    public void registerModelMBean(String sCanonicalName, Model model) {
        MBeanServer server = this.getServer();
        try {
            boolean fRetry = true;
            ObjectName name = this.getObjectName(sCanonicalName);
            while (true) {
                if (server.isRegistered(name)) {
                    server.unregisterMBean(name);
                }
                try {
                    server.registerMBean(this.instantiateModelMBean(model), name);
                }
                catch (InstanceAlreadyExistsException e) {
                    if (fRetry) {
                        name = new ObjectName(e.getMessage());
                        fRetry = false;
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }
        catch (MalformedObjectNameException e) {
            Component._trace(String.valueOf("Failed to register MBean: ") + model + "; reason=" + Component.getStackTrace(e), 1);
        }
        catch (JMException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public void reset() {
        super.reset();
        this.unregisterGlobalMBeans();
        Gateway gatewayRemote = this.getRemoteGateway();
        if (gatewayRemote != null) {
            gatewayRemote.reset();
        }
    }

    protected void setObjectNameCache(Map map) {
        this.__m_ObjectNameCache = map;
    }

    public void setRemoteGateway(Gateway gateway) {
        this.__m_RemoteGateway = gateway;
    }

    protected void setServer(MBeanServer server) {
        this.__m_Server = server;
    }

    public void unregisterGlobalMBeans() {
        MBeanServer server = this.getServer();
        try {
            Map mapNames = this.getObjectNameCache();
            Set<ObjectName> setNames = server.queryNames(this.getObjectName("*"), null);
            Iterator iter = setNames.iterator();
            while (iter.hasNext()) {
                ObjectName oname = (ObjectName)iter.next();
                if (!Gateway.isGlobal(oname.toString())) continue;
                try {
                    mapNames.remove(oname.getKeyPropertyListString());
                    server.unregisterMBean(oname);
                }
                catch (JMException e) {
                    // empty catch block
                }
            }
        }
        catch (JMException e) {
            Component._trace(String.valueOf("Unregister query failed: ") + e, 4);
        }
    }

    public void unregisterLocalModel(String sCanonicalName) {
        super.unregisterLocalModel(sCanonicalName);
        this.unregisterModelMBean(sCanonicalName);
        Gateway gatewayRemote = this.getRemoteGateway();
        if (gatewayRemote != null) {
            gatewayRemote.unregisterLocalModel(sCanonicalName);
        }
    }

    public void unregisterModelMBean(String sCanonicalName) {
        MBeanServer server = this.getServer();
        try {
            Map mapNames = this.getObjectNameCache();
            Set<ObjectName> setNames = server.queryNames(this.getObjectName(sCanonicalName), null);
            Iterator iter = setNames.iterator();
            while (iter.hasNext()) {
                ObjectName oname = null;
                try {
                    oname = (ObjectName)iter.next();
                    mapNames.remove(oname.getKeyPropertyListString());
                    server.unregisterMBean(oname);
                }
                catch (Exception e) {
                    Component._trace(String.valueOf("Failed to unregister MBean ") + oname + "; " + e, 4);
                }
            }
            mapNames.remove(sCanonicalName);
        }
        catch (JMException e) {
            Component._trace(String.valueOf("Unregister query failed: ") + e, 4);
        }
    }
}

