/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.memberSet.actualMemberSet;

import com.oracle.common.net.exabus.EndPoint;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet$Iterator;
import com.tangosol.coherence.component.net.memberSet.ActualMemberSet;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableHashMap;
import com.tangosol.util.ObservableMap;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class ServiceMemberSet
extends ActualMemberSet {
    public static final int MEMBER_JOINED = 2;
    public static final int MEMBER_JOINING = 1;
    public static final int MEMBER_LEAVING = 3;
    public static final int MEMBER_NEW = 0;
    private transient AtomicLong[] __m_BackloggedAtomic;
    private ObservableMap[] __m_MemberConfigMap;
    private Member __m_OldestMember;
    private transient boolean[] __m_ServiceBacklogged;
    private transient EndPoint[] __m_ServiceEndPoint;
    private transient String[] __m_ServiceEndPointName;
    private transient int __m_ServiceId;
    private long[] __m_ServiceJoinTime;
    private transient String __m_ServiceName;
    private String[] __m_ServiceVersion;
    private int[] __m_State;
    private static ListMap __mapChildren;

    static {
        ServiceMemberSet.__initStatic();
    }

    public ServiceMemberSet() {
        this(null, null, true);
    }

    public ServiceMemberSet(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Iterator", MemberSet$Iterator.get_CLASS());
    }

    public synchronized void clear() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(ServiceMemberSet setMember) {
        Component._assert(this.isEmpty());
        this.setServiceId(setMember.getServiceId());
        this.setServiceName(setMember.getServiceName());
        ServiceMemberSet serviceMemberSet = setMember;
        synchronized (serviceMemberSet) {
            Iterator iter = setMember.iterator();
            while (iter.hasNext()) {
                Member member = (Member)iter.next();
                int nMember = member.getId();
                this.add(member);
                this.setServiceVersion(nMember, setMember.getServiceVersion(nMember));
                this.setServiceJoinTime(nMember, setMember.getServiceJoinTime(nMember));
                this.setServiceEndPointName(nMember, setMember.getServiceEndPointName(nMember));
                this.setState(nMember, setMember.getState(nMember));
                this.ensureMemberConfigMap(nMember).putAll(setMember.getMemberConfigMap(nMember));
                setMember.setMemberConfigMap(nMember, null);
            }
            Component._assert(!this.equals(setMember) ? false : this.getOldestMember() == setMember.getOldestMember());
        }
    }

    public synchronized ObservableMap ensureMemberConfigMap(int i) {
        ObservableMap[] amap = this.getMemberConfigMap();
        ObservableMap map = (amap == null ? true : i >= amap.length) ? null : amap[i];
        if (map == null) {
            map = new ObservableHashMap();
            this.setMemberConfigMap(i, map);
        }
        return map;
    }

    public static String formatEndPoint(String sName) {
        return (sName == null ? true : sName.length() == 0) ? "datagram" : sName;
    }

    public static String formatJoinTime(long ldt) {
        return new Timestamp(ldt).toString();
    }

    public static String formatStateName(int nState) {
        switch (nState) {
            case 0: {
                return "NEW";
            }
            case 1: {
                return "JOINING";
            }
            case 2: {
                return "JOINED";
            }
            case 3: {
                return "LEAVING";
            }
        }
        return "<unknown>";
    }

    protected AtomicLong[] getBackloggedAtomic() {
        return this.__m_BackloggedAtomic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AtomicLong getBackloggedAtomic(int i) {
        AtomicLong[] aBits = this.getBackloggedAtomic();
        if (aBits == null ? true : i >= aBits.length) {
            ServiceMemberSet serviceMemberSet = this;
            synchronized (serviceMemberSet) {
                aBits = this.getBackloggedAtomic();
                if (aBits == null ? true : i >= aBits.length) {
                    AtomicLong[] aBitsNew = new AtomicLong[i + 8];
                    if (aBits != null) {
                        System.arraycopy(aBits, 0, aBitsNew, 0, aBits.length);
                    }
                    int j = aBits == null ? 0 : aBits.length;
                    while (j < aBitsNew.length) {
                        aBitsNew[j] = new AtomicLong();
                        ++j;
                    }
                    aBits = aBitsNew;
                    this.setBackloggedAtomic(aBits);
                }
            }
        }
        return aBits[i];
    }

    public String getDescription(boolean fShowTransport) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf("\n  OldestMember=") + this.getOldestMember()).append(String.valueOf("\n  ActualMemberSet=") + Base.indentString(this.toString(Member.SHOW_STD), "  ", false)).append("\n  MemberId|ServiceVersion|ServiceJoined|MemberState");
        if (fShowTransport) {
            sb.append("|EndPoint");
        }
        boolean fFirst = true;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (fFirst) {
                fFirst = false;
            } else {
                sb.append(',');
            }
            int nMember = ((Member)iter.next()).getId();
            sb.append("\n    ").append(nMember).append('|').append(this.getServiceVersion(nMember)).append('|').append(ServiceMemberSet.formatJoinTime(this.getServiceJoinTime(nMember))).append('|').append(ServiceMemberSet.formatStateName(this.getState(nMember)));
            if (!fShowTransport) continue;
            sb.append('|').append(ServiceMemberSet.formatEndPoint(this.getServiceEndPointName(nMember)));
        }
        return sb.toString();
    }

    protected ObservableMap[] getMemberConfigMap() {
        return this.__m_MemberConfigMap;
    }

    public ObservableMap getMemberConfigMap(int i) {
        ObservableMap[] amap = this.getMemberConfigMap();
        ObservableMap map = (amap == null ? true : i >= amap.length) ? null : amap[i];
        if (map == null) {
            map = NullImplementation.getObservableMap();
        }
        return map;
    }

    public Member getOldestMember() {
        return this.__m_OldestMember;
    }

    protected EndPoint[] getServiceEndPoint() {
        return this.__m_ServiceEndPoint;
    }

    public EndPoint getServiceEndPoint(int i) {
        EndPoint[] aPoint = this.getServiceEndPoint();
        return (aPoint == null ? true : i >= aPoint.length) ? null : aPoint[i];
    }

    protected String[] getServiceEndPointName() {
        return this.__m_ServiceEndPointName;
    }

    public String getServiceEndPointName(int i) {
        String[] asEndPoint = this.getServiceEndPointName();
        return (asEndPoint == null ? true : i >= asEndPoint.length) ? null : asEndPoint[i];
    }

    public int getServiceId() {
        return this.__m_ServiceId;
    }

    protected long[] getServiceJoinTime() {
        return this.__m_ServiceJoinTime;
    }

    public long getServiceJoinTime(int i) {
        long[] alMillis = this.getServiceJoinTime();
        return (alMillis == null ? true : i >= alMillis.length) ? 0L : alMillis[i];
    }

    public String getServiceName() {
        return this.__m_ServiceName;
    }

    protected String[] getServiceVersion() {
        return this.__m_ServiceVersion;
    }

    public String getServiceVersion(int i) {
        String[] asVersion = this.getServiceVersion();
        return (asVersion == null ? true : i >= asVersion.length) ? null : asVersion[i];
    }

    protected int[] getState() {
        return this.__m_State;
    }

    public int getState(int i) {
        int[] anState = this.getState();
        return (anState == null ? true : i >= anState.length) ? 0 : anState[i];
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/memberSet/actualMemberSet/ServiceMemberSet".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new ServiceMemberSet();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isServiceBacklogged(int i) {
        return (this.getBackloggedAtomic(i / 64).get() & 1L << i % 64) != (long)0;
    }

    public boolean isServiceJoined(int nMember) {
        return this.getState(nMember) == MEMBER_JOINED;
    }

    public boolean isServiceJoining(int nMember) {
        return this.getState(nMember) == MEMBER_JOINING;
    }

    public boolean isServiceLeaving(int nMember) {
        return this.getState(nMember) == MEMBER_LEAVING;
    }

    public synchronized boolean remove(Object o) {
        if (super.remove(o)) {
            Member memberLeft = (Member)o;
            int nId = memberLeft.getId();
            this.setServiceVersion(nId, null);
            this.setServiceJoinTime(nId, 0L);
            this.setServiceEndPoint(nId, null);
            this.setServiceBacklogged(nId, false);
            this.setMemberConfigMap(nId, null);
            this.setState(nId, 0);
            if (!(this.getServiceId() > 0) ? false : memberLeft == this.getOldestMember()) {
                Member memberOldest = null;
                long lOldestJoined = Long.MAX_VALUE;
                int nOldestId = 0;
                Iterator iter = this.iterator();
                while (iter.hasNext()) {
                    Member member = (Member)iter.next();
                    int nMemberId = member.getId();
                    long lMemberJoined = this.getServiceJoinTime(member.getId());
                    Component._assert(!(lMemberJoined > 0L) ? false : lMemberJoined != lOldestJoined);
                    if (!(lMemberJoined < lOldestJoined)) continue;
                    memberOldest = member;
                    nOldestId = nMemberId;
                    lOldestJoined = lMemberJoined;
                }
                this.setOldestMember(memberOldest);
            }
            return true;
        }
        return false;
    }

    protected void setBackloggedAtomic(int i, AtomicLong point) {
        this.getBackloggedAtomic()[i] = point;
    }

    protected void setBackloggedAtomic(AtomicLong[] aPoint) {
        this.__m_BackloggedAtomic = aPoint;
    }

    protected synchronized void setMemberConfigMap(int i, ObservableMap map) {
        boolean fBeyondBounds;
        ObservableMap[] amap = this.getMemberConfigMap();
        boolean bl = fBeyondBounds = amap == null ? true : i >= amap.length;
        if (!(map != null) ? false : fBeyondBounds) {
            ObservableMap[] amapNew = new ObservableMap[i + 8];
            if (amap != null) {
                System.arraycopy(amap, 0, amapNew, 0, amap.length);
            }
            amap = amapNew;
            this.setMemberConfigMap(amap);
            fBeyondBounds = false;
        }
        if (fBeyondBounds ^ true) {
            amap[i] = map;
        }
    }

    protected void setMemberConfigMap(ObservableMap[] amap) {
        this.__m_MemberConfigMap = amap;
    }

    protected void setOldestMember(Member member) {
        this.__m_OldestMember = member;
    }

    public void setServiceBacklogged(int i, boolean fBacklogged) {
        long lCur;
        AtomicLong atl = this.getBackloggedAtomic(i / 64);
        long iBit = 1L << i % 64;
        while (atl.compareAndSet(lCur = atl.get(), fBacklogged ? lCur | iBit : lCur & (iBit ^ 0xFFFFFFFFFFFFFFFFL)) ^ true) {
        }
    }

    public void setServiceEndPoint(int i, EndPoint point) {
        boolean fBeyondBounds;
        EndPoint[] aPoint = this.getServiceEndPoint();
        boolean bl = fBeyondBounds = aPoint == null ? true : i >= aPoint.length;
        if (!(point != null) ? false : fBeyondBounds) {
            EndPoint[] aPointNew = new EndPoint[i + 8];
            if (aPoint != null) {
                System.arraycopy(aPoint, 0, aPointNew, 0, aPoint.length);
            }
            aPoint = aPointNew;
            this.setServiceEndPoint(aPoint);
            fBeyondBounds = false;
        }
        if (fBeyondBounds ^ true) {
            aPoint[i] = point;
            this.setServiceBacklogged(i, false);
        }
    }

    protected void setServiceEndPoint(EndPoint[] aPoint) {
        this.__m_ServiceEndPoint = aPoint;
    }

    public void setServiceEndPointName(int i, String sEndPoint) {
        boolean fBeyondBounds;
        String[] asEndPoint = this.getServiceEndPointName();
        boolean bl = fBeyondBounds = asEndPoint == null ? true : i >= asEndPoint.length;
        if (!(sEndPoint != null) ? false : fBeyondBounds) {
            String[] asEndPointNew = new String[i + 8];
            if (asEndPoint != null) {
                System.arraycopy(asEndPoint, 0, asEndPointNew, 0, asEndPoint.length);
            }
            asEndPoint = asEndPointNew;
            this.setServiceEndPointName(asEndPoint);
            fBeyondBounds = false;
        }
        if (fBeyondBounds ^ true) {
            asEndPoint[i] = sEndPoint;
        }
    }

    protected void setServiceEndPointName(String[] asName) {
        this.__m_ServiceEndPointName = asName;
    }

    public void setServiceId(int nId) {
        this.__m_ServiceId = nId;
    }

    public synchronized void setServiceJoinTime(int i, long lMillis) {
        boolean fBeyondBounds;
        long[] alMillis = this.getServiceJoinTime();
        boolean bl = fBeyondBounds = alMillis == null ? true : i >= alMillis.length;
        if (!(lMillis != 0L) ? false : fBeyondBounds) {
            long[] alMillisNew = new long[i + 8];
            if (alMillis != null) {
                System.arraycopy(alMillis, 0, alMillisNew, 0, alMillis.length);
            }
            alMillis = alMillisNew;
            this.setServiceJoinTime(alMillis);
            fBeyondBounds = false;
        }
        if (fBeyondBounds ^ true) {
            if (!(lMillis > 0L) ? false : this.getServiceId() > 0) {
                Member memberOldest = this.getOldestMember();
                if (memberOldest == null) {
                    this.setOldestMember(this.getMember(i));
                } else {
                    int nMemberId = i;
                    long lMemberJoined = lMillis;
                    int nOldestId = memberOldest.getId();
                    long lOldestJoined = alMillis[nOldestId];
                    Component._assert(!(nMemberId != nOldestId) ? false : lMemberJoined != lOldestJoined, String.valueOf("Member=") + nMemberId + "(Joined=" + lMemberJoined + "), Oldest=" + nOldestId + "(Joined=" + lOldestJoined + ')');
                    if (lMemberJoined < lOldestJoined) {
                        this.setOldestMember(this.getMember(nMemberId));
                    }
                }
            }
            alMillis[i] = lMillis;
        }
    }

    protected void setServiceJoinTime(long[] alMillis) {
        this.__m_ServiceJoinTime = alMillis;
    }

    public void setServiceJoined(int nMember) {
        this.setState(nMember, MEMBER_JOINED);
    }

    public void setServiceJoining(int nMember) {
        this.setState(nMember, MEMBER_JOINING);
    }

    public void setServiceLeaving(int nMember) {
        this.setState(nMember, MEMBER_LEAVING);
    }

    public void setServiceName(String sName) {
        this.__m_ServiceName = sName;
    }

    public synchronized void setServiceVersion(int i, String sVersion) {
        boolean fBeyondBounds;
        String[] asVersion = this.getServiceVersion();
        boolean bl = fBeyondBounds = asVersion == null ? true : i >= asVersion.length;
        if (!(sVersion != null) ? false : fBeyondBounds) {
            String[] asVersionNew = new String[i + 8];
            if (asVersion != null) {
                System.arraycopy(asVersion, 0, asVersionNew, 0, asVersion.length);
            }
            asVersion = asVersionNew;
            this.setServiceVersion(asVersion);
            fBeyondBounds = false;
        }
        if (fBeyondBounds ^ true) {
            asVersion[i] = sVersion;
        }
    }

    protected void setServiceVersion(String[] asVersion) {
        this.__m_ServiceVersion = asVersion;
    }

    public synchronized void setState(int i, int nState) {
        int[] anState = this.getState();
        if (anState == null ? true : i >= anState.length) {
            int[] anStateNew = new int[i + 8];
            if (anState != null) {
                System.arraycopy(anState, 0, anStateNew, 0, anState.length);
            }
            anState = anStateNew;
            this.setState(anState);
        }
        anState[i] = nState;
    }

    protected void setState(int[] aiState) {
        this.__m_State = aiState;
    }

    public String toString() {
        return String.valueOf(this.get_Name()) + '(' + this.getDescription(true) + "\n  )";
    }

    public void updateMemberConfigMap(int nMember, Map mapConfig, boolean fNew) {
        if (mapConfig != null) {
            ObservableMap mapOldConfig = this.ensureMemberConfigMap(nMember);
            if (fNew) {
                mapOldConfig.clear();
                mapOldConfig.putAll(mapConfig);
            } else {
                mapOldConfig.keySet().retainAll(mapConfig.keySet());
                mapOldConfig.putAll(mapConfig);
            }
        }
    }
}

