/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.message;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.packet.messagePacket.Broadcast;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.Disposable;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.IOException;
import java.net.SocketAddress;

public class DiscoveryMessage
extends Message {
    private transient boolean __m_ReadError;
    private SocketAddress __m_SourceAddress;
    private Member __m_ToMember;

    public DiscoveryMessage() {
        this(null, null, true);
    }

    public DiscoveryMessage(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setBufferUsageCounter(1);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void ensureEOS(DataInput stream) throws IOException {
        if (stream.skipBytes(1) == 0) {
            return;
        }
        throw new IOException("message contains more data then expected");
    }

    public String getClusterName() {
        return this.getFromMember().getClusterName();
    }

    public SocketAddress getSourceAddress() {
        return this.__m_SourceAddress;
    }

    public Member getToMember() {
        return this.__m_ToMember;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/message/DiscoveryMessage".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new DiscoveryMessage();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isReadError() {
        return this.__m_ReadError;
    }

    public boolean packetize(ReadBuffer buffer, int cbPreferred, int cbMax) {
        if (this.getToMemberSet() == null) {
            int cbBody;
            int cbMsg = buffer.length();
            if (cbMsg > (cbBody = Broadcast.calcBodyLength(Broadcast.calcHeaderLength(), cbPreferred, cbMax))) {
                throw new IllegalStateException(String.valueOf("Broadcast Message is too ") + "large (max=" + cbBody + ", actual=" + buffer.length() + ", " + this);
            }
            Broadcast packet = new Broadcast();
            packet.setFromId(this.getFromMember().getId());
            packet.setMessageType(this.getMessageType());
            packet.setBufferController((Disposable)this.getBufferController());
            packet.defineBufferView(buffer, 0, cbMsg);
            Member memberTo = this.getToMember();
            if (memberTo != null) {
                packet.setToAddress(memberTo.getSocketAddress());
            }
            this.setMessagePartCount(1);
            this.setPacket(0, packet);
            return true;
        }
        return super.packetize(buffer, cbPreferred, cbMax);
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        Member memberFrom = new Member();
        memberFrom.readExternal(input);
        this.setFromMember(memberFrom);
        this.setSourceAddress(memberFrom.getSocketAddress());
        if (input.readBoolean()) {
            Member memberTo = new Member();
            memberTo.readExternal(input);
            this.setToMember(memberTo);
        }
    }

    public void setReadError(boolean fReadError) {
        this.__m_ReadError = fReadError;
    }

    public void setSourceAddress(SocketAddress pSourceAddress) {
        this.__m_SourceAddress = pSourceAddress;
    }

    public void setToMember(Member member) {
        this.__m_ToMember = member;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        Member memberFrom = this.getFromMember();
        Member memberTo = this.getToMember();
        memberFrom.writeExternal(output);
        if (memberTo == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            memberTo.writeExternal(output);
        }
    }
}

