/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.security;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Cluster$ClusterService;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.net.Security$RefAction;
import com.tangosol.coherence.component.net.ServiceInfo;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.net.ClusterPermission;
import com.tangosol.net.Service;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.security.AccessController;
import com.tangosol.net.security.PermissionInfo;
import com.tangosol.net.security.SecurityHelper;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.MapSet;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.WrapperException;
import java.security.AccessControlException;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;

public class Standard
extends Security {
    private transient AccessController __m_AccessController;
    private transient CallbackHandler __m_CallbackHandler;
    private transient String __m_ModuleName;
    private transient Map __m_ServiceContext;
    private transient Map __m_ServiceMemberContext;
    private transient ThreadLocal __m_ThreadContext;
    private Map __m_ValidSubjects;
    private static ListMap __mapChildren;

    static {
        Standard.__initStatic();
    }

    public Standard() {
        this(null, null, true);
    }

    public Standard(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_ServiceContext = new SafeHashMap();
            this.__m_ServiceMemberContext = new SafeHashMap();
            this.__m_ThreadContext = new ThreadLocal();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("RefAction", Security$RefAction.get_CLASS());
    }

    public void checkPermission(com.tangosol.net.Cluster cluster, ClusterPermission permission) {
        Member memberSenior;
        Object oResponse;
        Cluster$ClusterService clusterservice;
        Grid service;
        String sService;
        AccessController controller = this.getAccessController();
        Subject subject = (Subject)this.getThreadContext().get();
        if (subject == null) {
            subject = this.getTempSubject();
        }
        Component._assert((sService = permission.getServiceName()) != null);
        this.validateSubject(sService, subject);
        controller.checkPermission(permission, subject);
        if (cluster == null ? true : cluster.isRunning() ^ true) {
            return;
        }
        if (cluster instanceof SafeCluster) {
            cluster = ((SafeCluster)cluster).getCluster();
        }
        if (!((service = (clusterservice = ((Cluster)cluster).getClusterService()).getService(sService)) != null) ? false : service.isRunning()) {
            return;
        }
        ServiceInfo info = clusterservice.getServiceInfo(sService);
        if (info == null) {
            return;
        }
        do {
            if (!((memberSenior = (Member)info.getOldestMember()) == null)) continue;
            return;
        } while ((oResponse = clusterservice.pollSecure(memberSenior, this.encryptPermissionInfo(permission, subject))) == null);
        if (oResponse instanceof Throwable) {
            throw Base.ensureRuntimeException((Throwable)oResponse);
        }
        PermissionInfo responseInfo = (PermissionInfo)oResponse;
        ClusterPermission permissionResponse = responseInfo.getPermission();
        if (permissionResponse == null) {
            try {
                permissionResponse = (ClusterPermission)controller.decrypt(responseInfo.getSignedPermission(), responseInfo.getSubject(), subject);
            }
            catch (GeneralSecurityException e) {
                throw new AccessControlException("Security configuration mismatch or break-in attempt", permission);
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e, "Security configuration mismatch");
            }
        }
        if (Base.equals(permission, permissionResponse) ^ true) {
            throw new AccessControlException("Permission mismatch or break-in attempt", permission);
        }
    }

    protected void configure(XmlElement xmlConfig) {
        boolean fEnabled;
        super.configure(xmlConfig);
        if (xmlConfig != null && (fEnabled = xmlConfig.getSafeElement("enabled").getBoolean())) {
            String sModule = xmlConfig.getSafeElement("login-module-name").getString("Coherence");
            XmlElement xmlAC = xmlConfig.getSafeElement("access-controller");
            XmlElement xmlCH = xmlConfig.getSafeElement("callback-handler");
            CallbackHandler handler = (CallbackHandler)Standard.newInstance(xmlCH);
            AccessController controller = (AccessController)Standard.newInstance(xmlAC);
            if (controller == null) {
                throw new RuntimeException("The 'access-controller' configuration element must be specified");
            }
            this.setAccessController(controller);
            this.setCallbackHandler(handler);
            this.setModuleName(sModule);
        }
    }

    protected PermissionInfo encryptPermissionInfo(ClusterPermission permission, Subject subject) {
        try {
            return new PermissionInfo(permission, permission.getServiceName(), this.getAccessController().encrypt(permission, subject), subject);
        }
        catch (Exception e) {
            throw new SecurityException(String.valueOf("Invalid subject credentials: ") + e);
        }
    }

    public AccessController getAccessController() {
        return this.__m_AccessController;
    }

    protected CallbackHandler getCallbackHandler() {
        return this.__m_CallbackHandler;
    }

    public String getModuleName() {
        return this.__m_ModuleName;
    }

    private Map getServiceContext() {
        return this.__m_ServiceContext;
    }

    private Map getServiceMemberContext() {
        return this.__m_ServiceMemberContext;
    }

    protected Subject getTempSubject() {
        CallbackHandler handler = this.getCallbackHandler();
        if (handler != null) {
            return (Subject)this.loginSecure(handler);
        }
        Subject subject = SecurityHelper.getCurrentSubject();
        if (subject == null) {
            throw new SecurityException(String.valueOf("Attempt to access a protected resource was made without credentials and ") + "the default 'callback-handler' was not configured.");
        }
        return subject;
    }

    private ThreadLocal getThreadContext() {
        return this.__m_ThreadContext;
    }

    private Map getValidSubjects() {
        return this.__m_ValidSubjects;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/security/Standard".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new Standard();
    }

    private final Component get_Module() {
        return this;
    }

    public Object impersonate(Object oSubject, String sNameOld, String sNameNew) {
        Subject subject = (Subject)oSubject;
        Subject subjectNew = new Subject();
        Iterator iter = subject.getPrincipals().iterator();
        while (iter.hasNext()) {
            Principal p = (Principal)iter.next();
            String sName = p.getName();
            if (sName.indexOf(sNameOld) >= 0) {
                try {
                    sName = Base.replace(sName, sNameOld, sNameNew);
                    p = (Principal)ClassHelper.newInstance(p.getClass(), new Object[]{sName});
                    Component._trace(String.valueOf("Successfully impersonated ") + p + "@" + p.getClass());
                }
                catch (Exception e) {
                    Component._trace(String.valueOf("Cannot impersonate ") + p + "@" + p.getClass());
                }
            }
            subjectNew.getPrincipals().add(p);
        }
        subjectNew.getPublicCredentials().addAll(subject.getPublicCredentials());
        subjectNew.getPrivateCredentials().addAll(subject.getPrivateCredentials());
        return subjectNew;
    }

    public Object loginSecure(Object oHandler) {
        LoginContext lc;
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(new AuthPermission("coherence.login"));
        }
        CallbackHandler handler = (CallbackHandler)oHandler;
        try {
            lc = new LoginContext(this.getModuleName(), handler);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "Failed to create LoginContext");
        }
        try {
            lc.login();
            Subject subject = lc.getSubject();
            subject.setReadOnly();
            return subject;
        }
        catch (Exception e) {
            throw new SecurityException(String.valueOf("Authentication failed: ") + e.getMessage());
        }
    }

    protected static Object newInstance(XmlElement xmlConfig) {
        String sClass = xmlConfig.getSafeElement("class-name").getString();
        if (sClass.length() > 0) {
            XmlElement xmlParams = xmlConfig.getSafeElement("init-params");
            Object[] aoParam = XmlHelper.parseInitParams(xmlParams);
            try {
                Class clz = ExternalizableHelper.loadClass(sClass, Standard.get_CLASS().getClassLoader(), null);
                return ClassHelper.newInstance(clz, aoParam);
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e);
            }
        }
        return null;
    }

    public void onInit() {
        this.setValidSubjects(new LocalCache(Integer.MAX_VALUE, 10000));
        super.onInit();
    }

    public Object processSecureRequest(Service service, Member memberFrom, Object oRequestInfo) {
        ClusterPermission permission;
        Subject subjCurrent;
        ClusterService clusterservice = (ClusterService)service;
        Component._assert(Thread.currentThread() == clusterservice.getThread());
        AccessController controller = this.getAccessController();
        PermissionInfo infoRequest = (PermissionInfo)oRequestInfo;
        String sService = infoRequest.getServiceName();
        ServiceInfo infoService = clusterservice.getServiceInfo(sService);
        Member memberThis = clusterservice.getThisMember();
        if (infoService == null ? true : infoService.getOldestMember() != memberThis) {
            return null;
        }
        Subject subjRequestor = infoRequest.getSubject();
        try {
            subjCurrent = (Subject)this.getServiceContext().get(sService);
            if (subjCurrent == null) {
                return new RuntimeException("No service context");
            }
            permission = memberFrom.equals(memberThis) ? infoRequest.getPermission() : (ClusterPermission)controller.decrypt(infoRequest.getSignedPermission(), subjRequestor, subjCurrent);
            Component._trace(String.valueOf("Remote permission request: ") + permission + " by " + memberFrom, 5);
            controller.checkPermission(permission, subjRequestor);
        }
        catch (Exception e) {
            return Base.ensureRuntimeException(e, "Remote permission check failed");
        }
        Set setMembers = (Set)this.getServiceMemberContext().get(sService);
        if (setMembers == null) {
            setMembers = new MapSet(new WeakHashMap());
            this.getServiceMemberContext().put(sService, setMembers);
        }
        setMembers.add(memberFrom);
        try {
            return this.encryptPermissionInfo(permission, subjCurrent);
        }
        catch (Exception e) {
            return Base.ensureRuntimeException(e, "Remote encryption failed");
        }
    }

    public void releaseSecureContext(String sServiceName) {
        this.getServiceContext().remove(sServiceName);
    }

    public static Object runAnonymously(Object oAction) throws PrivilegedActionException {
        return Security.runAnonymously(oAction);
    }

    protected Object runSecure(Object oSubject, Object oAction) throws PrivilegedActionException {
        Subject subject;
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(new AuthPermission("coherence.runAs"));
        }
        if ((subject = (Subject)oSubject) == null) {
            return Standard.runAnonymously(oAction);
        }
        this.getThreadContext().set(subject);
        try {
            Object t = oAction instanceof PrivilegedAction ? Subject.doAs(subject, (PrivilegedAction)oAction) : Subject.doAs(subject, (PrivilegedExceptionAction)oAction);
            Object var6_7 = null;
            this.getThreadContext().set(null);
            return t;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.getThreadContext().set(null);
            throw throwable;
        }
    }

    protected void setAccessController(AccessController controller) {
        this.__m_AccessController = controller;
    }

    protected void setCallbackHandler(CallbackHandler handler) {
        this.__m_CallbackHandler = handler;
    }

    protected void setModuleName(String sName) {
        this.__m_ModuleName = sName;
    }

    private void setServiceContext(Map mapCtx) {
        this.__m_ServiceContext = mapCtx;
    }

    private void setServiceMemberContext(Map map) {
        this.__m_ServiceMemberContext = map;
    }

    private void setThreadContext(ThreadLocal ctx) {
        this.__m_ThreadContext = ctx;
    }

    private void setValidSubjects(Map cache) {
        this.__m_ValidSubjects = cache;
    }

    protected void validateSubject(String sService, Subject subject) {
        Map mapContext;
        Subject subjCurrent;
        Map mapValid = this.getValidSubjects();
        if (mapValid.containsKey(subject) ^ true) {
            AccessController controller = this.getAccessController();
            Double oTest = new Double(Math.random());
            try {
                Object o = controller.decrypt(controller.encrypt(oTest, subject), subject, null);
                Component._assert(o.equals(oTest));
                mapValid.put(subject, null);
            }
            catch (Exception e) {
                Component._trace(e, String.valueOf("Failed to verify the subject: ") + subject);
                throw new SecurityException("Failed to verify the subject");
            }
        }
        if ((subjCurrent = (Subject)(mapContext = this.getServiceContext()).get(sService)) == null) {
            mapContext.put(sService, subject);
        }
    }

    public void verifySecureContext(Service service, String sServiceName, Member memberFrom) {
        ClusterService clusterservice = (ClusterService)service;
        Component._assert(Thread.currentThread() == clusterservice.getThread());
        boolean fSuccess = false;
        Set setMembers = (Set)this.getServiceMemberContext().get(sServiceName);
        if (setMembers != null) {
            fSuccess = setMembers.remove(memberFrom);
            if (setMembers.isEmpty()) {
                this.getServiceMemberContext().remove(sServiceName);
            }
        }
        if (fSuccess ^ true) {
            String sMsg = "Security configuration mismatch or break-in attempt";
            Component._trace(sMsg, 1);
            throw new SecurityException(sMsg);
        }
    }
}

