/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.socket;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Socket;
import com.tangosol.coherence.component.net.UdpPacket;
import com.tangosol.coherence.component.net.udpPacket.OutgoingUdpPacket;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.util.Base;
import com.tangosol.util.HashHelper;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Set;

public abstract class UdpSocket
extends Socket {
    private transient int __m_ActualBufferSent;
    private int __m_BufferReceived;
    private int __m_BufferSent;
    private long __m_BytesReceived;
    private long __m_BytesSent;
    private int __m_CountReceived;
    private int __m_CountSent;
    private DatagramSocket __m_DatagramSocket;
    private transient boolean __m_IgnoreSendErrors;
    private int __m_PacketLength;
    private transient Set __m_RxDebugDropAddresses;
    private transient int __m_RxDebugDropRate;
    private transient Set __m_TxDebugDropAddresses;
    private transient int __m_TxDebugDropRate;

    public UdpSocket(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() != Socket.STATE_CLOSED) {
                DatagramSocket socket = this.getDatagramSocket();
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setDatagramSocket(null);
                }
                this.setState(Socket.STATE_CLOSED);
            }
        }
    }

    protected void configure(DatagramSocket socket) throws IOException {
    }

    public int getActualBufferSent() {
        return this.__m_ActualBufferSent;
    }

    public int getBufferReceived() {
        return this.__m_BufferReceived;
    }

    public int getBufferSent() {
        return this.__m_BufferSent;
    }

    public long getBytesReceived() {
        return this.__m_BytesReceived;
    }

    public long getBytesSent() {
        return this.__m_BytesSent;
    }

    public int getCountReceived() {
        return this.__m_CountReceived;
    }

    public int getCountSent() {
        return this.__m_CountSent;
    }

    public DatagramSocket getDatagramSocket() {
        return this.__m_DatagramSocket;
    }

    public int getPacketLength() {
        return this.__m_PacketLength;
    }

    public Set getRxDebugDropAddresses() {
        return this.__m_RxDebugDropAddresses;
    }

    public int getRxDebugDropRate() {
        return this.__m_RxDebugDropRate;
    }

    public Set getTxDebugDropAddresses() {
        return this.__m_TxDebugDropAddresses;
    }

    public int getTxDebugDropRate() {
        return this.__m_TxDebugDropRate;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/socket/UdpSocket".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private final Component get_Module() {
        return this;
    }

    public int hashCode() {
        return HashHelper.hash(this.getInetAddress(), this.getPort());
    }

    protected void initializeDatagramSocket(DatagramSocket socket) {
        try {
            int cMillis;
            int cRecv;
            int cbPacket = this.getPacketLength();
            Component._assert(cbPacket > 0, String.valueOf("UdpSocket.open: ") + "PacketLength property is required and must be greater than zero");
            int cSend = this.getBufferSent();
            if (cSend > 0) {
                int cbReq = cbPacket * cSend;
                int cbActual = socket.getSendBufferSize();
                while (cbActual < cbReq) {
                    try {
                        socket.setSendBufferSize(cbReq);
                    }
                    catch (SocketException e) {
                        // empty catch block
                    }
                    cbActual = socket.getSendBufferSize();
                    cbReq = Math.max(cbActual, cbReq * 3 / 4);
                }
                this.setActualBufferSent(cbActual / cbPacket);
                this.validateBufferSize("send", cbActual, cbPacket * cSend, cbPacket);
            }
            if ((cRecv = this.getBufferReceived()) > 0) {
                int cbReq = cbPacket * cRecv;
                int cbActual = socket.getReceiveBufferSize();
                while (cbActual < cbReq) {
                    try {
                        socket.setReceiveBufferSize(cbReq);
                    }
                    catch (SocketException e) {
                        // empty catch block
                    }
                    cbActual = socket.getReceiveBufferSize();
                    cbReq = Math.max(cbActual, cbReq * 3 / 4);
                }
                this.validateBufferSize("receive", cbActual, cbPacket * cRecv, cbPacket);
            }
            if ((cMillis = this.getSoTimeout()) >= 0) {
                socket.setSoTimeout(cMillis);
                this.validateSoTimeout(socket.getSoTimeout(), cMillis);
            }
        }
        catch (SocketException e) {
            throw new WrapperException(e);
        }
    }

    protected DatagramSocket instantiateDatagramSocket() throws IOException {
        InetAddress addr = this.getInetAddress();
        int nPort = this.getPort();
        Component._assert(addr != null, String.valueOf("UdpSocket.open: ") + "InetAddress is required");
        Component._assert(!(nPort > 0) ? false : nPort <= 65535, String.valueOf("UdpSocket.open: ") + "Port out of range (" + nPort + ")");
        DatagramSocket socket = this.getProvider().openDatagramSocket();
        this.configure(socket);
        socket.bind(new InetSocketAddress(addr, nPort));
        return socket;
    }

    public boolean isIgnoreSendErrors() {
        return this.__m_IgnoreSendErrors;
    }

    private boolean isRxDebugDrop(UdpPacket packet) {
        int iDropRate = this.getRxDebugDropRate();
        if (iDropRate == 0 ? true : iDropRate < Base.getRandom().nextInt(100000)) {
            return false;
        }
        Set setAddress = this.getRxDebugDropAddresses();
        return setAddress == null ? true : setAddress.contains(packet.getSocketAddress());
    }

    private boolean isTxDebugDrop(UdpPacket packet) {
        int iDropRate = this.getTxDebugDropRate();
        if (iDropRate == 0 ? true : iDropRate < Base.getRandom().nextInt(100000)) {
            return false;
        }
        Set setAddress = this.getTxDebugDropAddresses();
        return setAddress == null ? true : setAddress.contains(packet.getSocketAddress());
    }

    private boolean isTxDebugDrop(SocketAddress socketAddress) {
        int iDropRate = this.getTxDebugDropRate();
        if (iDropRate == 0 ? true : iDropRate < Base.getRandom().nextInt(100000)) {
            return false;
        }
        Set setAddress = this.getTxDebugDropAddresses();
        return setAddress == null ? true : setAddress.contains(socketAddress);
    }

    public void onInit() {
        this.setIgnoreSendErrors(Boolean.getBoolean("tangosol.coherence.udp.ignoretxerror"));
        super.onInit();
    }

    protected void onReceiveException(IOException eException, long lSocketActionMillis) {
        this.onException(eException, lSocketActionMillis);
    }

    protected void onSendException(IOException eException, long lSocketActionMillis) {
        this.onException(eException, lSocketActionMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() != Socket.STATE_OPEN) {
                DatagramSocket socket = this.getDatagramSocket();
                if (socket == null) {
                    socket = this.instantiateDatagramSocket();
                }
                try {
                    this.initializeDatagramSocket(socket);
                    this.setDatagramSocket(socket);
                    this.setLastOpenMillis(Base.getSafeTimeMillis());
                }
                catch (RuntimeException e) {
                    try {
                        socket.close();
                    }
                    catch (Exception eIgnore) {
                        // empty catch block
                    }
                    this.setDatagramSocket(null);
                    throw e;
                }
                this.setCountSent(0);
                this.setCountReceived(0);
                this.setBytesSent(0L);
                this.setBytesReceived(0L);
                this.setState(Socket.STATE_OPEN);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean receive(UdpPacket packet) {
        while (true) {
            IOException eIO = null;
            DatagramSocket socket = this.getDatagramSocket();
            try {
                if (socket != null) {
                    ByteArrayWriteBuffer buffer = (ByteArrayWriteBuffer)packet.getWriteBuffer();
                    byte[] ab = buffer.getRawByteArray();
                    int cb = ab.length;
                    DatagramPacket dgPacket = new DatagramPacket(ab, cb);
                    socket.receive(dgPacket);
                    buffer.setLength(dgPacket.getLength());
                    if (this.isRxDebugDrop(packet)) continue;
                    this.setCountReceived(this.getCountReceived() + 1);
                    this.setBytesReceived(this.getBytesReceived() + (long)dgPacket.getLength());
                    return true;
                }
            }
            catch (InterruptedIOException e) {
                this.onInterruptedIOException(e, Base.getSafeTimeMillis());
                return false;
            }
            catch (IOException e) {
                eIO = e;
            }
            Object object = this.getLock();
            synchronized (object) {
                if (socket == this.getDatagramSocket()) {
                    if (this.getState() == Socket.STATE_OPEN) {
                        this.onReceiveException(eIO, Base.getSafeTimeMillis());
                    } else {
                        Exception eReason = this.getLastException();
                        throw new ConnectionException(String.valueOf("UdpSocket.receive: ") + "unable to reopen socket; State=" + Socket.formatStateName(this.getState()), eReason == null ? eIO : eReason);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(UdpPacket packet) {
        while (true) {
            IOException eIO = null;
            DatagramSocket socket = this.getDatagramSocket();
            try {
                if (socket != null) {
                    ByteArrayWriteBuffer buffer = (ByteArrayWriteBuffer)packet.getWriteBuffer();
                    byte[] ab = buffer.getRawByteArray();
                    int cb = buffer.length();
                    DatagramPacket dgPacket = new DatagramPacket(ab, cb);
                    if (packet instanceof OutgoingUdpPacket) {
                        OutgoingUdpPacket outPacket = (OutgoingUdpPacket)packet;
                        SocketAddress[] aAddr = ((OutgoingUdpPacket)packet).getSocketAddresses();
                        int i = 0;
                        int c = outPacket.getAddressCount();
                        while (i < c) {
                            dgPacket.setSocketAddress(aAddr[i]);
                            if (this.isTxDebugDrop(packet) ^ true) {
                                socket.send(dgPacket);
                            }
                            this.setCountSent(this.getCountSent() + 1);
                            this.setBytesSent(this.getBytesSent() + (long)cb);
                            ++i;
                        }
                    } else {
                        dgPacket.setSocketAddress(packet.getSocketAddress());
                        if (this.isTxDebugDrop(packet) ^ true) {
                            socket.send(dgPacket);
                        }
                        this.setCountSent(this.getCountSent() + 1);
                        this.setBytesSent(this.getBytesSent() + (long)cb);
                    }
                    return;
                }
            }
            catch (PortUnreachableException e) {
                return;
            }
            catch (IOException e) {
                String sMsg = e.getMessage();
                if (this.isIgnoreSendErrors() ? true : (!(sMsg != null) ? false : ((sMsg.equals("Host is down") ? true : sMsg.equals("No route to host")) ? true : sMsg.equals("No buffer space available")))) {
                    return;
                }
                eIO = e;
            }
            Object object = this.getLock();
            synchronized (object) {
                if (socket == this.getDatagramSocket()) {
                    if (this.getState() == Socket.STATE_OPEN) {
                        this.onSendException(eIO, Base.getSafeTimeMillis());
                    } else {
                        Exception eReason = this.getLastException();
                        throw new ConnectionException(String.valueOf("UdpSocket.send: ") + "unable to reopen socket; State=" + Socket.formatStateName(this.getState()), eReason == null ? eIO : eReason);
                    }
                }
            }
        }
    }

    protected void setActualBufferSent(int cPackets) {
        this.__m_ActualBufferSent = cPackets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferReceived(int cPackets) {
        Object object = this.getLock();
        synchronized (object) {
            Component._assert(this.getState() != Socket.STATE_OPEN, "BufferReceived cannot be modified once the socket is open");
            this.__m_BufferReceived = cPackets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferSent(int cPackets) {
        Object object = this.getLock();
        synchronized (object) {
            Component._assert(this.getState() != Socket.STATE_OPEN, "BufferSent cannot be modified once the socket is open");
            this.__m_BufferSent = cPackets;
        }
    }

    public void setBytesReceived(long cBytes) {
        this.__m_BytesReceived = cBytes;
    }

    public void setBytesSent(long cBytes) {
        this.__m_BytesSent = cBytes;
    }

    protected void setCountReceived(int cReceived) {
        this.__m_CountReceived = cReceived;
    }

    protected void setCountSent(int cSent) {
        this.__m_CountSent = cSent;
    }

    protected void setDatagramSocket(DatagramSocket socket) {
        this.__m_DatagramSocket = socket;
    }

    public void setIgnoreSendErrors(boolean fIgnore) {
        this.__m_IgnoreSendErrors = fIgnore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPacketLength(int cb) {
        Object object = this.getLock();
        synchronized (object) {
            Component._assert(this.getState() != Socket.STATE_OPEN, "PacketLength cannot be modified once the socket is open");
            this.__m_PacketLength = cb;
        }
    }

    public void setRxDebugDropAddresses(Set set) {
        this.__m_RxDebugDropAddresses = set;
    }

    public void setRxDebugDropRate(int iRate) {
        if (iRate != this.getRxDebugDropRate()) {
            Set setAddr = this.getRxDebugDropAddresses();
            this.__m_RxDebugDropRate = iRate;
            Component._trace(String.valueOf("Configuring ") + this + " to drop " + (float)iRate / 1000.0f + "% of incomming packets" + (setAddr == null ? "." : String.valueOf(" from ") + setAddr), 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoTimeout(int cMillis) {
        if (cMillis >= 0) {
            Object object = this.getLock();
            synchronized (object) {
                if (this.getState() == Socket.STATE_OPEN) {
                    DatagramSocket socket = this.getDatagramSocket();
                    try {
                        socket.setSoTimeout(cMillis);
                        this.validateSoTimeout(socket.getSoTimeout(), cMillis);
                    }
                    catch (SocketException e) {
                        throw new WrapperException(e);
                    }
                }
                super.setSoTimeout(cMillis);
            }
        }
    }

    public void setTxDebugDropAddresses(Set set) {
        this.__m_TxDebugDropAddresses = set;
    }

    public void setTxDebugDropRate(int iRate) {
        if (iRate != this.getTxDebugDropRate()) {
            Set setAddr = this.getTxDebugDropAddresses();
            this.__m_TxDebugDropRate = iRate;
            Component._trace(String.valueOf("Configuring ") + this + " to drop " + (float)iRate / 1000.0f + "% of outgoing packets" + (setAddr == null ? "." : String.valueOf(" to ") + setAddr), 2);
        }
    }

    protected void validateBufferSize(String sBufferName, int cbActualSize, int cbRequestedSize, int cbMinimumSize) {
        if (cbActualSize < cbRequestedSize) {
            int nPct = cbActualSize * 100 / cbRequestedSize;
            int iPacketLength = this.getPacketLength();
            String sMsg = String.valueOf(this.get_Name()) + " failed to set " + sBufferName + " buffer size to " + cbRequestedSize / iPacketLength + " packets (" + Base.toMemorySizeString(cbRequestedSize, false) + "); actual size is " + nPct + "%, " + cbActualSize / iPacketLength + " packets (" + Base.toMemorySizeString(cbActualSize, false) + "). Consult your OS " + "documentation regarding increasing the maximum socket buffer size.";
            if (cbActualSize < cbMinimumSize) {
                Component._trace(sMsg, 1);
                throw new RuntimeException(sMsg);
            }
            if (nPct < 80) {
                sMsg = String.valueOf(sMsg) + " Proceeding with the actual value may cause sub-optimal performance.";
                Component._trace(sMsg, nPct < 50 ? 2 : 6);
            }
        }
    }
}

